<?php

return [
    'customers' => [
        'forgot-password' => [
            'already-sent'         => 'El correu de restabliment de contrasenya ja s’ha enviat.',
            'back'                 => 'Tornar a iniciar sessió',
            'bagisto'              => 'Bagisto',
            'email'                => 'Correu electrònic',
            'email-not-exist'      => 'No podem trobar un usuari amb aquesta adreça de correu electrònic.',
            'footer'               => '© Drets d’autor 2010 - :current_year, Webkul Software (Registrat a l’Índia). Tots els drets reservats.',
            'forgot-password-text' => 'Si heu oblidat la vostra contrasenya, recupereu-la introduint la vostra adreça de correu electrònic.',
            'page-title'           => 'Heu oblidat la contrasenya?',
            'reset-link-sent'      => 'Hem enviat per correu electrònic l’enllaç per restablir la vostra contrasenya.',
            'sign-in-button'       => 'Iniciar sessió',
            'submit'               => 'Restablir contrasenya',
            'title'                => 'Recuperar contrasenya',
        ],

        'reset-password' => [
            'back-link-title'  => 'Tornar a iniciar sessió',
            'bagisto'          => 'Bagisto',
            'confirm-password' => 'Confirmar contrasenya',
            'email'            => 'Correu electrònic registrat',
            'footer'           => '© Drets d’autor 2010 - :current_year, Webkul Software (Registrada a l’Índia). Tots els drets reservats.',
            'password'         => 'Contrasenya',
            'submit-btn-title' => 'Restablir contrasenya',
            'title'            => 'Restablir contrasenya',
        ],

        'login-form' => [
            'bagisto'             => 'Bagisto',
            'button-title'        => 'Iniciar sessió',
            'create-your-account' => 'Crea el teu compte',
            'email'               => 'Correu electrònic',
            'footer'              => '© Drets d’autor 2010 - :current_year, Webkul Software (Registrada a l’Índia). Tots els drets reservats.',
            'forgot-pass'         => 'Has oblidat la contrasenya?',
            'form-login-text'     => 'Si tens un compte, inicia sessió amb la teva adreça de correu electrònic.',
            'invalid-credentials' => 'Si us plau, verifica les teves credencials i torna-ho a intentar.',
            'new-customer'        => 'Nou client?',
            'not-activated'       => 'La teva activació requereix l’aprovació de l’administrador.',
            'page-title'          => 'Inici de sessió del client',
            'password'            => 'Contrasenya',
            'show-password'       => 'Mostrar contrasenya',
            'title'               => 'Iniciar sessió',
            'verify-first'        => 'Verifica primer el teu compte de correu electrònic.',
        ],

        'signup-form' => [
            'account-exists'              => 'Ja tens un compte?',
            'bagisto'                     => 'Bagisto',
            'button-title'                => 'Registrar-se',
            'click-here'                  => 'Clica aquí',
            'confirm-pass'                => 'Confirmar contrasenya',
            'email'                       => 'Correu electrònic',
            'first-name'                  => 'Nom',
            'footer'                      => '© Drets d’autor 2010 - :current_year, Webkul Software (Registrada a l’Índia). Tots els drets reservats.',
            'form-signup-text'            => 'Si ets nou a la nostra botiga, estem encantats de tenir-te com a membre.',
            'last-name'                   => 'Cognom',
            'page-title'                  => 'Convertir-se en usuari',
            'password'                    => 'Contrasenya',
            'sign-in-button'              => 'Iniciar sessió',
            'subscribe-to-newsletter'     => 'Subscriure’s al butlletí',
            'success'                     => 'Compte creat amb èxit.',
            'success-verify'              => 'Compte creat amb èxit, s’ha enviat un correu electrònic per a la seva verificació.',
            'terms-conditions'            => 'Termes i Condicions',
            'verification-not-sent'       => 'Error! Problema en enviar el correu de verificació, si us plau intenta-ho de nou més tard.',
            'verification-sent'           => 'Correu de verificació enviat',
            'verified'                    => 'El teu compte ha estat verificat, intenta iniciar sessió ara.',
            'verify-failed'               => 'No podem verificar el teu compte de correu.',
        ],

        'account' => [
            'home' => 'Inici',

            'profile' => [
                'index' => [
                    'delete'         => 'Eliminar',
                    'delete-failed'  => 'S’ha produït un error en eliminar el client.',
                    'delete-profile' => 'Eliminar perfil',
                    'delete-success' => 'Client eliminat amb èxit',
                    'dob'            => 'Data de naixement',
                    'edit'           => 'Editar',
                    'edit-success'   => 'Perfil actualitzat amb èxit',
                    'email'          => 'Correu electrònic',
                    'enter-password' => 'Introdueix la teva contrasenya',
                    'first-name'     => 'Nom',
                    'gender'         => 'Gènere',
                    'last-name'      => 'Cognom',
                    'order-pending'  => 'No es pot eliminar el compte del client perquè hi ha comandes pendents o en procés.',
                    'title'          => 'Perfil',
                    'unmatched'      => 'La contrasenya antiga no coincideix.',
                    'wrong-password' => 'Contrasenya incorrecta!',
                ],

                'edit' => [
                    'confirm-password'        => 'Confirmar contrasenya',
                    'current-password'        => 'Contrasenya actual',
                    'dob'                     => 'Data de naixement',
                    'edit'                    => 'Editar',
                    'edit-profile'            => 'Editar perfil',
                    'email'                   => 'Correu electrònic',
                    'female'                  => 'Femení',
                    'first-name'              => 'Nom',
                    'gender'                  => 'Gènere',
                    'last-name'               => 'Cognom',
                    'male'                    => 'Masculí',
                    'new-password'            => 'Nova contrasenya',
                    'other'                   => 'Altres',
                    'phone'                   => 'Telèfon',
                    'save'                    => 'Desar',
                    'subscribe-to-newsletter' => 'Subscriu-te al butlletí',
                ],
            ],

            'addresses' => [
                'index' => [
                    'add-address'      => 'Afegir Adreça',
                    'create-success'   => 'L\'adreça s\'ha afegit correctament.',
                    'default-address'  => 'Adreça Predeterminada',
                    'default-delete'   => 'No es pot canviar l\'adreça predeterminada.',
                    'delete'           => 'Eliminar',
                    'delete-success'   => 'Adreça eliminada correctament',
                    'edit'             => 'Editar',
                    'edit-success'     => 'Adreça actualitzada correctament.',
                    'empty-address'    => 'Encara no has afegit cap adreça al teu compte.',
                    'security-warning' => 'S\'ha detectat activitat sospitosa!',
                    'set-as-default'   => 'Establir com a Predeterminada',
                    'title'            => 'Adreça',
                    'update-success'   => 'L\'adreça s\'ha actualitzat correctament.',
                ],

                'create' => [
                    'add-address'    => 'Afegir Adreça',
                    'city'           => 'Ciutat',
                    'company-name'   => 'Nom de l\'Empresa',
                    'country'        => 'País',
                    'email'          => 'Correu Electrònic',
                    'first-name'     => 'Nom',
                    'last-name'      => 'Cognom',
                    'phone'          => 'Telèfon',
                    'post-code'      => 'Codi Postal',
                    'save'           => 'Desar',
                    'select-country' => 'Seleccionar País',
                    'set-as-default' => 'Establir com a Predeterminada',
                    'state'          => 'Estat',
                    'street-address' => 'Adreça',
                    'title'          => 'Adreça',
                    'vat-id'         => 'ID de l\'IVA',
                ],

                'edit' => [
                    'city'           => 'Ciutat',
                    'company-name'   => 'Nom de l\'Empresa',
                    'country'        => 'País',
                    'edit'           => 'Editar',
                    'email'          => 'Correu Electrònic',
                    'first-name'     => 'Nom',
                    'last-name'      => 'Cognom',
                    'phone'          => 'Telèfon',
                    'post-code'      => 'Codi Postal',
                    'select-country' => 'Seleccionar País',
                    'state'          => 'Estat',
                    'street-address' => 'Adreça',
                    'title'          => 'Adreça',
                    'update-btn'     => 'Actualitzar',
                    'vat-id'         => 'ID de l\'IVA',
                ],
            ],

            'orders' => [
                'action'      => 'Acció',
                'action-view' => 'Veure',
                'empty-order' => 'Encara no has realitzat cap comanda',
                'order'       => 'Comanda',
                'order-date'  => 'Data de la comanda',
                'order-id'    => 'ID de la comanda',
                'subtotal'    => 'Subtotal',
                'title'       => 'Comandes',
                'total'       => 'Total',

                'status' => [
                    'title' => 'Estat',

                    'options' => [
                        'canceled'        => 'Cancel·lat',
                        'closed'          => 'Tancat',
                        'completed'       => 'Completat',
                        'fraud'           => 'Frau',
                        'pending'         => 'Pendent',
                        'pending-payment' => 'Pagament Pendent',
                        'processing'      => 'Processant',
                    ],
                ],

                'view' => [
                    'billing-address'      => 'Adreça de Facturació',
                    'cancel-btn-title'     => 'Cancel·lar',
                    'cancel-confirm-msg'   => 'Estàs segur que vols cancel·lar aquesta comanda?',
                    'cancel-error'         => 'No es pot cancel·lar la teva comanda.',
                    'cancel-success'       => 'La teva comanda ha estat cancel·lada',
                    'contact'              => 'Contacte',
                    'item-invoiced'        => 'Producte Facturat',
                    'item-refunded'        => 'Producte Reembossat',
                    'item-shipped'         => 'Producte Enviat',
                    'item-ordered'         => 'Producte Comandat',
                    'order-id'             => 'ID de la Comanda',
                    'page-title'           => 'Comanda #:order_id',
                    'payment-method'       => 'Mètode de Pagament',
                    'reorder-btn-title'    => 'Tornar a Comandar',
                    'shipping-address'     => 'Adreça d\'Enviament',
                    'shipping-method'      => 'Mètode d\'Enviament',
                    'shipping-and-payment' => 'Detalls d\'Enviament i Pagament',
                    'status'               => 'Estat',
                    'title'                => 'Veure',
                    'total'                => 'Total',

                    'information' => [
                        'discount'                   => 'Descompte',
                        'excl-tax'                   => 'Excl. Impostos:',
                        'grand-total'                => 'Total',
                        'info'                       => 'Informació',
                        'item-canceled'              => 'Cancel·lat (:qty_canceled)',
                        'item-refunded'              => 'Reembossat (:qty_refunded)',
                        'invoiced-item'              => 'Facturat (:qty_invoiced)',
                        'item-shipped'               => 'Enviat (:qty_shipped)',
                        'item-status'                => 'Estat del Producte',
                        'ordered-item'               => 'Comandat (:qty_ordered)',
                        'placed-on'                  => 'Realitzat el',
                        'price'                      => 'Preu',
                        'product-name'               => 'Nom',
                        'shipping-handling'          => 'Enviament i Manipulació',
                        'shipping-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
                        'shipping-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
                        'sku'                        => 'SKU',
                        'subtotal'                   => 'Subtotal',
                        'subtotal-excl-tax'          => 'Subtotal (Excl. Impostos)',
                        'subtotal-incl-tax'          => 'Subtotal (Incl. Impostos)',
                        'order-summary'              => 'Resum de la Comanda',
                        'tax'                        => 'Impostos',
                        'tax-amount'                 => 'Import d\'Impostos',
                        'tax-percent'                => 'Percentatge d\'Impostos',
                        'total-due'                  => 'Total a Pagar',
                        'total-paid'                 => 'Total Pagat',
                        'total-refunded'             => 'Total Reemborsat',
                    ],

                    'invoices' => [
                        'discount'                   => 'Descompte',
                        'excl-tax'                   => 'Excl. Impostos:',
                        'grand-total'                => 'Total General',
                        'individual-invoice'         => 'Factura #:invoice_id',
                        'invoices'                   => 'Factures',
                        'price'                      => 'Preu',
                        'print'                      => 'Imprimir',
                        'product-name'               => 'Nom',
                        'products-ordered'           => 'Productes Encarregats',
                        'qty'                        => 'Quantitat',
                        'shipping-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
                        'shipping-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
                        'shipping-handling'          => 'Enviament i Manipulació',
                        'sku'                        => 'SKU',
                        'subtotal-excl-tax'          => 'Subtotal (Excl. Impostos)',
                        'subtotal-incl-tax'          => 'Subtotal (Incl. Impostos)',
                        'subtotal'                   => 'Subtotal',
                        'tax'                        => 'Impostos',
                        'tax-amount'                 => 'Import d\'Impostos',
                    ],

                    'shipments' => [
                        'individual-shipment' => 'Enviament #:shipment_id',
                        'product-name'        => 'Nom',
                        'qty'                 => 'Quantitat',
                        'shipments'           => 'Enviaments',
                        'sku'                 => 'SKU',
                        'subtotal'            => 'Subtotal',
                        'tracking-number'     => 'Número de Seguiment',
                    ],

                    'refunds' => [
                        'adjustment-fee'             => 'Comissió d\'Ajust',
                        'adjustment-refund'          => 'Reemborsament d\'Ajust',
                        'discount'                   => 'Descompte',
                        'grand-total'                => 'Total',
                        'individual-refund'          => 'Reemborsament #:refund_id',
                        'no-result-found'            => 'No s\'han trobat registres.',
                        'order-summary'              => 'Resum de la Comanda',
                        'price'                      => 'Preu',
                        'product-name'               => 'Nom',
                        'qty'                        => 'Quantitat',
                        'refunds'                    => 'Reemborsaments',
                        'shipping-handling'          => 'Enviament i Manipulació',
                        'shipping-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
                        'shipping-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
                        'sku'                        => 'SKU',
                        'subtotal'                   => 'Subtotal',
                        'subtotal-excl-tax'          => 'Subtotal (Excl. Impostos)',
                        'subtotal-incl-tax'          => 'Subtotal (Incl. Impostos)',
                        'tax'                        => 'Impostos',
                        'tax-amount'                 => 'Import d\'Impostos',
                    ],
                ],

                'invoice-pdf' => [
                    'bank-details'               => 'Detalls Bancaris',
                    'bill-to'                    => 'Facturar a',
                    'contact-number'             => 'Número de Contacte',
                    'contact'                    => 'Contacte',
                    'date'                       => 'Data de la Factura',
                    'discount'                   => 'Descompte',
                    'excl-tax'                   => 'Excl. Impostos:',
                    'grand-total'                => 'Total General',
                    'invoice-id'                 => 'ID de la Factura',
                    'invoice'                    => 'Factura',
                    'order-date'                 => 'Data de la Comanda',
                    'order-id'                   => 'ID de la Comanda',
                    'payment-method'             => 'Mètode de Pagament',
                    'payment-terms'              => 'Termes de Pagament',
                    'price'                      => 'Preu',
                    'product-name'               => 'Nom del Producte',
                    'qty'                        => 'Quantitat',
                    'ship-to'                    => 'Enviar a',
                    'shipping-handling-excl-tax' => 'Enviament i Manipulació (Excl. Impostos)',
                    'shipping-handling-incl-tax' => 'Enviament i Manipulació (Incl. Impostos)',
                    'shipping-handling'          => 'Enviament i Manipulació',
                    'shipping-method'            => 'Mètode d\'Enviament',
                    'sku'                        => 'SKU',
                    'subtotal-excl-tax'          => 'Subtotal (Excl. Impostos)',
                    'subtotal-incl-tax'          => 'Subtotal (Incl. Impostos)',
                    'subtotal'                   => 'Subtotal',
                    'tax-amount'                 => 'Import d\'Impostos',
                    'tax'                        => 'Impostos',
                    'vat-number'                 => 'Número d\'IVA',
                ],
            ],

            'reviews' => [
                'empty-review' => 'Encara no has revisat cap producte',
                'title'        => 'Opinions',
            ],

            'downloadable-products' => [
                'available'           => 'Disponible',
                'completed'           => 'Finalitzat',
                'date'                => 'Data',
                'download-error'      => 'L\'enllaç de descàrrega ha caducat.',
                'expired'             => 'Caducat',
                'empty-product'       => 'No tens productes per descarregar',
                'name'                => 'Productes Descarregables',
                'orderId'             => 'ID de Comanda',
                'pending'             => 'Pendent',
                'payment-error'       => 'El pagament no s\'ha realitzat per aquesta descàrrega.',
                'records-found'       => 'Registre(s) trobat(s)',
                'remaining-downloads' => 'Descàrregues Restants',
                'status'              => 'Estat',
                'title'               => 'Títol',
            ],

            'wishlist' => [
                'color'              => 'Color',
                'delete-all'         => 'Eliminar-ho Tot',
                'empty'              => 'No s\'han afegit productes a la llista de desitjos.',
                'move-to-cart'       => 'Moure a la Cistella',
                'moved'              => 'Article mogut amb èxit a la cistella',
                'moved-success'      => 'Article mogut amb èxit a la cistella',
                'page-title'         => 'Llista de Desitjos',
                'product-removed'    => 'El producte ja no està disponible, ha estat eliminat per l’administrador',
                'profile'            => 'Perfil',
                'remove'             => 'Eliminar',
                'remove-all-success' => 'Tots els articles de la teva llista de desitjos han estat eliminats',
                'remove-fail'        => 'No s\'ha pogut eliminar l\'article de la llista de desitjos',
                'removed'            => 'Article eliminat amb èxit de la llista de desitjos',
                'see-details'        => 'Veure Detalls',
                'success'            => 'Article afegit amb èxit a la llista de desitjos',
                'title'              => 'Llista de Desitjos',
            ],

            'gdpr' => [
                'create-success'              => 'Sol·licitud creada correctament',
                'revoked-successfully'        => 'Sol·licitud revocada correctament',
                'success-verify'              => 'Èxit! S\'ha enviat el correu electrònic de verificació.',
                'success-verify-email-unsent' => 'Èxit! El correu electrònic de verificació no s\'ha enviat.',
                'unable-to-sent'              => 'No s\'ha pogut enviar el correu electrònic.',

                'index'   => [
                    'create-btn' => 'Crea sol·licitud',
                    'html'       => 'HTML',
                    'pdf'        => 'PDF',
                    'title'      => 'Sol·licituds de dades GDPR',

                    'modal' => [
                        'message' => 'Missatge',
                        'save'    => 'Desa',
                        'title'   => 'Crea una nova sol·licitud',

                        'type'    => [
                            'choose' => 'Tria',
                            'delete' => 'Elimina',
                            'title'  => 'Tipus',
                            'update' => 'Actualitza',
                        ],
                    ],

                    'datagrid' => [
                        'completed'  => 'Completat',
                        'date'       => 'Data',
                        'declined'   => 'Rebutjat',
                        'delete'     => 'Eliminar',
                        'id'         => 'ID',
                        'message'    => 'Missatge',
                        'pending'    => 'Pendent',
                        'processing' => 'Processant',
                        'revoke-btn' => 'Revoca',
                        'revoked'    => 'Revocat',
                        'status'     => 'Estat',
                        'type'       => 'Tipus',
                        'update'     => 'Actualitza',
                    ],
                ],

                'pdf' => [
                    'title' => 'Vista per defecte de la botiga',

                    'account-info' => [
                        'dob'          => 'Data de naixement',
                        'email'        => 'Correu electrònic',
                        'first-name'   => 'Nom',
                        'gender'       => 'Gènere',
                        'last-name'    => 'Cognom',
                        'phone'        => 'Telèfon',
                        'title'        => 'Informació del compte',
                    ],

                    'address-info' => [
                        'address'    => 'Adreça',
                        'address1'   => 'Adreça 1',
                        'address2'   => 'Adreça 2',
                        'city'       => 'Ciutat',
                        'company'    => 'Empresa',
                        'country'    => 'País',
                        'first-name' => 'Nom',
                        'last-name'  => 'Cognom',
                        'phone'      => 'Telèfon',
                        'postcode'   => 'Codi postal',
                        'state'      => 'Estat',
                        'title'      => 'Informació d\'adreça',
                        'vat-id'     => 'ID d\'IVA',
                    ],

                    'order-info' => [
                        'amount'       => 'Import',
                        'order-id'     => 'ID de comanda',
                        'product-name' => 'Nom del producte',
                        'qty'          => 'Quantitat',
                        'shipping'     => 'Enviament',
                        'sku'          => 'SKU',
                        'status'       => 'Estat',
                        'title'        => 'Informació de la comanda',
                        'type'         => 'Tipus',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'accordion' => [
            'default-content' => 'Contingut per defecte',
            'default-header'  => 'Capçalera per defecte',
        ],

        'drawer' => [
            'default-toggle' => 'Alternar per defecte',
        ],

        'media' => [
            'index' => [
                'add-attachments' => 'Afegir adjunts',
                'add-image'       => 'Afegir Imatge/Vídeo',
            ],
        ],

        'layouts' => [
            'header' => [
                'desktop' => [
                    'top' => [
                        'default-locale' => 'Idioma predeterminat',
                    ],

                    'bottom' => [
                        'all'           => 'Tot',
                        'back-button'   => 'Torna al menú principal',
                        'bagisto'       => 'Bagisto',
                        'categories'    => 'Categories',
                        'compare'       => 'Comparar',
                        'dropdown-text' => 'Gestiona la cistella, comandes i desitjats',
                        'logout'        => 'Tancar sessió',
                        'orders'        => 'Comandes',
                        'profile'       => 'Perfil',
                        'search'        => 'Cercar',
                        'search-text'   => 'Cerca productes aquí',
                        'sign-in'       => 'Inicia sessió',
                        'sign-up'       => 'Registra’t',
                        'submit'        => 'Envia',
                        'welcome'       => 'Benvingut',
                        'welcome-guest' => 'Benvingut convidat',
                        'wishlist'      => 'Llista de desitjos',
                    ],
                ],

                'mobile' => [
                    'account'       => 'Compte',
                    'back-button'   => 'Torna al menú principal',
                    'bagisto'       => 'Bagisto',
                    'compare'       => 'Comparar',
                    'currencies'    => 'Monedes',
                    'dropdown-text' => 'Gestiona la cistella, comandes i desitjats',
                    'locales'       => 'Idiomes',
                    'login'         => 'Registra’t o inicia sessió',
                    'logout'        => 'Tancar sessió',
                    'orders'        => 'Comandes',
                    'profile'       => 'Perfil',
                    'search'        => 'Cercar',
                    'search-text'   => 'Cerca productes aquí',
                    'sign-in'       => 'Inicia sessió',
                    'sign-up'       => 'Registra’t',
                    'welcome'       => 'Benvingut',
                    'welcome-guest' => 'Benvingut convidat',
                    'wishlist'      => 'Llista de desitjos',
                ],
            ],

            'footer' => [
                'about-us'               => 'Sobre nosaltres',
                'contact-us'             => 'Contacte',
                'currency'               => 'Moneda',
                'customer-service'       => 'Atenció al client',
                'email'                  => 'Correu electrònic',
                'footer-content'         => 'Contingut del peu de pàgina',
                'footer-text'            => '© Copyright 2010 - :current_year, Webkul Software (registrada a l’Índia). Tots els drets reservats.',
                'locale'                 => 'Idioma',
                'newsletter-text'        => 'Prepara’t per al nostre divertit butlletí!',
                'order-return'           => 'Comandes i devolucions',
                'payment-policy'         => 'Política de pagaments',
                'privacy-cookies-policy' => 'Política de privadesa i cookies',
                'shipping-policy'        => 'Política d’enviaments',
                'subscribe'              => 'Subscriu-te',
                'subscribe-newsletter'   => 'Subscriu-te al butlletí',
                'subscribe-stay-touch'   => 'Subscriu-te per mantenir-te en contacte.',
                'whats-new'              => 'Novetats',
            ],

            'cookie' => [
                'index' => [
                    'privacy-policy'           => 'Política de Privacitat',
                    'reject'                   => 'Rebutjar',
                    'accept'                   => 'Acceptar',
                    'learn-more-and-customize' => 'Més informació i personalitzar',
                ],

                'consent' => [
                    'your-cookie-consent-preferences'        => 'Les teves preferències de consentiment de cookies',
                    'save-and-continue'                      => 'Desar i continuar',
                    'strictly-necessary'                     => 'Estricament necessàries',
                    'basic-interactions'                     => 'Interaccions bàsiques i funcionalitats',
                    'experience-enhancement'                 => 'Millora de l\'experiència',
                    'measurements'                           => 'Mesures',
                    'targeting-and-advertising'              => 'Orientació i publicitat',
                ],
            ],
        ],

        'datagrid' => [
            'toolbar' => [
                'length-of' => ':length de',
                'results'   => ':total resultats',
                'selected'  => ':total seleccionats',

                'mass-actions' => [
                    'must-select-a-mass-action'        => 'Has de seleccionar una acció massiva.',
                    'must-select-a-mass-action-option' => 'Has de seleccionar una opció per a l’acció massiva.',
                    'no-records-selected'              => 'No s’han seleccionat registres.',
                    'select-action'                    => 'Selecciona acció',
                ],

                'search' => [
                    'title' => 'Cercar',
                ],

                'filter' => [
                    'apply-filter' => 'Aplicar filtre',
                    'title'        => 'Filtre',

                    'dropdown' => [
                        'select' => 'Selecciona',

                        'searchable' => [
                            'at-least-two-chars' => 'Introdueix almenys 2 caràcters...',
                            'no-results'         => 'Sense resultats...',
                        ],
                    ],

                    'custom-filters' => [
                        'clear-all' => 'Esborrar tot',
                    ],
                ],
            ],

            'table' => [
                'actions'              => 'Accions',
                'next-page'            => 'Pàgina següent',
                'no-records-available' => 'No hi ha registres disponibles.',
                'of'                   => 'de :total registres',
                'page-navigation'      => 'Navegació de pàgina',
                'page-number'          => 'Número de pàgina',
                'previous-page'        => 'Pàgina anterior',
                'showing'              => 'Mostrant :firstItem',
                'to'                   => 'fins a :lastItem',
            ],
        ],

        'modal' => [
            'default-content' => 'Contingut per defecte',
            'default-header'  => 'Capçalera per defecte',

            'confirm' => [
                'agree-btn'    => 'Acceptar',
                'disagree-btn' => 'No acceptar',
                'message'      => 'Estàs segur que vols realitzar aquesta acció?',
                'title'        => 'Estàs segur?',
            ],
        ],

        'products' => [
            'card' => [
                'add-to-cart'            => 'Afegir a la cistella',
                'add-to-compare'         => 'Afegir a comparar',
                'add-to-compare-success' => 'Element afegit correctament a la llista de comparació.',
                'add-to-wishlist'        => 'Afegir a la llista de desitjos',
                'already-in-compare'     => 'L\'element ja està afegit a la llista de comparació.',
                'new'                    => 'Nou',
                'review-description'     => 'Sigues el primer a revisar aquest producte',
                'sale'                   => 'Oferta',
            ],

            'carousel' => [
                'next'     => 'Següent',
                'previous' => 'Anterior',
                'view-all' => 'Veure tot',
            ],

            'ratings' => [
                'title' => 'Valoracions',
            ],
        ],

        'range-slider' => [
            'max-range' => 'Rang màxim',
            'min-range' => 'Rang mínim',
            'range'     => 'Rang:',
        ],

        'carousel' => [
            'image-slide' => 'Diapositiva d’imatge',
            'next'        => 'Següent',
            'previous'    => 'Anterior',
        ],

        'quantity-changer' => [
            'decrease-quantity' => 'Disminuir quantitat',
            'increase-quantity' => 'Augmentar quantitat',
        ],
    ],

    'products' => [
        'prices' => [
            'grouped' => [
                'starting-at' => 'A partir de',
            ],

            'configurable' => [
                'as-low-as' => 'Des de',
            ],
        ],

        'sort-by' => [
            'title'   => 'Ordenar per',
        ],

        'view' => [
            'type' => [
                'simple' => [
                    'customizable-options' => [
                        'none'         => 'Cap',
                        'total-amount' => 'Import Total',
                    ],
                ],

                'configurable' => [
                    'select-options'       => 'Si us plau, seleccioneu una opció',
                    'select-above-options' => 'Si us plau, seleccioneu les opcions anteriors',
                ],

                'bundle' => [
                    'none'         => 'Cap',
                    'total-amount' => 'Import Total',
                ],

                'downloadable' => [
                    'links'   => 'Enllaços',
                    'samples' => 'Mostres',
                    'sample'  => 'Mostra',
                ],

                'grouped' => [
                    'name' => 'Nom',
                ],

                'booking' => [
                    'location'    => 'Ubicació',
                    'view-on-map' => 'Veure al mapa',

                    'default' => [
                        'slot-duration-in-minutes' => ':minutes Minuts',
                        'slot-duration'            => 'Durada del slot',
                    ],

                    'appointment' => [
                        'closed'                   => 'Tancat',
                        'see-details'              => 'Veure detalls',
                        'slot-duration'            => 'Durada del slot',
                        'slot-duration-in-minutes' => ':minutes Minuts',
                        'today-availability'       => 'Disponibilitat d\'avui',
                    ],

                    'event' => [
                        'book-your-ticket' => 'Reserva la teva entrada',
                        'title'            => 'Esdeveniment el :',
                    ],

                    'rental'      => [
                        'choose-rent-option' => 'Tria l\'opció de lloguer',
                        'daily-basis'        => 'Diari',
                        'from'               => 'Des de',
                        'hourly-basis'       => 'Per hores',
                        'rent-an-item'       => 'Llogar un article',
                        'select-date'        => 'Selecciona la data',
                        'select-rent-time'   => 'Selecciona l\'hora de lloguer',
                        'select-slot'        => 'Selecciona el slot',
                        'select-time-slot'   => 'Selecciona el slot de temps',
                        'slot'               => 'Slot',
                        'no-slots-available' => 'No hi ha slots disponibles',
                        'to'                 => 'Fins a',
                    ],

                    'table'       => [
                        'book-a-table'             => 'Reserva una taula',
                        'closed'                   => 'Tancat',
                        'slot-duration'            => 'Durada del slot',
                        'slot-duration-in-minutes' => ':minutes Minuts',
                        'slots-for-all-days'       => 'Mostrar per a tots els dies',
                        'special-notes'            => 'Sol·licitud/Notes especials',
                        'today-availability'       => 'Disponibilitat d\'avui',
                    ],

                    'slots' => [
                        'book-an-appointment' => 'Reserva una cita',
                        'date'                => 'Data',
                        'no-slots-available'  => 'No hi ha slots disponibles',
                        'select-slot'         => 'Selecciona el slot',
                        'title'               => 'Slot',
                    ],
                ],
            ],

            'gallery' => [
                'product-image'   => 'Imatge del producte',
                'thumbnail-image' => 'Imatge en miniatura',
            ],

            'reviews' => [
                'attachments'      => 'Adjunts',
                'cancel'           => 'Cancel·lar',
                'comment'          => 'Comentari',
                'customer-review'  => 'Opinions dels clients',
                'empty-review'     => 'No s’han trobat ressenyes, sigues el primer a valorar aquest producte.',
                'failed-to-upload' => 'La imatge no s’ha pogut carregar',
                'load-more'        => 'Carregar més',
                'name'             => 'Nom',
                'rating'           => 'Valoració',
                'ratings'          => 'Valoracions',
                'submit-review'    => 'Enviar ressenya',
                'success'          => 'Ressenya enviada amb èxit.',
                'title'            => 'Títol',
                'translate'        => 'Traduir',
                'translating'      => 'Traduint...',
                'write-a-review'   => 'Escriure una ressenya',
            ],

            'add-to-cart'            => 'Afegir a la cistella',
            'add-to-compare'         => 'Producte afegit a la llista de comparació.',
            'add-to-wishlist'        => 'Afegir a la llista de desitjos',
            'additional-information' => 'Informació addicional',
            'already-in-compare'     => 'El producte ja està a la llista de comparació.',
            'buy-now'                => 'Comprar ara',
            'compare'                => 'Comparar',
            'description'            => 'Descripció',
            'related-product-title'  => 'Productes relacionats',
            'review'                 => 'Ressenyes',
            'tax-inclusive'          => 'Inclou tots els impostos',
            'up-sell-title'          => 'Hem trobat altres productes que podrien agradar-te.',
        ],

        'type' => [
            'abstract' => [
                'offers' => 'Compra :qty a :price cadascun i estalvia :discount',
            ],
        ],

        'booking' => [
            'closed' => 'Tancat',

            'cart'             => [
                'booking-from' => 'Reserva des de',
                'booking-till' => 'Reserva fins a',
                'daily'        => 'Diari',
                'event-from'   => 'Esdeveniment des de',
                'event-ticket' => 'Entrada per a l\'esdeveniment',
                'event-till'   => 'Esdeveniment fins a',
                'hourly'       => 'Per hores',

                'integrity'    => [
                    'event'                  => [
                        'expired' => 'Aquest esdeveniment ha expirat.',
                    ],

                    'missing_options'        => 'Falten opcions per a aquest producte.',
                    'inventory_warning'      => 'La quantitat sol·licitada no està disponible, si us plau intenta-ho més tard.',
                    'select_hourly_duration' => 'Selecciona una durada d\'una hora.',
                ],

                'rent-from'    => 'Lloguer des de',
                'rent-till'    => 'Lloguer fins a',
                'rent-type'    => 'Tipus de lloguer',
                'renting_type' => 'Tipus de lloguer',
                'special-note' => 'Sol·licitud/Notes especials',
            ],

            'per-ticket-price' => ':price Per entrada',
        ],
    ],

    'categories' => [
        'filters' => [
            'clear-all' => 'Esborrar tot',
            'filter'    => 'Filtrar',
            'filters'   => 'Filtres:',

            'search' => [
                'load-more'            => 'Carrega més',
                'loading'              => 'Carregant...',
                'no-options-available' => 'No hi ha opcions disponibles.',
                'results-info'         => 'Mostrant :currentCount de :totalCount opcions',
                'title'                => 'Cerca',
            ],

            'sort'      => 'Ordenar',
        ],

        'toolbar' => [
            'grid' => 'Quadrícula',
            'list' => 'Llista',
            'show' => 'Mostrar',
        ],

        'view' => [
            'empty'     => 'No hi ha productes disponibles en aquesta categoria',
            'load-more' => 'Carregar més',
        ],
    ],

    'search' => [
        'title'   => 'Aquests són els resultats per a : :query',
        'suggest' => 'Cerca en lloc de',
        'results' => 'Resultats de cerca',

        'images' => [
            'index' => [
                'only-images-allowed'  => 'Només es permeten imatges (.jpeg, .jpg, .png, ..).',
                'search'               => 'Cercar',
                'size-limit-error'     => 'Error de límit de mida',
                'something-went-wrong' => 'Alguna cosa ha fallat, si us plau, torna-ho a intentar més tard.',
            ],

            'results' => [
                'analyzed-keywords' => 'Paraules clau analitzades:',
            ],
        ],
    ],

    'compare' => [
        'already-added'      => 'L\'article ja ha estat afegit a la llista de comparació',
        'delete-all'         => 'Esborrar-ho tot',
        'empty-text'         => 'No tens articles a la teva llista de comparació',
        'item-add-success'   => 'L\'article s\'ha afegit correctament a la llista de comparació',
        'product-compare'    => 'Comparació de productes',
        'remove-all-success' => 'Tots els articles s\'han eliminat correctament.',
        'remove-error'       => 'Alguna cosa ha anat malament. Si us plau, intenta-ho més tard.',
        'remove-success'     => 'L\'article s\'ha eliminat correctament.',
        'title'              => 'Comparació de productes',
    ],

    'checkout' => [
        'success' => [
            'info'          => 'T\'enviarem els detalls de la teva comanda i la informació de seguiment per correu electrònic',
            'order-id-info' => 'El teu número de comanda és #:order_id',
            'thanks'        => 'Gràcies per la teva comanda!',
            'title'         => 'Comanda realitzada amb èxit',
        ],

        'cart' => [
            'continue-to-checkout'      => 'Continuar amb el Pagament',
            'illegal'                   => 'La quantitat no pot ser inferior a un.',
            'inactive-add'              => 'L\'article inactiu no es pot afegir a la cistella.',
            'inactive'                  => 'L\'article ha estat desactivat i posteriorment eliminat de la cistella.',
            'inventory-warning'         => 'La quantitat sol·licitada no està disponible, si us plau intenta-ho de nou més tard.',
            'item-add-to-cart'          => 'Producte afegit correctament',
            'minimum-order-message'     => 'L\'import mínim de la comanda és',
            'missing-fields'            => 'Falten alguns camps obligatoris per aquest producte.',
            'missing-options'           => 'Falten opcions per aquest producte.',
            'paypal-payment-cancelled'  => 'El pagament de Paypal ha estat cancel·lat.',
            'qty-missing'               => 'Almenys un producte ha de tenir una quantitat superior a 1.',
            'return-to-shop'            => 'Tornar a la Botiga',
            'rule-applied'              => 'Regla de cistella aplicada',
            'select-hourly-duration'    => 'Selecciona una durada d\'una hora.',
            'success-remove'            => 'L\'article s\'ha eliminat correctament de la cistella.',
            'suspended-account-message' => 'El teu compte ha estat suspès.',

            'index' => [
                'bagisto'                  => 'Bagisto',
                'cart'                     => 'Cistella',
                'continue-shopping'        => 'Continuar comprant',
                'empty-product'            => 'No tens productes a la teva cistella.',
                'excl-tax'                 => 'Excl. Impostos:',
                'home'                     => 'Inici',
                'items-selected'           => ':count Articles seleccionats',
                'move-to-wishlist'         => 'Moure a la llista de desitjos',
                'move-to-wishlist-success' => 'Els articles seleccionats s\'han mogut correctament a la llista de desitjos.',
                'price'                    => 'Preu',
                'product-name'             => 'Nom del Producte',
                'quantity'                 => 'Quantitat',
                'quantity-update'          => 'Quantitat actualitzada correctament',
                'remove'                   => 'Eliminar',
                'remove-selected-success'  => 'Els articles seleccionats s\'han eliminat correctament de la cistella.',
                'see-details'              => 'Veure Detalls',
                'select-all'               => 'Seleccionar tot',
                'select-cart-item'         => 'Seleccionar article de la cistella',
                'tax'                      => 'Impost',
                'total'                    => 'Total',
                'update-cart'              => 'Actualitzar Cistella',
                'view-cart'                => 'Veure Cistella',

                'cross-sell' => [
                    'title' => 'Més opcions',
                ],
            ],

            'mini-cart' => [
                'continue-to-checkout' => 'Continuar amb el Pagament',
                'empty-cart'           => 'La teva cistella està buida',
                'excl-tax'             => 'Excl. Impostos:',
                'offer-on-orders'      => 'Obté fins a un 30% de DESCOMPTE en la teva primera comanda!',
                'remove'               => 'Eliminar',
                'see-details'          => 'Veure Detalls',
                'shopping-cart'        => 'Cistella de Compra',
                'subtotal'             => 'Subtotal',
                'view-cart'            => 'Veure Cistella',
            ],

            'summary' => [
                'cart-summary'              => 'Resum de la Cistella',
                'delivery-charges'          => 'Despeses d\'enviament',
                'delivery-charges-excl-tax' => 'Despeses d\'enviament (Excl. Impostos)',
                'delivery-charges-incl-tax' => 'Despeses d\'enviament (Incl. Impostos)',
                'discount-amount'           => 'Import de Descompte',
                'grand-total'               => 'Total General',
                'place-order'               => 'Fer comanda',
                'proceed-to-checkout'       => 'Continuar amb el Pagament',
                'sub-total'                 => 'Subtotal',
                'sub-total-excl-tax'        => 'Subtotal (Excl. Impostos)',
                'sub-total-incl-tax'        => 'Subtotal (Incl. Impostos)',
                'tax'                       => 'Impost',

                'estimate-shipping' => [
                    'country'        => 'País',
                    'info'           => 'Introdueix el teu destí per obtenir una estimació d\'enviament i impostos.',
                    'postcode'       => 'Codi Postal',
                    'select-country' => 'Selecciona País',
                    'select-state'   => 'Selecciona Estat',
                    'state'          => 'Estat',
                    'title'          => 'Calcular Enviament i Impostos',
                ],
            ],
        ],

        'onepage' => [
            'address' => [
                'add-new'                => 'Afegir nova adreça',
                'add-new-address'        => 'Afegir nova adreça',
                'back'                   => 'Tornar',
                'billing-address'        => 'Adreça de facturació',
                'check-billing-address'  => 'Falta l\'adreça de facturació.',
                'check-shipping-address' => 'Falta l\'adreça d\'enviament.',
                'city'                   => 'Ciutat',
                'company-name'           => 'Nom de l\'empresa',
                'confirm'                => 'Confirmar',
                'country'                => 'País',
                'email'                  => 'Correu electrònic',
                'first-name'             => 'Nom',
                'last-name'              => 'Cognom',
                'postcode'               => 'Codi postal',
                'proceed'                => 'Continuar',
                'same-as-billing'        => '¿Utilitzar la mateixa adreça per l\'enviament?',
                'save'                   => 'Desar',
                'save-address'           => 'Desar a la llibreta d\'adreces',
                'select-country'         => 'Seleccionar país',
                'select-state'           => 'Seleccionar estat',
                'shipping-address'       => 'Adreça d\'enviament',
                'state'                  => 'Estat',
                'street-address'         => 'Adreça',
                'telephone'              => 'Telèfon',
                'title'                  => 'Adreça',
                'vat-id'                 => 'Número d\'Identificació Fiscal',
            ],

            'index' => [
                'checkout' => 'Fer Comanda',
                'home'     => 'Inici',
            ],

            'payment' => [
                'payment-method' => 'Mètode de Pagament',
            ],

            'shipping' => [
                'shipping-method' => 'Mètode d\'Enviament',
            ],

            'summary' => [
                'cart-summary'              => 'Resum de la Cistella',
                'delivery-charges'          => 'Despeses d\'enviament',
                'delivery-charges-excl-tax' => 'Despeses d\'enviament (Excl. Impostos)',
                'delivery-charges-incl-tax' => 'Despeses d\'enviament (Incl. Impostos)',
                'discount-amount'           => 'Import de descompte',
                'excl-tax'                  => 'Excl. Impostos:',
                'grand-total'               => 'Total General',
                'place-order'               => 'Fer comanda',
                'price_&_qty'               => ':price × :qty',
                'processing'                => 'Processant',
                'sub-total'                 => 'Subtotal',
                'sub-total-excl-tax'        => 'Subtotal (Excl. Impostos)',
                'sub-total-incl-tax'        => 'Subtotal (Incl. Impostos)',
                'tax'                       => 'Impost',
            ],
        ],

        'coupon' => [
            'already-applied' => 'El codi de descompte ja ha estat aplicat.',
            'applied'         => 'Codi aplicat',
            'apply'           => 'Aplicar Codi',
            'apply-issue'     => 'No es pot aplicar el codi de descompte.',
            'button-title'    => 'Aplicar',
            'code'            => 'Codi de Descompte',
            'discount'        => 'Descompte de Codi',
            'enter-your-code' => 'Introdueix el teu codi',
            'error'           => 'Alguna cosa ha sortit malament',
            'invalid'         => 'El codi de descompte no és vàlid.',
            'remove'          => 'Eliminar Codi',
            'subtotal'        => 'Subtotal',
            'success-apply'   => 'Codi de descompte aplicat amb èxit.',
        ],

        'login' => [
            'email'    => 'Correu electrònic',
            'password' => 'Contrasenya',
            'title'    => 'Iniciar sessió',
        ],
    ],

    'home' => [
        'contact' => [
            'about'         => 'Deixa\'ns una nota i et responem el més ràpid possible',
            'desc'          => 'En què estàs pensant?',
            'describe-here' => 'Descriu-ho aquí',
            'email'         => 'Correu electrònic',
            'message'       => 'Missatge',
            'name'          => 'Nom',
            'phone-number'  => 'Número de telèfon',
            'submit'        => 'Envia',
            'title'         => 'Contacta\'ns',
        ],

        'index' => [
            'categories-carousel' => 'Carrusel de Categories',
            'image-carousel'      => 'Carrusel d\'Imatges',
            'offer'               => 'Obté FINS A un 40% de DESCOMPTE en la teva primera comanda COMPRA ARA',
            'product-carousel'    => 'Carrusel de Productes',
            'resend-verify-email' => 'Reenviar Correu de Verificació',
            'verify-email'        => 'Verifica el teu compte de correu electrònic',
        ],

        'thanks-for-contact' => 'Gràcies per contactar-nos amb els teus comentaris i preguntes. Et responem ben aviat.',
    ],

    'partials' => [
        'pagination' => [
            'next-page'          => 'Pàgina següent',
            'pagination-showing' => 'Mostrant :firstItem a :lastItem de :total entrades',
            'prev-page'          => 'Pàgina anterior',
        ],
    ],

    'errors' => [
        'go-to-home' => 'Anar a l\'inici',

        '404' => [
            'description' => 'Ostres! La pàgina que busques està de vacances. Sembla que no podem trobar el que busques.',
            'title'       => '404 Pàgina no trobada',
        ],

        '401' => [
            'description' => 'Ostres! Sembla que no tens permís per accedir a aquesta pàgina. Potser et falten les credencials necessàries.',
            'title'       => '401 No autoritzat',
        ],

        '403' => [
            'description' => 'Ostres! Aquesta pàgina està prohibida. Sembla que no tens els permisos necessaris per veure aquest contingut.',
            'title'       => '403 Prohibit',
        ],

        '500' => [
            'description' => 'Ostres! Alguna cosa ha anat malament. Sembla que tenim problemes per carregar la pàgina que busques.',
            'title'       => '500 Error intern del servidor',
        ],

        '503' => [
            'description' => 'Ostres! Sembla que estem temporalment fora de línia per manteniment. Torna més tard.',
            'title'       => '503 Servei no disponible',
        ],
    ],

    'layouts' => [
        'address'               => 'Adreça',
        'downloadable-products' => 'Productes descarregables',
        'sol·licitud-gdpr'      => 'Sol·licituds de GDPR',
        'my-account'            => 'El meu compte',
        'orders'                => 'Comandes',
        'profile'               => 'Perfil',
        'reviews'               => 'Ressenyes',
        'wishlist'              => 'Llista de desitjos',
    ],

    'subscription' => [
        'already'             => 'Ja està subscrit al nostre butlletí.',
        'subscribe-success'   => 'S\'ha subscrit correctament al nostre butlletí.',
        'unsubscribe-success' => 'S\'ha donat de baixa correctament del nostre butlletí.',
    ],

    'emails' => [
        'dear'   => 'Benvolgut/da :customer_name',
        'thanks' => 'Si necessita ajuda, contacti\'ns a <a href=":link" style=":style">:email</a>.<br/>Gràcies!',

        'customers' => [
            'registration' => [
                'credentials-description' => 'El seu compte ha estat creat. Els detalls del seu compte es mostren a continuació:',
                'description'             => 'El seu compte ha estat creat correctament i pot iniciar sessió amb la seva adreça de correu electrònic i contrasenya. Després d\'iniciar sessió, podrà accedir a més serveis, incloent la revisió de comandes anteriors, llistes de desitjos i l\'edició de la seva informació de compte.',
                'greeting'                => 'Benvingut i gràcies per registrar-se amb nosaltres!',
                'password'                => 'Contrasenya',
                'sign-in'                 => 'Iniciar sessió',
                'subject'                 => 'Nou registre de client',
                'username-email'          => 'Nom d\'usuari/Correu electrònic',
            ],

            'forgot-password' => [
                'description'    => 'Rep aquest correu electrònic perquè hem rebut una sol·licitud per restablir la contrasenya del seu compte.',
                'greeting'       => 'Contrasenya oblidada!',
                'reset-password' => 'Restablir contrasenya',
                'subject'        => 'Correu electrònic per restablir la contrasenya',
            ],

            'update-password' => [
                'description' => 'Rep aquest correu electrònic perquè ha actualitzat la seva contrasenya.',
                'greeting'    => 'Contrasenya actualitzada!',
                'subject'     => 'Contrasenya actualitzada',
            ],

            'verification' => [
                'description'  => 'Si us plau, faci clic al botó de baix per confirmar la seva adreça de correu electrònic.',
                'greeting'     => 'Benvingut!',
                'subject'      => 'Correu electrònic de verificació del compte',
                'verify-email' => 'Confirmar adreça de correu electrònic',
            ],

            'commented' => [
                'description' => 'Nota - :note',
                'subject'     => 'Nou comentari afegit',
            ],

            'subscribed' => [
                'description' => 'Felicitats i benvingut a la nostra comunitat de butlletins! Estem encantats de tenir-te a bord i mantenir-te informat amb les últimes notícies, tendències i ofertes exclusives.',
                'greeting'    => 'Benvingut al nostre butlletí!',
                'subject'     => '¡Vostè! S\'ha subscrit al nostre butlletí',
                'unsubscribe' => 'Donar-se de baixa',
            ],

            'gdpr' => [
                'new-delete-request' => 'New Request For Data Delete',
                'new-update-request' => 'New Request For Data Update',

                'new-request' => [
                    'delete-summary' => 'Zusammenfassung der Löschanforderung',
                    'message'        => 'Message : ',
                    'request-status' => 'Request Status : ',
                    'request-type'   => 'Request Type : ',
                    'update-summary' => 'Zusammenfassung der Aktualisierungsanforderung',
                ],

                'status-update' => [
                    'subject'        => 'Your GDPR Request Has Been Updated',
                    'summary'        => 'Your GDPR Request Status has been Updated',
                    'request-status' => 'Request Status:',
                    'request-type'   => 'Request Type:',
                    'message'        => 'Message:',
                ],
            ],

            'reminder' => [
                'already-paid'    => 'Si ja heu fet el pagament, si us plau, ignoreu aquest missatge.',
                'invoice-overdue' => 'Aquest és un recordatori amable que la vostra factura està vençuda. Us demanem amablement que feu el pagament tan aviat com sigui possible.',
                'subject'         => 'Recordatori de factura',
            ],
        ],

        'contact-us' => [
            'contact-from'    => 'a través del formulari de contacte del lloc web',
            'reply-to-mail'   => 'si us plau, respongui a aquest correu electrònic.',
            'reach-via-phone' => 'Alternativament, pot comunicar-se amb nosaltres por telèfon al',
            'inquiry-from'    => 'Consulta de',
            'to'              => 'Per a contactar a',
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Gràcies per la seva comanda :order_id, realitzada el :created_at',
                'subject'  => 'Nova confirmació de comanda',
                'summary'  => 'Resum de la comanda',
                'title'    => 'Confirmació de comanda!',
            ],

            'invoiced' => [
                'greeting' => 'La seva factura #:invoice_id per la comanda :order_id, creada el :created_at',
                'subject'  => 'Nova confirmació de factura',
                'summary'  => 'Resum de la factura',
                'title'    => 'Confirmació de factura!',
            ],

            'shipped' => [
                'greeting' => 'La seva comanda :order_id, realitzada el :created_at, ha estat enviada',
                'subject'  => 'Nova confirmació d\'enviament',
                'summary'  => 'Resum de l\'enviament',
                'title'    => 'Comanda enviada!',
            ],

            'refunded' => [
                'greeting' => 'S\'ha iniciat el reemborsament per la comanda :order_id, realitzada el :created_at',
                'subject'  => 'Nova confirmació de reemborsament',
                'summary'  => 'Resum del reemborsament',
                'title'    => 'Comanda reemborsada!',
            ],

            'canceled' => [
                'greeting' => 'La seva comanda :order_id, realitzada el :created_at, ha estat cancel·lada',
                'subject'  => 'Nova cancel·lació de comanda',
                'summary'  => 'Resum de la comanda',
                'title'    => 'Comanda cancel·lada!',
            ],

            'commented' => [
                'subject' => 'Nou comentari afegit',
                'title'   => 'Nou comentari afegit a la seva comanda :order_id, realitzada el :created_at',
            ],

            'billing-address'            => 'Adreça de facturació',
            'carrier'                    => 'Transportista',
            'contact'                    => 'Contacte',
            'discount'                   => 'Descompte',
            'excl-tax'                   => 'Excl. Impostos: ',
            'grand-total'                => 'Total',
            'name'                       => 'Nom',
            'payment'                    => 'Pagament',
            'price'                      => 'Preu',
            'qty'                        => 'Quantitat',
            'shipping'                   => 'Enviament',
            'shipping-address'           => 'Adreça d\'enviament',
            'shipping-handling'          => 'Enviament i manipulació',
            'shipping-handling-excl-tax' => 'Enviament i manipulació (Excl. Impostos)',
            'shipping-handling-incl-tax' => 'Enviament i manipulació (Incl. Impostos)',
            'sku'                        => 'SKU',
            'subtotal'                   => 'Subtotal',
            'subtotal-excl-tax'          => 'Subtotal (Excl. Impostos)',
            'subtotal-incl-tax'          => 'Subtotal (Incl. Impostos)',
            'tax'                        => 'Impostos',
            'tracking-number'            => 'Número de seguiment: :tracking_number',
        ],
    ],
];
