<?php

return [
    'users' => [
        'sessions' => [
            'email'                  => 'Адреса електронної пошти',
            'forget-password-link'   => 'Забули пароль?',
            'password'               => 'Пароль',
            'powered-by-description' => 'Працює на платформі :bagisto, спільний проект :webkul.',
            'submit-btn'             => 'Увійти',
            'title'                  => 'Увійти',
        ],

        'forget-password' => [
            'create' => [
                'email'                  => 'Зареєстрована електронна пошта',
                'email-not-exist'        => 'Електронна пошта не існує',
                'page-title'             => 'Забули пароль',
                'powered-by-description' => 'Працює на платформі :bagisto, спільний проект :webkul.',
                'reset-link-sent'        => 'Посилання на скидання пароля відправлено',
                'sign-in-link'           => 'Повернутися до увійти?',
                'submit-btn'             => 'Скинути',
                'title'                  => 'Відновити пароль',
            ],
        ],

        'reset-password' => [
            'back-link-title'        => 'Повернутися до увійти?',
            'confirm-password'       => 'Підтвердити пароль',
            'email'                  => 'Зареєстрована електронна пошта',
            'password'               => 'Пароль',
            'powered-by-description' => 'Працює на платформі :bagisto, спільний проект :webkul.',
            'submit-btn'             => 'Скинути пароль',
            'title'                  => 'Скинути пароль',
        ],
    ],

    'notifications' => [
        'description-text' => 'Список всіх повідомлень',
        'marked-success'   => 'Усі повідомлення позначено як прочитані',
        'no-record'        => 'Записів не знайдено',
        'of'               => 'з',
        'per-page'         => 'на сторінці',
        'read-all'         => 'Позначити як прочитане',
        'title'            => 'Повідомлення',
        'view-all'         => 'Переглянути всі',

        'order-status-messages' => [
            'all'             => 'Все',
            'canceled'        => 'Замовлення скасовано',
            'closed'          => 'Замовлення закрито',
            'completed'       => 'Замовлення завершено',
            'pending'         => 'Замовлення очікує на оплату',
            'pending-payment' => 'Очікується оплата',
            'processing'      => 'Замовлення обробляється',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => 'Назад',
            'change-password'   => 'Змінити пароль',
            'confirm-password'  => 'Підтвердити пароль',
            'current-password'  => 'Поточний пароль',
            'email'             => 'Електронна пошта',
            'general'           => 'Загальні',
            'invalid-password'  => 'Ви ввели неправильний поточний пароль.',
            'name'              => 'Ім я ',
            'password'          => 'Пароль',
            'profile-image'     => 'Зображення профілю',
            'save-btn'          => 'Зберегти обліковий запис',
            'title'             => 'Мій обліковий запис',
            'update-success'    => 'Обліковий запис успішно оновлено',
            'upload-image-info' => 'Завантажте зображення профілю (110px X 110px) у форматі PNG або JPG',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => 'Додати клієнта',
            'add-product'                 => 'Додати продукт',
            'all-channels'                => 'Усі канали',
            'attribute-code'              => 'Код атрибута',
            'average-sale'                => 'Середній обсяг замовлення',
            'color'                       => 'Колір',
            'customer-info'               => 'Не знайдено клієнта з найбільшими продажами',
            'customer-with-most-sales'    => 'Клієнт з найбільшими продажами',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => 'Поріг Пустоти',
            'empty-threshold-description' => 'Немає доступних товарів',
            'end-date'                    => 'Дата закінчення',
            'from'                        => 'З',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ Ще продуктів',
            'order'                       => ':total_orders Замовлень',
            'order-count'                 => ':count Замовлень',
            'order-id'                    => '#:id',
            'overall-details'             => 'Загальна інформація',
            'pay-by'                      => 'Оплатити через - :method',
            'product-count'               => ':count Продуктів',
            'product-image'               => 'Зображення продукту',
            'product-info'                => 'Додайте пов язані продукти в дорозі.',
            'product-number'              => 'Продукт - :product_number',
            'revenue'                     => 'Дохід :total',
            'sale-count'                  => ':count Продажів',
            'sales'                       => 'Продажі',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => 'Дата початку',
            'stock-threshold'             => 'Поріг запасу',
            'store-stats'                 => 'Статистика магазину',
            'title'                       => 'Панель інструментів',
            'to'                          => 'До',
            'today-customers'             => 'Клієнти сьогодні',
            'today-details'               => 'Деталі сьогодні',
            'today-orders'                => 'Замовлення сьогодні',
            'today-sales'                 => 'Продажі сьогодні',
            'top-performing-categories'   => 'Найкращі категорії',
            'top-selling-products'        => 'Найпопулярніші продукти',
            'total-customers'             => 'Загальна кількість клієнтів',
            'total-orders'                => 'Загальна кількість замовлень',
            'total-sales'                 => 'Загальна кількість продажів',
            'total-stock'                 => ':total_stock Запасів',
            'total-unpaid-invoices'       => 'Загальна кількість невиплачених рахунків',
            'unique-visitors'             => ':count Унікальний',
            'user-info'                   => 'Швидкий перегляд подій в вашому магазині',
            'user-name'                   => 'Привіт! :user_name',
            'visitors'                    => 'Відвідувач',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => 'Створити замовлення',
                'title'      => 'Замовлення',

                'search-customer' => [
                    'create-btn'  => 'Створити клієнта',
                    'empty-info'  => 'Немає доступних клієнтів за вказаним пошуковим запитом.',
                    'empty-title' => 'Клієнти не знайдені',
                    'search-by'   => 'Пошук за електронною поштою або ім\'ям',
                    'title'       => 'Вибрати клієнта',
                ],

                'datagrid' => [
                    'canceled'        => 'Скасовано',
                    'channel-name'    => 'Канал',
                    'closed'          => 'Закрито',
                    'completed'       => 'Завершено',
                    'customer'        => 'Клієнт',
                    'date'            => 'Дата',
                    'email'           => 'Електронна пошта',
                    'fraud'           => 'Шахрайство',
                    'grand-total'     => 'Загальний підсумок',
                    'id'              => '#:id',
                    'items'           => 'Товари',
                    'location'        => 'Місцезнаходження',
                    'order-id'        => 'Номер замовлення',
                    'pay-by'          => 'Сплачено через - :method',
                    'pay-via'         => 'Сплатити через',
                    'pending-payment' => 'Очікується оплата',
                    'pending'         => 'В очікуванні',
                    'processing'      => 'Обробка',
                    'product-count'   => ':count + Ще більше продуктів',
                    'status'          => 'Статус',
                    'success'         => 'Успішно',
                    'view'            => 'Перегляд',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'Додати в кошик',
                'back-btn'                => 'Назад',
                'check-billing-address'   => 'Відсутня адреса для виставлення рахунку.',
                'check-shipping-address'  => 'Відсутня адреса доставки.',
                'configuration'           => 'Конфігурація',
                'coupon-already-applied'  => 'Код купона вже застосований.',
                'coupon-applied'          => 'Код купона успішно застосований.',
                'coupon-error'            => 'Не вдалося застосувати код купона.',
                'coupon-not-found'        => 'Код купона не знайдено',
                'coupon-remove'           => 'Код купона успішно видалено.',
                'error'                   => 'Щось пішло не так',
                'minimum-order-error'     => 'Мінімальна сума замовлення не досягнута.',
                'order-placed-success'    => 'Замовлення успішно оформлено.',
                'payment-not-supported'   => 'Цей спосіб оплати не підтримується',
                'save-btn'                => 'Створити замовлення',
                'specify-payment-method'  => 'Відсутній спосіб оплати.',
                'specify-shipping-method' => 'Відсутній спосіб доставки.',
                'title'                   => 'Створити замовлення для :name',

                'types' => [
                    'simple' => [
                        'none'         => 'Немає',
                        'total-amount' => 'Загальна сума',
                    ],

                    'configurable' => [
                        'select-options' => 'Будь ласка, виберіть опцію',
                    ],

                    'bundle' => [
                        'none'         => 'Немає',
                        'total-amount' => 'Загальна сума',
                    ],

                    'grouped' => [
                        'name' => 'Назва',
                    ],

                    'downloadable' => [
                        'title' => 'Посилання',
                    ],

                    'virtual' => [
                        'none'         => 'Немає',
                        'total-amount' => 'Загальна сума',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => 'Товар успішно додано в кошик',
                    'success-remove'      => 'Елемент успішно видалено з кошика',
                    'success-update'      => 'Елемент кошика успішно оновлено',

                    'items' => [
                        'add-product'       => 'Додати товар',
                        'amount-per-unit'   => ':amount за одиницю x :qty Кількість',
                        'delete'            => 'Видалити',
                        'empty-description' => 'В кошику немає товарів.',
                        'empty-title'       => 'Порожній кошик',
                        'excl-tax'          => 'Без ПДВ',
                        'move-to-wishlist'  => 'Перемістити в список бажань',
                        'see-details'       => 'Детальніше',
                        'sku'               => 'Артикул - :sku',
                        'sub-total'         => 'Підсумок - :sub_total',
                        'title'             => 'Товари в кошику',

                        'search' => [
                            'add-to-cart'   => 'Додати в кошик',
                            'available-qty' => ':qty доступно',
                            'empty-info'    => 'Немає товарів за вказаним пошуковим запитом.',
                            'empty-title'   => 'Товари не знайдені',
                            'product-image' => 'Зображення товару',
                            'qty'           => 'Кількість',
                            'sku'           => 'Артикул - :sku',
                            'title'         => 'Пошук товарів',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => 'Додати адресу',
                        'add-new'          => 'Додати нову адресу',
                        'add-new-address'  => 'Додати нову адресу',
                        'addresses'        => 'Адреси',
                        'back'             => 'Назад',
                        'billing-address'  => 'Адреса для виставлення рахунку',
                        'city'             => 'Місто',
                        'company-name'     => 'Назва компанії',
                        'confirm'          => 'Підтвердити',
                        'country'          => 'Країна',
                        'edit-btn'         => 'Редагувати адресу',
                        'email'            => 'Електронна пошта',
                        'first-name'       => 'Ім\'я',
                        'last-name'        => 'Прізвище',
                        'postcode'         => 'Поштовий індекс',
                        'proceed'          => 'Продовжити',
                        'same-as-billing'  => 'Використовувати ту саму адресу для доставки?',
                        'save'             => 'Зберегти',
                        'save-address'     => 'Зберегти в адресну книгу',
                        'select-country'   => 'Виберіть країну',
                        'select-state'     => 'Виберіть область',
                        'shipping-address' => 'Адреса доставки',
                        'state'            => 'Область',
                        'street-address'   => 'Вулиця, будинок',
                        'telephone'        => 'Телефон',
                        'title'            => 'Адреса',
                        'vat-id'           => 'ІПН',
                    ],

                    'payment' => [
                        'title' => 'Оплата',
                    ],

                    'shipping' => [
                        'title' => 'Доставка',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'Застосувати купон',
                        'discount-amount'          => 'Сума знижки',
                        'enter-your-code'          => 'Введіть свій код',
                        'grand-total'              => 'Загальна сума',
                        'place-order'              => 'Оформити замовлення',
                        'processing'               => 'Обробка',
                        'shipping-amount-excl-tax' => 'Сума доставки (без ПДВ)',
                        'shipping-amount-incl-tax' => 'Сума доставки (з ПДВ)',
                        'shipping-amount'          => 'Сума доставки',
                        'sub-total-excl-tax'       => 'Підсумок (без ПДВ)',
                        'sub-total-incl-tax'       => 'Підсумок (з ПДВ)',
                        'sub-total'                => 'Підсумок',
                        'tax'                      => 'ПДВ',
                        'title'                    => 'Резюме замовлення',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'Додати в кошик',
                    'delete'            => 'Видалити',
                    'empty-description' => 'В кошику немає товарів.',
                    'empty-title'       => 'Порожній кошик',
                    'excl-tax'          => 'Без ПДВ',
                    'see-details'       => 'Детальніше',
                    'sku'               => 'Артикул - :sku',
                    'title'             => 'Товари в кошику',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'Додати в кошик',
                    'empty-description' => 'В вашому списку останніх замовлень немає товарів.',
                    'empty-title'       => 'Порожні замовлення',
                    'see-details'       => 'Детальніше',
                    'sku'               => 'Артикул - :sku',
                    'title'             => 'Товари з останніх замовлень',
                    'view'              => 'Перегляд',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'Додати в кошик',
                    'delete'            => 'Видалити',
                    'empty-description' => 'В вашому списку бажань немає товарів.',
                    'empty-title'       => 'Порожній список бажань',
                    'see-details'       => 'Детальніше',
                    'sku'               => 'Артикул - :sku',
                    'title'             => 'Товари в списку бажань',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'Додати в кошик',
                    'delete'            => 'Видалити',
                    'empty-description' => 'В вашому списку порівняння немає товарів.',
                    'empty-title'       => 'Порожній список порівняння',
                    'sku'               => 'Артикул - :sku',
                    'title'             => 'Товари в списку порівняння',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount за одиницю x :qty кількість',
                'billing-address'                => 'Адреса для виставлення рахунку',
                'cancel'                         => 'Скасувати',
                'cancel-msg'                     => 'Ви впевнені, що хочете скасувати це замовлення',
                'cancel-success'                 => 'Замовлення успішно скасовано',
                'canceled'                       => 'Скасовано',
                'channel'                        => 'Канал',
                'closed'                         => 'Закрито',
                'comment-success'                => 'Коментар успішно додано.',
                'comments'                       => 'Коментарі',
                'completed'                      => 'Завершено',
                'contact'                        => 'Контакт',
                'create-success'                 => 'Замовлення успішно створено',
                'currency'                       => 'Валюта',
                'customer'                       => 'Клієнт',
                'customer-group'                 => 'Група клієнта',
                'customer-not-notified'          => ':date | Клієнт <b>Не повідомлений</b>',
                'customer-notified'              => ':date | Клієнт <b>Повідомлений</b>',
                'discount'                       => 'Знижка - :discount',
                'download-pdf'                   => 'Завантажити PDF',
                'fraud'                          => 'Шахрайство',
                'grand-total'                    => 'Загальна сума - :grand_total',
                'invoice-id'                     => 'Рахунок-фактура #:invoice',
                'invoices'                       => 'Рахунки-фактури',
                'item-canceled'                  => 'Скасовано (:qty_canceled)',
                'item-invoice'                   => 'Виставлено рахунок-фактуру (:qty_invoiced)',
                'item-ordered'                   => 'Замовлено (:qty_ordered)',
                'item-refunded'                  => 'Повернуто (:qty_refunded)',
                'item-shipped'                   => 'Відправлено (:qty_shipped)',
                'name'                           => 'Ім\'я',
                'no-invoice-found'               => 'Рахунок-фактура не знайдений',
                'no-refund-found'                => 'Повернення не знайдено',
                'no-shipment-found'              => 'Відправлення не знайдено',
                'notify-customer'                => 'Повідомити клієнта',
                'order-date'                     => 'Дата замовлення',
                'order-information'              => 'Інформація про замовлення',
                'order-status'                   => 'Статус замовлення',
                'payment-and-shipping'           => 'Оплата та доставка',
                'payment-method'                 => 'Спосіб оплати',
                'pending'                        => 'В очікуванні',
                'pending_payment'                => 'Очікування оплати',
                'per-unit'                       => 'За одиницю',
                'price'                          => 'Ціна - :price',
                'price-excl-tax'                 => 'Ціна (без податку) - :price',
                'price-incl-tax'                 => 'Ціна (з податком) - :price',
                'processing'                     => 'Обробка',
                'quantity'                       => 'Кількість',
                'refund'                         => 'Повернення',
                'refund-id'                      => 'Повернення #:refund',
                'refunded'                       => 'Повернуто',
                'reorder'                        => 'Повторне замовлення',
                'ship'                           => 'Відправити',
                'shipment'                       => 'Відправлення #:shipment',
                'shipments'                      => 'Відправлення',
                'shipping-address'               => 'Адреса доставки',
                'shipping-and-handling'          => 'Доставка та обробка',
                'shipping-and-handling-excl-tax' => 'Доставка та обробка (без податку)',
                'shipping-and-handling-incl-tax' => 'Доставка та обробка (з податком)',
                'shipping-method'                => 'Спосіб доставки',
                'shipping-price'                 => 'Вартість доставки',
                'sku'                            => 'Артикул - :sku',
                'status'                         => 'Статус',
                'sub-total'                      => 'Підсумок - :sub_total',
                'sub-total-excl-tax'             => 'Підсумок (без податку) - :sub_total',
                'sub-total-incl-tax'             => 'Підсумок (з податком) - :sub_total',
                'submit-comment'                 => 'Надіслати коментар',
                'summary-discount'               => 'Знижка',
                'summary-grand-total'            => 'Загальна сума',
                'summary-sub-total'              => 'Підсумок',
                'summary-sub-total-excl-tax'     => 'Підсумок (без податку)',
                'summary-sub-total-incl-tax'     => 'Підсумок (з податком)',
                'summary-tax'                    => 'Податок',
                'tax'                            => 'Податок (:percent) - :tax',
                'title'                          => 'Замовлення #:order_id',
                'total-due'                      => 'Загальна сума до сплати',
                'total-paid'                     => 'Загальна сума оплати',
                'total-refund'                   => 'Загальна сума повернення',
                'view'                           => 'Перегляд',
                'write-your-comment'             => 'Напишіть свій коментар',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => 'Відвантаження',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => 'Джерело інвентаризації',
                    'order-date'       => 'Дата замовлення',
                    'order-id'         => 'Номер замовлення',
                    'shipment-date'    => 'Дата відвантаження',
                    'shipment-to'      => 'Доставлено до',
                    'total-qty'        => 'Загальна кількість',
                    'view'             => 'Переглянути',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount за одиницю x :qty Кількість',
                'cancel-error'     => 'Замовлення не можна скасувати',
                'carrier-name'     => 'Назва перевізника',
                'create-btn'       => 'Створити відвантаження',
                'creation-error'   => 'Помилка при створенні відвантаження',
                'item-canceled'    => 'Скасовано (:qty_canceled)',
                'item-invoice'     => 'Виставлено рахунок (:qty_invoiced)',
                'item-ordered'     => 'Замовлено (:qty_ordered)',
                'item-refunded'    => 'Повернуто (:qty_refunded)',
                'item-shipped'     => 'Відправлено (:qty_shipped)',
                'order-error'      => 'Відвантаження не є дійсним',
                'per-unit'         => 'За одиницю',
                'qty-available'    => 'Доступна кількість',
                'qty-to-ship'      => 'Кількість для відвантаження',
                'quantity-invalid' => 'Кількість недійсна',
                'sku'              => 'SKU - :sku',
                'source'           => 'Джерело',
                'success'          => 'Відвантаження створено успішно',
                'title'            => 'Створити нове відвантаження',
                'tracking-number'  => 'Номер відстеження',
            ],

            'view' => [
                'billing-address'      => 'Платіжна адреса',
                'carrier-title'        => 'Назва перевізника',
                'channel'              => 'Канал',
                'currency'             => 'Валюта',
                'customer'             => 'Клієнт',
                'email'                => 'Електронна пошта - :email',
                'inventory-source'     => 'Джерело інвентаризації',
                'order-date'           => 'Дата замовлення',
                'order-id'             => 'Номер замовлення',
                'order-information'    => 'Інформація про замовлення',
                'order-status'         => 'Статус замовлення',
                'ordered-items'        => 'Замовлені товари',
                'payment-and-shipping' => 'Оплата та доставка',
                'payment-method'       => 'Метод оплати',
                'product-image'        => 'Зображення продукту',
                'qty'                  => 'Кількість - :qty',
                'shipping-address'     => 'Адреса доставки',
                'shipping-method'      => 'Спосіб доставки',
                'shipping-price'       => 'Вартість доставки',
                'sku'                  => 'SKU - :sku ',
                'title'                => 'Відвантаження #:shipment_id',
                'tracking-number'      => 'Номер відстеження',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => 'Повернення',

                'datagrid' => [
                    'billed-to'       => 'Оплачено для',
                    'id'              => 'ID',
                    'order-id'        => 'Номер замовлення',
                    'refund-date'     => 'Дата повернення',
                    'refunded-amount' => 'Повернена сума',
                    'view'            => 'Переглянути',
                ],
            ],

            'view' => [
                'account-information'        => 'Інформація про обліковий запис',
                'adjustment-fee'             => 'Комісія за коригування',
                'adjustment-refund'          => 'Повернення за коригування',
                'base-discounted-amount'     => 'Сума зі знижкою - :base_discounted_amount',
                'billing-address'            => 'Адреса для виставлення рахунку',
                'currency'                   => 'Валюта',
                'sub-total-amount-excl-tax'  => 'Підсумкова сума (без податку) - :discounted_amount',
                'sub-total-amount-incl-tax'  => 'Підсумкова сума (з податком) - :discounted_amount',
                'sub-total-amount'           => 'Підсумкова сума - :discounted_amount',
                'grand-total'                => 'Загальна сума',
                'order-channel'              => 'Канал замовлення',
                'order-date'                 => 'Дата замовлення',
                'order-id'                   => 'ID замовлення',
                'order-information'          => 'Інформація про замовлення',
                'order-status'               => 'Статус замовлення',
                'payment-information'        => 'Інформація про оплату',
                'payment-method'             => 'Спосіб оплати',
                'price-excl-tax'             => 'Ціна (без податку) - :price',
                'price-incl-tax'             => 'Ціна (з податком) - :price',
                'price'                      => 'Ціна - :price',
                'product-image'              => 'Зображення товару',
                'product-ordered'            => 'Замовлені товари',
                'qty'                        => 'Кількість - :qty',
                'refund'                     => 'Повернення',
                'shipping-address'           => 'Адреса доставки',
                'shipping-handling-excl-tax' => 'Вартість доставки та обробки (без податку)',
                'shipping-handling-incl-tax' => 'Вартість доставки та обробки (з податком)',
                'shipping-handling'          => 'Вартість доставки та обробки',
                'shipping-method'            => 'Спосіб доставки',
                'shipping-price'             => 'Вартість доставки',
                'sku'                        => 'Артикул - :sku',
                'sub-total-excl-tax'         => 'Підсумкова сума (без податку)',
                'sub-total-incl-tax'         => 'Підсумкова сума (з податком)',
                'sub-total'                  => 'Підсумкова сума',
                'tax'                        => 'Податок',
                'tax-amount'                 => 'Сума податку - :tax_amount',
                'title'                      => 'Повернення #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => 'Виправлення комісії',
                'adjustment-refund'           => 'Виправлення повернення',
                'amount-per-unit'             => ':amount за одиницю x :qty Кількість',
                'create-success'              => 'Повернення успішно створено',
                'creation-error'              => 'Створення повернення не дозволено.',
                'discount-amount'             => 'Сума знижки',
                'grand-total'                 => 'Загальна сума',
                'invalid-qty'                 => 'Виявлено недійсну кількість для виставлення рахунків за товари.',
                'invalid-refund-amount-error' => 'Сума повернення повинна бути ненульовою.',
                'item-canceled'               => 'Скасовано (:qty_canceled)',
                'item-invoice'                => 'Виставлено рахунок (:qty_invoiced)',
                'item-ordered'                => 'Замовлено (:qty_ordered)',
                'item-refunded'               => 'Повернено (:qty_refunded)',
                'item-shipped'                => 'Відправлено (:qty_shipped)',
                'per-unit'                    => 'За одиницю',
                'price'                       => 'Ціна',
                'qty-to-refund'               => 'Кількість для повернення',
                'refund-btn'                  => 'Повернути',
                'refund-limit-error'          => 'Суму повернення :amount не можна обробити.',
                'refund-shipping'             => 'Повернення доставки',
                'sku'                         => 'Артикул - :sku',
                'subtotal'                    => 'Підсумок',
                'tax-amount'                  => 'Сума податку',
                'title'                       => 'Створити повернення',
                'update-totals-btn'           => 'Оновити суми',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => 'Рахунки',

                'datagrid' => [
                    'action'              => 'Дії',
                    'days-left'           => 'Залишилось :count дн(і/ів)',
                    'days-overdue'        => ':count дн(і/ів) прострочено',
                    'grand-total'         => 'Загальна сума',
                    'id'                  => 'ID',
                    'invoice-date'        => 'Дата рахунку',
                    'mass-update-success' => 'Вибрані рахунки успішно оновлено.',
                    'order-id'            => 'ID замовлення',
                    'overdue'             => 'Просрочено',
                    'overdue-by'          => 'Прострочено на :count дн(і/ів)',
                    'paid'                => 'Оплачено',
                    'pending'             => 'В очікуванні',
                    'status'              => 'Статус',
                    'update-status'       => 'Оновити статус',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount за одиницю x :qty Кількість',
                'channel'                        => 'Канал',
                'customer-email'                 => 'Електронна пошта - :email',
                'customer'                       => 'Клієнт',
                'discount'                       => 'Сума знижки - :discount',
                'email'                          => 'Електронна пошта',
                'grand-total'                    => 'Загальна сума',
                'invoice-items'                  => 'Позиції рахунку',
                'invoice-sent'                   => 'Рахунок успішно відправлено',
                'invoice-status'                 => 'Статус рахунку',
                'order-date'                     => 'Дата замовлення',
                'order-id'                       => 'ID замовлення',
                'order-information'              => 'Інформація про замовлення',
                'order-status'                   => 'Статус замовлення',
                'price-excl-tax'                 => 'Ціна (без податку) - :price',
                'price-incl-tax'                 => 'Ціна (з податком) - :price',
                'price'                          => 'Ціна - :price',
                'print'                          => 'Друк',
                'product-image'                  => 'Зображення товару',
                'qty'                            => 'Кількість - :qty',
                'send-btn'                       => 'Надіслати',
                'send-duplicate-invoice'         => 'Надіслати дублікат рахунку',
                'send'                           => 'Надіслати',
                'shipping-and-handling-excl-tax' => 'Доставка та обробка (без податку)',
                'shipping-and-handling-incl-tax' => 'Доставка та обробка (з податком)',
                'shipping-and-handling'          => 'Доставка та обробка',
                'sku'                            => 'Артикул - :sku',
                'sub-total-excl-tax'             => 'Підсумок (без податку) - :sub_total',
                'sub-total-incl-tax'             => 'Підсумок (з податком) - :sub_total',
                'sub-total-summary-excl-tax'     => 'Підсумок (без податку)',
                'sub-total-summary-incl-tax'     => 'Підсумок (з податком)',
                'sub-total-summary'              => 'Підсумок',
                'sub-total'                      => 'Підсумок - :sub_total',
                'summary-discount'               => 'Сума знижки',
                'summary-tax'                    => 'Сума податку',
                'tax'                            => 'Сума податку - :tax',
                'title'                          => 'Рахунок #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => ':amount За Одиницю x :qty Кількість',
                'create-invoice'     => 'Створити Рахунок-фактуру',
                'create-success'     => 'Рахунок-фактура успішно створена',
                'create-transaction' => 'Створити Транзакцію',
                'creation-error'     => 'Створення рахунку-фактури замовлення не дозволено.',
                'invalid-qty'        => 'Ми знайшли недійсну кількість для виставлення рахунків за товари.',
                'invoice'            => 'Рахунок-фактура',
                'new-invoice'        => 'Нова Рахунок-фактура',
                'product-error'      => 'Рахунок-фактура не може бути створена без товарів.',
                'product-image'      => 'Зображення Продукту',
                'qty-to-invoiced'    => 'Кількість для рахунків',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => 'Банківські реквізити',
                'bill-to'                    => 'Платник',
                'contact-number'             => 'Контактний номер',
                'contact'                    => 'Контакт',
                'date'                       => 'Дата рахунку',
                'discount'                   => 'Знижка',
                'excl-tax'                   => 'Без податку:',
                'grand-total'                => 'Загальна сума',
                'invoice-id'                 => 'ID рахунку-фактури',
                'invoice'                    => 'Рахунок-фактура',
                'order-date'                 => 'Дата замовлення',
                'order-id'                   => 'ID замовлення',
                'payment-method'             => 'Спосіб оплати',
                'payment-terms'              => 'Умови оплати',
                'price'                      => 'Ціна',
                'product-name'               => 'Назва товару',
                'qty'                        => 'Кількість',
                'ship-to'                    => 'Адреса доставки',
                'shipping-handling-excl-tax' => 'Доставка та обробка (без податку)',
                'shipping-handling-incl-tax' => 'Доставка та обробка (з податком)',
                'shipping-handling'          => 'Доставка та обробка',
                'shipping-method'            => 'Метод доставки',
                'sku'                        => 'Артикул',
                'subtotal-excl-tax'          => 'Підсумок (без податку)',
                'subtotal-incl-tax'          => 'Підсумок (з податком)',
                'subtotal'                   => 'Підсумок',
                'tax-amount'                 => 'Сума податку',
                'tax'                        => 'Податок',
                'vat-number'                 => 'Номер платника ПДВ',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => 'Дата транзакції',
            'transaction-id'   => 'ID транзакції',
            'view'             => 'Переглянути',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => 'Створити транзакції',
                'title'      => 'Транзакції',

                'datagrid' => [
                    'completed'          => 'Завершено',
                    'id'                 => 'ІД',
                    'invoice-id'         => 'ІД рахунку',
                    'order-id'           => 'ІД замовлення',
                    'paid'               => 'Оплачено',
                    'pending'            => 'Очікується',
                    'status'             => 'Статус',
                    'transaction-amount' => 'Сума',
                    'transaction-date'   => 'Дата',
                    'transaction-id'     => 'ІД транзакції',
                    'view'               => 'Перегляд',
                ],

                'create' => [
                    'already-paid'               => 'Вже оплачено',
                    'amount'                     => 'Сума',
                    'create-transaction'         => 'Створити транзакцію',
                    'invoice-id'                 => 'Номер рахунку-фактури',
                    'invoice-missing'            => 'Рахунок-фактура відсутня',
                    'payment-method'             => 'Спосіб оплати',
                    'save-transaction'           => 'Зберегти транзакцію',
                    'transaction-amount-exceeds' => 'Сума транзакції перевищує',
                    'transaction-amount-zero'    => 'Сума транзакції нульова',
                    'transaction-saved'          => 'Транзакцію успішно збережено.',
                ],

                'view' => [
                    'amount'           => 'Сума',
                    'created-at'       => 'Створено',
                    'invoice-id'       => 'Ідентифікатор рахунку',
                    'order-id'         => 'Ідентифікатор замовлення',
                    'payment-details'  => 'Деталі оплати',
                    'payment-method'   => 'Спосіб оплати',
                    'status'           => 'Статус',
                    'title'            => 'Деталі транзакції',
                    'transaction-id'   => 'Ідентифікатор транзакції',
                ],
            ],
        ],

        'booking' => [
            'index' => [
                'datagrid' => [
                    'created-date' => 'Дата створення',
                    'from'         => 'З',
                    'id'           => 'ID',
                    'order-id'     => 'Номер замовлення',
                    'qty'          => 'Кількість',
                    'to'           => 'До',
                    'view'         => 'Перегляд',
                ],

                'title'    => 'Бронювання',
            ],

            'calendar' => [
                'booking-date'     => 'Дата бронювання',
                'booking-details'  => 'Деталі бронювання',
                'canceled'         => 'Скасовано',
                'closed'           => 'Закрито',
                'done'             => 'Виконано',
                'order-id'         => 'Номер замовлення',
                'pending'          => 'В очікуванні',
                'price'            => 'Ціна',
                'status'           => 'Статус',
                'time-slot'        => 'Часовий слот:',
                'view-details'     => 'Переглянути деталі',
            ],

            'title' => 'Продукт бронювання',
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => ':name вже зайнятий.',
                'create-btn'    => 'Створити товар',
                'title'         => 'Товари',

                'create' => [
                    'back-btn'                => 'Назад',
                    'configurable-attributes' => 'Атрибути конфігурованого товару',
                    'create-btn'              => 'Створити товар',
                    'family'                  => 'Сімейство',
                    'save-btn'                => 'Зберегти товар',
                    'sku'                     => 'Артикул',
                    'title'                   => 'Створити новий товар',
                    'type'                    => 'Тип',
                ],

                'datagrid' => [
                    'active'                 => 'Активний',
                    'attribute-family'       => 'Сімейство атрибутів',
                    'attribute-family-value' => 'Сімейство атрибутів - :attribute_family',
                    'category'               => 'Категорія',
                    'channel'                => 'Канал',
                    'copy-of'                => 'Копія :value',
                    'copy-of-slug'           => 'копія-:value',
                    'delete'                 => 'Видалити',
                    'disable'                => 'Відключити',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => 'Зображення',
                    'mass-delete-success'    => 'Вибрані товари успішно видалені',
                    'mass-update-success'    => 'Вибрані товари успішно оновлені',
                    'name'                   => 'Назва',
                    'out-of-stock'           => 'Немає в наявності',
                    'price'                  => 'Ціна',
                    'product-image'          => 'Зображення товару',
                    'qty'                    => 'Кількість',
                    'qty-value'              => ':qty в наявності',
                    'sku'                    => 'Артикул',
                    'sku-value'              => 'Артикул - :sku',
                    'status'                 => 'Статус',
                    'type'                   => 'Тип',
                    'update-status'          => 'Оновити статус',
                ],
            ],

            'edit' => [
                'preview'  => 'Перегляд',
                'remove'   => 'Видалити',
                'save-btn' => 'Зберегти товар',
                'title'    => 'Редагувати товар',

                'channels' => [
                    'title' => 'Канали',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'Додати ціну для групи',
                        'all-groups'                => 'Всі групи',
                        'create-btn'                => 'Додати новий',
                        'discount-group-price-info' => 'Для :qty штук зі знижкою :price',
                        'edit-btn'                  => 'Редагувати',
                        'empty-info'                => 'Спеціальні ціни для покупців, які належать до певної групи.',
                        'fixed-group-price-info'    => 'Для :qty штук за фіксованою ціною :price',
                        'title'                     => 'Ціни для груп покупців',

                        'create' => [
                            'all-groups'     => 'Всі групи',
                            'create-title'   => 'Створити ціну для групи покупців',
                            'customer-group' => 'Група покупців',
                            'delete-btn'     => 'Видалити',
                            'discount'       => 'Знижка',
                            'fixed'          => 'Фіксована',
                            'price'          => 'Ціна',
                            'price-type'     => 'Тип ціни',
                            'qty'            => 'Мінімальна кількість',
                            'save-btn'       => 'Зберегти',
                            'update-title'   => 'Оновити ціну для групи покупців',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => 'Очікувана кількість замовлення: :qty',
                    'pending-ordered-qty-info' => 'Після відвантаження, очікувана кількість замовлення буде списана з відповідного джерела інвентаризації. У разі скасування, очікувана кількість стане доступною для продажу.',
                    'title'                    => 'Інвентаризація',
                ],

                'categories' => [
                    'title' => 'Категорії',
                ],

                'images' => [
                    'info'  => 'Роздільна здатність зображення повинна бути приблизно 560px X 609px',
                    'title' => 'Зображення',
                ],

                'videos' => [
                    'error' => 'Параметр :attribute не може перевищувати :max кілобайт. Виберіть менший файл.',
                    'title' => 'Відео',
                    'info'  => 'Максимальний розмір відео повинен бути приблизно :size',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => 'Додайте пов\'язані продукти в дорозі.',
                        'info'       => 'Покупцеві, який переглядає товар, також пропонуються пов’язані товари.',
                        'title'      => 'Пов’язані товари',
                    ],

                    'up-sells' => [
                        'empty-info' => ' Додайте додаткові товари для продажу в дорозі.',
                        'info'       => 'Покупцю пропонують товари для збільшення продажів, які є преміум або вищої якості, ніж товар, який він переглядає.',
                        'title'      => 'Товари для збільшення продажів',
                    ],

                    'cross-sells' => [
                        'empty-info' => 'Додайте товари з перекреслого продажу в дорозі.',
                        'info'       => 'Поруч із кошиком, ви знайдете ці "імпульсні" товари, розташовані як перекресні продажі, щоб доповнити товари, які вже додані до вашого кошика.',
                        'title'      => 'Товари для перекресних продажів',
                    ],

                    'add-btn'           => 'Додати товар',
                    'delete'            => 'Видалити',
                    'empty-info'        => 'Додати товари типу :type на ходу.',
                    'empty-title'       => 'Додати товар',
                    'image-placeholder' => 'Зображення товару',
                    'sku'               => 'Артикул - :sku',
                ],

                'types' => [
                    'simple' => [
                        'customizable-options' => [
                            'add-btn'           => 'Додати опцію',
                            'empty-info'        => 'Для створення налаштовуваних опцій швидко.',
                            'empty-title'       => 'Додати опцію',
                            'info'              => 'Це дозволить налаштувати простий продукт.',
                            'title'             => 'Налаштовуваний елемент',

                            'update-create' => [
                                'is-required'               => 'Необхідно',
                                'max-characters'            => 'Максимальна кількість символів',
                                'name'                      => 'Назва',
                                'no'                        => 'Ні',
                                'price'                     => 'Ціна',
                                'save-btn'                  => 'Зберегти',
                                'supported-file-extensions' => 'Підтримувані розширення файлів',
                                'title'                     => 'Опція',
                                'type'                      => 'Тип',
                                'yes'                       => 'Так',
                            ],

                            'option' => [
                                'add-btn'     => 'Додати опцію',
                                'delete'      => 'Видалити',
                                'delete-btn'  => 'Видалити',
                                'edit-btn'    => 'Редагувати',
                                'empty-info'  => 'Для створення різних комбінацій продуктів.',
                                'empty-title' => 'Додати опцію',

                                'types' => [
                                    'text' => [
                                        'title' => 'Текст',
                                    ],

                                    'textarea' => [
                                        'title' => 'Текстова область',
                                    ],

                                    'checkbox' => [
                                        'title' => 'Чекбокс',
                                    ],

                                    'radio' => [
                                        'title' => 'Радіо',
                                    ],

                                    'select' => [
                                        'title' => 'Вибір',
                                    ],

                                    'multiselect' => [
                                        'title' => 'Мультивибір',
                                    ],

                                    'date' => [
                                        'title' => 'Дата',
                                    ],

                                    'datetime' => [
                                        'title' => 'Дата і час',
                                    ],

                                    'time' => [
                                        'title' => 'Час',
                                    ],

                                    'file' => [
                                        'title' => 'Файл',
                                    ],
                                ],

                                'items' => [
                                    'update-create' => [
                                        'label'    => 'Мітка',
                                        'price'    => 'Ціна',
                                        'save-btn' => 'Зберегти',
                                        'title'    => 'Опція',
                                    ],
                                ],
                            ],

                            'validations' => [
                                'associated-product' => 'Цей продукт вже асоційований з іншим налаштовуваним продуктом.',
                            ],
                        ],
                    ],

                    'configurable' => [
                        'add-btn'           => 'Додати варіант',
                        'delete-btn'        => 'Видалити',
                        'edit-btn'          => 'Редагувати',
                        'empty-info'        => 'Створити різні комбінації товару на ходу.',
                        'empty-title'       => 'Додати варіант',
                        'image-placeholder' => 'Зображення товару',
                        'info'              => 'Варіаційні товари залежать від всіх можливих комбінацій атрибутів.',
                        'qty'               => ':qty шт.',
                        'sku'               => 'Артикул - :sku',
                        'title'             => 'Варіації',

                        'create' => [
                            'description'            => 'Опис',
                            'name'                   => 'Назва',
                            'save-btn'               => 'Додати',
                            'title'                  => 'Додати варіант',
                            'variant-already-exists' => 'Цей варіант вже існує',
                        ],

                        'edit' => [
                            'disabled'        => 'Вимкнено',
                            'edit-info'       => 'Якщо ви хочете оновити інформацію про товар докладніше, перейдіть на сторінку',
                            'edit-link-title' => 'Сторінка деталей товару',
                            'enabled'         => 'Увімкнено',
                            'images'          => 'Зображення',
                            'name'            => 'Назва',
                            'price'           => 'Ціна',
                            'quantities'      => 'Кількість',
                            'save-btn'        => 'Зберегти',
                            'sku'             => 'Артикул',
                            'status'          => 'Статус',
                            'title'           => 'Товар',
                            'weight'          => 'Вага',
                        ],

                        'mass-edit' => [
                            'add-images'          => 'Додати зображення',
                            'apply-to-all-btn'    => 'Застосувати до всіх',
                            'apply-to-all-name'   => 'Застосувати ім\'я до всіх варіантів.',
                            'apply-to-all-sku'    => 'Застосувати ціну до всіх SKU.',
                            'apply-to-all-status' => 'Застосувати статус до всіх варіантів.',
                            'apply-to-all-weight' => 'Застосувати вагу до всіх варіантів.',
                            'edit-inventories'    => 'Редагувати інвентар',
                            'edit-names'          => 'Редагувати назви',
                            'edit-prices'         => 'Редагувати ціни',
                            'edit-sku'            => 'Редагувати SKU',
                            'edit-status'         => 'Редагувати статус',
                            'edit-weight'         => 'Редагувати вагу',
                            'name'                => 'Ім\'я',
                            'price'               => 'Ціна',
                            'remove-images'       => 'Видалити зображення',
                            'remove-variants'     => 'Видалити варіанти',
                            'select-action'       => 'Вибрати дію',
                            'select-variants'     => 'Вибрати варіанти',
                            'status'              => 'Статус',
                            'variant-name'        => 'Назва варіанту',
                            'variant-sku'         => 'SKU варіанту',
                            'weight'              => 'Вага',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => 'Додати товар',
                        'default-qty'       => 'Кількість за замовчуванням',
                        'delete'            => 'Видалити',
                        'empty-info'        => 'Створити різні комбінації товару на ходу.',
                        'empty-title'       => 'Додати товар',
                        'image-placeholder' => 'Зображення товару',
                        'info'              => 'Груповий товар включає самостійні товари, представлені як набір, що дозволяє варіювати або координувати за сезоном або темою. Кожен товар можна купити окремо або в комплекті.',
                        'sku'               => 'Артикул - :sku',
                        'title'             => 'Групові товари',
                    ],

                    'bundle' => [
                        'add-btn'           => 'Додати опцію',
                        'empty-info'        => 'Створити опції пакету на ходу.',
                        'empty-title'       => 'Додати опцію',
                        'image-placeholder' => 'Зображення товару',
                        'info'              => 'Пакетний товар - це пакет декількох товарів або послуг, продаваних разом за спеціальною ціною, що надає вартість і зручність покупцям.',
                        'title'             => 'Елементи пакету',

                        'update-create' => [
                            'checkbox'    => 'Прапорець',
                            'is-required' => 'Обов’язково',
                            'multiselect' => 'Мультиселект',
                            'name'        => 'Назва',
                            'no'          => 'Ні',
                            'radio'       => 'Радіо',
                            'save-btn'    => 'Зберегти',
                            'select'      => 'Вибір',
                            'title'       => 'Опція',
                            'type'        => 'Тип',
                            'yes'         => 'Так',
                        ],

                        'option' => [
                            'add-btn'     => 'Додати товар',
                            'default-qty' => 'Кількість за замовчуванням',
                            'delete'      => 'Видалити',
                            'delete-btn'  => 'Видалити',
                            'edit-btn'    => 'Редагувати',
                            'empty-info'  => 'Створити різні комбінації товару на ходу.',
                            'empty-title' => 'Додати товар',
                            'sku'         => 'Артикул - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'Встановити товар за замовчуванням за допомогою прапорця',
                                    'title' => 'Прапорець',
                                ],

                                'multiselect' => [
                                    'info'  => 'Встановити товар за замовчуванням за допомогою кнопки прапорця',
                                    'title' => 'Мультиселект',
                                ],

                                'radio' => [
                                    'info'  => 'Встановити товар за замовчуванням за допомогою кнопки радіо',
                                    'title' => 'Радіо',
                                ],

                                'select' => [
                                    'info'  => 'Встановити товар за замовчуванням за допомогою вибіркової кнопки',
                                    'title' => 'Вибір',
                                ],
                            ],
                        ],
                    ],

                    'booking' => [
                        'available-from' => 'Доступно з',
                        'available-to'   => 'Доступно до',
                        'location'       => 'Місцезнаходження',
                        'qty'            => 'Кількість',
                        'title'          => 'Тип бронювання',

                        'available-every-week' => [
                            'no'    => 'Ні',
                            'title' => 'Доступно щотижня',
                            'yes'   => 'Так',
                        ],

                        'appointment' => [
                            'break-duration' => 'Час перерви між слотами (хв)',
                            'slot-duration'  => 'Тривалість слота (хв)',

                            'same-slot-for-all-days' => [
                                'no'    => 'Ні',
                                'title' => 'Один і той самий слот для всіх днів',
                                'yes'   => 'Так',
                            ],
                        ],

                        'default' => [
                            'add'              => 'Додати',
                            'break-duration'   => 'Час перерви між слотами (хв)',
                            'close'            => 'Закрити',
                            'description'      => 'Інформація про бронювання',
                            'description-info' => 'Тривалість часу буде створена і відображена відповідно до слотів. Вона буде унікальною для всіх слотів і видимою на вітрині магазину',
                            'edit'             => 'Редагувати',
                            'many'             => 'Багато бронювань на один день',
                            'one'              => 'Одне бронювання на багато днів',
                            'open'             => 'Відкрити',
                            'slot-add'         => 'Додати слоти',
                            'slot-duration'    => 'Тривалість слота (хв)',
                            'slot-title'       => 'Тривалість часу слотів',
                            'title'            => 'За замовчуванням',
                            'unavailable'      => 'Недоступно',

                            'modal'            => [
                                'slot' => [
                                    'add-title'  => 'Додати слоти',
                                    'close'      => 'Закрити',
                                    'day'        => 'День',
                                    'edit-title' => 'Редагувати слоти',
                                    'friday'     => 'П\'ятниця',
                                    'from'       => 'З',
                                    'from-day'   => 'З дня',
                                    'from-time'  => 'З часу',
                                    'monday'     => 'Понеділок',
                                    'open'       => 'Відкрити',
                                    'saturday'   => 'Субота',
                                    'save'       => 'Зберегти',
                                    'select'     => 'Вибрати',
                                    'status'     => 'Статус',
                                    'sunday'     => 'Неділя',
                                    'thursday'   => 'Четвер',
                                    'to'         => 'До',
                                    'to-day'     => 'До дня',
                                    'to-time'    => 'До часу',
                                    'tuesday'    => 'Вівторок',
                                    'wednesday'  => 'Середа',
                                    'week'       => ':day',
                                ],
                            ],
                        ],

                        'event' => [
                            'add'                => 'Додати квитки',
                            'delete'             => 'Видалити',
                            'description'        => 'Опис',
                            'description-info'   => 'Квитки недоступні.',
                            'edit'               => 'Редагувати',
                            'name'               => 'Назва',
                            'price'              => 'Ціна',
                            'qty'                => 'Кількість',
                            'special-price'      => 'Спеціальна ціна',
                            'special-price-from' => 'Спеціальна ціна з',
                            'special-price-to'   => 'Спеціальна ціна до',
                            'title'              => 'Квитки',
                            'valid-from'         => 'Дійсно з',
                            'valid-until'        => 'Дійсно до',

                            'modal'              => [
                                'edit' => 'Редагувати квитки',
                                'save' => 'Зберегти',
                            ],
                        ],

                        'empty-info' => [
                            'tickets' => [
                                'add' => 'Додати квитки',
                            ],

                            'slots'   => [
                                'add'         => 'Додати слоти',
                                'description' => 'Доступні слоти з тривалістю часу.',
                            ],
                        ],

                        'rental' => [
                            'daily'                  => 'Щоденна основа',
                            'daily-hourly'           => 'Обидва (щоденна та погодинна основа)',
                            'daily-price'            => 'Щоденна ціна',
                            'hourly'                 => 'Погодинна основа',
                            'hourly-price'           => 'Погодинна ціна',
                            'title'                  => 'Тип оренди',

                            'same-slot-for-all-days' => [
                                'no'    => 'Ні',
                                'title' => 'Один і той самий слот для всіх днів',
                                'yes'   => 'Так',
                            ],
                        ],

                        'slots' => [
                            'add'              => 'Додати слоти',
                            'description-info' => 'Тривалість часу буде створена і відображена відповідно до слотів. Вона буде унікальною для всіх слотів і видимою на вітрині магазину',
                            'save'             => 'Зберегти',
                            'title'            => 'Тривалість часу слотів',
                            'unavailable'      => 'Недоступно',

                            'action'           => [
                                'add' => 'Додати',
                            ],

                            'modal'            => [
                                'slot' => [
                                    'friday'     => 'П\'ятниця',
                                    'from'       => 'З',
                                    'monday'     => 'Понеділок',
                                    'saturday'   => 'Субота',
                                    'sunday'     => 'Неділя',
                                    'thursday'   => 'Четвер',
                                    'to'         => 'До',
                                    'tuesday'    => 'Вівторок',
                                    'wednesday'  => 'Середа',
                                ],
                            ],
                        ],

                        'table' => [
                            'break-duration'            => 'Час перерви між слотами (хв)',
                            'guest-capacity'            => 'Місткість гостей',
                            'guest-limit'               => 'Ліміт гостей за столом',
                            'prevent-scheduling-before' => 'Запобігти плануванню до',
                            'slot-duration'             => 'Тривалість слота (хв)',

                            'charged-per'               => [
                                'guest'  => 'Гість',
                                'table'  => 'Стіл',
                                'title'  => 'Заряджено за',
                            ],

                            'same-slot-for-all-days'    => [
                                'no'    => 'Ні',
                                'title' => 'Один і той самий слот для всіх днів',
                                'yes'   => 'Так',
                            ],
                        ],

                        'type' => [
                            'appointment' => 'Бронювання зустрічі',
                            'default'     => 'Бронювання за замовчуванням',
                            'event'       => 'Бронювання події',
                            'many'        => 'Багато',
                            'one'         => 'Один',
                            'rental'      => 'Бронювання оренди',
                            'table'       => 'Бронювання столу',
                            'title'       => 'Тип',
                        ],

                        'validations' => [
                            'type-mismatch'      => 'Тип бронювання не можна змінити.',
                            'time-validation'    => 'Час початку має бути меншим за час закінчення.',
                            'overlap-validation' => 'Часовий проміжок перекривається з існуючим проміжком.',
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'Додати посилання',
                            'delete-btn'  => 'Видалити',
                            'edit-btn'    => 'Редагувати',
                            'empty-info'  => 'Створити посилання на ходу.',
                            'empty-title' => 'Додати посилання',
                            'file'        => 'Файл : ',
                            'info'        => 'Тип продукту для завантаження дозволяє продавати цифрові товари, такі як електронні книги, програми, музику, ігри тощо.',
                            'sample-file' => 'Зразок файлу : ',
                            'sample-url'  => 'Зразок URL : ',
                            'title'       => 'Посилання для завантаження',
                            'url'         => 'URL : ',

                            'update-create' => [
                                'downloads'   => 'Завантаження дозволено',
                                'file'        => 'Файл',
                                'file-type'   => 'Тип файлу',
                                'name'        => 'Заголовок',
                                'price'       => 'Ціна',
                                'sample'      => 'Зразок',
                                'sample-type' => 'Тип зразка',
                                'save-btn'    => 'Зберегти',
                                'title'       => 'Посилання',
                                'url'         => 'URL',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'Додати зразок',
                            'delete-btn'  => 'Видалити',
                            'edit-btn'    => 'Редагувати',
                            'empty-info'  => 'Створити зразок на ходу.',
                            'empty-title' => 'Додати зразок',
                            'file'        => 'Файл : ',
                            'info'        => 'Тип продукту для завантаження дозволяє продавати цифрові товари, такі як електронні книги, програми, музику, ігри тощо.',
                            'title'       => 'Зразки для завантаження',
                            'url'         => 'URL : ',

                            'update-create' => [
                                'file'        => 'Файл',
                                'file-type'   => 'Тип файлу',
                                'name'        => 'Заголовок',
                                'save-btn'    => 'Зберегти',
                                'title'       => 'Посилання',
                                'url'         => 'URL',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => 'Продукт успішно створено',
            'delete-failed'           => 'Помилка видалення продукту',
            'delete-success'          => 'Продукт успішно видалено',
            'product-copied'          => 'Продукт успішно скопійовано',
            'saved-inventory-message' => 'Продукт успішно збережено',
            'update-success'          => 'Продукт успішно оновлено',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => 'Створити атрибути',
                'title'      => 'Атрибути',

                'datagrid' => [
                    'boolean'             => 'Boolean',
                    'channel-based'       => 'На базі каналу',
                    'checkbox'            => 'Прапорець',
                    'code'                => 'Код',
                    'created-at'          => 'Створено',
                    'date'                => 'Дата',
                    'date-time'           => 'Дата Час',
                    'delete'              => 'Видалити',
                    'edit'                => 'Редагувати',
                    'false'               => 'Неправда',
                    'file'                => 'Файл',
                    'id'                  => 'Ідентифікатор',
                    'image'               => 'Зображення',
                    'locale-based'        => 'На основі локалізації',
                    'mass-delete-success' => 'Вибрані атрибути успішно видалено',
                    'multiselect'         => 'Мульти-вибір',
                    'name'                => 'Назва',
                    'price'               => 'Ціна',
                    'required'            => 'Обов\'язково',
                    'select'              => 'Вибрати',
                    'text'                => 'Текст',
                    'textarea'            => 'Текстова область',
                    'true'                => 'Правда',
                    'type'                => 'Тип',
                    'unique'              => 'Унікальний',
                ],
            ],

            'create' => [
                'add-attribute-options' => 'Додати опції атрибуту',
                'add-option'            => 'Додати опцію',
                'add-options-info'      => 'Для створення різних комбінацій опцій атрибуту на ходу.',
                'add-row'               => 'Додати рядок',
                'admin'                 => 'Адміністратор',
                'admin-name'            => 'Назва для адміністратора',
                'back-btn'              => 'Назад',
                'boolean'               => 'Логічний',
                'checkbox'              => 'Прапорець',
                'code'                  => 'Код атрибуту',
                'color'                 => 'Колір',
                'configuration'         => 'Конфігурація',
                'create-empty-option'   => 'Створити порожню опцію за замовчуванням',
                'date'                  => 'Дата',
                'datetime'              => 'Дата та час',
                'decimal'               => 'Десятковий',
                'default-value'         => 'Значення за замовчуванням',
                'email'                 => 'Email',
                'enable-wysiwyg'        => 'Увімкнути редактор Wysiwyg',
                'file'                  => 'Файл',
                'general'               => 'Загальні',
                'image'                 => 'Зображення',
                'input-options'         => 'Опції введення',
                'input-validation'      => 'Валідація введення',
                'is-comparable'         => 'Атрибут можна порівнювати',
                'is-configurable'       => 'Використовувати для створення конфігурованих продуктів',
                'is-filterable'         => 'Використовувати в фільтрації',
                'is-required'           => 'Обов’язковий',
                'is-unique'             => 'Унікальний',
                'is-visible-on-front'   => 'Видимий на сторінці перегляду продукту на фронт-енді',
                'label'                 => 'Мітка',
                'multiselect'           => 'Мультиселект',
                'no'                    => 'Ні',
                'numeric'               => 'Число',
                'option-deleted'        => 'Опцію успішно видалено',
                'options'               => 'Опції',
                'position'              => 'Позиція',
                'price'                 => 'Ціна',
                'regex'                 => 'Регулярний вираз',
                'regex-info'            => 'Вираз повинен бути в подвійних лапках.',
                'save-btn'              => 'Зберегти атрибут',
                'select'                => 'Вибір',
                'select-type'           => 'Вибрати тип атрибуту',
                'swatch'                => 'Палітра',
                'text'                  => 'Текст',
                'textarea'              => 'Текстова область',
                'title'                 => 'Додати атрибут',
                'type'                  => 'Тип атрибуту',
                'url'                   => 'URL',
                'use-in-flat'           => 'Створити в плоскій таблиці продуктів',
                'validations'           => 'Валідація',
                'value-per-channel'     => 'Значення за каналом',
                'value-per-locale'      => 'Значення за локаллю',
                'yes'                   => 'Так',

                'option'                => [
                    'color'    => 'Колір палітри',
                    'dropdown' => 'Випадаючий список',
                    'image'    => 'Зображення палітри',
                    'save-btn' => 'Зберегти опцію',
                    'text'     => 'Текстова палітра',
                ],
            ],

            'edit' => [
                'add-attribute-options' => 'Додати Опції Атрибуту',
                'add-option'            => 'Додати Опцію',
                'add-options-info'      => 'Для створення різних комбінацій Опцій Атрибуту на льоту.',
                'add-row'               => 'Додати Рядок',
                'admin'                 => 'Адміністратор',
                'admin-name'            => 'Назва для Адміністратора',
                'back-btn'              => 'Назад',
                'boolean'               => 'Логічний',
                'checkbox'              => 'Прапорець',
                'code'                  => 'Код Атрибуту',
                'color'                 => 'Колір',
                'configuration'         => 'Конфігурація',
                'create-empty-option'   => 'Створити порожню опцію за замовчуванням',
                'date'                  => 'Дата',
                'datetime'              => 'Дата та Час',
                'decimal'               => 'Десятковий',
                'default-value'         => 'Значення за замовчуванням',
                'email'                 => 'Email',
                'enable-wysiwyg'        => 'Увімкнути Редактор Wysiwyg',
                'file'                  => 'Файл',
                'general'               => 'Загальні',
                'image'                 => 'Зображення',
                'input-options'         => 'Опції Введення',
                'input-validation'      => 'Валідація Введення',
                'is-comparable'         => 'Атрибут Порівнюваний',
                'is-configurable'       => 'Використовувати Для Створення Конфігурованих Продуктів',
                'is-filterable'         => 'Використовувати в Шаровій Навігації',
                'is-required'           => 'Обов’язковий',
                'is-unique'             => 'Унікальний',
                'is-visible-on-front'   => 'Видимий на Сторінці Перегляду Продукту на Front-end',
                'label'                 => 'Мітка',
                'multiselect'           => 'Багатовибірний',
                'no'                    => 'Ні',
                'numeric'               => 'Число',
                'option-deleted'        => 'Опцію успішно видалено',
                'options'               => 'Опції',
                'position'              => 'Позиція',
                'price'                 => 'Ціна',
                'regex'                 => 'Регулярний Вираз',
                'regex-info'            => 'Вираз повинен бути в подвійних лапках.',
                'save-btn'              => 'Зберегти Атрибут',
                'select'                => 'Вибір',
                'select-type'           => 'Тип Вибору Атрибуту',
                'swatch'                => 'Вибір Кольору',
                'text'                  => 'Текст',
                'textarea'              => 'Текстова Область',
                'title'                 => 'Редагувати Атрибут',
                'type'                  => 'Тип Атрибуту',
                'url'                   => 'URL',
                'use-in-flat'           => 'Створити в Таблиці Продуктів',
                'validations'           => 'Валідація',
                'value-per-channel'     => 'Значення За Каналом',
                'value-per-locale'      => 'Значення За Мовою',
                'yes'                   => 'Так',

                'option' => [
                    'color'    => 'Вибір Кольору',
                    'dropdown' => 'Випадаючий Список',
                    'image'    => 'Вибір Зображення',
                    'save-btn' => 'Зберегти Опцію',
                    'text'     => 'Вибір Тексту',
                ],
            ],

            'create-success'    => 'Атрибут успішно створено',
            'delete-failed'     => 'Помилка видалення Атрибута',
            'delete-success'    => 'Атрибут успішно видалено',
            'update-success'    => 'Атрибут успішно оновлено',
            'user-define-error' => 'Не можна видалити системний Атрибут',
        ],

        'categories' => [
            'index' => [
                'add-btn' => 'Створити Категорію',
                'title'   => 'Категорії',

                'datagrid' => [
                    'active'         => 'Активна',
                    'delete'         => 'Видалити',
                    'delete-success' => 'Вибрані :resource успішно видалено',
                    'edit'           => 'Редагувати',
                    'id'             => 'ID',
                    'inactive'       => 'Неактивна',
                    'name'           => 'Назва',
                    'no-of-products' => 'Кількість Продуктів',
                    'position'       => 'Позиція',
                    'status'         => 'Видимий у меню',
                    'update-status'  => 'Оновити Статус',
                ],
            ],

            'create' => [
                'add-banner'               => 'Додати Банер',
                'add-logo'                 => 'Додати Логотип',
                'back-btn'                 => 'Назад',
                'banner'                   => 'Банер',
                'banner-size'              => 'Розмір банера (1320px X 300px)',
                'description'              => 'Опис',
                'description-and-images'   => 'Опис та Зображення',
                'description-only'         => 'Лише Опис',
                'display-mode'             => 'Режим Відображення',
                'enter-position'           => 'Введіть Позицію',
                'filterable-attributes'    => 'Фільтрувати Атрибути',
                'general'                  => 'Загальні',
                'logo'                     => 'Логотип',
                'logo-size'                => 'Роздільна Здатність Логотипу (110px X 110px)',
                'meta-description'         => 'Мета-Опис',
                'meta-keywords'            => 'Мета-Ключові Слова',
                'meta-title'               => 'Мета-Заголовок',
                'name'                     => 'Назва',
                'parent-category'          => 'Батьківська Категорія',
                'position'                 => 'Позиція',
                'products-and-description' => 'Продукти та Опис',
                'products-only'            => 'Лише Продукти',
                'save-btn'                 => 'Зберегти Категорію',
                'select-display-mode'      => 'Виберіть Режим Відображення',
                'seo-details'              => 'SEO Деталі',
                'settings'                 => 'Налаштування',
                'slug'                     => 'URL-Частина (Slug)',
                'title'                    => 'Додати Нову Категорію',
                'visible-in-menu'          => 'Видима В Меню',
            ],

            'edit' => [
                'add-banner'               => 'Додати Банер',
                'add-logo'                 => 'Додати Логотип',
                'back-btn'                 => 'Назад',
                'banner'                   => 'Банер',
                'banner-size'              => 'Розмір банера (1320px X 300px)',
                'description'              => 'Опис',
                'description-and-images'   => 'Опис та Зображення',
                'description-only'         => 'Лише Опис',
                'display-mode'             => 'Режим Відображення',
                'enter-position'           => 'Введіть Позицію',
                'filterable-attributes'    => 'Фільтрувати Атрибути',
                'general'                  => 'Загальні',
                'logo'                     => 'Логотип',
                'logo-size'                => 'Роздільна Здатність Логотипу (110px X 110px)',
                'meta-description'         => 'Мета-Опис',
                'meta-keywords'            => 'Мета-Ключові Слова',
                'meta-title'               => 'Мета-Заголовок',
                'name'                     => 'Назва',
                'position'                 => 'Позиція*',
                'products-and-description' => 'Продукти та Опис',
                'products-only'            => 'Лише Продукти',
                'save-btn'                 => 'Зберегти Категорію',
                'select-display-mode'      => 'Виберіть Режим Відображення',
                'select-parent-category'   => 'Виберіть Батьківську Категорію*',
                'seo-details'              => 'SEO Деталі',
                'settings'                 => 'Налаштування',
                'slug'                     => 'URL-Частина (Slug)',
                'title'                    => 'Редагувати Категорію',
                'visible-in-menu'          => 'Видима В Меню',
            ],

            'category'             => 'Категорія',
            'create-success'       => 'Категорію створено успішно.',
            'delete-category-root' => 'Кореневу категорію не можна видалити.',
            'delete-failed'        => 'Помилка під час видалення категорії',
            'delete-success'       => 'Категорію успішно видалено.',
            'update-success'       => 'Категорію оновлено успішно.',
        ],

        'families' => [
            'index' => [
                'add'   => 'Створити Сімейство Атрибутів',
                'title' => 'Сімейства',

                'datagrid' => [
                    'code'           => 'Код',
                    'delete'         => 'Видалити',
                    'delete-success' => 'Вибрані :resource успішно видалено',
                    'edit'           => 'Редагувати',
                    'id'             => 'ID',
                    'method-error'   => 'Помилка! Виявлено неправильний метод, будь ласка, перевірте конфігурацію масової дії',
                    'name'           => 'Назва',
                    'no-resource'    => 'Недостатньо ресурсів для виконання дії',
                    'partial-action' => 'Деякі дії не виконано через обмеження системи для :resource',
                    'update-success' => 'Вибрані :resource успішно оновлено',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'Додати Групу',
                'add-group-title'                  => 'Додати Нову Групу',
                'back-btn'                         => 'Назад',
                'code'                             => 'Код',
                'column'                           => 'Колонка',
                'delete-group-btn'                 => 'Видалити Групу',
                'edit-group-info'                  => 'Подвійний клік для редагування Групи',
                'enter-code'                       => 'Введіть Код',
                'enter-name'                       => 'Введіть Назву',
                'general'                          => 'Загальні',
                'group-code-already-exists'        => 'Код групи атрибутів вже існує.',
                'group-contains-system-attributes' => 'Ця група містить системні атрибути. Спочатку перемістіть системні атрибути в іншу групу і спробуйте знову.',
                'group-name-already-exists'        => 'Назва групи атрибутів вже існує.',
                'groups'                           => 'Групи',
                'groups-info'                      => 'Керуйте групами сімейства атрибутів',
                'main-column'                      => 'Головна Колонка',
                'name'                             => 'Назва',
                'removal-not-possible'             => 'Ви не можете видалити системні атрибути з сімейства атрибутів.',
                'right-column'                     => 'Права Колонка',
                'save-btn'                         => 'Зберегти Сімейство Атрибутів',
                'select-group'                     => 'Будь ласка, виберіть групу атрибутів.',
                'title'                            => 'Створити Сімейство Атрибутів',
                'unassigned-attributes'            => 'Непризначені Атрибути',
                'unassigned-attributes-info'       => 'Перетягніть ці атрибути, щоб додати їх до колонок або груп.',
            ],

            'edit' => [
                'add-group-btn'                    => 'Додати Групу',
                'add-group-title'                  => 'Додати Нову Групу',
                'back-btn'                         => 'Назад',
                'code'                             => 'Код',
                'column'                           => 'Колонка',
                'delete-group-btn'                 => 'Видалити Групу',
                'edit-group-info'                  => 'Подвійний клік для редагування Групи',
                'enter-code'                       => 'Введіть Код',
                'enter-name'                       => 'Введіть Назву',
                'group-code-already-exists'        => 'Код групи атрибутів вже існує.',
                'group-contains-system-attributes' => 'Ця група містить системні атрибути. Спочатку перемістіть системні атрибути в іншу групу і спробуйте знову.',
                'group-name-already-exists'        => 'Назва групи атрибутів вже існує.',
                'groups'                           => 'Групи',
                'groups-info'                      => 'Керуйте групами сімейства атрибутів',
                'main-column'                      => 'Головна Колонка',
                'name'                             => 'Назва',
                'removal-not-possible'             => 'Ви не можете видалити системні атрибути з сімейства атрибутів.',
                'right-column'                     => 'Права Колонка',
                'save-btn'                         => 'Зберегти Сімейство Атрибутів',
                'select-group'                     => 'Будь ласка, виберіть групу атрибутів.',
                'title'                            => 'Редагувати Сімейство Атрибутів',
                'unassigned-attributes'            => 'Непризначені Атрибути',
                'unassigned-attributes-info'       => 'Перетягніть ці атрибути, щоб додати їх до колонок або груп.',
            ],

            'attribute-family'        => 'Сімейство Атрибутів',
            'attribute-product-error' => 'Сімейство використовується в продуктах.',
            'create-success'          => 'Сімейство створено успішно.',
            'delete-failed'           => 'Під час видалення Сімейства сталася помилка.',
            'delete-success'          => 'Сімейство видалено успішно.',
            'family'                  => 'Сімейство',
            'last-delete-error'       => 'Потрібно щонайменше одне сімейство.',
            'update-success'          => 'Сімейство оновлено успішно.',
            'user-define-error'       => 'Неможливо видалити системне Сімейство Атрибутів',
        ],

    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => 'Клієнти',
                'login-message' => 'Ви увійшли як :customer_name',

                'datagrid' => [
                    'active'         => 'Активний',
                    'address'        => ':address Адреса(и)',
                    'address-count'  => 'Кількість адрес',
                    'channel'        => 'Канал',
                    'delete'         => 'Видалити',
                    'delete-success' => 'Вибрані дані успішно видалено',
                    'email'          => 'Електронна пошта',
                    'gender'         => 'Стать',
                    'group'          => 'Група',
                    'id'             => 'Ідентифікатор клієнта',
                    'id-value'       => 'ID - :id',
                    'inactive'       => 'Неактивний',
                    'method-error'   => 'Помилка! Виявлено невірний метод, будь ласка, перевірте конфігурацію масових дій',
                    'name'           => 'Ім\'я клієнта',
                    'no-resource'    => 'Недостатньо ресурсів для виконання дії',
                    'order'          => ':order Замовлення(я)',
                    'order-count'    => 'Кількість замовлень',
                    'order-pending'  => 'Клієнт має невиконані замовлення',
                    'partial-action' => 'Деякі дії не були виконані через обмеження системи щодо :resource',
                    'phone'          => 'Контактний номер',
                    'revenue'        => 'Дохід',
                    'status'         => 'Статус',
                    'suspended'      => 'Призупинено',
                    'update-status'  => 'Оновити статус',
                    'update-success' => 'Вибрані клієнти успішно оновлено',
                ],

                'create' => [
                    'contact-number'        => 'Контактний номер',
                    'create-btn'            => 'Створити клієнта',
                    'create-success'        => 'Клієнта успішно створено',
                    'customer-group'        => 'Група клієнтів',
                    'date-of-birth'         => 'Дата народження',
                    'email'                 => 'Електронна пошта',
                    'female'                => 'Жінка',
                    'first-name'            => "Ім'я",
                    'gender'                => 'Стать',
                    'last-name'             => 'Прізвище',
                    'male'                  => 'Чоловік',
                    'other'                 => 'Інша',
                    'save-btn'              => 'Зберегти клієнта',
                    'select-customer-group' => 'Вибрати групу клієнтів',
                    'select-gender'         => 'Вибрати стать',
                    'title'                 => 'Створити нового клієнта',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => 'Ви впевнені, що хочете видалити цей обліковий запис?',
                'active'                      => 'Активний',
                'address-delete-confirmation' => 'Ви впевнені, що хочете видалити цю адресу?',
                'back-btn'                    => 'Назад',
                'create-order'                => 'Створити замовлення',
                'customer'                    => 'Клієнт',
                'date-of-birth'               => 'Дата народження - :dob',
                'default-address'             => 'Адреса за замовчуванням',
                'delete-account'              => 'Видалити обліковий запис',
                'delete'                      => 'Видалити',
                'email'                       => 'Електронна пошта - :email',
                'empty-description'           => 'Створіть нові адреси для клієнта',
                'empty-title'                 => 'Додати адресу клієнта',
                'gender'                      => 'Стать - :gender',
                'group'                       => 'Група - :group_code',
                'inactive'                    => 'Неактивний',
                'login-as-customer'           => 'Увійти як клієнт',
                'note-created-success'        => 'Примітка успішно створена',
                'order-create-confirmation'   => 'Ви впевнені, що хочете створити замовлення для цього клієнта?',
                'phone'                       => 'Телефон - :phone',
                'set-as-default'              => 'Встановити за замовчуванням',
                'suspended'                   => 'Призупинено',
                'title'                       => 'Перегляд клієнта',

                'address' => [
                    'count'  => 'Адреси (:count)',

                    'create' => [
                        'city'               => 'Місто',
                        'company-name'       => 'Назва компанії',
                        'country'            => 'Країна',
                        'create-btn'         => 'Створити',
                        'create-address-btn' => 'Додати нову адресу',
                        'default-address'    => 'Адреса за замовчуванням',
                        'email'              => 'Електронна пошта',
                        'first-name'         => "Ім'я",
                        'last-name'          => 'Прізвище',
                        'phone'              => 'Телефон',
                        'post-code'          => 'Поштовий індекс',
                        'save-btn-title'     => 'Зберегти адресу',
                        'select-country'     => 'Вибрати країну',
                        'state'              => 'Область',
                        'street-address'     => 'Вулиця',
                        'title'              => 'Створити адресу',
                        'vat-id'             => 'Ідентифікаційний номер ПДВ',
                    ],

                    'edit' => [
                        'city'            => 'Місто',
                        'company-name'    => 'Назва компанії',
                        'country'         => 'Країна',
                        'default-address' => 'Адреса за замовчуванням',
                        'edit-btn'        => 'Редагувати',
                        'email'           => 'Електронна пошта',
                        'first-name'      => "Ім'я",
                        'last-name'       => 'Прізвище',
                        'phone'           => 'Телефон',
                        'post-code'       => 'Поштовий індекс',
                        'save-btn-title'  => 'Зберегти адресу',
                        'select-country'  => 'Вибрати країну',
                        'state'           => 'Область',
                        'street-address'  => 'Вулиця',
                        'title'           => 'Редагувати адресу',
                        'vat-id'          => 'Ідентифікаційний номер ПДВ',
                    ],

                    'address-delete-success' => 'Адресу успішно видалено',
                    'create-success'         => 'Адресу успішно створено',
                    'set-default-success'    => 'Адресу за замовчуванням успішно оновлено',
                    'success-mass-delete'    => 'Масове видалення адрес успішно виконано',
                    'update-success'         => 'Адресу успішно оновлено',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'Немає відгуків',
                        'increment-id'   => 'Ідентифікатор рахунка-фактури',
                        'invoice-amount' => 'Сума рахунка-фактури',
                        'invoice-date'   => 'Дата рахунка-фактури',
                        'order-id'       => 'Ідентифікатор замовлення',
                        'view'           => 'Перегляд',
                    ],

                    'orders' => [
                        'canceled'        => 'Скасовано',
                        'channel-name'    => 'Назва каналу',
                        'closed'          => 'Закрито',
                        'completed'       => 'Завершено',
                        'customer-name'   => 'Ім\'я клієнта',
                        'date'            => 'Дата',
                        'empty-order'     => 'Немає доступних замовлень',
                        'email'           => 'Електронна пошта',
                        'fraud'           => 'Шахрайство',
                        'grand-total'     => 'Загальна сума',
                        'location'        => 'Місце розташування',
                        'order-id'        => 'Ідентифікатор замовлення',
                        'pay-via'         => 'Оплата через',
                        'pending'         => 'В очікуванні',
                        'pending-payment' => 'Очікує оплати',
                        'processing'      => 'Обробка',
                        'status'          => 'Статус',
                        'view'            => 'Перегляд',
                    ],

                    'reviews' => [
                        'approved'      => 'Схвалено',
                        'comment'       => 'Коментар',
                        'created-at'    => 'Створено',
                        'disapproved'   => 'Не схвалено',
                        'empty-reviews' => 'Немає доступних рахунків',
                        'id'            => 'Ідентифікатор',
                        'invoice-date'  => 'Дата рахунка-фактури',
                        'pending'       => 'В очікуванні',
                        'product-id'    => 'Ідентифікатор продукту',
                        'product-name'  => 'Назва продукту',
                        'rating'        => 'Рейтинг',
                        'status'        => 'Статус',
                        'title'         => 'Заголовок',
                    ],
                ],

                'edit' => [
                    'contact-number'        => 'Номер телефону',
                    'customer-group'        => 'Група клієнтів',
                    'date-of-birth'         => 'Дата народження',
                    'edit-btn'              => 'Редагувати',
                    'email'                 => 'Електронна пошта',
                    'female'                => 'Жінка',
                    'first-name'            => "Ім'я",
                    'gender'                => 'Стать',
                    'last-name'             => 'Прізвище',
                    'male'                  => 'Чоловік',
                    'other'                 => 'Інша',
                    'save-btn'              => 'Зберегти клієнта',
                    'select-customer-group' => 'Вибрати групу клієнтів',
                    'select-gender'         => 'Вибрати стать',
                    'status'                => 'Статус',
                    'suspended'             => 'Призупинено',
                    'title'                 => 'Редагувати клієнта',
                ],

                'invoices' => [
                    'count'        => 'Рахунки-фактури (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'Додати примітку',
                    'customer-not-notified' => ':date | Клієнта <b>не сповіщено</b>',
                    'customer-notified'     => ':date | Клієнта <b>сповіщено</b>',
                    'note'                  => 'Примітка',
                    'note-placeholder'      => 'Напишіть вашу примітку тут',
                    'notify-customer'       => 'Сповістити клієнта',
                    'submit-btn-title'      => 'Надіслати примітку',
                ],

                'orders' => [
                    'count'         => 'Замовлення (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => 'Загальний дохід - :revenue',
                ],

                'reviews' => [
                    'id'    => 'Ідентифікатор - :id',
                    'count' => 'Відгуки (:count)',
                ],

                'cart' => [
                    'delete-success' => 'Елемент кошика успішно видалено.',
                ],

                'wishlist' => [
                    'delete-success' => 'Елемент списку бажань успішно видалено.',
                ],

                'compare' => [
                    'delete-success' => 'Елемент порівняння успішно видалено.',
                ],
            ],

            'delete-failed'  => 'Видалення клієнта не вдалося',
            'delete-success' => 'Клієнта успішно видалено',
            'order-pending'  => 'Замовлення в очікуванні',
            'update-success' => 'Клієнта успішно оновлено',
        ],

        'groups' => [
            'index' => [
                'title' => 'Групи',

                'create' => [
                    'code'       => 'Код',
                    'create-btn' => 'Створити Групу',
                    'name'       => 'Назва',
                    'save-btn'   => 'Зберегти Групу',
                    'success'    => 'Група успішно створена',
                    'title'      => 'Створити нову Групу',
                ],

                'edit' => [
                    'delete-failed'  => 'Видалення Групи не вдалося',
                    'delete-success' => 'Групу успішно видалено',
                    'group-default'  => 'Групу за замовчуванням не можна видалити',
                    'success'        => 'Група успішно оновлена',
                    'title'          => 'Редагувати Групу',
                ],

                'datagrid' => [
                    'code'   => 'Код',
                    'delete' => 'Видалити',
                    'edit'   => 'Редагувати',
                    'id'     => 'ID',
                    'name'   => 'Назва',
                ],
            ],
        ],

        'gdpr' => [
            'index' => [
                'title' => 'Запит GDPR',

                'datagrid' => [
                    'completed'     => 'Завершено',
                    'created-at'    => 'Створено',
                    'customer-name' => 'Ім\'я клієнта',
                    'declined'      => 'Відхилено',
                    'delete'        => 'Видалити',
                    'edit'          => 'Редагувати',
                    'id'            => 'ID',
                    'message'       => 'Повідомлення',
                    'pending'       => 'В очікуванні',
                    'processing'    => 'Обробка',
                    'revoked'       => 'Скасовано',
                    'status'        => 'Статус',
                    'type'          => 'Тип',
                ],

                'modal' => [
                    'completed'     => 'Завершено',
                    'declined'      => 'Відхилено',
                    'message'       => 'Повідомлення',
                    'pending'       => 'В очікуванні',
                    'processing'    => 'Обробка',
                    'revoked'       => 'Скасовано',
                    'save-btn'      => 'Зберегти',
                    'status'        => 'Статус',
                    'title'         => 'Редагувати запит на дані GDPR',
                    'type'          => 'Тип',
                ],

                'update-success'              => 'Запит на дані успішно оновлено та електронний лист надіслано клієнту.',
                'delete-success'              => 'Запит на дані успішно видалено.',
                'attribute-reason-error'      => 'Не вдалося видалити.',
                'update-success-unsent-email' => 'Запит на дані успішно оновлено, але електронний лист не надіслано клієнту.',
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => 'Дата',
                'description' => 'Опис',
                'id'          => 'ID',
                'name'        => 'Ім я',
                'product'     => 'Продукт',
                'rating'      => 'Рейтинг',
                'status'      => 'Статус',
                'title'       => 'Відгуки',

                'edit' => [
                    'approved'       => 'Схвалено',
                    'customer'       => 'Клієнт',
                    'date'           => 'Дата',
                    'disapproved'    => 'Відхилено',
                    'id'             => 'ID',
                    'images'         => 'Зображення',
                    'pending'        => 'В очікуванні',
                    'product'        => 'Продукт',
                    'rating'         => 'Рейтинг',
                    'review-comment' => 'Коментар',
                    'review-title'   => 'Заголовок',
                    'save-btn'       => 'Зберегти',
                    'status'         => 'Статус',
                    'title'          => 'Редагувати Відгук',
                    'update-success' => 'Оновлено успішно',
                ],

                'datagrid' => [
                    'approved'            => 'Схвалено',
                    'comment'             => 'Коментар',
                    'customer-names'      => 'Ім я',
                    'date'                => 'Дата',
                    'delete'              => 'Видалити',
                    'delete-success'      => 'Відгук успішно видалено',
                    'disapproved'         => 'Відхилено',
                    'edit'                => 'Редагувати',
                    'id'                  => 'ID',
                    'mass-delete-error'   => 'Щось пішло не так',
                    'mass-delete-success' => 'Вибрані відгуки успішно видалено',
                    'mass-update-success' => 'Вибрані відгуки успішно оновлено',
                    'pending'             => 'В очікуванні',
                    'product'             => 'Продукт',
                    'rating'              => 'Рейтинг',
                    'review-id'           => 'ID - :review_id',
                    'status'              => 'Статус',
                    'title'               => 'Заголовок',
                    'update-status'       => 'Оновити Статус',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'Створити Шаблон',
                    'title'      => 'Шаблони Email',

                    'datagrid' => [
                        'active'   => 'Активний',
                        'draft'    => 'Чернетка',
                        'id'       => 'ID',
                        'inactive' => 'Неактивний',
                        'name'     => 'Назва',
                        'status'   => 'Статус',
                    ],
                ],

                'create' => [
                    'active'         => 'Активний',
                    'back-btn'       => 'Назад',
                    'content'        => 'Зміст',
                    'create-success' => 'Шаблон Email успішно створено.',
                    'draft'          => 'Чернетка',
                    'general'        => 'Загальне',
                    'inactive'       => 'Неактивний',
                    'name'           => 'Назва',
                    'save-btn'       => 'Зберегти Шаблон',
                    'select-status'  => 'Виберіть Статус',
                    'status'         => 'Статус',
                    'title'          => 'Створити Шаблон',
                ],

                'edit' => [
                    'active'         => 'Активний',
                    'back-btn'       => 'Назад',
                    'content'        => 'Зміст*',
                    'draft'          => 'Чернетка',
                    'general'        => 'Загальне',
                    'inactive'       => 'Неактивний',
                    'name'           => 'Назва',
                    'save-btn'       => 'Зберегти Шаблон',
                    'status'         => 'Статус',
                    'title'          => 'Редагувати Шаблон',
                    'update-success' => 'Оновлено успішно',
                ],

                'delete-failed'  => ':name Видалення не вдалося',
                'delete-success' => 'Шаблон видалено успішно',
                'email-template' => 'Email Шаблон',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn'  => 'Створити Кампанію',
                    'title'       => 'Кампанії',

                    'datagrid' => [
                        'active'   => 'Активний',
                        'delete'   => 'Видалити',
                        'edit'     => 'Редагувати',
                        'id'       => 'ID',
                        'inactive' => 'Неактивний',
                        'name'     => 'Назва',
                        'status'   => 'Статус',
                        'subject'  => 'Тема',
                    ],
                ],

                'create' => [
                    'active'          => 'Активний',
                    'back-btn'        => 'Назад',
                    'channel'         => 'Канал',
                    'customer-group'  => 'Група Клієнтів',
                    'email-template'  => 'Email Шаблон',
                    'event'           => 'Подія',
                    'general'         => 'Загальне',
                    'inactive'        => 'Неактивний',
                    'name'            => 'Назва',
                    'save-btn'        => 'Зберегти Кампанію',
                    'select-channel'  => 'Вибрати канал',
                    'select-event'    => 'Виберіть Подію',
                    'select-group'    => 'Вибрати групу',
                    'select-status'   => 'Виберіть Статус',
                    'select-template' => 'Виберіть Шаблон',
                    'setting'         => 'Настройки',
                    'status'          => 'Статус',
                    'subject'         => 'Тема',
                    'title'           => 'Створити Кампанію',
                ],

                'edit' => [
                    'active'          => 'Активний',
                    'audience'        => 'Аудиторія',
                    'back-btn'        => 'Назад',
                    'channel'         => 'Канал',
                    'customer-group'  => 'Група Клієнтів',
                    'email-template'  => 'Email Шаблон',
                    'event'           => 'Подія',
                    'general'         => 'Загальне',
                    'inactive'        => 'Неактивний',
                    'name'            => 'Назва',
                    'save-btn'        => 'Зберегти Кампанію',
                    'select-event'    => 'Виберіть Подію',
                    'select-status'   => 'Виберіть Статус',
                    'select-template' => 'Виберіть Шаблон',
                    'status'          => 'Статус',
                    'subject'         => 'Тема',
                    'title'           => 'Редагувати Кампанію',
                ],

                'create-success' => 'Кампанію створено успішно.',
                'delete-failed'  => ':name Видалення не вдалося',
                'delete-success' => 'Кампанію видалено успішно',
                'email-campaign' => 'Email Кампанія',
                'update-success' => 'Кампанію оновлено успішно.',
            ],

            'events' => [
                'index' => [
                    'create-btn' => 'Створити Подію',
                    'event'      => 'Подія',
                    'title'      => 'Події',

                    'datagrid' => [
                        'actions' => 'Дії',
                        'date'    => 'Дата',
                        'delete'  => 'Видалити',
                        'edit'    => 'Редагувати',
                        'id'      => 'ID',
                        'name'    => 'Назва',
                    ],

                    'create' => [
                        'date'           => 'Дата',
                        'delete-warning' => 'Ви впевнені, що хочете виконати цю дію?',
                        'description'    => 'Опис',
                        'general'        => 'Загальне',
                        'name'           => 'Назва',
                        'save-btn'       => 'Зберегти Подію',
                        'success'        => 'Події успішно створено',
                        'title'          => 'Створити Події',
                    ],

                    'edit' => [
                        'success' => 'Події успішно оновлено',
                        'title'   => 'Редагувати Події',
                    ],
                ],

                'delete-failed'  => ':name Видалення не вдалося',
                'delete-success' => 'Події успішно видалено',
                'edit-error'     => 'Подію не можна редагувати',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'Підписки на Розсилку',

                    'datagrid' => [
                        'actions'    => 'Дії',
                        'delete'     => 'Видалити',
                        'edit'       => 'Редагувати',
                        'email'      => 'Email',
                        'false'      => 'Ні',
                        'id'         => 'ID',
                        'subscribed' => 'Підписаний',
                        'true'       => 'Так',
                    ],

                    'edit' => [
                        'back-btn'      => 'Назад',
                        'email'         => 'Email',
                        'false'         => 'Ні',
                        'save-btn'      => 'Зберегти Підписника',
                        'subscribed'    => 'Підписаний',
                        'success'       => 'Підписку на розсилку оновлено успішно',
                        'title'         => 'Редагувати Підписника на Розсилку',
                        'true'          => 'Так',
                        'update-failed' => 'Підписку на розсилку не оновлено',
                    ],
                ],

                'delete-failed'  => 'Видалення підписника не вдалося',
                'delete-success' => 'Підписника успішно видалено',
                'delete-warning' => 'Ви впевнені, що хочете виконати цю дію?',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => 'Правила Кошика',
                'catalog-rule-title' => 'Каталогові Правила',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'Створити Правило Кошика',
                    'title'      => 'Правила Кошика',

                    'datagrid' => [
                        'active'      => 'Активне',
                        'copy'        => 'Копіювати',
                        'copy-of'     => ':value',
                        'coupon-code' => 'Промокод',
                        'delete'      => 'Видалити',
                        'draft'       => 'Чернетка',
                        'edit'        => 'Редагувати',
                        'end'         => 'Кінець',
                        'id'          => 'ID',
                        'inactive'    => 'Неактивне',
                        'name'        => 'Назва',
                        'priority'    => 'Пріоритет',
                        'start'       => 'Початок',
                        'status'      => 'Статус',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'Тип Дії',
                    'actions'                                   => 'Дії',
                    'add-condition'                             => 'Додати Умову',
                    'additional'                                => 'Додатково',
                    'all-conditions-true'                       => 'Усі Умови Вірні',
                    'any-conditions-true'                       => 'Будь-яка Умова Вірна',
                    'apply-to-shipping'                         => 'Застосувати до Доставки',
                    'attribute-family'                          => 'Сімейство Атрибутів',
                    'attribute-name-children-only'              => ':attribute_name (Тільки Діти)',
                    'attribute-name-parent-only'                => ':attribute_name (Тільки Батьки)',
                    'auto-generate-coupon'                      => 'Автоматично Генерувати Промокод',
                    'back-btn'                                  => 'Назад',
                    'buy-x-get-y-free'                          => 'Купи X Отримай Y За Безкоштовно',
                    'buy-x-quantity'                            => 'Купи Кількість X',
                    'cart-attribute'                            => 'Атрибут Кошика',
                    'cart-item-attribute'                       => 'Атрибут Товару у Кошику',
                    'categories'                                => 'Категорії',
                    'channels'                                  => 'Канали',
                    'children-categories'                       => 'Категорії (Тільки Діти)',
                    'choose-condition-to-add'                   => 'Виберіть умову для додавання',
                    'condition-type'                            => 'Тип Умови',
                    'conditions'                                => 'Умови',
                    'contain'                                   => 'Містить',
                    'contains'                                  => 'Містить',
                    'coupon-code'                               => 'Промокод',
                    'coupon-type'                               => 'Тип Промокоду',
                    'create-success'                            => 'Правило Кошика створено успішно',
                    'customer-groups'                           => 'Групи Клієнтів',
                    'description'                               => 'Опис',
                    'discount-amount'                           => 'Сума Знижки',
                    'does-not-contain'                          => 'Не Містить',
                    'end-of-other-rules'                        => 'Кінець Інших Правил',
                    'equals-or-greater-than'                    => 'Дорівнюється або більше',
                    'equals-or-less-than'                       => 'Дорівнюється або менше',
                    'fixed-amount'                              => 'Фіксована Сума',
                    'fixed-amount-whole-cart'                   => 'Фіксована Сума для Всього Кошика',
                    'free-shipping'                             => 'Безкоштовна Доставка',
                    'from'                                      => 'З',
                    'general'                                   => 'Загальне',
                    'greater-than'                              => 'Більше',
                    'is-equal-to'                               => 'Дорівнює',
                    'is-not-equal-to'                           => 'Не Дорівнює',
                    'less-than'                                 => 'Менше',
                    'marketing-time'                            => 'Час Маркетингу',
                    'maximum-quantity-allowed-to-be-discounted' => 'Максимальна Кількість, яка підлягає Знижці',
                    'name'                                      => 'Назва',
                    'no'                                        => 'Ні',
                    'no-coupon'                                 => 'Без Промокоду',
                    'parent-categories'                         => 'Категорії (Тільки Батьки)',
                    'payment-method'                            => 'Спосіб Оплати',
                    'percentage-product-price'                  => 'Відсоток від Ціни Продукту',
                    'price-in-cart'                             => 'Ціна у Кошику',
                    'priority'                                  => 'Пріоритет',
                    'product-attribute'                         => 'Атрибут Продукту',
                    'qty-in-cart'                               => 'Кількість у Кошику',
                    'save-btn'                                  => 'Зберегти Правило Кошика',
                    'settings'                                  => 'Налаштування',
                    'shipping-country'                          => 'Країна Доставки',
                    'shipping-method'                           => 'Спосіб Доставки',
                    'shipping-postcode'                         => 'Індекс Доставки',
                    'shipping-state'                            => 'Область Доставки',
                    'specific-coupon'                           => 'Конкретний Промокод',
                    'status'                                    => 'Статус',
                    'subtotal'                                  => 'Проміжний Підсумок',
                    'title'                                     => 'Створити Правило Кошика',
                    'to'                                        => 'До',
                    'total-items-qty'                           => 'Загальна Кількість Товарів',
                    'total-weight'                              => 'Загальна Вага',
                    'uses-per-coupon'                           => 'Використання на Промокод',
                    'uses-per-customer'                         => 'Використання на Клієнта',
                    'uses-per-customer-control-info'            => 'Використовується тільки для авторизованих клієнтів.',
                    'yes'                                       => 'Так',
                ],

                'edit' => [
                    'action-type'                               => 'Тип Дії',
                    'actions'                                   => 'Дії',
                    'add-condition'                             => 'Додати Умову',
                    'additional'                                => 'Додатково',
                    'all-conditions-true'                       => 'Усі Умови Вірні',
                    'alphabetical'                              => 'Буквений',
                    'alphanumeric'                              => 'Буквено-Цифровий',
                    'any-conditions-true'                       => 'Будь-яка Умова Вірна',
                    'apply-to-shipping'                         => 'Застосувати до Доставки',
                    'attribute-family'                          => 'Сімейство Атрибутів',
                    'attribute-name-children-only'              => ':attribute_name (Тільки Діти)',
                    'attribute-name-parent-only'                => ':attribute_name (Тільки Батьки)',
                    'auto-generate-coupon'                      => 'Автоматично Генерувати Промокод',
                    'back-btn'                                  => 'Назад',
                    'buy-x-get-y-free'                          => 'Купи X Отримай Y За Безкоштовно',
                    'buy-x-quantity'                            => 'Купи Кількість X',
                    'cart-attribute'                            => 'Атрибут Кошика',
                    'cart-item-attribute'                       => 'Атрибут Товару у Кошику',
                    'categories'                                => 'Категорії',
                    'channels'                                  => 'Канали',
                    'children-categories'                       => 'Категорії (Тільки Діти)',
                    'choose-condition-to-add'                   => 'Виберіть умову для додавання',
                    'code-format'                               => 'Формат Коду',
                    'code-prefix'                               => 'Префікс Коду',
                    'code-suffix'                               => 'Суфікс Коду',
                    'condition-type'                            => 'Тип Умови',
                    'conditions'                                => 'Умови',
                    'contain'                                   => 'Містить',
                    'contains'                                  => 'Містить',
                    'coupon-code'                               => 'Промокод',
                    'coupon-length'                             => 'Довжина Промокоду',
                    'coupon-qty'                                => 'Кількість Промокодів',
                    'coupon-type'                               => 'Тип Промокоду',
                    'customer-group'                            => 'Група Клієнтів',
                    'customer-groups'                           => 'Групи Клієнтів',
                    'description'                               => 'Опис',
                    'discount-amount'                           => 'Сума Знижки',
                    'does-not-contain'                          => 'Не Містить',
                    'end-of-other-rules'                        => 'Кінець Інших Правил',
                    'equals-or-greater-than'                    => 'Дорівнюється або більше',
                    'equals-or-less-than'                       => 'Дорівнюється або менше',
                    'fixed-amount'                              => 'Фіксована Сума',
                    'fixed-amount-whole-cart'                   => 'Фіксована Сума для Всього Кошика',
                    'free-shipping'                             => 'Безкоштовна Доставка',
                    'from'                                      => 'З',
                    'general'                                   => 'Загальне',
                    'generate'                                  => 'Генерувати',
                    'greater-than'                              => 'Більше',
                    'is-equal-to'                               => 'Дорівнює',
                    'is-not-equal-to'                           => 'Не Дорівнює',
                    'less-than'                                 => 'Менше',
                    'marketing-time'                            => 'Час Маркетингу',
                    'maximum-quantity-allowed-to-be-discounted' => 'Максимальна Кількість, яка підлягає Знижці',
                    'name'                                      => 'Назва',
                    'no'                                        => 'Ні',
                    'no-coupon'                                 => 'Без Промокоду',
                    'numeric'                                   => 'Цифровий',
                    'parent-categories'                         => 'Категорії (Тільки Батьки)',
                    'payment-method'                            => 'Спосіб Оплати',
                    'percentage-product-price'                  => 'Відсоток від Ціни Продукту',
                    'price-in-cart'                             => 'Ціна у Кошику',
                    'priority'                                  => 'Пріоритет',
                    'product-attribute'                         => 'Атрибут Продукту',
                    'qty-in-cart'                               => 'Кількість у Кошику',
                    'save-btn'                                  => 'Зберегти Правило Кошика',
                    'settings'                                  => 'Налаштування',
                    'shipping-country'                          => 'Країна Доставки',
                    'shipping-method'                           => 'Спосіб Доставки',
                    'shipping-postcode'                         => 'Індекс Доставки',
                    'shipping-state'                            => 'Область Доставки',
                    'specific-coupon'                           => 'Конкретний Промокод',
                    'status'                                    => 'Статус',
                    'subtotal'                                  => 'Проміжний Підсумок',
                    'title'                                     => 'Редагувати Правило Кошика',
                    'to'                                        => 'До',
                    'total-items-qty'                           => 'Загальна Кількість Товарів',
                    'total-weight'                              => 'Загальна Вага',
                    'update-success'                            => 'Правило Кошика оновлено успішно',
                    'uses-per-coupon'                           => 'Використання на Промокод',
                    'uses-per-customer'                         => 'Використання на Клієнта',
                    'uses-per-customer-control-info'            => 'Використовується тільки для авторизованих клієнтів.',
                    'yes'                                       => 'Так',
                ],

                'delete-failed'  => 'Правило Кошика не вдалося видалити',
                'delete-success' => 'Правило Кошика успішно видалено',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => 'Створити Правило Каталогу',
                    'title'      => 'Правила Каталогу',

                    'datagrid' => [
                        'active'   => 'Активне',
                        'delete'   => 'Видалити',
                        'edit'     => 'Редагувати',
                        'end'      => 'Кінець',
                        'id'       => 'ID',
                        'inactive' => 'Неактивне',
                        'name'     => 'Назва',
                        'priority' => 'Пріоритет',
                        'start'    => 'Початок',
                        'status'   => 'Статус',
                    ],
                ],

                'create' => [
                    'action-type'              => 'Тип Дії',
                    'actions'                  => 'Дії',
                    'add-condition'            => 'Додати Умову',
                    'all-conditions-true'      => 'Усі Умови Вірні',
                    'any-conditions-true'      => 'Будь-яка Умова Вірна',
                    'attribute-family'         => 'Сімейство Атрибутів',
                    'back-btn'                 => 'Назад',
                    'categories'               => 'Категорії',
                    'channels'                 => 'Канали',
                    'choose-condition-to-add'  => 'Виберіть Умову для Додавання',
                    'condition-type'           => 'Тип Умови',
                    'conditions'               => 'Умови',
                    'contain'                  => 'Містить',
                    'contains'                 => 'Містить',
                    'customer-groups'          => 'Групи Клієнтів',
                    'description'              => 'Опис',
                    'discount-amount'          => 'Сума Знижки',
                    'does-not-contain'         => 'Не Містить',
                    'end-other-rules'          => 'Закінчити інші правила',
                    'equals-or-greater-than'   => 'Дорівнюється або більше',
                    'equals-or-less-than'      => 'Дорівнюється або менше',
                    'fixed-amount'             => 'Фіксована Сума',
                    'from'                     => 'З',
                    'general'                  => 'Загальне',
                    'greater-than'             => 'Більше',
                    'is-equal-to'              => 'Дорівнює',
                    'is-not-equal-to'          => 'Не Дорівнює',
                    'less-than'                => 'Менше',
                    'marketing-time'           => 'Час Маркетингу',
                    'name'                     => 'Назва',
                    'no'                       => 'Ні',
                    'percentage-product-price' => 'Відсоток від Ціни Продукту',
                    'priority'                 => 'Пріоритет',
                    'product-attribute'        => 'Атрибут Продукту',
                    'save-btn'                 => 'Зберегти Правило Каталогу',
                    'settings'                 => 'Налаштування',
                    'status'                   => 'Статус',
                    'title'                    => 'Створити Правило Каталогу',
                    'to'                       => 'До',
                    'yes'                      => 'Так',
                ],

                'edit' => [
                    'action-type'              => 'Тип Дії',
                    'actions'                  => 'Дії',
                    'add-condition'            => 'Додати Умову',
                    'all-conditions-true'      => 'Усі Умови Вірні',
                    'any-conditions-true'      => 'Будь-яка Умова Вірна',
                    'back-btn'                 => 'Назад',
                    'categories'               => 'Категорії',
                    'channels'                 => 'Канали',
                    'choose-condition-to-add'  => 'Виберіть Умову для Додавання',
                    'condition-type'           => 'Тип Умови',
                    'conditions'               => 'Умови',
                    'contain'                  => 'Містить',
                    'contains'                 => 'Містить',
                    'customer-groups'          => 'Групи Клієнтів',
                    'description'              => 'Опис',
                    'discount-amount'          => 'Сума Знижки',
                    'does-not-contain'         => 'Не Містить',
                    'end-other-rules'          => 'Закінчити інші правила',
                    'equals-or-greater-than'   => 'Дорівнюється або більше',
                    'equals-or-less-than'      => 'Дорівнюється або менше',
                    'fixed-amount'             => 'Фіксована Сума',
                    'from'                     => 'З',
                    'general'                  => 'Загальне',
                    'greater-than'             => 'Більше',
                    'is-equal-to'              => 'Дорівнює',
                    'is-not-equal-to'          => 'Не Дорівнює',
                    'less-than'                => 'Менше',
                    'marketing-time'           => 'Час Маркетингу',
                    'name'                     => 'Назва',
                    'no'                       => 'Ні',
                    'percentage-product-price' => 'Відсоток від Ціни Продукту',
                    'priority'                 => 'Пріоритет',
                    'product-attribute'        => 'Атрибут Продукту',
                    'save-btn'                 => 'Зберегти Правило Каталогу',
                    'settings'                 => 'Налаштування',
                    'status'                   => 'Статус',
                    'title'                    => 'Редагувати Правило Каталогу',
                    'to'                       => 'До',
                    'yes'                      => 'Так',
                ],

                'create-success' => 'Правило Каталогу створено успішно',
                'delete-success' => 'Правило Каталогу видалено успішно',
                'update-success' => 'Правило Каталогу оновлено успішно',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => 'Правило кошика не можна видалити',
                'delete-success'              => 'Купон правила кошика успішно видалено',
                'mass-delete-success'         => 'Вибрані елементи успішно видалено',
                'success'                     => ':name успішно створено',

                'datagrid' => [
                    'coupon-code'     => 'Код купона',
                    'created-date'    => 'Дата створення',
                    'delete'          => 'Видалити',
                    'expiration-date' => 'Дата закінчення',
                    'id'              => 'ID',
                    'times-used'      => 'Кількість використань',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => 'Створити новий термін пошуку',
                    'title'      => 'Терміни пошуку',

                    'datagrid' => [
                        'actions'             => 'Дії',
                        'channel'             => 'Канал',
                        'delete'              => 'Видалити',
                        'edit'                => 'Редагувати',
                        'id'                  => 'ID',
                        'locale'              => 'Локаль',
                        'mass-delete-success' => 'Вибрані терміни пошуку успішно видалено',
                        'redirect-url'        => 'URL переадресації',
                        'results'             => 'Результати',
                        'search-query'        => 'Пошукова фраза',
                        'uses'                => 'Використання',
                    ],

                    'create' => [
                        'channel'        => 'Канал',
                        'delete-warning' => 'Ви впевнені, що хочете виконати цю дію?',
                        'locale'         => 'Локаль',
                        'redirect-url'   => 'URL переадресації',
                        'results'        => 'Результати',
                        'save-btn'       => 'Зберегти термін пошуку',
                        'search-query'   => 'Пошукова фраза',
                        'success'        => 'Термін пошуку успішно створено',
                        'title'          => 'Створити новий термін пошуку',
                        'uses'           => 'Використання',
                    ],

                    'edit' => [
                        'delete-success' => 'Термін пошуку успішно видалено',
                        'success'        => 'Термін пошуку успішно оновлено',
                        'title'          => 'Редагувати термін пошуку',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => 'Створити синонім пошуку',
                    'title'      => 'Синоніми пошуку',

                    'datagrid' => [
                        'actions'             => 'Дії',
                        'delete'              => 'Видалити',
                        'edit'                => 'Редагувати',
                        'id'                  => 'Ідентифікатор',
                        'mass-delete-success' => 'Вибрані синоніми пошуку успішно видалено',
                        'name'                => 'Назва',
                        'terms'               => 'Терміни',
                    ],

                    'create' => [
                        'delete-warning' => 'Ви впевнені, що хочете виконати цю дію?',
                        'name'           => 'Назва',
                        'save-btn'       => 'Зберегти синонім пошуку',
                        'success'        => 'Синонім пошуку успішно створено',
                        'terms'          => 'Терміни',
                        'terms-info'     => 'Введіть синоніми у вигляді розділених комами списків, наприклад, "взуття,взуття." Це розширює пошук для включення всіх термінів.',
                        'title'          => 'Створення синоніму пошуку',
                    ],

                    'edit' => [
                        'delete-success' => 'Синонім пошуку успішно видалено',
                        'success'        => 'Синонім пошуку успішно оновлено',
                        'title'          => 'Редагування синоніму пошуку',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'Створити карту сайту',
                    'sitemap'    => 'Карта сайту',
                    'title'      => 'Карта сайту',

                    'datagrid' => [
                        'actions'         => 'Дії',
                        'delete'          => 'Видалити',
                        'edit'            => 'Редагувати',
                        'file-name'       => 'Ім я файлу',
                        'id'              => 'ID',
                        'link-for-google' => 'Посилання для Google',
                        'path'            => 'Шлях',
                    ],

                    'create' => [
                        'delete-warning' => 'Ви впевнені, що хочете виконати цю дію?',
                        'file-name'      => 'Ім я файлу',
                        'file-name-info' => 'Приклад: sitemap.xml',
                        'path'           => 'Шлях',
                        'path-info'      => 'Приклад: "/sitemap/" або "/" для базового шляху',
                        'save-btn'       => 'Зберегти карту сайту',
                        'success'        => 'Карта сайту успішно створена',
                        'title'          => 'Створити карту сайту',
                    ],

                    'edit' => [
                        'delete-success' => 'Карта сайту успішно видалена',
                        'success'        => 'Карта сайту успішно оновлена',
                        'title'          => 'Редагувати карту сайту',
                    ],
                ],

                'edit' => [
                    'back-btn'       => 'Назад',
                    'file-name'      => 'Ім я файлу',
                    'file-name-info' => 'Приклад: sitemap.xml',
                    'general'        => 'Загальне',
                    'path'           => 'Шлях',
                    'path-info'      => 'Приклад: "/sitemap/" або "/" для базового шляху',
                    'save-btn'       => 'Зберегти карту сайту',
                ],

                'delete-failed' => ':name Видалення не вдалося',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => 'Створити переадресацію URL',
                    'title'      => 'Переадресації URL',

                    'datagrid' => [
                        'actions'             => 'Дії',
                        'category'            => 'Категорія',
                        'cms-page'            => 'Сторінка CMS',
                        'delete'              => 'Видалити',
                        'edit'                => 'Редагувати',
                        'for'                 => 'Для',
                        'id'                  => 'ID',
                        'locale'              => 'Локаль',
                        'mass-delete-success' => 'Вибрані переадресації URL успішно видалено',
                        'permanent-redirect'  => 'Постійна (301)',
                        'product'             => 'Продукт',
                        'redirect-type'       => 'Тип переадресації',
                        'request-path'        => 'Шлях запиту',
                        'target-path'         => 'Цільовий шлях',
                        'temporary-redirect'  => 'Тимчасова (302)',
                    ],

                    'create' => [
                        'category'           => 'Категорія',
                        'cms-page'           => 'Сторінка CMS',
                        'delete-warning'     => 'Ви впевнені, що хочете виконати цю дію?',
                        'for'                => 'Для',
                        'locale'             => 'Локаль',
                        'permanent-redirect' => 'Постійна (301)',
                        'product'            => 'Продукт',
                        'redirect-type'      => 'Тип переадресації',
                        'request-path'       => 'Шлях запиту',
                        'save-btn'           => 'Зберегти переадресацію URL',
                        'success'            => 'Переадресацію URL створено успішно',
                        'target-path'        => 'Цільовий шлях',
                        'temporary-redirect' => 'Тимчасова (302)',
                        'title'              => 'Створити переадресацію URL',
                    ],

                    'edit' => [
                        'delete-success' => 'Переадресацію URL видалено успішно',
                        'success'        => 'Переадресацію URL оновлено успішно',
                        'title'          => 'Редагувати переадресацію URL',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => 'Це ім\'я :name вже використовується.',
            'create-btn'    => 'Створити сторінку',
            'channel'       => 'Канал',
            'language'      => 'Мова',
            'title'         => 'Сторінки',

            'datagrid' => [
                'channel'             => 'Канал',
                'delete'              => 'Видалити',
                'edit'                => 'Редагувати',
                'id'                  => 'ID',
                'mass-delete-success' => 'Вибрані дані успішно видалено',
                'page-title'          => 'Заголовок сторінки',
                'url-key'             => 'URL-ключ',
                'view'                => 'Перегляд',
            ],
        ],

        'create' => [
            'channels'         => 'Канали',
            'content'          => 'Зміст',
            'description'      => 'Опис',
            'general'          => 'Загальне',
            'meta-description' => 'Мета опис',
            'meta-keywords'    => 'Мета ключові слова',
            'meta-title'       => 'Мета заголовок',
            'page-title'       => 'Заголовок',
            'save-btn'         => 'Зберегти сторінку',
            'seo'              => 'Пошукова оптимізація',
            'title'            => 'Створити сторінку',
            'url-key'          => 'URL-ключ',
        ],

        'edit' => [
            'back-btn'         => 'Назад',
            'channels'         => 'Канали',
            'content'          => 'Зміст',
            'description'      => 'Опис',
            'general'          => 'Загальне',
            'meta-description' => 'Мета опис',
            'meta-keywords'    => 'Мета ключові слова',
            'meta-title'       => 'Мета заголовок',
            'page-title'       => 'Заголовок сторінки',
            'preview-btn'      => 'Попередній перегляд сторінки',
            'save-btn'         => 'Зберегти сторінку',
            'seo'              => 'Пошукова оптимізація',
            'title'            => 'Редагувати сторінку',
            'url-key'          => 'URL-ключ',
        ],

        'create-success' => 'CMS створена успішно.',
        'delete-success' => 'CMS успішно видалена.',
        'no-resource'    => 'Ресурс не існує.',
        'update-success' => 'CMS успішно оновлена.',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => 'Створити Локаль',
                'locale'     => 'Локаль',
                'logo-size'  => 'Роздільна здатність зображення повинна бути 24px x 16px',
                'title'      => 'Локалі',

                'datagrid' => [
                    'actions'   => 'Дії',
                    'code'      => 'Код',
                    'delete'    => 'Видалити',
                    'direction' => 'Напрямок',
                    'edit'      => 'Редагувати',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => 'Назва',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'Код',
                    'direction'        => 'Напрямок',
                    'locale-logo'      => 'Логотип Локалі',
                    'name'             => 'Назва',
                    'save-btn'         => 'Зберегти Локаль',
                    'select-direction' => 'Вибрати напрямок',
                    'title'            => 'Створити Локаль',
                ],

                'edit' => [
                    'title' => 'Редагувати Локалі',
                ],

                'create-success'    => 'Локаль створена успішно.',
                'delete-failed'     => 'Помилка видалення Локалі',
                'delete-success'    => 'Локаль успішно видалена.',
                'delete-warning'    => 'Ви впевнені, що хочете виконати цю дію?',
                'last-delete-error' => 'Необхідно щонайменше одну Локаль.',
                'update-success'    => 'Локаль успішно оновлена.',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => 'Створити Валюту',
                'currency'   => 'Валюта',
                'title'      => 'Валюти',

                'datagrid' => [
                    'actions'        => 'Дії',
                    'code'           => 'Код',
                    'delete'         => 'Видалити',
                    'edit'           => 'Редагувати',
                    'id'             => 'ID',
                    'method-error'   => 'Помилка! Виявлено неправильний метод, будь ласка, перевірте налаштування масової дії',
                    'name'           => 'Назва',
                    'no-resource'    => 'Даних для виконання дії недостатньо',
                    'partial-action' => 'Деякі дії не були виконані через обмеження системи для :resource',
                    'update-success' => 'Вибрані :resource успішно оновлені',
                ],

                'create' => [
                    'code'                   => 'Код',
                    'create-btn'             => 'Створити Валюту',
                    'currency-position'      => 'Позиція Валюти',
                    'decimal'                => 'Десятковий роздільник',
                    'decimal-separator'      => 'Десятковий роздільник',
                    'decimal-separator-note' => 'Поле :attribute може приймати лише оператори кома (,) та крапка (.)',
                    'delete-warning'         => 'Ви впевнені, що хочете виконати цю дію?',
                    'general'                => 'Загальне',
                    'group-separator'        => 'Роздільник груп',
                    'group-separator-note'   => 'Поле :attribute може містити лише символи кома (,), крапка (.), апостроф (\') і пробіл ( ).',
                    'name'                   => 'Назва',
                    'save-btn'               => 'Зберегти Валюту',
                    'symbol'                 => 'Символ',
                    'title'                  => 'Створити Нову Валюту',
                ],

                'edit' => [
                    'title' => 'Редагувати Валюту',
                ],

                'create-success'    => 'Валюта створена успішно.',
                'delete-failed'     => 'Валюта Видалена Невдало',
                'delete-success'    => 'Валюта успішно видалена.',
                'last-delete-error' => 'Необхідно щонайменше одну Валюту.',
                'update-success'    => 'Валюта успішно оновлена.',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'Дія',
                    'allowed-errors'      => 'Дозволені помилки',
                    'back-btn'            => 'Назад',
                    'create-update'       => 'Створити/Оновити',
                    'delete'              => 'Видалити',
                    'download-sample'     => 'Завантажити приклад',
                    'field-separator'     => 'Роздільник полів',
                    'file-info-example'   => 'Наприклад, у випадку з зображеннями продуктів, файли слід розміщувати в папку /project-root/storage/app/import/product-images.',
                    'file-info'           => 'Вкажіть відносний шлях до /project-root/storage/app/import, наприклад product-images, import-images.',
                    'file'                => 'Файл',
                    'general'             => 'Загальні',
                    'images-directory'    => 'Шлях до папки з зображеннями',
                    'process-in-queue'    => 'Обробка в черзі',
                    'results'             => 'Результати',
                    'save-btn'            => 'Зберегти імпорт',
                    'settings'            => 'Налаштування',
                    'skip-errors'         => 'Пропустити помилки',
                    'stop-on-errors'      => 'Зупинити при помилках',
                    'title'               => 'Створити імпорт',
                    'type'                => 'Тип',
                    'validation-strategy' => 'Стратегія перевірки',
                ],

                'edit' => [
                    'action'              => 'Дія',
                    'allowed-errors'      => 'Дозволені помилки',
                    'back-btn'            => 'Назад',
                    'create-update'       => 'Створити/Оновити',
                    'current-file'        => 'Поточний завантажений файл',
                    'delete'              => 'Видалити',
                    'download-sample'     => 'Завантажити приклад',
                    'field-separator'     => 'Роздільник полів',
                    'file-info-example'   => 'Наприклад, у випадку з зображеннями продуктів, файли слід розміщувати в папку /project-root/storage/import/app/product-images.',
                    'file-info'           => 'Вкажіть відносний шлях до /project-root/storage/app/import, наприклад product-images, import-images.',
                    'file'                => 'Файл',
                    'general'             => 'Загальні',
                    'images-directory'    => 'Шлях до папки з зображеннями',
                    'process-in-queue'    => 'Обробка в черзі',
                    'results'             => 'Результати',
                    'save-btn'            => 'Зберегти імпорт',
                    'settings'            => 'Налаштування',
                    'skip-errors'         => 'Пропустити помилки',
                    'stop-on-errors'      => 'Зупинити при помилках',
                    'title'               => 'Редагувати імпорт',
                    'type'                => 'Тип',
                    'validation-strategy' => 'Стратегія перевірки',
                ],

                'index' => [
                    'button-title' => 'Створити імпорт',
                    'title'        => 'Імпорти',

                    'datagrid' => [
                        'actions'       => 'Дії',
                        'completed-at'  => 'Завершено',
                        'created'       => 'Створено',
                        'delete'        => 'Видалити',
                        'deleted'       => 'Видалено',
                        'edit'          => 'Редагувати',
                        'error-file'    => 'Файл помилок',
                        'id'            => 'ID',
                        'started-at'    => 'Розпочато',
                        'state'         => 'Стан',
                        'summary'       => 'Огляд',
                        'updated'       => 'Оновлено',
                        'uploaded-file' => 'Завантажено файл',
                    ],
                ],

                'import' => [
                    'back-btn'                => 'Назад',
                    'completed-batches'       => 'Всього обробоановано партій:',
                    'download-error-report'   => 'Завантажити повний звіт',
                    'edit-btn'                => 'Редагувати',
                    'imported-info'           => 'Вітаємо! Ваш імпорт успішно виконано.',
                    'importing-info'          => 'Імпорт у процесі',
                    'indexing-info'           => 'Індексація ресурсів (ціна, інвентаризація та Elasticsearch) у процесі',
                    'linking-info'            => 'Зв\'язування ресурсів у процесі',
                    'progress'                => 'Прогрес:',
                    'title'                   => 'Імпорт',
                    'total-batches'           => 'Всього партій:',
                    'total-created'           => 'Всього створено записів:',
                    'total-deleted'           => 'Всього видалено записів:',
                    'total-errors'            => 'Всього помилок:',
                    'total-invalid-rows'      => 'Всього недійсних рядків:',
                    'total-rows-processed'    => 'Всього опрацьовано рядків:',
                    'total-updated'           => 'Всього оновлено записів:',
                    'validate-info'           => 'Натисніть „Перевірити дані“, щоб перевірити свій імпорт.',
                    'validate'                => 'Перевірити',
                    'validating-info'         => 'Дані почали читання та перевірку',
                    'validation-failed-info'  => 'Ваш імпорт недійсний. Будь ласка, виправте наступні помилки та спробуйте ще раз.',
                    'validation-success-info' => 'Ваш імпорт дійсний. Натисніть „Імпорт“, щоб розпочати процес імпорту.',
                ],

                'create-success'    => 'Імпорт успішно створено.',
                'delete-failed'     => 'Не вдалося видалити імпорт.',
                'delete-success'    => 'Імпорт успішно видалено.',
                'not-valid'         => 'Імпорт недійсний',
                'nothing-to-import' => 'Немає ресурсів для імпорту.',
                'setup-queue-error' => 'Будь ласка, змініть ваш драйвер черги на „database“ або „redis“, щоб розпочати процес імпорту.',
                'update-success'    => 'Імпорт успішно оновлено.',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => 'Створити Курс Валют',
                'exchange-rate' => 'Курс Валют',
                'title'         => 'Курси Валют',
                'update-rates'  => 'Оновити Курс Валют',

                'create' => [
                    'delete-warning'         => 'Ви впевнені, що хочете виконати цю дію?',
                    'rate'                   => 'Курс',
                    'save-btn'               => 'Зберегти Курс Валют',
                    'select-target-currency' => 'Виберіть цільову валюту',
                    'source-currency'        => 'Вихідна Валюта',
                    'target-currency'        => 'Цільова Валюта',
                    'title'                  => 'Створити Курс Валют',
                ],

                'edit' => [
                    'title' => 'Редагувати Курс Валют',
                ],

                'datagrid' => [
                    'actions'       => 'Дії',
                    'currency-name' => 'Назва Валюти',
                    'delete'        => 'Видалити',
                    'edit'          => 'Редагувати',
                    'exchange-rate' => 'Курс Валют',
                    'id'            => 'ID',
                ],

                'create-success'  => 'Курс Валют Створено Успішно',
                'delete-error'    => 'Помилка видалення Курсу Валют',
                'delete-success'  => 'Курс Валют Видалено Успішно',
                'update-success'  => 'Курс Валют Оновлено Успішно',
            ],
        ],

        'inventory-sources' => [
            'index'  => [
                'create-btn' => 'Створити джерело інвентаризації',
                'title'      => 'Джерела інвентаризації',

                'datagrid' => [
                    'active'   => 'Активне',
                    'code'     => 'Код',
                    'delete'   => 'Видалити',
                    'edit'     => 'Редагувати',
                    'id'       => 'ID',
                    'inactive' => 'Неактивне',
                    'name'     => 'Назва',
                    'priority' => 'Пріоритет',
                    'status'   => 'Статус',
                ],
            ],

            'create' => [
                'add-title'      => 'Додати джерело інвентаризації',
                'address'        => 'Адреса джерела',
                'back-btn'       => 'Назад',
                'city'           => 'Місто',
                'code'           => 'Код',
                'contact-email'  => 'Електронна пошта',
                'contact-fax'    => 'Факс',
                'contact-info'   => 'Контактна інформація',
                'contact-name'   => 'Ім я',
                'contact-number' => 'Контактний номер',
                'country'        => 'Країна',
                'description'    => 'Опис',
                'general'        => 'Загальне',
                'latitude'       => 'Широта',
                'longitude'      => 'Довгота',
                'name'           => 'Назва',
                'postcode'       => 'Поштовий індекс',
                'priority'       => 'Пріоритет',
                'save-btn'       => 'Зберегти Джерело інвентаризації',
                'select-country' => 'Виберіть країну',
                'select-state'   => 'Виберіть область',
                'settings'       => 'Налаштування',
                'state'          => 'Область',
                'status'         => 'Статус',
                'street'         => 'Вулиця',
                'title'          => 'Джерела інвентаризації',
            ],

            'edit' => [
                'back-btn'       => 'Назад',
                'city'           => 'Місто',
                'code'           => 'Код',
                'contact-email'  => 'Електронна пошта',
                'contact-fax'    => 'Факс',
                'contact-info'   => 'Контактна інформація',
                'contact-name'   => 'Ім я',
                'contact-number' => 'Контактний номер',
                'country'        => 'Країна',
                'description'    => 'Опис',
                'general'        => 'Загальне',
                'latitude'       => 'Широта',
                'longitude'      => 'Довгота',
                'name'           => 'Назва',
                'postcode'       => 'Поштовий індекс',
                'priority'       => 'Пріоритет',
                'save-btn'       => 'Зберегти Джерело інвентаризації',
                'select-country' => 'Виберіть країну',
                'select-state'   => 'Виберіть область',
                'settings'       => 'Налаштування',
                'source-address' => 'Адреса джерела',
                'state'          => 'Область',
                'status'         => 'Статус',
                'street'         => 'Вулиця',
                'title'          => 'Редагувати Джерела інвентаризації',
            ],

            'create-success'    => 'Джерело інвентаризації створено успішно',
            'delete-failed'     => 'Не вдалося видалити джерела інвентаризації',
            'delete-success'    => 'Джерела інвентаризації видалено успішно',
            'last-delete-error' => 'Останнє джерело інвентаризації не може бути видалено',
            'update-success'    => 'Джерела інвентаризації успішно оновлено',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => 'Ви впевнені, що хочете видалити?',
                    'tax-category'   => 'Податкова категорія',
                    'title'          => 'Податкові категорії',

                    'datagrid' => [
                        'actions' => 'Дії',
                        'code'    => 'Код',
                        'delete'  => 'Видалити',
                        'edit'    => 'Редагувати',
                        'id'      => 'ID',
                        'name'    => 'Назва',
                    ],

                    'create' => [
                        'add-tax-rates' => 'Додати податкові ставки',
                        'code'          => 'Код',
                        'description'   => 'Опис',
                        'empty-text'    => 'Податкові ставки недоступні, будь ласка, створіть нові податкові ставки.',
                        'general'       => 'Податкова категорія',
                        'name'          => 'Назва',
                        'save-btn'      => 'Зберегти податкову категорію',
                        'select'        => 'Вибрати',
                        'tax-rates'     => 'Податкові ставки',
                        'title'         => 'Створити податкову категорію',
                    ],

                    'edit' => [
                        'title' => 'Редагувати податкові категорії',
                    ],

                    'can-not-delete' => 'Категорії, призначені податковим ставкам, не можуть бути видалені.',
                    'create-success' => 'Нова податкова категорія створена',
                    'delete-failed'  => 'Помилка видалення податкової категорії',
                    'delete-success' => 'Податкова категорія успішно видалена',
                    'update-success' => 'Податкова категорія успішно оновлена',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => 'Створити податкову ставку',
                    'tax-rate'     => 'Податкова ставка',
                    'title'        => 'Податкові ставки',

                    'datagrid' => [
                        'country'    => 'Країна',
                        'delete'     => 'Видалити',
                        'edit'       => 'Редагувати',
                        'id'         => 'ID',
                        'identifier' => 'Ідентифікатор',
                        'state'      => 'Область',
                        'tax-rate'   => 'Податкова ставка',
                        'zip-code'   => 'Поштовий код',
                        'zip-from'   => 'Поштовий код від',
                        'zip-to'     => 'Поштовий код до',
                    ],
                ],

                'create' => [
                    'back-btn'       => 'Назад',
                    'country'        => 'Країна',
                    'general'        => 'Загальне',
                    'identifier'     => 'Ідентифікатор',
                    'is-zip'         => 'Увімкнути діапазон поштових індексів',
                    'save-btn'       => 'Зберегти податкову ставку',
                    'select-country' => 'Виберіть країну',
                    'select-state'   => 'Виберіть область',
                    'settings'       => 'Налаштування',
                    'state'          => 'Область',
                    'tax-rate'       => 'Ставка',
                    'title'          => 'Створити податкову ставку',
                    'zip-code'       => 'Поштовий індекс',
                    'zip-from'       => 'Поштовий індекс від',
                    'zip-to'         => 'Поштовий індекс до',
                ],

                'edit' => [
                    'back-btn'       => 'Назад',
                    'country'        => 'Країна',
                    'identifier'     => 'Ідентифікатор',
                    'save-btn'       => 'Зберегти податкову ставку',
                    'select-country' => 'Виберіть країну',
                    'select-state'   => 'Виберіть область',
                    'settings'       => 'Налаштування',
                    'state'          => 'Область',
                    'tax-rate'       => 'Ставка',
                    'title'          => 'Редагувати податкову ставку',
                    'zip-code'       => 'Поштовий індекс',
                    'zip-from'       => 'Поштовий індекс від',
                    'zip-to'         => 'Поштовий індекс до',
                ],

                'create-success' => 'Податкову ставку успішно створено.',
                'delete-failed'  => 'Помилка видалення податкової ставки',
                'delete-success' => 'Податкову ставку успішно видалено',
                'update-success' => 'Податкову ставку успішно оновлено',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'Створити канал',
                'delete-failed'     => 'Канал Видалення не вдалося',
                'delete-success'    => 'Канал успішно видалено.',
                'last-delete-error' => 'Не вдалося видалити останній канал.',
                'title'             => 'Канали',

                'datagrid' => [
                    'code'      => 'Код',
                    'delete'    => 'Видалити',
                    'edit'      => 'Редагувати',
                    'host-name' => 'Ім"я хоста"',
                    'id'        => 'ID',
                    'name'      => 'Назва',
                ],
            ],

            'create' => [
                'allowed-ips'             => 'Дозволені IP-адреси',
                'cancel'                  => 'Назад',
                'code'                    => 'Код',
                'create-success'          => 'Канал створено успішно.',
                'currencies'              => 'Валюти',
                'currencies-and-locales'  => 'Валюти та локалі',
                'default-currency'        => 'Валюта за замовчуванням',
                'default-locale'          => 'Мова за замовчуванням',
                'description'             => 'Опис',
                'design'                  => 'Дизайн',
                'favicon'                 => 'Фавікон',
                'favicon-size'            => 'Роздільна здатність зображення має бути приблизно 16px X 16px',
                'general'                 => 'Загальне',
                'hostname'                => 'Ім "я хоста"',
                'hostname-placeholder'    => 'https://www.example.com (Не додавайте слеш в кінці.)',
                'inventory-sources'       => 'Джерела інвентаризації',
                'last-delete-error'       => 'Принаймні один канал обов "язковий".',
                'locales'                 => 'Локалі',
                'logo'                    => 'Логотип',
                'logo-size'               => 'Роздільна здатність зображення має бути приблизно 192px X 50px',
                'maintenance-mode-text'   => 'Повідомлення',
                'name'                    => 'Назва',
                'root-category'           => 'Коренева категорія',
                'save-btn'                => 'Зберегти канал',
                'select-default-currency' => 'Виберіть типову валюту',
                'select-default-locale'   => 'Виберіть типову локаль',
                'select-root-category'    => 'Виберіть кореневу категорію',
                'select-theme'            => 'Виберіть тему',
                'seo'                     => 'SEO головної сторінки',
                'seo-description'         => 'Мета-опис',
                'seo-keywords'            => 'Мета-ключові слова',
                'seo-title'               => 'Мета-заголовок',
                'settings'                => 'Налаштування',
                'status'                  => 'Статус',
                'theme'                   => 'Тема',
                'title'                   => 'Створити канал',
            ],

            'edit' => [
                'allowed-ips'            => 'Дозволені IP-адреси',
                'back-btn'               => 'Назад',
                'code'                   => 'Код',
                'currencies'             => 'Валюти',
                'currencies-and-locales' => 'Валюти та локалі',
                'default-currency'       => 'Валюта за замовчуванням',
                'default-locale'         => 'Мова за замовчуванням',
                'description'            => 'Опис',
                'design'                 => 'Дизайн',
                'favicon'                => 'Фавікон',
                'favicon-size'           => 'Роздільна здатність зображення має бути приблизно 16px X 16px',
                'general'                => 'Загальне',
                'hostname'               => 'Ім"я хоста".',
                'hostname-placeholder'   => 'https://www.example.com (Не додавайте слеш в кінці.)',
                'inventory-sources'      => 'Джерела інвентаризації',
                'last-delete-error'      => 'Принаймні один канал обов "язковий".',
                'locales'                => 'Локалі',
                'logo'                   => 'Логотип',
                'logo-size'              => 'Роздільна здатність зображення має бути приблизно 192px X 50px',
                'maintenance-mode'       => 'Режим обслуговування',
                'maintenance-mode-text'  => 'Повідомлення',
                'name'                   => 'Назва',
                'root-category'          => 'Коренева категорія',
                'save-btn'               => 'Зберегти канал',
                'seo'                    => 'SEO головної сторінки',
                'seo-description'        => 'Мета-опис',
                'seo-keywords'           => 'Мета-ключові слова',
                'seo-title'              => 'Мета-заголовок',
                'status'                 => 'Статус',
                'theme'                  => 'Тема',
                'title'                  => 'Редагувати канал',
                'update-success'         => 'Канал оновлено успішно.',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => 'Адміністратор',
                'title' => 'Користувачі',
                'user'  => 'Користувач',

                'create' => [
                    'confirm-password'  => 'Підтвердіть пароль',
                    'email'             => 'Електронна пошта',
                    'name'              => 'Ім я',
                    'password'          => 'Пароль',
                    'role'              => 'Роль',
                    'save-btn'          => 'Зберегти користувача',
                    'status'            => 'Статус',
                    'title'             => 'Створити користувача',
                    'upload-image-info' => 'Завантажте зображення профілю (110px X 110px) у форматі PNG або JPG',
                ],

                'datagrid' => [
                    'actions'  => 'Дії',
                    'active'   => 'Активний',
                    'delete'   => 'Видалити',
                    'edit'     => 'Редагувати',
                    'email'    => 'Електронна пошта',
                    'id'       => 'ID',
                    'inactive' => 'Неактивний',
                    'name'     => 'Ім я',
                    'role'     => 'Роль',
                    'status'   => 'Статус',
                ],

                'edit' => [
                    'title' => 'Редагувати користувача',
                ],
            ],

            'edit' => [
                'back-btn'         => 'Назад',
                'confirm-password' => 'Підтвердіть пароль',
                'email'            => 'Електронна пошта',
                'general'          => 'Загальне',
                'name'             => 'Ім я',
                'password'         => 'Пароль',
                'role'             => 'Роль',
                'save-btn'         => 'Зберегти користувача',
                'status'           => 'Статус',
                'title'            => 'Редагувати користувача',
            ],

            'activate-warning'   => 'Ваш обліковий запис ще не активовано, будь ласка, зв\'яжіться з адміністратором.',
            'cannot-change'      => 'Користувач не може бути змінений.',
            'create-success'     => 'Користувача успішно створено.',
            'delete-failed'      => 'Не вдалося видалити користувача.',
            'delete-self-error'  => 'Ви не можете видалити свій власний обліковий запис.',
            'delete-success'     => 'Користувача успішно видалено.',
            'delete-warning'     => 'Ви впевнені, що хочете виконати цю дію?',
            'incorrect-password' => 'Невірний пароль',
            'last-delete-error'  => 'Не вдалося видалити останнього користувача.',
            'login-error'        => 'Перевірте свої облікові дані і спробуйте ще раз.',
            'update-success'     => 'Користувача успішно оновлено.',
        ],

        'roles' => [
            'index' => [
                'create-btn' => 'Створити роль',
                'title'      => 'Ролі',

                'datagrid' => [
                    'custom'          => 'Користувацькі',
                    'all'             => 'Всі',
                    'permission-type' => 'Тип дозволу',
                    'name'            => 'Назва',
                    'id'              => 'ID',
                    'edit'            => 'Редагувати',
                    'delete'          => 'Видалити',
                ],
            ],

            'create' => [
                'access-control' => 'Контроль доступу',
                'all'            => 'Всі',
                'back-btn'       => 'Назад',
                'custom'         => 'Користувацькі',
                'description'    => 'Опис',
                'general'        => 'Загальне',
                'name'           => 'Назва',
                'permissions'    => 'Дозволи',
                'save-btn'       => 'Зберегти роль',
                'title'          => 'Створити роль',
            ],

            'edit' => [
                'access-control' => 'Контроль доступу',
                'all'            => 'Всі',
                'back-btn'       => 'Назад',
                'custom'         => 'Користувацькі',
                'description'    => 'Опис',
                'general'        => 'Загальне',
                'name'           => 'Назва',
                'permissions'    => 'Дозволи',
                'save-btn'       => 'Зберегти роль',
                'title'          => 'Редагувати роль',
            ],

            'being-used'        => 'Роль вже використовується в адміністраторському користувачеві',
            'create-success'    => 'Роль створена успішно',
            'delete-failed'     => 'Видалення ролі не вдалося',
            'delete-success'    => 'Роль видалена успішно',
            'last-delete-error' => 'Останню роль неможливо видалити',
            'update-success'    => 'Роль оновлена успішно',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'Створити Тему',
                'title'      => 'Теми',

                'datagrid' => [
                    'active'        => 'Активна',
                    'channel_name'  => 'Назва Каналу',
                    'change-status' => 'Змінити статус',
                    'delete'        => 'Видалити',
                    'id'            => 'Ідентифікатор',
                    'inactive'      => 'Неактивна',
                    'name'          => 'Назва',
                    'sort-order'    => 'Порядок Сортування',
                    'status'        => 'Статус',
                    'theme'         => 'Тема',
                    'type'          => 'Тип',
                    'view'          => 'Перегляд',
                ],
            ],

            'create' => [
                'name'       => 'Назва',
                'save-btn'   => 'Зберегти тему',
                'sort-order' => 'Порядок Сортування',
                'themes'     => 'Теми',
                'title'      => 'Створити Тему',

                'type' => [
                    'category-carousel' => 'Категорійний Карусель',
                    'footer-links'      => 'Посилання У Підвалі',
                    'image-carousel'    => 'Карусель зображень',
                    'product-carousel'  => 'Карусель Товарів',
                    'services-content'  => 'Контент послуг',
                    'static-content'    => 'Статичний Контент',
                    'title'             => 'Тип',
                ],
            ],

            'edit' => [
                'active'                        => 'Активна',
                'add-filter-btn'                => 'Додати Фільтр',
                'add-footer-link-btn'           => 'Додати Посилання У Підвалі',
                'add-image-btn'                 => 'Додати Зображення',
                'add-link'                      => 'Додати Посилання',
                'asc'                           => 'зростання',
                'back'                          => 'Назад',
                'category-carousel'             => 'Категорійна Карусель',
                'category-carousel-description' => 'Показ категорій привабливим чином за допомогою відзивного каруселі категорій.',
                'channels'                      => 'Канали',
                'column'                        => 'Колонка',
                'create-filter'                 => 'Створити Фільтр',
                'css'                           => 'CSS',
                'delete'                        => 'Видалити',
                'desc'                          => 'спадання',
                'edit'                          => 'Редагувати',
                'featured'                      => 'Обране',
                'filter-title'                  => 'Заголовок',
                'filters'                       => 'Фільтри',
                'footer-link'                   => 'Посилання У Підвалі',
                'footer-link-description'       => 'Переходьте за допомогою посилань у підвалі для безперервного перегляду веб-сайту та отримання інформації.',
                'footer-link-form-title'        => 'Посилання У Підвалі',
                'footer-title'                  => 'Заголовок',
                'general'                       => 'Загальне',
                'html'                          => 'HTML',
                'image'                         => 'Зображення',
                'image-size'                    => 'Розмір зображення повинен бути (1920 пікселів x 700 пікселів)',
                'image-title'                   => 'Заголовок зображення',
                'image-upload-message'          => 'Дозволено лише зображення (.jpeg, .jpg, .png, .webp, ..).',
                'inactive'                      => 'Неактивна',
                'key'                           => 'Ключ: :key',
                'key-input'                     => 'Ключ',
                'limit'                         => 'Обмеження',
                'link'                          => 'Посилання',
                'name'                          => 'Назва',
                'new'                           => 'Новий',
                'no'                            => 'Ні',
                'parent-id'                     => 'Батьківський ID',
                'parent-id-hint'                => 'Ви можете ввести кілька батьківських ID як розділені комами значення (наприклад: 12,15,34)',
                'category-id'                   => 'Ідентифікатор категорії',
                'preview'                       => 'Попередній Перегляд',
                'product-carousel'              => 'Карусель Товарів',
                'product-carousel-description'  => 'Елегантно представляйте товари за допомогою динамічної та відзивної каруселі товарів.',
                'save-btn'                      => 'Зберегти',
                'select'                        => 'Вибрати',
                'slider'                        => 'Слайдер',
                'slider-add-btn'                => 'Додати Слайдер',
                'slider-description'            => 'Налаштування теми, пов’язані зі слайдером.',
                'slider-image'                  => 'Зображення Слайдера',
                'slider-required'               => 'Поле Слайдера обов’язкове.',
                'sort'                          => 'Сортувати',
                'sort-order'                    => 'Порядок Сортування',
                'static-content'                => 'Статичний Контент',
                'static-content-description'    => 'Покращуйте взаємодію з аудиторією завдяки лаконічному та інформативному статичному контенту.',
                'status'                        => 'Статус',
                'themes'                        => 'Теми',
                'title'                         => 'Редагувати Тему',
                'update-slider'                 => 'Оновити Слайдер',
                'url'                           => 'URL',
                'value'                         => 'Значення: :value',
                'value-input'                   => 'Значення',

                'services-content' => [
                    'add-btn'            => 'Додати послуги',
                    'channels'           => 'Канали',
                    'delete'             => 'Видалити',
                    'description'        => 'Опис',
                    'general'            => 'Загальне',
                    'name'               => 'Назва',
                    'save-btn'           => 'Зберегти',
                    'service-icon'       => 'Значок послуги',
                    'service-icon-class' => 'Клас значка послуги',
                    'service-info'       => 'Налаштування теми, пов’язаної з послугами.',
                    'services'           => 'Послуги',
                    'sort-order'         => 'Порядок сортування',
                    'status'             => 'Статус',
                    'title'              => 'Заголовок',
                    'update-service'     => 'Оновити послуги',
                ],
                'yes'                           => 'Так',
            ],

            'create-success' => 'Тему успішно створено',
            'delete-success' => 'Тему успішно видалено',
            'update-success' => 'Тему успішно оновлено',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => 'Залишені кошики',
                'abandoned-products'            => 'Залишені товари',
                'abandoned-rate'                => 'Відсоток залишених',
                'abandoned-revenue'             => 'Дохід від залишених товарів',
                'added-to-cart'                 => 'Додано в кошик',
                'added-to-cart-info'            => 'Лише :progress відвідувачів додали товари в кошик',
                'all-channels'                  => 'Усі канали',
                'average-order-value-over-time' => 'Середній обсяг замовлення відносно часу',
                'average-sales'                 => 'Середній обсяг замовлення',
                'count'                         => 'Кількість',
                'end-date'                      => 'Дата закінчення',
                'id'                            => 'Ідентифікатор',
                'interval'                      => 'Інтервал',
                'name'                          => 'Назва',
                'orders'                        => 'Замовлення',
                'orders-over-time'              => 'Замовлення відносно часу',
                'payment-method'                => 'Спосіб оплати',
                'product-views'                 => 'Перегляди товарів',
                'product-views-info'            => 'Лише :progress відвідувачів переглядають товари',
                'purchase-funnel'               => 'Воронка покупок',
                'purchased'                     => 'Куплено',
                'purchased-info'                => 'Лише :progress відвідувачів здійснили покупку',
                'refunds'                       => 'Повернення коштів',
                'refunds-over-time'             => 'Повернення коштів відносно часу',
                'sales-over-time'               => 'Продажі відносно часу',
                'shipping-collected'            => 'Вартість доставки',
                'shipping-collected-over-time'  => 'Вартість доставки відносно часу',
                'start-date'                    => 'Дата початку',
                'tax-collected'                 => 'Податок',
                'tax-collected-over-time'       => 'Податок відносно часу',
                'title'                         => 'Продажі',
                'top-payment-methods'           => 'Топові способи оплати',
                'top-shipping-methods'          => 'Топові способи доставки',
                'top-tax-categories'            => 'Топові категорії податків',
                'total'                         => 'Усього',
                'total-orders'                  => 'Загальна кількість замовлень',
                'total-sales'                   => 'Загальний обсяг продажів',
                'total-visits'                  => 'Загальна кількість відвідувань',
                'total-visits-info'             => 'Загальна кількість відвідувачів в магазині',
                'view-details'                  => 'Переглянути деталі',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'Усі канали',
                'count'                       => 'Кількість',
                'customers'                   => 'Клієнти',
                'customers-over-time'         => 'Клієнти відносно часу',
                'customers-traffic'           => 'Трафік клієнтів',
                'customers-with-most-orders'  => 'Клієнти з найбільшою кількістю замовлень',
                'customers-with-most-reviews' => 'Клієнти з найбільшою кількістю відгуків',
                'customers-with-most-sales'   => 'Клієнти з найбільшою кількістю продажів',
                'email'                       => 'Електронна пошта',
                'end-date'                    => 'Дата закінчення',
                'id'                          => 'Ідентифікатор',
                'interval'                    => 'Інтервал',
                'name'                        => 'Назва',
                'orders'                      => 'Замовлення',
                'reviews'                     => 'Відгуки',
                'start-date'                  => 'Дата початку',
                'title'                       => 'Клієнти',
                'top-customer-groups'         => 'Топові групи клієнтів',
                'total'                       => 'Усього',
                'total-customers'             => 'Загальна кількість клієнтів',
                'total-visitors'              => 'Загальна кількість відвідувачів',
                'traffic-over-week'           => 'Трафік протягом тижня',
                'unique-visitors'             => 'Унікальні відвідувачі',
                'view-details'                => 'Переглянути деталі',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'Усі канали',
                'channel'                          => 'Канал',
                'end-date'                         => 'Дата закінчення',
                'id'                               => 'Ідентифікатор',
                'interval'                         => 'Інтервал',
                'last-search-terms'                => 'Останні запити для пошуку',
                'locale'                           => 'Мова',
                'name'                             => 'Назва',
                'orders'                           => 'Замовлення',
                'price'                            => 'Ціна',
                'products-added-over-time'         => 'Товари, додані з часом',
                'products-with-most-reviews'       => 'Товари з найбільшою кількістю відгуків',
                'products-with-most-visits'        => 'Товари з найбільшою кількістю відвідувань',
                'quantities'                       => 'Кількість',
                'quantities-sold-over-time'        => 'Кількість проданих товарів відносно часу',
                'results'                          => 'Результати',
                'revenue'                          => 'Дохід',
                'reviews'                          => 'Відгуки',
                'search-term'                      => 'Запит для пошуку',
                'start-date'                       => 'Дата початку',
                'title'                            => 'Товари',
                'top-search-terms'                 => 'Найбільш популярні запити для пошуку',
                'top-selling-products-by-quantity' => 'Топові товари за кількістю',
                'top-selling-products-by-revenue'  => 'Топові товари за доходом',
                'total'                            => 'Усього',
                'total-products-added-to-wishlist' => 'Товари, додані в список бажань',
                'total-sold-quantities'            => 'Загальна кількість проданих товарів',
                'uses'                             => 'Використання',
                'view-details'                     => 'Переглянути деталі',
                'visits'                           => 'Відвідувань',
            ],
        ],

        'view' => [
            'all-channels'  => 'Усі канали',
            'back-btn'      => 'Назад',
            'day'           => 'День',
            'end-date'      => 'Дата закінчення',
            'export-csv'    => 'Експорт у форматі CSV',
            'export-xls'    => 'Експорт у форматі XLS',
            'month'         => 'Місяць',
            'not-available' => 'Немає доступних записів.',
            'start-date'    => 'Дата початку',
            'year'          => 'Рік',
        ],

        'empty' => [
            'info'  => 'Для обраного інтервалу немає даних',
            'title' => 'Дані недоступні',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => 'Назад',
            'delete'                       => 'Видалити',
            'enable-at-least-one-payment'  => 'Увімкніть принаймні один спосіб оплати.',
            'enable-at-least-one-shipping' => 'Увімкніть принаймні один спосіб доставки.',
            'no-result-found'              => 'Результатів не знайдено',
            'save-btn'                     => 'Зберегти налаштування',
            'save-message'                 => 'Налаштування успішно збережено',
            'search'                       => 'Пошук',
            'select-country'               => 'Виберіть країну',
            'select-state'                 => 'Виберіть область',
            'title'                        => 'Налаштування',

            'general' => [
                'info'  => 'Встановіть параметри одиниць.',
                'title' => 'Загальне',

                'general' => [
                    'info'  => 'Налаштуйте параметри одиниць та перемикайте опції хлібних крихт і відвідувачів.',
                    'title' => 'Загальне',

                    'unit-options' => [
                        'info'        => 'Встановіть параметри одиниць.',
                        'title'       => 'Параметри одиниць',
                        'title-info'  => 'Налаштуйте вагу у фунтах (lbs) або кілограмах (kgs).',
                        'weight-unit' => 'Одиниця ваги',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'Хлібні крихти магазину',
                        'title'      => 'Хлібні крихти',
                        'title-info' => 'Увімкніть або вимкніть навігацію хлібних крихт у магазині.',
                    ],

                    'visitor-options' => [
                        'enable'     => 'Увімкнути опції відвідувачів',
                        'title'      => 'Опції відвідувачів',
                        'title-info' => 'Дозволяє контролювати сайт для відстеження та підрахунку кількості відвідувань, допомагаючи моніторити загальну активність і залученість відвідувачів.',
                    ],
                ],

                'content' => [
                    'info'  => 'Встановіть заголовок пропозиції в хедері та користувацькі скрипти.',
                    'title' => 'Контент',

                    'header-offer' => [
                        'title'             => 'Заголовок пропозиції в хедері',
                        'title-info'        => 'Налаштуйте заголовок пропозиції в хедері з заголовком пропозиції, заголовком перенаправлення та посиланням перенаправлення.',
                        'offer-title'       => 'Заголовок пропозиції',
                        'redirection-title' => 'Заголовок перенаправлення',
                        'redirection-link'  => 'Посилання перенаправлення',
                    ],

                    'speculation-rules' => [
                        'enable-speculation' => 'Увімкнути правила спекуляції',
                        'info'               => 'Налаштуйте параметри для увімкнення або вимкнення автоматичної логіки спекуляції.',
                        'title'              => 'Правила спекуляції',

                        'prerender' => [
                            'conservative'           => 'Консервативний',
                            'eager'                  => 'Активний',
                            'eagerness'              => 'Рівень активності prerender',
                            'eagerness-info'         => 'Керує тим, наскільки агресивно застосовуються правила спекуляції. Варіанти: активний (максимум), помірний (за замовчуванням), консервативний (низький).',
                            'enabled'                => 'Увімкнути правила спекуляції prerender',
                            'ignore-url-params'      => 'Ігнорувати параметри URL prerender',
                            'ignore-url-params-info' => 'Вкажіть параметри URL, які потрібно ігнорувати у правилах спекуляції. Використовуйте символ | для розділення кількох параметрів.',
                            'ignore-urls'            => 'Ігнорувати URL prerender',
                            'ignore-urls-info'       => 'Введіть URL-адреси, які потрібно виключити з логіки спекуляції. Розділяйте кілька URL символом |.',
                            'info'                   => 'Встановити статус правил спекуляції.',
                            'moderate'               => 'Помірний',
                        ],

                        'prefetch' => [
                            'conservative'           => 'Консервативний',
                            'eager'                  => 'Активний',
                            'eagerness'              => 'Рівень активності prefetch',
                            'eagerness-info'         => 'Керує тим, наскільки агресивно застосовуються правила спекуляції. Варіанти: активний (максимум), помірний (за замовчуванням), консервативний (низький).',
                            'enabled'                => 'Увімкнути правила спекуляції prefetch',
                            'ignore-url-params'      => 'Ігнорувати параметри URL prefetch',
                            'ignore-url-params-info' => 'Вкажіть параметри URL, які потрібно ігнорувати у правилах спекуляції. Використовуйте символ | для розділення кількох параметрів.',
                            'ignore-urls'            => 'Ігнорувати URL prefetch',
                            'ignore-urls-info'       => 'Введіть URL-адреси, які потрібно виключити з логіки спекуляції. Розділяйте кілька URL символом |.',
                            'info'                   => 'Встановити статус правил спекуляції.',
                            'moderate'               => 'Помірний',
                        ],
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'Користувацький CSS',
                        'custom-javascript' => 'Користувацький JavaScript',
                        'title'             => 'Користувацькі скрипти',
                        'title-info'        => 'Користувацькі скрипти - це персоналізовані фрагменти коду, створені для додавання конкретних функцій або можливостей до програмного забезпечення, покращуючи його унікальні можливості.',
                    ],
                ],

                'design' => [
                    'info'  => 'Встановіть логотип та іконку фавікону для панелі адміністратора.',
                    'title' => 'Дизайн',

                    'admin-logo' => [
                        'favicon'    => 'Фавікон',
                        'logo-image' => 'Зображення логотипу',
                        'title'      => 'Логотип адміністратора',
                        'title-info' => 'Налаштуйте зображення логотипу та фавікону для фронтенду вашого веб-сайту для кращого брендування та визнання.',
                    ],

                    'menu-category' => [
                        'default'         => 'Меню за замовчуванням',
                        'info'            => 'Це налаштування керує відображенням категорій у верхньому меню. Ви можете вибрати відображення лише батьківських категорій або всіх вкладених категорій.',
                        'preview-default' => 'Перегляд меню за замовчуванням',
                        'preview-sidebar' => 'Перегляд бокового меню',
                        'sidebar'         => 'Бокове меню',
                        'title'           => 'Перегляд категорії меню',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Встановіть параметри Magic AI та дозвольте деякі опції для автоматизації створення контенту.',
                    'title' => 'Magic AI',

                    'settings' => [
                        'api-key'        => 'Ключ API',
                        'enabled'        => 'Увімкнено',
                        'llm-api-domain' => 'Домен LLM API',
                        'organization'   => 'Організація',
                        'title'          => 'Загальні налаштування',
                        'title-info'     => 'Покращте свій досвід з функцією Magic AI, введіть свій ексклюзивний ключ API та вкажіть відповідну організацію для беззаперечної інтеграції. Отримайте контроль над своїми обліковими даними OpenAI та налаштуйте параметри відповідно до своїх потреб.',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'Запит опису категорії',
                        'cms-page-content-prompt'          => 'Запит вмісту сторінки CMS',
                        'enabled'                          => 'Увімкнено',
                        'product-description-prompt'       => 'Запит опису товару',
                        'product-short-description-prompt' => 'Запит короткого опису товару',
                        'title'                            => 'Генерація контенту',
                        'title-info'                       => 'Ця функція дозволить Magic AI для кожного редактора WYSIWYG, де ви хочете керувати контентом за допомогою штучного інтелекту.<br/><br/>Після увімкнення перейдіть до будь-якого редактора, щоб згенерувати контент.',
                    ],

                    'image-generation' => [
                        'enabled'    => 'Увімкнено',
                        'title'      => 'Генерація зображень',
                        'title-info' => 'Ця функція дозволить Magic AI для кожного завантаження зображень, де ви хочете генерувати зображення за допомогою DALL-E.<br/><br/>Після увімкнення перейдіть до будь-якого завантаження зображень, щоб згенерувати зображення.',
                    ],

                    'review-translation' => [
                        'deepseek-r1-8b'    => 'DeepSeek R1 (8b)',
                        'enabled'           => 'Увімкнено',
                        'gemini-2-0-flash'  => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'       => 'OpenAI gpt-4 Turbo',
                        'gpt-4o'            => 'OpenAI gpt-4o',
                        'gpt-4o-mini'       => 'OpenAI gpt-4o mini',
                        'llama-groq'        => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'       => 'Llama 3.1 (8B)',
                        'llama3-2-1b'       => 'Llama 3.2 (1B)',
                        'llama3-2-3b'       => 'Llama 3.2 (3B)',
                        'llama3-8b'         => 'Llama 3 (8B)',
                        'llava-7b'          => 'Llava (7b)',
                        'mistral-7b'        => 'Mistral (7b)',
                        'model'             => 'Модель',
                        'orca-mini'         => 'Orca Mini',
                        'phi3-5'            => 'Phi 3.5',
                        'qwen2-5-0-5b'      => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'      => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'       => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'        => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'        => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'    => 'Starling-lm (7b)',
                        'title'             => 'Переклад відгуків',
                        'title-info'        => 'Надайте клієнту або відвідувачу можливість перекласти відгук клієнта на англійську мову.<br/><br/>Після увімкнення перейдіть до відгуку, і ви знайдете кнопку "Перекласти на англійську", якщо відгук не англійською мовою.',
                        'vicuna-13b'        => 'Vicuna (13b)',
                        'vicuna-7b'         => 'Vicuna (7b)',
                    ],

                    'checkout-message' => [
                        'deepseek-r1-8b'    => 'DeepSeek R1 (8b)',
                        'enabled'           => 'Увімкнено',
                        'gemini-2-0-flash'  => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'       => 'OpenAI gpt 4 Turbo',
                        'gpt-4o'            => 'OpenAI gpt-4o',
                        'gpt-4o-mini'       => 'OpenAI gpt-4o mini',
                        'llama-groq'        => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'       => 'Llama 3.1 (8B)',
                        'llama3-2-1b'       => 'Llama 3.2 (1B)',
                        'llama3-2-3b'       => 'Llama 3.2 (3B)',
                        'llama3-8b'         => 'Llama 3 (8B)',
                        'llava-7b'          => 'Llava (7b)',
                        'mistral-7b'        => 'Mistral (7b)',
                        'model'             => 'Модель',
                        'orca-mini'         => 'Orca Mini',
                        'phi3-5'            => 'Phi 3.5',
                        'prompt'            => 'Запит',
                        'qwen2-5-0-5b'      => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'      => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'       => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'        => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'        => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'    => 'Starling-lm (7b)',
                        'title'             => 'Персоналізоване повідомлення на сторінці оформлення замовлення',
                        'title-info'        => 'Створіть персоналізоване повідомлення на сторінці оформлення замовлення для клієнтів на сторінці подяки, налаштовуючи вміст відповідно до індивідуальних уподобань і покращуючи загальний досвід після покупки.',
                        'vicuna'            => 'Vicuna',
                        'vicuna-13b'        => 'Vicuna (13b)',
                        'vicuna-7b'         => 'Vicuna (7b)',
                    ],
                ],

                'gdpr' => [
                    'title' => 'GDPR',
                    'info'  => 'Налаштування відповідності GDPR',

                    'settings' => [
                        'title'   => 'Налаштування відповідності GDPR',
                        'info'    => 'Керуйте налаштуваннями відповідності GDPR, включаючи політику конфіденційності. Увімкніть або вимкніть функції GDPR відповідно до вимог.',
                        'enabled' => 'Увімкнути GDPR',
                    ],

                    'agreement' => [
                        'title'          => 'Угода GDPR',
                        'info'           => 'Керуйте згодою клієнтів відповідно до регламенту GDPR. Увімкніть необхідну згоду на збір та обробку даних.',
                        'enable'         => 'Увімкнути згоду клієнтів',
                        'checkbox-label' => 'Мітка для згоди',
                        'content'        => 'Зміст згоди',
                    ],

                    'cookie' => [
                        'bottom-left'  => 'Нижній лівий',
                        'bottom-right' => 'Нижній правий',
                        'center'       => 'Центр',
                        'description'  => 'Опис',
                        'enable'       => 'Увімкнути повідомлення про файли cookie',
                        'identifier'   => 'ID статичного блоку',
                        'info'         => 'Налаштуйте параметри згоди на файли cookie, щоб інформувати користувачів про збір даних та політику конфіденційності.',
                        'position'     => 'Позиція блоку файлів cookie',
                        'title'        => 'Налаштування повідомлень про файли cookie',
                        'top-left'     => 'Верхній лівий',
                        'top-right'    => 'Верхній правий',
                    ],

                    'cookie-consent' => [
                        'title'                  => 'Керування налаштуваннями файлів cookie',
                        'info'                   => 'Виберіть бажані налаштування файлів cookie для керування використанням даних. Налаштуйте параметри згоди для різних типів файлів cookie.',
                        'strictly-necessary'     => 'Суворо необхідні',
                        'basic-interaction'      => 'Основна взаємодія та функціональність',
                        'experience-enhancement' => 'Покращення досвіду',
                        'measurement'            => 'Вимірювання',
                        'targeting-advertising'  => 'Цільова реклама',
                    ],
                ],

                'sitemap' => [
                    'info'  => 'Налаштуйте параметри карти сайту.',
                    'title' => 'Карта сайту',

                    'settings' => [
                        'enabled' => 'Увімкнено',
                        'info'    => 'Увімкніть або вимкніть карту сайту для вашого веб-сайту, щоб покращити пошукову оптимізацію та підвищити зручність користування.',
                        'title'   => 'Налаштування',
                    ],

                    'file-limits' => [
                        'info'             => 'Налаштуйте параметри обмеження файлів.',
                        'max-file-size'    => 'Максимальний розмір файлу',
                        'max-url-per-file' => 'Максимальна кількість URL на файл',
                        'title'            => 'Обмеження файлів',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'Каталог',
                'title' => 'Каталог',

                'products' => [
                    'info'  => 'Сторінка перегляду продукту, сторінка перегляду кошика, вітрина магазину, огляд і соціальний поділ атрибутів.',
                    'title' => 'Товари',

                    'settings' => [
                        'compare-options'     => 'Параметри порівняння',
                        'image-search-option' => 'Параметр пошуку за зображенням',
                        'title'               => 'Налаштування',
                        'title-info'          => 'Налаштування відносяться до налаштувань, які контролюють поведінку системи, додатка або пристрою, враховуючи вимоги та вподобання користувачів.',
                        'wishlist-options'    => 'Параметри списку бажань',
                    ],

                    'search' => [
                        'admin-mode'            => 'Режим пошуку адміністратора',
                        'admin-mode-info'       => 'Мега-пошук, таблиця даних та інші функції пошуку в панелі адміністратора будуть базуватися на вибраному пошуковому двигуні.',
                        'database'              => 'База даних',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => 'Максимальна довжина запиту',
                        'max-query-length-info' => 'Встановіть максимальну довжину запиту для пошукових запитів.',
                        'min-query-length'      => 'Мінімальна довжина запиту',
                        'min-query-length-info' => 'Встановіть мінімальну довжину запиту для пошукових запитів.',
                        'search-engine'         => 'Пошуковий двигун',
                        'storefront-mode'       => 'Режим пошуку фронтенду',
                        'storefront-mode-info'  => 'Функціональність пошуку на фронтенді буде базуватися на вибраному пошуковому двигуні, включаючи сторінку категорій, сторінку пошуку та інші функції пошуку.',
                        'title'                 => 'Пошук',
                        'title-info'            => 'Для налаштування пошукового двигуна для пошуку товарів ви можете вибрати між базою даних та Elasticsearch в залежності від ваших потреб. Якщо у вас велика кількість товарів, рекомендується використовувати Elasticsearch.',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'Дозволити гостьове оформлення',
                        'allow-guest-checkout-hint' => 'Підказка: Якщо ввімкнено, цю опцію можна налаштувати для кожного товару окремо.',
                        'title'                     => 'Гостьове оформлення',
                        'title-info'                => 'Гостьове оформлення дозволяє клієнтам купувати товари без створення облікового запису, спрощуючи процес покупки для зручності та швидших транзакцій.',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => 'Дозволена кількість пов\'язаних товарів',
                        'allow-no-of-up-sells-products' => 'Дозволена кількість товарів для продажу',
                        'title'                         => 'Налаштування сторінки перегляду товару',
                        'title-info'                    => 'Налаштування сторінки перегляду товару передбачає налаштування макету та елементів на сторінці відображення товару, покращуючи користувацький досвід та представлення інформації.',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'Дозволена кількість товарів для продажу',
                        'title'                            => 'Налаштування сторінки кошика',
                        'title-info'                       => 'Налаштування сторінки кошика включає розташування товарів, деталей та параметрів на сторінці кошика, покращуючи взаємодію користувача та процес покупки.',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => 'Дозволити клієнтам безпосередньо купувати товари',
                        'cheapest-first'         => 'Спочатку найбільш дешеві',
                        'comma-separated'        => 'Розділені комами',
                        'default-list-mode'      => 'Режим списку за замовчуванням',
                        'expensive-first'        => 'Спочатку найбільш дорогі',
                        'from-a-z'               => 'Від А до Я',
                        'from-z-a'               => 'Від Я до А',
                        'grid'                   => 'Сітка',
                        'latest-first'           => 'Спочатку найновіші',
                        'list'                   => 'Список',
                        'oldest-first'           => 'Спочатку найстаріші',
                        'products-per-page'      => 'Товарів на сторінці',
                        'sort-by'                => 'Сортувати за',
                        'title'                  => 'Фронтенд',
                        'title-info'             => 'Фронтенд - це інтерфейс, доступний для клієнтів онлайн-магазину, на якому відображаються товари, категорії та навігація для безперешкодного покупного досвіду.',
                    ],

                    'small-image' => [
                        'height'      => 'Висота',
                        'placeholder' => 'Заповнювач малого зображення',
                        'title'       => 'Мале зображення',
                        'title-info'  => 'Фронтенд - це інтерфейс, доступний для клієнтів онлайн-магазину, на якому відображаються товари, категорії та навігація для безперешкодного покупного досвіду.',
                        'width'       => 'Ширина',
                    ],

                    'medium-image' => [
                        'height'      => 'Висота',
                        'placeholder' => 'Заповнювач середнього зображення',
                        'title'       => 'Середнє зображення',
                        'title-info'  => 'Середнє зображення - це зображення помірного розміру, яке забезпечує баланс між деталями та екранним простором, часто використовується для візуальних елементів.',
                        'width'       => 'Ширина',
                    ],

                    'large-image' => [
                        'height'      => 'Висота',
                        'placeholder' => 'Заповнювач великого зображення',
                        'title'       => 'Велике зображення',
                        'title-info'  => 'Велике зображення представляє собою зображення високої роздільної здатності, яке надає покращену деталізацію та візуальний ефект, часто використовується для демонстрації товарів або графіки.',
                        'width'       => 'Ширина',
                    ],

                    'review' => [
                        'allow-customer-review'   => 'Дозволити відгуки клієнтів',
                        'allow-guest-review'      => 'Дозволити відгуки гостей',
                        'censoring-reviewer-name' => 'Цензурування імені рецензента',
                        'display-review-count'    => 'Відображення кількості відгуків для оцінок.',
                        'display-star-count'      => 'Показати кількість зірок у рейтингах.',
                        'summary'                 => 'Резюме',
                        'title'                   => 'Відгуки',
                        'title-info'              => 'Оцінка або оцінка чогось, часто з використанням думок та відгуків.',
                    ],

                    'attribute' => [
                        'file-upload-size'  => 'Дозволений розмір завантаження файлу (в Кб)',
                        'image-upload-size' => 'Дозволений розмір завантаження зображення (в Кб)',
                        'title'             => 'Атрибути',
                        'title-info'        => 'Характеристика або властивість, яка визначає об\'єкт і впливає на його поведінку, зовнішній вигляд або функціональність.',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Налаштуйте налаштування соціального поширення, щоб увімкнути поділ товарів в Instagram, Twitter, WhatsApp, Facebook, Pinterest, LinkedIn та по електронній пошті.',
                        'title'                       => 'Соціальне поширення',
                        'share-message'               => 'Повідомлення для поширення',
                        'share'                       => 'Поділитися',
                        'enable-social-share'         => 'Увімкнути соціальне поширення?',
                        'enable-share-whatsapp-info'  => 'Посилання на поділ у WhatsApp буде доступне лише для мобільних пристроїв.',
                        'enable-share-whatsapp'       => 'Увімкнути поділ у WhatsApp?',
                        'enable-share-twitter'        => 'Увімкнути поділ у Twitter?',
                        'enable-share-pinterest'      => 'Увімкнути поділ у Pinterest?',
                        'enable-share-linkedin'       => 'Увімкнути поділ у Linkedin?',
                        'enable-share-facebook'       => 'Увімкнути поділ у Facebook?',
                        'enable-share-email'          => 'Увімкнути поділ у Email?',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => 'Налаштування товарів та категорій.',
                    'title' => 'Rich Snippets',

                    'products' => [
                        'enable'          => 'Увімкнути',
                        'show-categories' => 'Показувати категорії',
                        'show-images'     => 'Показувати зображення',
                        'show-offers'     => 'Показувати пропозиції',
                        'show-ratings'    => 'Показувати рейтинги',
                        'show-reviews'    => 'Показувати відгуки',
                        'show-sku'        => 'Показувати артикул',
                        'show-weight'     => 'Показувати вагу',
                        'title'           => 'Товари',
                        'title-info'      => 'Налаштування параметрів продукту, включаючи SKU, вагу, категорії, зображення, відгуки, рейтинги, пропозиції тощо.',
                    ],

                    'categories' => [
                        'enable'                  => 'Увімкнути',
                        'show-search-input-field' => 'Показувати поле введення пошуку',
                        'title'                   => 'Категорії',
                        'title-info'              => '«Категорії» відносяться до груп або класифікацій, які допомагають організувати та групувати схожі товари або предмети для зручного перегляду та навігації.',
                    ],
                ],

                'inventory' => [
                    'title'      => 'Інвентаризація',
                    'title-info' => 'Налаштуйте параметри інвентаризації для дозволу передзамовлень та визначення порогу відсутності на складі.',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'Дозволити передзамовлення',
                        'max-qty-allowed-in-cart' => 'Максимальна кількість товарів у кошику',
                        'min-qty-allowed-in-cart' => 'Мінімальна кількість товарів у кошику',
                        'out-of-stock-threshold'  => 'Поріг відсутності на складі',
                        'title'                   => 'Параметри товарного запасу',
                        'info'                    => 'Налаштуйте параметри запасів продукції для можливості відкладених замовлень, встановіть мінімальні і максимальні кількості у кошику, і визначте пороги відсутності товару.',
                    ],
                ],
            ],

            'customer' => [
                'info'  => 'Клієнт',
                'title' => 'Клієнт',

                'address' => [
                    'info'  => 'Встановити країну, область, поштовий індекс та адресу.',
                    'title' => 'Адреса',

                    'requirements' => [
                        'city'       => 'Місто',
                        'country'    => 'Країна',
                        'state'      => 'Область',
                        'title'      => 'Вимоги',
                        'title-info' => 'Вимоги - це умови, функції або специфікації, необхідні для успішного виконання, досягнення або задоволення чогось.',
                        'zip'        => 'Поштовий індекс',
                    ],

                    'information' => [
                        'street-lines' => 'Рядки в адресі',
                        'title'        => 'Інформація',
                        'title-info'   => '"Рядки в адресі" вказують на окремі сегменти адреси, часто розділені комами, надаючи інформацію про місцезнаходження, таку як номер будинку, вулиця, місто та інше.',
                    ],
                ],

                'captcha' => [
                    'info'  => 'Встановити ключ сайту, секретний ключ та статус.',
                    'title' => 'Google Капча',

                    'credentials' => [
                        'secret-key' => 'Секретний ключ',
                        'site-key'   => 'Ключ сайту',
                        'status'     => 'Статус',
                        'title'      => 'Облікові дані',
                        'title-info' => '"Карта сайту: Карта розташування веб-сайту для пошукових систем. Секретний ключ: Безпечний код для шифрування даних, аутентифікації або захисту доступу до API."',
                    ],

                    'validations' => [
                        'captcha'  => 'Щось пішло не так! Будь ласка, спробуйте ще раз.',
                        'required' => 'Будь ласка, виберіть CAPTCHA',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'Встановіть список бажань, перенаправлення при вході, підписки на розсилку, опцію типової групи, підтвердження електронної пошти та соціальний вхід.',
                    'title'         => 'Налаштування',

                    'login-as-customer' => [
                        'allow-option' => 'Дозволити вхід як клієнт',
                        'title'        => 'Вхід як клієнт',
                        'title-info'   => 'Увімкнути функціональність "Вхід як клієнт".',
                    ],

                    'wishlist' => [
                        'allow-option' => 'Дозволити опцію "Список бажань"',
                        'title'        => 'Список бажань',
                        'title-info'   => 'Увімкнути або вимкнути опцію "Список бажань".',
                    ],

                    'login-options' => [
                        'account'          => 'Обліковий запис',
                        'home'             => 'Головна',
                        'redirect-to-page' => 'Перенаправити клієнта на вибрану сторінку',
                        'title'            => 'Опції входу',
                        'title-info'       => 'Налаштуйте опції входу, щоб визначити сторінку перенаправлення для клієнтів після входу.',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'Дозволити підписку на розсилку',
                        'news-letter-info' => 'Увімкнути опцію підписки на розсилку на сторінці реєстрації.',
                        'title'            => 'Опції створення нового облікового запису',
                        'title-info'       => 'Встановіть параметри для нових облікових записів, включаючи призначення типової групи клієнтів та увімкнення опції підписки на розсилку під час реєстрації.',

                        'default-group' => [
                            'general'    => 'Загальний',
                            'guest'      => 'Гість',
                            'title'      => 'Типова група',
                            'title-info' => 'Призначте певну групу клієнтів типовою для нових клієнтів.',
                            'wholesale'  => 'Оптові продажі',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'Дозволити підписку на розсилку',
                        'title'        => 'Підписка на розсилку',
                        'title-info'   => '"Інформація про розсилку" містить оновлення, пропозиції або регулярно надсилається контент через електронну пошту підписникам, що дозволяє їх інформувати та залучати.',
                    ],

                    'email' => [
                        'email-verification' => 'Дозволити підтвердження електронної пошти',
                        'title'              => 'Підтвердження електронної пошти',
                        'title-info'         => '"Підтвердження електронної пошти" підтверджує автентичність електронної адреси, часто шляхом надсилання посилання для підтвердження, покращуючи безпеку облікового запису та надійність комунікації.',
                    ],

                    'social-login' => [
                        'title' => 'Соціальний вхід',
                        'info'  => '"Соціальний вхід" дозволяє користувачам отримати доступ до веб-сайту, використовуючи їхні облікові записи в соціальних мережах, спрощуючи процеси реєстрації та входу.',

                        'google' => [
                            'enable-google' => 'Увімкнути Google',

                            'client-id' => [
                                'title'      => 'Ідентифікатор клієнта',
                                'title-info' => 'Унікальний ідентифікатор, наданий Google при створенні вашого OAuth-додатку.',
                            ],

                            'client-secret' => [
                                'title'      => 'Таємний ключ клієнта',
                                'title-info' => 'Таємний ключ, пов\'язаний з вашим OAuth-клієнтом Google. Тримайте його в безпеці.',
                            ],

                            'redirect' => [
                                'title'      => 'URL для перенаправлення',
                                'title-info' => 'URL-адреса, на яку користувачі будуть перенаправлені після аутентифікації через Google. Вона повинна збігатися з URL, налаштованим у вашій консолі Google.',
                            ],
                        ],

                        'facebook' => [
                            'enable-facebook' => 'Увімкнути Facebook',

                            'client-id' => [
                                'title'      => 'Ідентифікатор клієнта',
                                'title-info' => 'ID додатку, наданий Facebook при створенні додатку в консолі розробника Facebook.',
                            ],

                            'client-secret' => [
                                'title'      => 'Таємний ключ клієнта',
                                'title-info' => 'Таємний ключ, пов\'язаний з вашим додатком Facebook. Зберігайте його в безпеці та конфіденційності.',
                            ],

                            'redirect' => [
                                'title'      => 'URL для перенаправлення',
                                'title-info' => 'URL-адреса, на яку користувачі будуть перенаправлені після аутентифікації через Facebook. Вона повинна збігатися з URL, налаштованим у налаштуваннях вашого додатку на Facebook.',
                            ],
                        ],

                        'github' => [
                            'enable-github' => 'Увімкнути GitHub',

                            'client-id' => [
                                'title'      => 'Ідентифікатор клієнта',
                                'title-info' => 'Унікальний ідентифікатор, наданий GitHub при створенні вашого OAuth-додатку.',
                            ],

                            'client-secret' => [
                                'title'      => 'Таємний ключ клієнта',
                                'title-info' => 'Таємний ключ, пов\'язаний з вашим OAuth-клієнтом GitHub. Тримайте його в безпеці.',
                            ],

                            'redirect' => [
                                'title'      => 'URL для перенаправлення',
                                'title-info' => 'URL-адреса, на яку користувачі будуть перенаправлені після аутентифікації через GitHub. Вона повинна збігатися з URL, налаштованим у вашій консолі GitHub.',
                            ],
                        ],

                        'linkedin' => [
                            'enable-linkedin' => 'Увімкнути LinkedIn',

                            'client-id' => [
                                'title'      => 'Ідентифікатор клієнта',
                                'title-info' => 'Унікальний ідентифікатор, наданий LinkedIn при створенні вашого OAuth-додатку.',
                            ],

                            'client-secret' => [
                                'title'      => 'Таємний ключ клієнта',
                                'title-info' => 'Таємний ключ, пов\'язаний з вашим OAuth-клієнтом LinkedIn. Тримайте його в безпеці.',
                            ],

                            'redirect' => [
                                'title'      => 'URL для перенаправлення',
                                'title-info' => 'URL-адреса, на яку користувачі будуть перенаправлені після аутентифікації через LinkedIn. Вона повинна збігатися з URL, налаштованим у вашій консолі LinkedIn.',
                            ],
                        ],

                        'twitter' => [
                            'enable-twitter' => 'Увімкнути Twitter',

                            'client-id' => [
                                'title'      => 'Ідентифікатор клієнта',
                                'title-info' => 'Унікальний ідентифікатор, наданий Twitter при створенні вашого OAuth-додатку.',
                            ],

                            'client-secret' => [
                                'title'      => 'Таємний ключ клієнта',
                                'title-info' => 'Таємний ключ, пов\'язаний з вашим OAuth-клієнтом Twitter. Тримайте його в безпеці.',
                            ],

                            'redirect' => [
                                'title'      => 'URL для перенаправлення',
                                'title-info' => 'URL-адреса, на яку користувачі будуть перенаправлені після аутентифікації через Twitter. Вона повинна збігатися з URL, налаштованим у вашій консолі Twitter.',
                            ],
                        ],
                    ],
                ],
            ],

            'email' => [
                'info'  => 'Електронна пошта',
                'title' => 'Електронна пошта',

                'email-settings' => [
                    'admin-email'           => 'Електронна пошта адміністратора',
                    'admin-email-tip'       => 'Адреса електронної пошти адміністратора для отримання листів',
                    'admin-name'            => 'Ім\'я адміністратора',
                    'admin-name-tip'        => 'Це ім\'я буде відображатися в усіх листах адміністратора',
                    'admin-page-limit'      => 'Кількість елементів на сторінці за замовчуванням (адміністратор)',
                    'contact-email'         => 'Електронна пошта для зв\'язку',
                    'contact-email-tip'     => 'Адреса електронної пошти, яка буде відображатися внизу ваших листів',
                    'contact-name'          => 'Ім\'я для зв\'язку',
                    'contact-name-tip'      => 'Це ім\'я буде відображатися внизу ваших листів',
                    'email-sender-name'     => 'Ім\'я відправника електронної пошти',
                    'email-sender-name-tip' => 'Це ім\'я буде відображатися відправнику в скринці клієнтів',
                    'info'                  => 'Встановіть ім\'я відправника електронної пошти, адресу електронної пошти магазину, ім\'я адміністратора та адресу електронної пошти адміністратора.',
                    'shop-email-from'       => 'Адреса електронної пошти магазину',
                    'shop-email-from-tip'   => 'Адреса електронної пошти цього каналу для відправки листів вашим клієнтам',
                    'title'                 => 'Налаштування електронної пошти',
                ],

                'notifications' => [
                    'cancel-order'                                     => 'Надіслати сповіщення клієнту після скасування замовлення',
                    'cancel-order-mail-to-admin'                       => 'Надіслати повідомлення адміністратору після скасування замовлення',
                    'customer'                                         => 'Надіслати облікові дані клієнта після реєстрації',
                    'customer-registration-confirmation-mail-to-admin' => 'Надіслати підтвердження адміністратору після реєстрації клієнта',
                    'info'                                             => 'Налаштуйте отримання електронних листів для підтвердження облікового запису, підтвердження замовлень, оновлень рахунків, повернень, відправлень та скасувань замовлень.',
                    'new-inventory-source'                             => 'Надіслати повідомлення джерелу інвентаризації після створення відправлення',
                    'new-invoice'                                      => 'Надіслати повідомлення клієнту після створення нового рахунку',
                    'new-invoice-mail-to-admin'                        => 'Надіслати повідомлення адміністратору після створення нового рахунку',
                    'new-order'                                        => 'Надіслати підтвердження клієнту після розміщення нового замовлення',
                    'new-order-mail-to-admin'                          => 'Надіслати підтвердження адміністратору після розміщення нового замовлення',
                    'new-refund'                                       => 'Надіслати повідомлення клієнту після створення повернення',
                    'new-refund-mail-to-admin'                         => 'Надіслати повідомлення адміністратору після створення нового повернення',
                    'new-shipment'                                     => 'Надіслати повідомлення клієнту після створення відправлення',
                    'new-shipment-mail-to-admin'                       => 'Надіслати повідомлення адміністратору після створення нового відправлення',
                    'registration'                                     => 'Надіслати підтвердження після реєстрації клієнта',
                    'title'                                            => 'Повідомлення',
                    'verification'                                     => 'Надіслати підтвердження після реєстрації клієнта',
                ],
            ],

            'sales' => [
                'info'  => 'Продажі',
                'title' => 'Продажі',

                'shipping-setting' => [
                    'info'  => 'Налаштуйте налаштування доставки, включаючи країну, штат, місто, вулицю, поштовий індекс, назву магазину, номер ПДВ, контактний номер та банківські реквізити.',
                    'title' => 'Налаштування доставки',

                    'origin' => [
                        'bank-details'   => 'Банківські реквізити',
                        'city'           => 'Місто',
                        'contact-number' => 'Контактний номер',
                        'country'        => 'Країна',
                        'state'          => 'Штат',
                        'store-name'     => 'Назва магазину',
                        'street-address' => 'Вулиця та номер будинку',
                        'title'          => 'Походження',
                        'title-info'     => 'Місце походження доставки відноситься до місця, де товари або продукти походять перед транспортуванням до місця призначення.',
                        'vat-number'     => 'Номер ПДВ',
                        'zip'            => 'Поштовий індекс',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => 'Налаштуйте методи доставки, включаючи безкоштовну доставку, фіксовану ставку та додаткові опції за потреби.',
                    'title' => 'Методи доставки',

                    'free-shipping' => [
                        'description' => 'Опис',
                        'page-title'  => 'Безкоштовна доставка',
                        'status'      => 'Статус',
                        'title'       => 'Назва',
                        'title-info'  => '«Безкоштовна доставка» - це метод доставки, при якому вартість доставки відміняється, а продавець покриває витрати на доставку товарів покупцю.',
                    ],

                    'flat-rate-shipping' => [
                        'description' => 'Опис',
                        'page-title'  => 'Доставка з фіксованою ставкою',
                        'rate'        => 'Ставка',
                        'status'      => 'Статус',
                        'title'       => 'Назва',
                        'title-info'  => 'Доставка з фіксованою ставкою - це метод доставки, при якому стягується фіксована плата за доставку, незалежно від ваги, розміру або відстані пакета. Це спрощує вартість доставки і може бути вигідним як для покупців, так і для продавців.',
                        'type'        => [
                            'per-order' => 'За замовленням',
                            'per-unit'  => 'За одиницю',
                            'title'     => 'Тип',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => 'Прийняті валюти',
                    'accepted-currencies-info'       => 'Додайте коди валют через кому, наприклад, USD, INR, ...',
                    'business-account'               => 'Бізнес-акаунт',
                    'cash-on-delivery'               => 'Оплата при отриманні',
                    'cash-on-delivery-info'          => 'Спосіб оплати, при якому клієнти оплачують готівкою при отриманні товарів або послуг на своєму порозі.',
                    'client-id'                      => 'Ідентифікатор клієнта',
                    'client-id-info'                 => 'Використовуйте "sb" для тестування.',
                    'client-secret'                  => 'Секретний ключ клієнта',
                    'client-secret-info'             => 'Додайте свій секретний ключ тут',
                    'description'                    => 'Опис',
                    'generate-invoice'               => 'Автоматично генерувати рахунок після оформлення замовлення',
                    'generate-invoice-applicable'    => 'Застосовно, якщо включено автоматичне генерування рахунку',
                    'info'                           => 'Встановіть інформацію про способи оплати',
                    'instructions'                   => 'Інструкції',
                    'logo'                           => 'Логотип',
                    'logo-information'               => 'Роздільна здатність зображення повинна бути 55px X 45px',
                    'mailing-address'                => 'Адреса для відправки чека',
                    'money-transfer'                 => 'Грошовий переказ',
                    'money-transfer-info'            => 'Переказ коштів від однієї особи або рахунку на інший, часто електронним шляхом, для різних цілей, таких як транзакції або перекази.',
                    'page-title'                     => 'Способи оплати',
                    'paid'                           => 'Оплачено',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'PayPal Smart Button: спрощує онлайн-платежі з настроюваними кнопками для безпечних багатометодних транзакцій на веб-сайтах та додатках.',
                    'paypal-standard'                => 'PayPal Standard',
                    'paypal-standard-info'           => 'PayPal Standard - це базовий варіант оплати PayPal для онлайн-бізнесу, який дозволяє клієнтам платити за допомогою своїх облікових записів PayPal або кредитних / дебетових карт.',
                    'pending'                        => 'Очікується',
                    'pending-payment'                => 'Очікується оплата',
                    'processing'                     => 'Обробка',
                    'sandbox'                        => 'Пісочниця',
                    'set-invoice-status'             => 'Встановити статус рахунку після створення рахунку на',
                    'set-order-status'               => 'Встановити статус замовлення після створення рахунку на',
                    'sort-order'                     => 'Порядок сортування',
                    'status'                         => 'Статус',
                    'title'                          => 'Назва',
                ],

                'order-settings' => [
                    'info'               => 'Встановіть номери замовлень, мінімальні замовлення та замовлення в запасі.',
                    'title'              => 'Налаштування замовлення',

                    'order-number' => [
                        'generator'   => 'Генератор номерів замовлень',
                        'info'        => 'Унікальний ідентифікатор, призначений конкретному замовленню клієнта, що допомагає відстежувати, спілкуватися та посилатися на нього протягом процесу покупки.',
                        'length'      => 'Довжина номера замовлення',
                        'prefix'      => 'Префікс номера замовлення',
                        'suffix'      => 'Суфікс номера замовлення',
                        'title'       => 'Налаштування номера замовлення',
                    ],

                    'minimum-order' => [
                        'description'             => 'Опис',
                        'enable'                  => 'Увімкнути',
                        'include-discount-amount' => 'Включити суму знижки',
                        'include-tax-amount'      => 'Включити податок до суми',
                        'info'                    => 'Налаштовані критерії, що визначають найнижчу необхідну кількість або вартість для обробки замовлення або отримання пільг.',
                        'minimum-order-amount'    => 'Мінімальна сума замовлення',
                        'title'                   => 'Налаштування мінімального замовлення',
                    ],

                    'reorder' => [
                        'admin-reorder'      => 'Повторне замовлення адміністратора',
                        'admin-reorder-info' => 'Увімкнути або вимкнути функцію повторного замовлення для адміністраторів.',
                        'info'               => 'Увімкнути або вимкнути функцію повторного замовлення для адміністраторів.',
                        'shop-reorder'       => 'Повторне замовлення магазину',
                        'shop-reorder-info'  => 'Увімкнути або вимкнути функцію повторного замовлення для користувачів магазину.',
                        'title'              => 'Дозволити повторне замовлення',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'Дозволити замовлення в запасі',
                        'info'              => 'Варіанти акцій - це інвестиційні контракти, які надають право купувати або продавати акції компанії за попередньо визначеною ціною, що впливає на потенційні прибутки.',
                        'title'             => 'Варіанти акцій',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => 'Встановіть номер рахунку, умови оплати, дизайн рахунку та нагадування про рахунки.',
                    'title' => 'Налаштування рахунку',

                    'invoice-number' => [
                        'generator'  => 'Генератор номерів рахунків',
                        'info'       => 'Конфігурація правил або параметрів для генерації та призначення унікальних ідентифікаційних номерів для рахунків для організаційних та відстежувальних цілей.',
                        'length'     => 'Довжина номера рахунку',
                        'prefix'     => 'Префікс номера рахунку',
                        'suffix'     => 'Суфікс номера рахунку',
                        'title'      => 'Налаштування номера рахунку',
                    ],

                    'payment-terms' => [
                        'due-duration'      => 'Термін оплати',
                        'due-duration-day'  => ':due-duration день',
                        'due-duration-days' => ':due-duration днів',
                        'info'              => 'Узгоджені умови, що визначають, коли і як оплата за товари або послуги повинна бути здійснена покупцем продавцю.',
                        'title'             => 'Умови оплати',
                    ],

                    'pdf-print-outs' => [
                        'footer-text'      => 'Текст підвалу',
                        'footer-text-info' => 'Введіть текст, який з\'явиться в підвалі PDF.',
                        'info'             => 'Налаштуйте друк PDF для відображення ID рахунку, ID замовлення в заголовку та включення логотипу рахунку.',
                        'invoice-id-info'  => 'Налаштуйте відображення ID рахунку в заголовку рахунку.',
                        'invoice-id-title' => 'Відображати ID рахунку в заголовку',
                        'logo'             => 'Логотип',
                        'logo-info'        => 'Роздільна здатність зображення має бути 131px x 30px.',
                        'order-id-info'    => 'Налаштуйте відображення ID замовлення в заголовку рахунку.',
                        'order-id-title'   => 'Відображати ID замовлення в заголовку',
                        'title'            => 'Друк PDF',
                    ],

                    'invoice-reminders' => [
                        'info'                       => 'Автоматичні сповіщення або комунікації, які надсилаються клієнтам для нагадування про наближення або прострочення платежів за рахунками.',
                        'interval-between-reminders' => 'Інтервал між нагадуваннями',
                        'maximum-limit-of-reminders' => 'Максимальний ліміт нагадувань',
                        'title'                      => 'Нагадування про рахунки',
                    ],
                ],

                'taxes' => [
                    'title'      => 'Податки',
                    'title-info' => 'Податки - це обов\'язкові збори, які накладають уряди на товари, послуги або операції, які збирають продавці та перераховують органам влади.',

                    'categories' => [
                        'title'      => 'Категорії податків',
                        'title-info' => 'Категорії податків - це класифікації різних типів податків, таких як податок на продаж, податок на додану вартість або акцизний податок, які використовуються для категоризації та застосування ставок податків до товарів або послуг.',
                        'product'    => 'Категорія податку за замовчуванням для товару',
                        'shipping'   => 'Категорія податку на доставку',
                        'none'       => 'Немає',
                    ],

                    'calculation' => [
                        'title'            => 'Налаштування розрахунку',
                        'title-info'       => 'Деталі про вартість товарів або послуг, включаючи базову ціну, знижки, податки та додаткові збори.',
                        'based-on'         => 'Розрахунок на основі',
                        'shipping-address' => 'Адреса доставки',
                        'billing-address'  => 'Адреса платника',
                        'shipping-origin'  => 'Місце відправлення',
                        'product-prices'   => 'Ціни на товари',
                        'shipping-prices'  => 'Ціни на доставку',
                        'excluding-tax'    => 'Без урахування податку',
                        'including-tax'    => 'З урахуванням податку',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'Країна за замовчуванням',
                        'default-post-code' => 'Поштовий індекс за замовчуванням',
                        'default-state'     => 'Штат за замовчуванням',
                        'title'             => 'Розрахунок місця доставки за замовчуванням',
                        'title-info'        => 'Автоматичне визначення стандартного або початкового місця доставки на основі попередньо визначених факторів або налаштувань.',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'Налаштування відображення кошика',
                        'title-info'              => 'Встановіть відображення податків у кошику',
                        'display-prices'          => 'Відображати ціни',
                        'display-subtotal'        => 'Відображати підсумок',
                        'display-shipping-amount' => 'Відображати вартість доставки',
                        'excluding-tax'           => 'Без урахування податку',
                        'including-tax'           => 'З урахуванням податку',
                        'both'                    => 'Обидва (без урахування та з урахуванням)',
                    ],

                    'sales' => [
                        'title'                   => 'Налаштування відображення замовлень, рахунків, повернень',
                        'title-info'              => 'Встановіть відображення податків у замовленнях, рахунках та поверненнях',
                        'display-prices'          => 'Відображати ціни',
                        'display-subtotal'        => 'Відображати підсумок',
                        'display-shipping-amount' => 'Відображати вартість доставки',
                        'excluding-tax'           => 'Без урахування податку',
                        'including-tax'           => 'З урахуванням податку',
                        'both'                    => 'Обидва (без урахування та з урахуванням)',
                    ],
                ],

                'checkout' => [
                    'title' => 'Оформлення замовлення',
                    'info'  => 'Налаштуйте оформлення замовлення для гостей, увімкніть або вимкніть міні-корзину, підсумок корзини.',

                    'shopping-cart' => [
                        'cart-page'              => 'Сторінка кошика',
                        'cart-page-info'         => 'Контролюйте видимість сторінки кошика, щоб покращити користувацький досвід покупця.',
                        'cross-sell'             => 'Додаткові товари',
                        'cross-sell-info'        => 'Увімкніть додаткові товари для підвищення можливостей додаткових продажів.',
                        'estimate-shipping'      => 'Розрахунок вартості доставки',
                        'estimate-shipping-info' => 'Увімкніть розрахунок вартості доставки, щоб надати передбачувані витрати на доставку.',
                        'guest-checkout'         => 'Дозволити оформлення замовлення гостем',
                        'guest-checkout-info'    => 'Увімкніть оформлення замовлення гостем для швидкого та безпроблемного процесу покупки.',
                        'info'                   => 'Увімкніть оформлення замовлення гостем, сторінку кошика, додаткові товари та розрахунок вартості доставки, щоб покращити зручність користувачів та оптимізувати процес покупок для збільшення продажів.',
                        'title'                  => 'Кошик',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'Показувати кількість товарів',
                        'display-number-in-cart'  => 'Показувати кількість товарів у кошику',
                        'info'                    => 'Увімкніть налаштування для Мого кошика, щоб показувати підсумок кількості товарів та відображати загальну кількість товарів у кошику для зручного відстеження.',
                        'summary'                 => 'Підсумок',
                        'title'                   => 'Мій кошик',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'Показувати міні-кошик',
                        'info'                 => 'Увімкніть налаштування міні-кошика, щоб відображати міні-кошик та показувати інформацію про пропозиції міні-кошика для швидкого доступу до деталей кошика та акційних пропозицій.',
                        'mini-cart-offer-info' => 'Інформація про пропозиції міні-кошика',
                        'title'                => 'Міні-кошик',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'Обліковий запис',
                'app-version'   => 'Версія: :version',
                'logout'        => 'Вийти',
                'my-account'    => 'Мій обліковий запис',
                'notifications' => 'Повідомлення',
                'visit-shop'    => 'Перейти в магазин',

                'mega-search' => [
                    'categories'                      => 'Категорії',
                    'customers'                       => 'Клієнти',
                    'explore-all-categories'          => 'Досліджуйте всі категорії',
                    'explore-all-customers'           => 'Досліджуйте всіх клієнтів',
                    'explore-all-matching-categories' => 'Досліджуйте всі категорії, що відповідають “:query” (:count)',
                    'explore-all-matching-customers'  => 'Досліджуйте всіх клієнтів, що відповідають “:query” (:count)',
                    'explore-all-matching-orders'     => 'Досліджуйте всі замовлення, що відповідають “:query” (:count)',
                    'explore-all-matching-products'   => 'Досліджуйте всі товари, що відповідають “:query” (:count)',
                    'explore-all-orders'              => 'Досліджуйте всі замовлення',
                    'explore-all-products'            => 'Досліджуйте всі товари',
                    'orders'                          => 'Замовлення',
                    'products'                        => 'Товари',
                    'sku'                             => 'Артикул: :sku',
                    'title'                           => 'Мега Пошук',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => 'Сімейства атрибутів',
                'attributes'               => 'Атрибути',
                'booking-product'          => 'Бронювання',
                'campaigns'                => 'Кампанії',
                'catalog'                  => 'Каталог',
                'categories'               => 'Категорії',
                'channels'                 => 'Канали',
                'cms'                      => 'CMS',
                'collapse'                 => 'Згорнути',
                'communications'           => 'Комунікації',
                'configure'                => 'Налаштувати',
                'currencies'               => 'Валюти',
                'customers'                => 'Клієнти',
                'dashboard'                => 'Панель керування',
                'data-transfer'            => 'Передача даних',
                'discount'                 => 'Знижка',
                'email-templates'          => 'Шаблони електронних листів',
                'events'                   => 'Події',
                'exchange-rates'           => 'Обмінні курси',
                'gdpr-data-requests'       => 'Запити на дані GDPR',
                'groups'                   => 'Групи',
                'imports'                  => 'Імпорт',
                'inventory-sources'        => 'Джерела інвентаризації',
                'invoices'                 => 'Рахунки',
                'locales'                  => 'Локалізації',
                'marketing'                => 'Маркетинг',
                'mode'                     => 'Темний режим',
                'newsletter-subscriptions' => 'Підписки на розсилку',
                'orders'                   => 'Замовлення',
                'products'                 => 'Продукти',
                'promotions'               => 'Промоакції',
                'refunds'                  => 'Повернення',
                'reporting'                => 'Звітність',
                'reviews'                  => 'Відгуки',
                'roles'                    => 'Ролі',
                'sales'                    => 'Продажі',
                'search-seo'               => 'Пошук та SEO',
                'search-synonyms'          => 'Синоніми пошуку',
                'search-terms'             => 'Пошукові терміни',
                'settings'                 => 'Налаштування',
                'shipments'                => 'Відвантаження',
                'sitemaps'                 => 'Карти сайту',
                'tax-categories'           => 'Категорії податків',
                'tax-rates'                => 'Податкові ставки',
                'taxes'                    => 'Податки',
                'themes'                   => 'Теми',
                'transactions'             => 'Транзакції',
                'url-rewrites'             => 'Переписування URL-адрес',
                'users'                    => 'Користувачі',
            ],

            'powered-by' => [
                'description' => 'Працює на платформі :bagisto, спільний проект :webkul.',
            ],
        ],

        'datagrid' => [
            'index' => [
                'no-records-selected'              => 'Не вибрано жодного запису.',
                'must-select-a-mass-action-option' => 'Ви повинні вибрати опцію масової дії.',
                'must-select-a-mass-action'        => 'Ви повинні вибрати масову дію.',
            ],

            'toolbar' => [
                'length-of' => ':length з',
                'of'        => 'з',
                'per-page'  => 'На сторінку',
                'results'   => ':total Результати',
                'selected'  => ':total Обрані',

                'mass-actions' => [
                    'select-action' => 'Вибрати дію',
                    'select-option' => 'Вибрати опцію',
                    'submit'        => 'Відправити',
                ],

                'filter' => [
                    'apply-filters-btn' => 'Застосувати фільтри',
                    'back-btn'          => 'Назад',
                    'create-new-filter' => 'Створити новий фільтр',
                    'custom-filters'    => 'Користувацькі фільтри',
                    'delete-error'      => 'Щось пішло не так під час видалення фільтра, будь ласка, спробуйте ще раз.',
                    'delete-success'    => 'Фільтр успішно видалено.',
                    'empty-description' => 'Немає вибраних фільтрів для збереження. Будь ласка, виберіть фільтри для збереження.',
                    'empty-title'       => 'Додати фільтри для збереження',
                    'name'              => 'Назва',
                    'quick-filters'     => 'Швидкі фільтри',
                    'save-btn'          => 'Зберегти',
                    'save-filter'       => 'Зберегти фільтр',
                    'saved-success'     => 'Фільтр успішно збережено.',
                    'selected-filters'  => 'Вибрані фільтри',
                    'title'             => 'Фільтр',
                    'update'            => 'Оновити',
                    'update-filter'     => 'Оновити фільтр',
                    'updated-success'   => 'Фільтр було успішно оновлено.',
                ],

                'search' => [
                    'title' => 'Пошук',
                ],
            ],

            'filters' => [
                'select' => 'Вибрати',
                'title'  => 'Фільтри',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => 'Введіть принаймні 2 символи...',
                        'no-results'        => 'Результати не знайдені...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'Очистити все',
                    'title'     => 'Користувацькі фільтри',
                ],

                'boolean-options' => [
                    'false' => 'Неправда',
                    'true'  => 'Правда',
                ],

                'date-options' => [
                    'last-month'        => 'Минулий місяць',
                    'last-six-months'   => 'Останні 6 місяців',
                    'last-three-months' => 'Останні 3 місяці',
                    'this-month'        => 'Цього місяця',
                    'this-week'         => 'Цього тижня',
                    'this-year'         => 'Цього року',
                    'today'             => 'Сьогодні',
                    'yesterday'         => 'Вчора',
                ],
            ],

            'table' => [
                'actions'              => 'Дії',
                'no-records-available' => 'Записи відсутні.',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => 'Згоден',
                'disagree-btn' => 'Не згоден',
                'message'      => 'Ви впевнені, що хочете виконати цю дію?',
                'title'        => 'Ви впевнені?',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => 'Додати обраний продукт',
                'empty-info'    => 'Немає доступних продуктів для терміну пошуку.',
                'empty-title'   => 'Продукти не знайдено',
                'product-image' => 'Зображення продукту',
                'qty'           => ':qty доступно',
                'sku'           => 'Артикул - :sku',
                'title'         => 'Вибрати продукти',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => 'Додати зображення',
                'ai-add-image-btn'  => 'Магія ШІ',
                'ai-btn-info'       => 'Створити Зображення',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => 'Дозволені тільки файли зображень (.jpeg, .jpg, .png, ..).',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => 'Застосувати',
                    'dall-e-2'         => 'Далл.Е 2',
                    'dall-e-3'         => 'Далл.Е 3',
                    'generate'         => 'Створити',
                    'generating'       => 'Створюється...',
                    'hd'               => 'HD',
                    'model'            => 'Модель',
                    'number-of-images' => 'Кількість Зображень',
                    'prompt'           => 'Підказка',
                    'quality'          => 'Якість',
                    'regenerate'       => 'Перестворити',
                    'regenerating'     => 'Перестворюється...',
                    'size'             => 'Розмір',
                    'standard'         => 'Стандарт',
                    'title'            => 'Генерація Зображень з Використанням ШІ',
                ],

                'placeholders' => [
                    'front'     => 'Зверху',
                    'next'      => 'Наступний',
                    'size'      => 'Розмір',
                    'use-cases' => 'Використання',
                    'zoom'      => 'Збільшення',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'Додати відео',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Дозволені лише файли відео (.mp4, .mov, .ogg ..).',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'Магія ШІ',

            'ai-generation' => [
                'apply'                  => 'Застосувати',
                'deepseek-r1-8b'         => 'DeepSeek R1 (8b)',
                'enabled'                => 'Увімкнено',
                'gemini-2-0-flash'       => 'Gemini 2.0 Flash',
                'generate'               => 'Створити',
                'generated-content'      => 'Згенерований контент',
                'generated-content-info' => 'Контент, створений ШІ, може бути оманливим. Будь ласка, перевірте згенерований контент перед його застосуванням.',
                'generating'             => 'Створюється...',
                'gpt-4-turbo'            => 'OpenAI gpt-4 Turbo',
                'gpt-4o'                 => 'OpenAI gpt-4o',
                'gpt-4o-mini'            => 'OpenAI gpt-4o mini',
                'llama-groq'             => 'Llama 3.3 (Groq)',
                'llama3-1-8b'            => 'Llama 3.1 (8B)',
                'llama3-2-1b'            => 'Llama 3.2 (1B)',
                'llama3-2-3b'            => 'Llama 3.2 (3B)',
                'llama3-8b'              => 'Llama 3 (8B)',
                'llava-7b'               => 'Llava (7b)',
                'mistral-7b'             => 'Mistral (7b)',
                'model'                  => 'Модель',
                'orca-mini'              => 'Orca Mini',
                'phi3-5'                 => 'Phi 3.5',
                'prompt'                 => 'Підказка',
                'qwen2-5-0-5b'           => 'Qwen 2.5 (0.5b)',
                'qwen2-5-1-5b'           => 'Qwen 2.5 (1.5b)',
                'qwen2-5-14b'            => 'Qwen 2.5 (14b)',
                'qwen2-5-3b'             => 'Qwen 2.5 (3b)',
                'qwen2-5-7b'             => 'Qwen 2.5 (7b)',
                'starling-lm-7b'         => 'Starling-lm (7b)',
                'title'                  => 'Допомога ШІ',
                'vicuna-13b'             => 'Vicuna (13b)',
                'vicuna-7b'              => 'Vicuna (7b)',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => 'Адреси',
        'attribute-families'       => 'Сімейства атрибутів',
        'attributes'               => 'Атрибути',
        'campaigns'                => 'Кампанії',
        'cancel'                   => 'Скасувати',
        'cart-rules'               => 'Правила кошика',
        'catalog-rules'            => 'Правила каталогу',
        'catalog'                  => 'Каталог',
        'categories'               => 'Категорії',
        'channels'                 => 'Канали',
        'cms'                      => 'CMS',
        'communications'           => 'Комунікації',
        'configure'                => 'Налаштувати',
        'copy'                     => 'Копіювати',
        'create'                   => 'Створити',
        'currencies'               => 'Валюти',
        'customers'                => 'Клієнти',
        'dashboard'                => 'Панель управління',
        'data-transfer'            => 'Передача даних',
        'delete'                   => 'Видалити',
        'edit'                     => 'Редагувати',
        'email-templates'          => 'Шаблони електронних листів',
        'events'                   => 'Події',
        'exchange-rates'           => 'Курси обміну',
        'gdpr'                     => 'GDPR',
        'groups'                   => 'Групи',
        'import'                   => 'Імпорт',
        'imports'                  => 'Імпорт',
        'inventory-sources'        => 'Джерела інвентаризації',
        'invoices'                 => 'Рахунки',
        'locales'                  => 'Локалізації',
        'marketing'                => 'Маркетинг',
        'newsletter-subscriptions' => 'Підписка на розсилку',
        'note'                     => 'Примітка',
        'orders'                   => 'Замовлення',
        'products'                 => 'Товари',
        'promotions'               => 'Акції',
        'refunds'                  => 'Повернення',
        'reporting'                => 'Звітність',
        'reviews'                  => 'Відгуки',
        'roles'                    => 'Ролі',
        'sales'                    => 'Продажі',
        'search-seo'               => 'Пошук та SEO',
        'search-synonyms'          => 'Синоніми пошуку',
        'search-terms'             => 'Пошукові терміни',
        'settings'                 => 'Налаштування',
        'shipments'                => 'Відправки',
        'sitemaps'                 => 'Карти сайту',
        'subscribers'              => 'Підписники на розсилку',
        'tax-categories'           => 'Категорії податків',
        'tax-rates'                => 'Ставки податків',
        'taxes'                    => 'Податки',
        'themes'                   => 'Теми',
        'transactions'             => 'Транзакції',
        'url-rewrites'             => 'Переписування URL-адрес',
        'users'                    => 'Користувачі',
        'view'                     => 'Перегляд',
    ],

    'errors' => [
        'dashboard' => 'Панель приладів',
        'go-back'   => 'Повернутися назад',
        'support'   => 'Якщо проблема не вирішена, зверніться до нас за адресою <a href=":link" class=":class">:email</a> для отримання допомоги.',

        '404' => [
            'description' => 'Ой! Сторінку, яку ви шукаєте, у відпустці. Здається, ми не можемо знайти те, що ви шукали.',
            'title'       => '404 Сторінку не знайдено',
        ],

        '401' => [
            'description' => 'Ой! Виглядає, ніби вам заборонено доступ до цієї сторінки. Здається, вам не вистачає необхідних облікових даних.',
            'title'       => '401 Не авторизовано',
        ],

        '403' => [
            'description' => 'Ой! Ця сторінка заборонена. Здається, у вас немає необхідних дозволів для перегляду цього вмісту.',
            'title'       => '403 Заборонено',
        ],

        '500' => [
            'description' => 'Ой! Щось пішло не так. Здається, у нас виникли проблеми з завантаженням сторінки, яку ви шукали.',
            'title'       => '500 Внутрішня помилка сервера',
        ],

        '503' => [
            'description' => 'Ой! Виглядає, якщо ми тимчасово вимкнуті для технічного обслуговування. Будь ласка, поверніться через трохи.',
            'title'       => '503 Сервіс тимчасово недоступний',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Завантажити',
        'export'     => 'Експорт',
        'no-records' => 'Нічого експортувати',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'Цей slug використовується в категоріях або товарах.',
        'slug-reserved'   => 'Цей slug зарезервований.',
    ],

    'footer' => [
        'copy-right' => 'Працює на платформі <a href="https://bagisto.com/" target="_blank">Bagisto</a>, Спільний проект <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => 'Шановний :admin_name',
        'thanks' => 'Якщо вам потрібна будь-яка допомога, будь ласка, зв\'яжіться з нами за адресою <a href=":link" style=":style">:email</a>.<br/>Дякуємо!',

        'admin' => [
            'forgot-password' => [
                'description'    => 'Ви отримали цей лист, оскільки ми отримали запит на скидання пароля для вашого облікового запису.',
                'greeting'       => 'Забули пароль!',
                'reset-password' => 'Скинути пароль',
                'subject'        => 'Повідомлення про скидання пароля',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => 'Новий обліковий запис клієнта успішно створено. Тепер вони можуть увійти, використовуючи свою адресу електронної пошти та пароль. Увійшовши в обліковий запис, вони матимуть доступ до різноманітних послуг, включаючи можливість переглядати минулі замовлення, керувати списками бажань і оновлювати інформацію свого облікового запису.',
                'greeting'    => 'Ми тепло вітаємо нового клієнта :customer_name, який щойно зареєструвався у нас!',
                'subject'     => 'Реєстрація нового клієнта',
            ],

            'gdpr' => [
                'new-delete-request' => 'Нове запит на видалення даних',
                'new-update-request' => 'Нове запит на оновлення даних',

                'new-request' => [
                    'customer-name'  => 'Ім’я клієнта : ',
                    'delete-summary' => 'Резюме запиту на видалення',
                    'message'        => 'Повідомлення : ',
                    'request-status' => 'Статус запиту : ',
                    'request-type'   => 'Тип запиту : ',
                    'update-summary' => 'Резюме запиту на оновлення',
                ],

                'status-update' => [
                    'subject'        => 'Запит GDPR оновлено',
                    'summary'        => 'Статус запиту GDPR оновлено',
                    'request-status' => 'Статус запиту:',
                    'request-type'   => 'Тип запиту:',
                    'message'        => 'Повідомлення:',
                ],
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => 'У вас нове замовлення :order_id, розміщене :created_at',
                'subject'  => 'Підтвердження нового замовлення',
                'summary'  => 'Загальна інформація про замовлення',
                'title'    => 'Підтвердження замовлення!',
            ],

            'invoiced' => [
                'greeting' => 'Ваш рахунок-фактура #:invoice_id для замовлення :order_id створено :created_at',
                'subject'  => 'Підтвердження нового рахунку-фактури',
                'summary'  => 'Загальна інформація про рахунок-фактуру',
                'title'    => 'Підтвердження рахунку-фактури!',
            ],

            'shipped' => [
                'greeting' => 'Ви відправили замовлення :order_id, розміщене :created_at',
                'subject'  => 'Підтвердження нової відвантаження',
                'summary'  => 'Загальна інформація про відвантаження',
                'title'    => 'Відвантаження замовлення!',
            ],

            'inventory-source' => [
                'greeting' => 'Ви відправили замовлення :order_id, розміщене :created_at',
                'subject'  => 'Підтвердження нової відвантаження',
                'summary'  => 'Загальна інформація про відвантаження',
                'title'    => 'Відвантаження замовлення!',
            ],

            'refunded' => [
                'greeting' => 'Ви повернули кошти за замовлення :order_id, розміщене :created_at',
                'subject'  => 'Підтвердження нового повернення',
                'summary'  => 'Загальна інформація про повернення',
                'title'    => 'Повернення замовлення!',
            ],

            'canceled' => [
                'greeting' => 'Ви скасували замовлення :order_id, розміщене :created_at',
                'subject'  => 'Скасування нового замовлення',
                'summary'  => 'Загальна інформація про замовлення',
                'title'    => 'Замовлення скасоване!',
            ],

            'billing-address'            => 'Адреса оплати',
            'carrier'                    => 'Перевізник',
            'contact'                    => 'Контакт',
            'discount'                   => 'Знижка',
            'excl-tax'                   => 'Без ПДВ: ',
            'grand-total'                => 'Загальна сума',
            'name'                       => 'Ім\'я',
            'payment'                    => 'Оплата',
            'price'                      => 'Ціна',
            'qty'                        => 'Кількість',
            'shipping-address'           => 'Адреса доставки',
            'shipping-handling-excl-tax' => 'Доставка та обробка (без ПДВ)',
            'shipping-handling-incl-tax' => 'Доставка та обробка (з ПДВ)',
            'shipping-handling'          => 'Доставка та обробка',
            'shipping'                   => 'Доставка',
            'sku'                        => 'Артикул',
            'subtotal-excl-tax'          => 'Підсумок (без ПДВ)',
            'subtotal-incl-tax'          => 'Підсумок (з ПДВ)',
            'subtotal'                   => 'Підсумок',
            'tax'                        => 'ПДВ',
            'tracking-number'            => 'Номер відстеження: :tracking_number',
        ],
    ],
];
