<?php

return [
    'users' => [
        'sessions' => [
            'email'                  => 'Dirección de Correo Electrónico',
            'forget-password-link'   => '¿Olvidaste tu Contraseña?',
            'password'               => 'Contraseña',
            'powered-by-description' => 'Desarrollado por :bagisto, un proyecto de código abierto de :webkul.',
            'submit-btn'             => 'Iniciar Sesión',
            'title'                  => 'Iniciar Sesión',
        ],

        'forget-password' => [
            'create'    => [
                'email'                  => 'Correo Electrónico Registrado',
                'email-not-exist'        => 'El Correo Electrónico no Existe',
                'page-title'             => 'Olvidar Contraseña',
                'powered-by-description' => 'Desarrollado por :bagisto, un proyecto de código abierto de :webkul.',
                'reset-link-sent'        => 'Enlace para Restablecer la Contraseña Enviado',
                'sign-in-link'           => '¿Volver a Iniciar Sesión?',
                'submit-btn'             => 'Restablecer',
                'title'                  => 'Recuperar Contraseña',
            ],
        ],

        'reset-password' => [
            'back-link-title'        => '¿Volver a Iniciar Sesión?',
            'confirm-password'       => 'Confirmar Contraseña',
            'email'                  => 'Correo Electrónico Registrado',
            'password'               => 'Contraseña',
            'powered-by-description' => 'Desarrollado por :bagisto, un proyecto de código abierto de :webkul.',
            'submit-btn'             => 'Restablecer Contraseña',
            'title'                  => 'Restablecer Contraseña',
        ],
    ],

    'notifications' => [
        'description-text' => 'Listar todas las notificaciones',
        'marked-success'   => 'Todas las notificaciones han sido marcadas como leídas',
        'no-record'        => 'No se Encontraron Registros',
        'of'               => 'de',
        'per-page'         => 'Por página',
        'read-all'         => 'Marcar como Leído',
        'title'            => 'Notificaciones',
        'view-all'         => 'Ver Todas',

        'order-status-messages' => [
            'all'             => 'Todos',
            'canceled'        => 'Pedido Cancelado',
            'closed'          => 'Pedido Cerrado',
            'completed'       => 'Pedido Completado',
            'pending'         => 'Pedido Pendiente',
            'pending-payment' => 'Pago Pendiente',
            'processing'      => 'Pedido en Proceso',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => 'Volver',
            'change-password'   => 'Cambiar Contraseña',
            'confirm-password'  => 'Confirmar Contraseña',
            'current-password'  => 'Contraseña Actual',
            'email'             => 'Correo Electrónico',
            'general'           => 'General',
            'invalid-password'  => 'La contraseña actual que ingresaste es incorrecta.',
            'name'              => 'Nombre',
            'password'          => 'Contraseña',
            'profile-image'     => 'Imagen de Perfil',
            'save-btn'          => 'Guardar Cuenta',
            'title'             => 'Mi Cuenta',
            'update-success'    => 'Cuenta actualizada con éxito',
            'upload-image-info' => 'Cargar una Imagen de Perfil (110px X 110px) en formato PNG o JPG',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => 'Agregar Cliente',
            'add-product'                 => 'Agregar Producto',
            'all-channels'                => 'Todos los Canales',
            'attribute-code'              => 'Código de Atributo',
            'average-sale'                => 'Promedio de Venta por Pedido',
            'color'                       => 'Color',
            'customer-info'               => 'No se encontraron clientes con más ventas',
            'customer-with-most-sales'    => 'Cliente con Más Ventas',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => 'Umbral de Vacío',
            'empty-threshold-description' => 'No hay productos disponibles',
            'end-date'                    => 'Fecha de Fin',
            'from'                        => 'Desde',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ Más Imágenes',
            'order'                       => ':total_orders Pedidos',
            'order-count'                 => ':count Pedidos',
            'order-id'                    => '#:id',
            'overall-details'             => 'Detalles Generales',
            'pay-by'                      => 'Pago Por - :method',
            'product-count'               => ':count Productos',
            'product-image'               => 'Imagen de Producto',
            'product-info'                => 'Agregar productos relacionados sobre la marcha.',
            'product-number'              => 'Producto - :product_number',
            'revenue'                     => 'Ingresos :total',
            'sale-count'                  => ':count Ventas',
            'sales'                       => 'Ventas',
            'sku'                         => 'SKU - :sku',
            'start-date'                  => 'Fecha de Inicio',
            'stock-threshold'             => 'Umbral de Stock',
            'store-stats'                 => 'Estadísticas de la Tienda',
            'title'                       => 'Panel de Control',
            'to'                          => 'Hasta',
            'today-customers'             => 'Clientes de Hoy',
            'today-details'               => 'Detalles de Hoy',
            'today-orders'                => 'Pedidos de Hoy',
            'today-sales'                 => 'Ventas de Hoy',
            'top-performing-categories'   => 'Categorías Más Destacadas',
            'top-selling-products'        => 'Productos Más Vendidos',
            'total-customers'             => 'Total de Clientes',
            'total-orders'                => 'Total de Pedidos',
            'total-sales'                 => 'Total de Ventas',
            'total-stock'                 => ':total_stock en Stock',
            'total-unpaid-invoices'       => 'Total de Facturas Impagadas',
            'unique-visitors'             => ':count Único',
            'user-info'                   => 'Revise rápidamente lo que está sucediendo en su tienda',
            'user-name'                   => '¡Hola! :user_name',
            'visitors'                    => 'Visitante',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => 'Crear Pedido',
                'title'      => 'Pedidos',

                'search-customer' => [
                    'create-btn'  => 'Crear Cliente',
                    'empty-info'  => 'No hay clientes disponibles para el término de búsqueda.',
                    'empty-title' => 'No se encontraron clientes',
                    'search-by'   => 'Buscar por correo electrónico o nombre',
                    'title'       => 'Seleccionar Cliente',
                ],

                'datagrid' => [
                    'canceled'        => 'Cancelado',
                    'channel-name'    => 'Canal',
                    'closed'          => 'Cerrado',
                    'completed'       => 'Completado',
                    'customer'        => 'Cliente',
                    'date'            => 'Fecha',
                    'email'           => 'Correo Electrónico',
                    'fraud'           => 'Fraude',
                    'grand-total'     => 'Total General',
                    'id'              => '#:id',
                    'items'           => 'Artículos',
                    'location'        => 'Ubicación',
                    'order-id'        => 'ID de Pedido',
                    'pay-by'          => 'Pagar Por - :method',
                    'pay-via'         => 'Pagar Vía',
                    'pending-payment' => 'Pago Pendiente',
                    'pending'         => 'Pendiente',
                    'processing'      => 'Procesando',
                    'product-count'   => ':count + Más productos',
                    'status'          => 'Estado',
                    'success'         => 'Éxito',
                    'view'            => 'Ver',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'Agregar al carrito',
                'back-btn'                => 'Volver',
                'check-billing-address'   => 'Falta la dirección de facturación.',
                'check-shipping-address'  => 'Falta la dirección de envío.',
                'configuration'           => 'Configuración',
                'coupon-already-applied'  => 'El código de cupón ya ha sido aplicado.',
                'coupon-applied'          => 'Código de cupón aplicado correctamente.',
                'coupon-error'            => 'No se puede aplicar el código de cupón.',
                'coupon-not-found'        => 'Cupón no encontrado',
                'coupon-remove'           => 'Código de cupón eliminado correctamente.',
                'error'                   => 'Algo salió mal',
                'minimum-order-error'     => 'No se cumple el monto mínimo del pedido.',
                'order-placed-success'    => 'Pedido realizado correctamente.',
                'payment-not-supported'   => 'Este método de pago no es compatible',
                'save-btn'                => 'Crear pedido',
                'specify-payment-method'  => 'Falta el método de pago.',
                'specify-shipping-method' => 'Falta el método de envío.',
                'title'                   => 'Crear pedido para :name',

                'types' => [
                    'simple' => [
                        'none'         => 'Ninguno',
                        'total-amount' => 'Monto total',
                    ],

                    'configurable' => [
                        'select-options' => 'Por favor, selecciona una opción',
                    ],

                    'bundle' => [
                        'none'         => 'Ninguno',
                        'total-amount' => 'Monto total',
                    ],

                    'grouped' => [
                        'name' => 'Nombre',
                    ],

                    'downloadable' => [
                        'title' => 'Enlaces',
                    ],

                    'virtual' => [
                        'none'         => 'Ninguno',
                        'total-amount' => 'Monto total',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => 'Producto agregado al carrito correctamente',
                    'success-remove'      => 'Elemento eliminado del carrito correctamente',
                    'success-update'      => 'Elemento del carrito actualizado correctamente',

                    'items' => [
                        'add-product'       => 'Agregar producto',
                        'amount-per-unit'   => ':amount por unidad x :qty cantidad',
                        'delete'            => 'Eliminar',
                        'empty-description' => 'No se encontraron elementos en tu carrito.',
                        'empty-title'       => 'Carrito vacío',
                        'excl-tax'          => 'Excl. Tax',
                        'move-to-wishlist'  => 'Mover a la lista de deseos',
                        'see-details'       => 'Ver detalles',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => 'Subtotal - :sub_total',
                        'title'             => 'Elementos del carrito',

                        'search' => [
                            'add-to-cart'   => 'Agregar al carrito',
                            'available-qty' => ':qty disponible',
                            'empty-info'    => 'No hay productos disponibles para el término de búsqueda.',
                            'empty-title'   => 'No se encontraron productos',
                            'product-image' => 'Imagen del producto',
                            'qty'           => 'Cantidad',
                            'sku'           => 'SKU - :sku',
                            'title'         => 'Buscar productos',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => 'Agregar dirección',
                        'add-new'          => 'Agregar nueva dirección',
                        'add-new-address'  => 'Agregar nueva dirección',
                        'addresses'        => 'Direcciones',
                        'back'             => 'Volver',
                        'billing-address'  => 'Dirección de facturación',
                        'city'             => 'Ciudad',
                        'company-name'     => 'Nombre de la empresa',
                        'confirm'          => 'Confirmar',
                        'country'          => 'País',
                        'edit-btn'         => 'Editar dirección',
                        'email'            => 'Correo electrónico',
                        'first-name'       => 'Nombre',
                        'last-name'        => 'Apellido',
                        'postcode'         => 'Código postal',
                        'proceed'          => 'Continuar',
                        'same-as-billing'  => '¿Usar la misma dirección para el envío?',
                        'save'             => 'Guardar',
                        'save-address'     => 'Guardar en la libreta de direcciones',
                        'select-country'   => 'Seleccionar país',
                        'select-state'     => 'Seleccionar estado',
                        'shipping-address' => 'Dirección de envío',
                        'state'            => 'Estado',
                        'street-address'   => 'Dirección',
                        'telephone'        => 'Teléfono',
                        'title'            => 'Dirección',
                        'vat-id'           => 'NIF',
                    ],

                    'payment' => [
                        'title' => 'Pago',
                    ],

                    'shipping' => [
                        'title' => 'Envío',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'Aplicar cupón',
                        'discount-amount'          => 'Monto de descuento',
                        'enter-your-code'          => 'Ingresa tu código',
                        'grand-total'              => 'Total',
                        'place-order'              => 'Realizar pedido',
                        'processing'               => 'Procesando',
                        'shipping-amount-excl-tax' => 'Monto de envío (Excl. Impuestos)',
                        'shipping-amount-incl-tax' => 'Monto de envío (Incl. Impuestos)',
                        'shipping-amount'          => 'Monto de envío',
                        'sub-total-excl-tax'       => 'Subtotal (Excl. Impuestos)',
                        'sub-total-incl-tax'       => 'Subtotal (Incl. Impuestos)',
                        'sub-total'                => 'Subtotal',
                        'tax'                      => 'Impuestos',
                        'title'                    => 'Resumen del pedido',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'Agregar al carrito',
                    'delete'            => 'Eliminar',
                    'empty-description' => 'No se encontraron elementos en tu carrito.',
                    'empty-title'       => 'Carrito vacío',
                    'excl-tax'          => 'Excl. Impuestos: ',
                    'see-details'       => 'Ver detalles',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementos del carrito',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'Agregar al carrito',
                    'empty-description' => 'No se encontraron elementos en tus pedidos recientes.',
                    'empty-title'       => 'Pedidos vacíos',
                    'see-details'       => 'Ver detalles',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementos del pedido reciente',
                    'view'              => 'Ver',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'Agregar al carrito',
                    'delete'            => 'Eliminar',
                    'empty-description' => 'No se encontraron elementos en tu lista de deseos.',
                    'empty-title'       => 'Elementos de la lista de deseos vacíos',
                    'see-details'       => 'Ver detalles',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementos de la lista de deseos',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'Agregar al carrito',
                    'delete'            => 'Eliminar',
                    'empty-description' => 'No se encontraron elementos en tu lista de comparación.',
                    'empty-title'       => 'Elementos de comparación vacíos',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Elementos de comparación',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Por Unidad x :qty Cantidad',
                'billing-address'                => 'Dirección de Facturación',
                'cancel'                         => 'Cancelar',
                'cancel-msg'                     => '¿Estás seguro de que quieres cancelar este pedido?',
                'cancel-success'                 => 'Pedido cancelado exitosamente',
                'canceled'                       => 'Cancelado',
                'channel'                        => 'Canal',
                'closed'                         => 'Cerrado',
                'comment-success'                => 'Comentario agregado exitosamente.',
                'comments'                       => 'Comentarios',
                'completed'                      => 'Completado',
                'contact'                        => 'Contacto',
                'create-success'                 => 'Pedido creado exitosamente',
                'currency'                       => 'Moneda',
                'customer'                       => 'Cliente',
                'customer-group'                 => 'Grupo de Clientes',
                'customer-not-notified'          => ':date | Cliente <b>No Notificado</b>',
                'customer-notified'              => ':date | Cliente <b>Notificado</b>',
                'discount'                       => 'Descuento - :discount',
                'download-pdf'                   => 'Descargar PDF',
                'fraud'                          => 'Fraude',
                'grand-total'                    => 'Total General - :grand_total',
                'invoice-id'                     => 'Factura #:invoice',
                'invoices'                       => 'Facturas',
                'item-canceled'                  => 'Cancelado (:qty_canceled)',
                'item-invoice'                   => 'Facturado (:qty_invoiced)',
                'item-ordered'                   => 'Pedido (:qty_ordered)',
                'item-refunded'                  => 'Reembolsado (:qty_refunded)',
                'item-shipped'                   => 'Enviado (:qty_shipped)',
                'name'                           => 'Nombre',
                'no-invoice-found'               => 'No se encontró ninguna factura',
                'no-refund-found'                => 'No se encontró ningún reembolso',
                'no-shipment-found'              => 'No se encontraron envíos',
                'notify-customer'                => 'Notificar al Cliente',
                'order-date'                     => 'Fecha del Pedido',
                'order-information'              => 'Información del Pedido',
                'order-status'                   => 'Estado del Pedido',
                'payment-and-shipping'           => 'Pago y Envío',
                'payment-method'                 => 'Método de Pago',
                'pending'                        => 'Pendiente',
                'pending_payment'                => 'Pago Pendiente',
                'per-unit'                       => 'Por Unidad',
                'price'                          => 'Precio - :price',
                'price-excl-tax'                 => 'Precio (Excl. Impuestos) - :price',
                'price-incl-tax'                 => 'Precio (Incl. Impuestos) - :price',
                'processing'                     => 'Procesando',
                'quantity'                       => 'Cantidad',
                'refund'                         => 'Reembolso',
                'refund-id'                      => 'Reembolso #:refund',
                'refunded'                       => 'Reembolsado',
                'reorder'                        => 'Reordenar',
                'ship'                           => 'Enviar',
                'shipment'                       => 'Envío #:shipment',
                'shipments'                      => 'Envíos',
                'shipping-address'               => 'Dirección de Envío',
                'shipping-and-handling'          => 'Envío y Manipulación',
                'shipping-and-handling-excl-tax' => 'Envío y Manipulación (Excl. Impuestos)',
                'shipping-and-handling-incl-tax' => 'Envío y Manipulación (Incl. Impuestos)',
                'shipping-method'                => 'Método de Envío',
                'shipping-price'                 => 'Precio de Envío',
                'sku'                            => 'SKU - :sku',
                'status'                         => 'Estado',
                'sub-total'                      => 'Subtotal - :sub_total',
                'sub-total-excl-tax'             => 'Subtotal (Excl. Impuestos) - :sub_total',
                'sub-total-incl-tax'             => 'Subtotal (Incl. Impuestos) - :sub_total',
                'submit-comment'                 => 'Enviar Comentario',
                'summary-discount'               => 'Descuento',
                'summary-grand-total'            => 'Total General',
                'summary-sub-total'              => 'Subtotal',
                'summary-sub-total-excl-tax'     => 'Subtotal (Excl. Impuestos)',
                'summary-sub-total-incl-tax'     => 'Subtotal (Incl. Impuestos)',
                'summary-tax'                    => 'Impuestos',
                'tax'                            => 'Impuestos (:percent) - :tax',
                'title'                          => 'Pedido #:order_id',
                'total-due'                      => 'Total a Pagar',
                'total-paid'                     => 'Total Pagado',
                'total-refund'                   => 'Total Reembolsado',
                'view'                           => 'Ver',
                'write-your-comment'             => 'Escribe tu comentario',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => 'Envíos',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => 'Fuente de Inventario',
                    'order-date'       => 'Fecha del Pedido',
                    'order-id'         => 'ID de Pedido',
                    'shipment-date'    => 'Fecha del Envío',
                    'shipment-to'      => 'Envío a',
                    'total-qty'        => 'Cantidad Total',
                    'view'             => 'Ver',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount Por Unidad x :qty Cantidad',
                'cancel-error'     => 'El pedido no puede ser cancelado',
                'carrier-name'     => 'Nombre de la Compañía de Envío',
                'create-btn'       => 'Crear Envío',
                'creation-error'   => 'Error al crear el envío',
                'item-canceled'    => 'Cancelado (:qty_canceled)',
                'item-invoice'     => 'Facturado (:qty_invoiced)',
                'item-ordered'     => 'Pedido (:qty_ordered)',
                'item-refunded'    => 'Reembolsado (:qty_refunded)',
                'item-shipped'     => 'Enviado (:qty_shipped)',
                'order-error'      => 'El envío no es válido',
                'per-unit'         => 'Por Unidad',
                'qty-available'    => 'Cantidad Disponible',
                'qty-to-ship'      => 'Cantidad a Enviar',
                'quantity-invalid' => 'Cantidad no válida',
                'sku'              => 'SKU - :sku',
                'source'           => 'Fuente',
                'success'          => 'Envío creado con éxito',
                'title'            => 'Crear nuevo Envío',
                'tracking-number'  => 'Número de Seguimiento',
            ],

            'view' => [
                'billing-address'      => 'Dirección de Facturación',
                'carrier-title'        => 'Título de la Compañía de Envío',
                'channel'              => 'Canal',
                'currency'             => 'Moneda',
                'customer'             => 'Cliente',
                'email'                => 'Correo Electrónico - :email',
                'inventory-source'     => 'Fuente de Inventario',
                'order-date'           => 'Fecha del Pedido',
                'order-id'             => 'ID de Pedido',
                'order-information'    => 'Información del Pedido',
                'order-status'         => 'Estado del Pedido',
                'ordered-items'        => 'Ítems Pedidos',
                'payment-and-shipping' => 'Pago y Envío',
                'payment-method'       => 'Método de Pago',
                'product-image'        => 'Imagen del Producto',
                'qty'                  => 'Cantidad - :qty',
                'shipping-address'     => 'Dirección de Envío',
                'shipping-method'      => 'Método de Envío',
                'shipping-price'       => 'Precio de Envío',
                'sku'                  => 'SKU - :sku',
                'title'                => 'Envío #:shipment_id',
                'tracking-number'      => 'Número de Seguimiento',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => 'Reembolsos',

                'datagrid' => [
                    'billed-to'       => 'Facturado a',
                    'id'              => 'ID',
                    'order-id'        => 'ID de Pedido',
                    'refund-date'     => 'Fecha de Reembolso',
                    'refunded-amount' => 'Monto Reembolsado',
                    'view'            => 'Ver',
                ],
            ],

            'view' => [
                'account-information'        => 'Información de la Cuenta',
                'adjustment-fee'             => 'Tarifa de Ajuste',
                'adjustment-refund'          => 'Reembolso de Ajuste',
                'base-discounted-amount'     => 'Monto Descontado - :base_discounted_amount',
                'billing-address'            => 'Dirección de Facturación',
                'currency'                   => 'Moneda',
                'sub-total-amount-excl-tax'  => 'Subtotal (Excl. Impuestos) - :discounted_amount',
                'sub-total-amount-incl-tax'  => 'Subtotal (Incl. Impuestos) - :discounted_amount',
                'sub-total-amount'           => 'Subtotal - :discounted_amount',
                'grand-total'                => 'Total General',
                'order-channel'              => 'Canal de Pedido',
                'order-date'                 => 'Fecha del Pedido',
                'order-id'                   => 'ID de Pedido',
                'order-information'          => 'Información del Pedido',
                'order-status'               => 'Estado del Pedido',
                'payment-information'        => 'Información de Pago',
                'payment-method'             => 'Método de Pago',
                'price-excl-tax'             => 'Precio (Excl. Impuestos) - :price',
                'price-incl-tax'             => 'Precio (Incl. Impuestos) - :price',
                'price'                      => 'Precio - :price',
                'product-image'              => 'Imagen del Producto',
                'product-ordered'            => 'Productos Pedidos',
                'qty'                        => 'Cantidad - :qty',
                'refund'                     => 'Reembolso',
                'shipping-address'           => 'Dirección de Envío',
                'shipping-handling-excl-tax' => 'Envío y Manipulación (Excl. Impuestos)',
                'shipping-handling-incl-tax' => 'Envío y Manipulación (Incl. Impuestos)',
                'shipping-handling'          => 'Envío y Manipulación',
                'shipping-method'            => 'Método de Envío',
                'shipping-price'             => 'Precio de Envío',
                'sku'                        => 'SKU - :sku',
                'sub-total-excl-tax'         => 'Subtotal (Excl. Impuestos)',
                'sub-total-incl-tax'         => 'Subtotal (Incl. Impuestos)',
                'sub-total'                  => 'Subtotal',
                'tax'                        => 'Impuestos',
                'tax-amount'                 => 'Monto de Impuestos - :tax_amount',
                'title'                      => 'Reembolso #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => 'Tarifa de Ajuste',
                'adjustment-refund'           => 'Reembolso de Ajuste',
                'amount-per-unit'             => ':amount Por Unidad x :qty Cantidad',
                'create-success'              => 'Reembolso creado exitosamente',
                'creation-error'              => 'La creación de reembolsos no está permitida.',
                'discount-amount'             => 'Monto de Descuento',
                'grand-total'                 => 'Total General',
                'invalid-qty'                 => 'Se encontró una cantidad no válida para facturar ítems.',
                'invalid-refund-amount-error' => 'La cantidad de reembolso debe ser distinta de cero.',
                'item-canceled'               => 'Cancelado (:qty_canceled)',
                'item-invoice'                => 'Facturado (:qty_invoiced)',
                'item-ordered'                => 'Pedido (:qty_ordered)',
                'item-refunded'               => 'Reembolsado (:qty_refunded)',
                'item-shipped'                => 'Enviado (:qty_shipped)',
                'per-unit'                    => 'Por Unidad',
                'price'                       => 'Precio',
                'qty-to-refund'               => 'Cantidad a Reembolsar',
                'refund-btn'                  => 'Reembolsar',
                'refund-limit-error'          => 'No se puede procesar un monto de reembolso de :amount.',
                'refund-shipping'             => 'Reembolso de Envío',
                'sku'                         => 'SKU - :sku',
                'subtotal'                    => 'Subtotal',
                'tax-amount'                  => 'Monto de Impuestos',
                'title'                       => 'Crear Reembolso',
                'update-totals-btn'           => 'Actualizar Totales',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => 'Facturas',

                'datagrid' => [
                    'action'              => 'Acciones',
                    'days-left'           => 'Quedan :count día(s)',
                    'days-overdue'        => ':count día(s) de retraso',
                    'grand-total'         => 'Total General',
                    'id'                  => 'ID',
                    'invoice-date'        => 'Fecha de la Factura',
                    'mass-update-success' => 'Factura(s) seleccionada(s) actualizada(s) correctamente.',
                    'order-id'            => 'ID de Pedido',
                    'overdue'             => 'Vencido',
                    'overdue-by'          => 'Atrasado por :count día(s)',
                    'paid'                => 'Pagado',
                    'pending'             => 'Pendiente',
                    'status'              => 'Estado',
                    'update-status'       => 'Actualizar estado',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount Por Unidad x :qty Cantidad',
                'channel'                        => 'Canal',
                'customer-email'                 => 'Email - :email',
                'customer'                       => 'Cliente',
                'discount'                       => 'Monto de Descuento - :discount',
                'email'                          => 'Email',
                'grand-total'                    => 'Total General',
                'invoice-items'                  => 'Ítems de Factura',
                'invoice-sent'                   => 'Factura enviada exitosamente',
                'invoice-status'                 => 'Estado de la Factura',
                'order-date'                     => 'Fecha del Pedido',
                'order-id'                       => 'ID del Pedido',
                'order-information'              => 'Información del Pedido',
                'order-status'                   => 'Estado del Pedido',
                'price-excl-tax'                 => 'Precio (Excl. Impuestos) - :price',
                'price-incl-tax'                 => 'Precio (Incl. Impuestos) - :price',
                'price'                          => 'Precio - :price',
                'print'                          => 'Imprimir',
                'product-image'                  => 'Imagen del Producto',
                'qty'                            => 'Cantidad - :qty',
                'send-btn'                       => 'Enviar',
                'send-duplicate-invoice'         => 'Enviar Factura Duplicada',
                'send'                           => 'Enviar',
                'shipping-and-handling-excl-tax' => 'Envío y Manejo (Excl. Impuestos)',
                'shipping-and-handling-incl-tax' => 'Envío y Manejo (Incl. Impuestos)',
                'shipping-and-handling'          => 'Envío y Manejo',
                'sku'                            => 'SKU - :sku',
                'sub-total-excl-tax'             => 'Sub Total (Excl. Impuestos) - :sub_total',
                'sub-total-incl-tax'             => 'Sub Total (Incl. Impuestos) - :sub_total',
                'sub-total-summary-excl-tax'     => 'Sub Total (Excl. Impuestos)',
                'sub-total-summary-incl-tax'     => 'Sub Total (Incl. Impuestos)',
                'sub-total-summary'              => 'Sub Total',
                'sub-total'                      => 'Sub Total - :sub_total',
                'summary-discount'               => 'Monto de Descuento',
                'summary-tax'                    => 'Monto de Impuestos',
                'tax'                            => 'Monto de Impuestos - :tax',
                'title'                          => 'Factura #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => ':amount Por Unidad x :qty Cantidad',
                'create-invoice'     => 'Crear Factura',
                'create-success'     => 'Factura creada exitosamente',
                'create-transaction' => 'Crear Transacción',
                'creation-error'     => 'No se permite la creación de la factura del pedido.',
                'invalid-qty'        => 'Hemos encontrado una cantidad inválida para facturar los artículos.',
                'invoice'            => 'Factura',
                'new-invoice'        => 'Nueva Factura',
                'product-error'      => 'No se puede crear una factura sin productos.',
                'product-image'      => 'Imagen del Producto',
                'qty-to-invoiced'    => 'Cantidad a facturar',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => 'Detalles Bancarios',
                'bill-to'                    => 'Facturar a',
                'contact-number'             => 'Número de Contacto',
                'contact'                    => 'Contacto',
                'date'                       => 'Fecha de la Factura',
                'discount'                   => 'Descuento',
                'excl-tax'                   => 'Excl. Impuestos:',
                'grand-total'                => 'Total General',
                'invoice-id'                 => 'ID de Factura',
                'invoice'                    => 'Factura',
                'order-date'                 => 'Fecha del Pedido',
                'order-id'                   => 'ID de Pedido',
                'payment-method'             => 'Método de Pago',
                'payment-terms'              => 'Términos de Pago',
                'price'                      => 'Precio',
                'product-name'               => 'Nombre del Producto',
                'qty'                        => 'Cantidad',
                'ship-to'                    => 'Enviar a',
                'shipping-handling-excl-tax' => 'Envío y Manejo (Excl. Impuestos)',
                'shipping-handling-incl-tax' => 'Envío y Manejo (Incl. Impuestos)',
                'shipping-handling'          => 'Envío y Manejo',
                'shipping-method'            => 'Método de Envío',
                'sku'                        => 'SKU',
                'subtotal-excl-tax'          => 'Subtotal (Excl. Impuestos)',
                'subtotal-incl-tax'          => 'Subtotal (Incl. Impuestos)',
                'subtotal'                   => 'Subtotal',
                'tax-amount'                 => 'Monto de Impuestos',
                'tax'                        => 'Impuestos',
                'vat-number'                 => 'Número de IVA',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => 'Fecha de Transacción',
            'transaction-id'   => 'ID de Transacción',
            'view'             => 'Ver',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => 'Crear Transacción',
                'title'      => 'Transacciones',

                'datagrid' => [
                    'completed'          => 'Completado',
                    'id'                 => 'ID',
                    'invoice-id'         => 'ID de factura',
                    'order-id'           => 'ID de pedido',
                    'paid'               => 'Pagado',
                    'pending'            => 'Pendiente',
                    'status'             => 'Estado',
                    'transaction-amount' => 'Cantidad',
                    'transaction-date'   => 'Fecha',
                    'transaction-id'     => 'ID de transacción',
                    'view'               => 'Ver',
                ],

                'create' => [
                    'already-paid'               => 'Ya pagado',
                    'amount'                     => 'Monto',
                    'create-transaction'         => 'Crear Transacción',
                    'invoice-id'                 => 'ID de Factura',
                    'invoice-missing'            => 'Factura Ausente',
                    'payment-method'             => 'Método de Pago',
                    'save-transaction'           => 'Guardar Transacción',
                    'transaction-amount-exceeds' => 'El monto de la transacción excede',
                    'transaction-amount-zero'    => 'Monto de la transacción cero',
                    'transaction-saved'          => 'Transacción guardada exitosamente.',
                ],

                'view' => [
                    'amount'           => 'Monto',
                    'created-at'       => 'Fecha de Creación',
                    'invoice-id'       => 'Número de Factura',
                    'order-id'         => 'Número de Pedido',
                    'payment-details'  => 'Detalles de Pago',
                    'payment-method'   => 'Método de Pago',
                    'status'           => 'Estado',
                    'title'            => 'Detalles de la Transacción',
                    'transaction-id'   => 'ID de Transacción',
                ],
            ],
        ],

        'booking' => [
            'index' => [
                'datagrid' => [
                    'created-date' => 'Fecha de Creación',
                    'from'         => 'Desde',
                    'id'           => 'ID',
                    'order-id'     => 'ID de Pedido',
                    'qty'          => 'Cantidad',
                    'to'           => 'Hasta',
                    'view'         => 'Ver',
                ],

                'title'    => 'Reservas',
            ],

            'calendar' => [
                'booking-date'     => 'Fecha de Reserva',
                'booking-details'  => 'Detalles de la Reserva',
                'canceled'         => 'Cancelado',
                'closed'           => 'Cerrado',
                'done'             => 'Hecho',
                'order-id'         => 'ID de Pedido',
                'pending'          => 'Pendiente',
                'price'            => 'Precio',
                'status'           => 'Estado',
                'time-slot'        => 'Franja Horaria:',
                'view-details'     => 'Ver Detalles',
            ],

            'title' => 'Producto de Reservas',
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => 'El :name ya ha sido tomado.',
                'create-btn'    => 'Crear producto',
                'title'         => 'Productos',

                'create' => [
                    'back-btn'                => 'Volver',
                    'configurable-attributes' => 'Atributos Configurables',
                    'create-btn'              => 'Crear producto',
                    'family'                  => 'Familia',
                    'save-btn'                => 'Guardar producto',
                    'sku'                     => 'SKU',
                    'title'                   => 'Crear nuevo producto',
                    'type'                    => 'Tipo',
                ],

                'datagrid' => [
                    'active'                 => 'Activo',
                    'attribute-family'       => 'Familia de atributos',
                    'attribute-family-value' => 'Familia de atributos - :attribute_family',
                    'category'               => 'Categoría',
                    'channel'                => 'Canal',
                    'copy-of'                => 'Copia de :value',
                    'copy-of-slug'           => 'copia-de-:value',
                    'delete'                 => 'Eliminar',
                    'disable'                => 'Desactivar',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => 'Imagen',
                    'mass-delete-success'    => 'Productos seleccionados eliminados exitosamente',
                    'mass-update-success'    => 'Productos seleccionados actualizados exitosamente',
                    'name'                   => 'Nombre',
                    'out-of-stock'           => 'Agotado',
                    'price'                  => 'Precio',
                    'product-image'          => 'Imagen del producto',
                    'qty'                    => 'Cantidad',
                    'qty-value'              => ':qty Disponible',
                    'sku'                    => 'SKU',
                    'sku-value'              => 'SKU - :sku',
                    'status'                 => 'Estado',
                    'type'                   => 'Tipo',
                    'update-status'          => 'Actualizar estado',
                ],
            ],

            'edit' => [
                'preview'  => 'Vista previa',
                'remove'   => 'Eliminar',
                'save-btn' => 'Guardar producto',
                'title'    => 'Editar producto',

                'channels' => [
                    'title' => 'Canales',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'Agregar precio de grupo',
                        'all-groups'                => 'Todas las categorías',
                        'create-btn'                => 'Agregar nuevo',
                        'discount-group-price-info' => 'Para qty Cantidad con un descuento de :price',
                        'edit-btn'                  => 'Editar',
                        'empty-info'                => 'Precios especiales para clientes que pertenecen a un grupo específico.',
                        'fixed-group-price-info'    => 'Para qty Cantidad a un precio fijo de :price',
                        'title'                     => 'Precio de grupo de cliente',

                        'create' => [
                            'all-groups'     => 'Todas las categorías',
                            'create-title'   => 'Crear precio de grupo de cliente',
                            'customer-group' => 'Grupo de cliente',
                            'delete-btn'     => 'Eliminar',
                            'discount'       => 'Descuento',
                            'fixed'          => 'Fijo',
                            'price'          => 'Precio',
                            'price-type'     => 'Tipo de precio',
                            'qty'            => 'Cantidad mínima',
                            'save-btn'       => 'Guardar',
                            'update-title'   => 'Actualizar precio de grupo de cliente',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => 'Cantidad pendiente de pedido: :qty',
                    'pending-ordered-qty-info' => 'La cantidad pendiente de pedido se deducirá de la fuente de inventario respectiva después del envío. En caso de cancelación, la cantidad pendiente estará disponible para la venta.',
                    'title'                    => 'Inventarios',
                ],

                'categories' => [
                    'title' => 'Categorías',
                ],

                'images' => [
                    'info'  => 'La resolución de la imagen debe ser de alrededor de 560px X 609px',
                    'title' => 'Imágenes',
                ],

                'videos' => [
                    'error' => 'El :attribute no debe ser mayor que :max kilobytes. Por favor, selecciona un archivo más pequeño.',
                    'info'  => 'El tamaño máximo del video debe ser de aproximadamente :size',
                    'title' => 'Videos',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => 'Agregar productos relacionados sobre la marcha.',
                        'info'       => 'Además del producto que está viendo el cliente, se le presentan productos relacionados.',
                        'title'      => 'Productos relacionados',
                    ],

                    'up-sells' => [
                        'empty-info' => 'Agregar productos para upsell sobre la marcha.',
                        'info'       => 'Se presenta al cliente productos de upsell, que sirven como una alternativa premium o de mayor calidad al producto que está viendo actualmente.',
                        'title'      => 'Productos de upsell',
                    ],

                    'cross-sells' => [
                        'empty-info' => 'Agregar productos de venta cruzada sobre la marcha.',
                        'info'       => 'Junto al carrito de compras, encontrará estos productos de "compra impulsiva" posicionados como productos de venta cruzada para complementar los artículos que ya ha agregado a su carrito.',
                        'title'      => 'Productos de venta cruzada',
                    ],

                    'add-btn'           => 'Agregar producto',
                    'delete'            => 'Eliminar',
                    'empty-info'        => 'Para agregar productos :type sobre la marcha.',
                    'empty-title'       => 'Agregar producto',
                    'image-placeholder' => 'Imagen del producto',
                    'sku'               => 'SKU - :sku',
                ],

                'types' => [
                    'simple' => [
                        'customizable-options' => [
                            'add-btn'           => 'Agregar opción',
                            'empty-info'        => 'Para crear opciones personalizables al instante.',
                            'empty-title'       => 'Agregar opción',
                            'info'              => 'Esto personalizará el producto simple.',
                            'title'             => 'Elemento personalizable',

                            'update-create' => [
                                'is-required'               => 'Es obligatorio',
                                'max-characters'            => 'Máximo de caracteres',
                                'name'                      => 'Título',
                                'no'                        => 'No',
                                'price'                     => 'Precio',
                                'save-btn'                  => 'Guardar',
                                'supported-file-extensions' => 'Extensiones de archivo admitidas',
                                'title'                     => 'Opción',
                                'type'                      => 'Tipo',
                                'yes'                       => 'Sí',
                            ],

                            'option' => [
                                'add-btn'     => 'Agregar opción',
                                'delete'      => 'Eliminar',
                                'delete-btn'  => 'Eliminar',
                                'edit-btn'    => 'Editar',
                                'empty-info'  => 'Para crear varias combinaciones de productos al instante.',
                                'empty-title' => 'Agregar opción',

                                'types' => [
                                    'text' => [
                                        'title' => 'Texto',
                                    ],

                                    'textarea' => [
                                        'title' => 'Área de texto',
                                    ],

                                    'checkbox' => [
                                        'title' => 'Casilla de verificación',
                                    ],

                                    'radio' => [
                                        'title' => 'Botón de opción',
                                    ],

                                    'select' => [
                                        'title' => 'Seleccionar',
                                    ],

                                    'multiselect' => [
                                        'title' => 'Selección múltiple',
                                    ],

                                    'date' => [
                                        'title' => 'Fecha',
                                    ],

                                    'datetime' => [
                                        'title' => 'Fecha y hora',
                                    ],

                                    'time' => [
                                        'title' => 'Hora',
                                    ],

                                    'file' => [
                                        'title' => 'Archivo',
                                    ],
                                ],

                                'items' => [
                                    'update-create' => [
                                        'label'    => 'Etiqueta',
                                        'price'    => 'Precio',
                                        'save-btn' => 'Guardar',
                                        'title'    => 'Opción',
                                    ],
                                ],
                            ],

                            'validations' => [
                                'associated-product' => 'El producto ya está asociado con un producto configurable, agrupado o en paquete.',
                            ],
                        ],
                    ],

                    'configurable' => [
                        'add-btn'           => 'Agregar variante',
                        'delete-btn'        => 'Eliminar',
                        'edit-btn'          => 'Editar',
                        'empty-info'        => 'Para crear varias combinaciones de productos sobre la marcha.',
                        'empty-title'       => 'Agregar variante',
                        'image-placeholder' => ':qty Cantidad',
                        'info'              => 'Los productos de variación dependen de todas las posibles combinaciones de atributos.',
                        'qty'               => ':qty Cantidad',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Variantes',

                        'create' => [
                            'description'            => 'Descripción',
                            'name'                   => 'Nombre',
                            'save-btn'               => 'Agregar',
                            'title'                  => 'Agregar variante',
                            'variant-already-exists' => 'Esta variante ya existe',
                        ],

                        'edit' => [
                            'disabled'        => 'Deshabilitado',
                            'edit-info'       => 'Si desea actualizar la información del producto en detalle, vaya a la',
                            'edit-link-title' => 'Página de detalles del producto',
                            'enabled'         => 'Habilitado',
                            'images'          => 'Imágenes',
                            'name'            => 'Nombre',
                            'price'           => 'Precio',
                            'quantities'      => 'Cantidades',
                            'save-btn'        => 'Guardar',
                            'sku'             => 'SKU',
                            'status'          => 'Estado',
                            'title'           => 'Producto',
                            'weight'          => 'Peso',
                        ],

                        'mass-edit' => [
                            'add-images'          => 'Agregar Imágenes',
                            'apply-to-all-btn'    => 'Aplicar a Todos',
                            'apply-to-all-name'   => 'Aplicar un nombre a todas las variantes.',
                            'apply-to-all-sku'    => 'Aplicar un precio a todas las SKU.',
                            'apply-to-all-status' => 'Aplicar un estado a todas las variantes.',
                            'apply-to-all-weight' => 'Aplicar un peso a todas las variantes.',
                            'edit-inventories'    => 'Editar Inventarios',
                            'edit-names'          => 'Editar Nombres',
                            'edit-prices'         => 'Editar Precios',
                            'edit-sku'            => 'Editar SKU',
                            'edit-status'         => 'Editar Estado',
                            'edit-weight'         => 'Editar Peso',
                            'name'                => 'Nombre',
                            'price'               => 'Precio',
                            'remove-images'       => 'Eliminar Imágenes',
                            'remove-variants'     => 'Eliminar Variantes',
                            'select-action'       => 'Seleccionar Acción',
                            'select-variants'     => 'Seleccionar Variantes',
                            'status'              => 'Estado',
                            'variant-name'        => 'Nombre de la Variante',
                            'variant-sku'         => 'SKU de la Variante',
                            'weight'              => 'Peso',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => 'Agregar producto',
                        'default-qty'       => 'Cantidad predeterminada',
                        'delete'            => 'Eliminar',
                        'empty-info'        => 'Para crear varias combinaciones de productos sobre la marcha.',
                        'empty-title'       => 'Agregar producto',
                        'image-placeholder' => 'Imagen del producto',
                        'info'              => 'Un producto agrupado consta de artículos independientes presentados como un conjunto, lo que permite variaciones o coordinación por temporada o tema. Cada producto se puede comprar individualmente o como parte del grupo.',
                        'sku'               => 'SKU - :sku',
                        'title'             => 'Productos agrupados',
                    ],

                    'bundle' => [
                        'add-btn'           => 'Agregar opción',
                        'empty-info'        => 'Para crear opciones de paquete sobre la marcha.',
                        'empty-title'       => 'Agregar opción',
                        'image-placeholder' => 'Imagen del producto',
                        'info'              => 'Un producto de paquete es un paquete de varios artículos o servicios que se venden juntos a un precio especial, ofreciendo valor y comodidad a los clientes.',
                        'title'             => 'Ítems de paquete',

                        'update-create' => [
                            'checkbox'    => 'Casilla de verificación',
                            'is-required' => 'Es requerido',
                            'multiselect' => 'Selección múltiple',
                            'name'        => 'Título',
                            'no'          => 'No',
                            'radio'       => 'Radio',
                            'save-btn'    => 'Guardar',
                            'select'      => 'Seleccionar',
                            'title'       => 'Opción',
                            'type'        => 'Tipo',
                            'yes'         => 'Sí',
                        ],

                        'option' => [
                            'add-btn'     => 'Agregar producto',
                            'default-qty' => 'Cantidad predeterminada',
                            'delete'      => 'Eliminar',
                            'delete-btn'  => 'Eliminar',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Para crear varias combinaciones de productos sobre la marcha.',
                            'empty-title' => 'Agregar producto',
                            'sku'         => 'SKU - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'Establezca el producto predeterminado utilizando una casilla de verificación.',
                                    'title' => 'Casilla de verificación',
                                ],

                                'multiselect' => [
                                    'info'  => 'Establezca el producto predeterminado utilizando un botón de casilla de verificación múltiple.',
                                    'title' => 'Selección múltiple',
                                ],

                                'radio' => [
                                    'info'  => 'Establezca el producto predeterminado utilizando un botón de radio.',
                                    'title' => 'Radio',
                                ],

                                'select' => [
                                    'info'  => 'Establezca el producto predeterminado utilizando un botón de selección.',
                                    'title' => 'Seleccionar',
                                ],
                            ],
                        ],
                    ],

                    'booking' => [
                        'available-from' => 'Disponible Desde',
                        'available-to'   => 'Disponible Hasta',
                        'location'       => 'Ubicación',
                        'qty'            => 'Cantidad',
                        'title'          => 'Tipo de Reserva',

                        'available-every-week' => [
                            'no'    => 'No',
                            'title' => 'Disponible Cada Semana',
                            'yes'   => 'Sí',
                        ],

                        'appointment' => [
                            'break-duration'         => 'Tiempo de Descanso entre Slots (Minutos)',
                            'slot-duration'          => 'Duración del Slot (Minutos)',

                            'same-slot-for-all-days' => [
                                'no'    => 'No',
                                'title' => 'Mismo Slot Para Todos los Días',
                                'yes'   => 'Sí',
                            ],
                        ],

                        'default' => [
                            'add'              => 'Agregar',
                            'break-duration'   => 'Tiempo de Descanso entre Slots (Minutos)',
                            'close'            => 'Cerrar',
                            'description'      => 'Información de la Reserva',
                            'description-info' => 'De acuerdo con las franjas horarias, se creará y se mostrará la duración del tiempo. Será única en todos los slots y será visible en la tienda en línea',
                            'edit'             => 'Editar',
                            'many'             => 'Muchas Reservas Para Un Día',
                            'one'              => 'Una Reserva Para Muchos Días',
                            'open'             => 'Abrir',
                            'slot-add'         => 'Agregar Slots',
                            'slot-duration'    => 'Duración del Slot (Minutos)',
                            'slot-title'       => 'Duración del Tiempo de los Slots',
                            'title'            => 'Predeterminado',
                            'unavailable'      => 'No Disponible',

                            'modal'            => [
                                'slot' => [
                                    'add-title'  => 'Agregar Slots',
                                    'close'      => 'Cerrar',
                                    'day'        => 'Día',
                                    'edit-title' => 'Editar Slots',
                                    'friday'     => 'Viernes',
                                    'from'       => 'Desde',
                                    'from-day'   => 'Desde el Día',
                                    'from-time'  => 'Desde la Hora',
                                    'monday'     => 'Lunes',
                                    'open'       => 'Abrir',
                                    'saturday'   => 'Sábado',
                                    'save'       => 'Guardar',
                                    'select'     => 'Seleccionar',
                                    'status'     => 'Estado',
                                    'sunday'     => 'Domingo',
                                    'thursday'   => 'Jueves',
                                    'to'         => 'Hasta',
                                    'to-day'     => 'Hasta el Día',
                                    'to-time'    => 'Hasta la Hora',
                                    'tuesday'    => 'Martes',
                                    'wednesday'  => 'Miércoles',
                                    'week'       => ':día',
                                ],
                            ],
                        ],

                        'event' => [
                            'add'                => 'Agregar Entradas',
                            'delete'             => 'Eliminar',
                            'description'        => 'Descripción',
                            'description-info'   => 'No hay entradas disponibles.',
                            'edit'               => 'Editar',
                            'name'               => 'Nombre',
                            'price'              => 'Precio',
                            'qty'                => 'Cantidad',
                            'special-price'      => 'Precio Especial',
                            'special-price-from' => 'Precio Especial Desde',
                            'special-price-to'   => 'Precio Especial Hasta',
                            'title'              => 'Entradas',
                            'valid-from'         => 'Válido Desde',
                            'valid-until'        => 'Válido Hasta',

                            'modal'              => [
                                'edit' => 'Editar Entradas',
                                'save' => 'Guardar',
                            ],
                        ],

                        'empty-info' => [
                            'tickets' => [
                                'add' => 'Agregar Entradas',
                            ],

                            'slots'   => [
                                'add'         => 'Agregar Slots',
                                'description' => 'Slots Disponibles con Duración de Tiempo.',
                            ],
                        ],

                        'rental' => [
                            'daily'                  => 'Base Diaria',
                            'daily-hourly'           => 'Ambos (Base Diaria y por Hora)',
                            'daily-price'            => 'Precio Diario',
                            'hourly'                 => 'Base por Hora',
                            'hourly-price'           => 'Precio por Hora',
                            'title'                  => 'Tipo de Alquiler',

                            'same-slot-for-all-days' => [
                                'no'    => 'No',
                                'title' => 'Mismo Slot Para Todos los Días',
                                'yes'   => 'Sí',
                            ],
                        ],

                        'slots' => [
                            'add'              => 'Agregar Slots',
                            'description-info' => 'De acuerdo con las franjas horarias, se creará y se mostrará la duración del tiempo. Será única en todos los slots y será visible en la tienda en línea',
                            'save'             => 'Guardar',
                            'title'            => 'Duración del Tiempo de los Slots',
                            'unavailable'      => 'No Disponible',

                            'action' => [
                                'add' => 'Agregar',
                            ],

                            'modal' => [
                                'slot' => [
                                    'friday'     => 'Viernes',
                                    'from'       => 'Desde',
                                    'monday'     => 'Lunes',
                                    'saturday'   => 'Sábado',
                                    'sunday'     => 'Domingo',
                                    'thursday'   => 'Jueves',
                                    'to'         => 'Hasta',
                                    'tuesday'    => 'Martes',
                                    'wednesday'  => 'Miércoles',
                                ],
                            ],
                        ],

                        'table' => [
                            'break-duration'            => 'Tiempo de Descanso entre Slots (Minutos)',
                            'guest-capacity'            => 'Capacidad de Huéspedes',
                            'guest-limit'               => 'Límite de Huéspedes por Mesa',
                            'prevent-scheduling-before' => 'Prevenir Programación Antes de',
                            'slot-duration'             => 'Duración del Slot (Minutos)',

                            'charged-per' => [
                                'guest'  => 'Huésped',
                                'table'  => 'Mesa',
                                'title'  => 'Cobrado Por',
                            ],

                            'same-slot-for-all-days' => [
                                'no'    => 'No',
                                'title' => 'Mismo Slot Para Todos los Días',
                                'yes'   => 'Sí',
                            ],
                        ],

                        'type' => [
                            'appointment' => 'Reserva de Cita',
                            'default'     => 'Reserva Predeterminada',
                            'event'       => 'Reserva de Evento',
                            'many'        => 'Muchas',
                            'one'         => 'Una',
                            'rental'      => 'Reserva de Alquiler',
                            'table'       => 'Reserva de Mesa',
                            'title'       => 'Tipo',
                        ],

                        'validations' => [
                            'type-mismatch'      => 'El tipo de reserva no se puede cambiar.',
                            'time-validation'    => 'La hora de inicio debe ser menor que la hora de finalización.',
                            'overlap-validation' => 'El intervalo de tiempo se superpone con un intervalo existente.',
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'Agregar enlace',
                            'delete-btn'  => 'Eliminar',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Para crear un enlace sobre la marcha.',
                            'empty-title' => 'Agregar enlace',
                            'file'        => 'Archivo: ',
                            'info'        => 'El tipo de producto descargable permite vender productos digitales como libros electrónicos, aplicaciones de software, música, juegos, etc.',
                            'sample-file' => 'Archivo de ejemplo: ',
                            'sample-url'  => 'URL de ejemplo: ',
                            'title'       => 'Enlaces descargables',
                            'url'         => 'URL: ',

                            'update-create' => [
                                'downloads'   => 'Descarga permitida',
                                'file'        => 'Archivo',
                                'file-type'   => 'Tipo de archivo',
                                'name'        => 'Título',
                                'price'       => 'Precio',
                                'sample'      => 'Muestra',
                                'sample-type' => 'Tipo de muestra',
                                'save-btn'    => 'Guardar',
                                'title'       => 'Enlace',
                                'url'         => 'URL',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'Agregar muestra',
                            'delete-btn'  => 'Eliminar',
                            'edit-btn'    => 'Editar',
                            'empty-info'  => 'Para crear una muestra sobre la marcha.',
                            'empty-title' => 'Agregar muestra',
                            'file'        => 'Archivo: ',
                            'info'        => 'El tipo de producto descargable permite vender productos digitales como libros electrónicos, aplicaciones de software, música, juegos, etc.',
                            'title'       => 'Muestras descargables',
                            'url'         => 'URL: ',

                            'update-create' => [
                                'file'        => 'Archivo',
                                'file-type'   => 'Tipo de archivo',
                                'name'        => 'Título',
                                'save-btn'    => 'Guardar',
                                'title'       => 'Enlace',
                                'url'         => 'URL',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => 'Producto creado exitosamente',
            'delete-failed'           => 'Error al eliminar el producto',
            'delete-success'          => 'Producto eliminado exitosamente',
            'product-copied'          => 'Producto copiado exitosamente',
            'saved-inventory-message' => 'Producto guardado exitosamente',
            'update-success'          => 'Producto actualizado exitosamente',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => 'Crear Atributos',
                'title'      => 'Atributos',

                'datagrid' => [
                    'boolean'             => 'Booleano',
                    'channel-based'       => 'Basado en canal',
                    'checkbox'            => 'Casilla de verificación',
                    'code'                => 'Código',
                    'created-at'          => 'Creado en',
                    'date'                => 'Fecha',
                    'date-time'           => 'Fecha y hora',
                    'delete'              => 'Eliminar',
                    'edit'                => 'Editar',
                    'false'               => 'Falso',
                    'file'                => 'Archivo',
                    'id'                  => 'ID',
                    'image'               => 'Imagen',
                    'locale-based'        => 'Basado en la localización',
                    'mass-delete-success' => 'Atributo seleccionado eliminado con éxito',
                    'multiselect'         => 'Selección múltiple',
                    'name'                => 'Nombre',
                    'price'               => 'Precio',
                    'required'            => 'Requerido',
                    'select'              => 'Seleccionar',
                    'text'                => 'Texto',
                    'textarea'            => 'Área de texto',
                    'true'                => 'Verdadero',
                    'type'                => 'Tipo',
                    'unique'              => 'Único',
                ],
            ],

            'create' => [
                'add-attribute-options' => 'Agregar Opciones de Atributo',
                'add-option'            => 'Agregar Opción',
                'add-options-info'      => 'Para crear varias combinaciones de Opciones de Atributo en el momento.',
                'add-row'               => 'Agregar Fila',
                'admin'                 => 'Admin',
                'admin-name'            => 'Nombre de Admin',
                'back-btn'              => 'Atrás',
                'boolean'               => 'Booleano',
                'checkbox'              => 'Casilla de Verificación',
                'code'                  => 'Código del Atributo',
                'color'                 => 'Color',
                'configuration'         => 'Configuración',
                'create-empty-option'   => 'Crear opción vacía predeterminada',
                'date'                  => 'Fecha',
                'datetime'              => 'Fecha y Hora',
                'decimal'               => 'Decimal',
                'default-value'         => 'Valor predeterminado',
                'email'                 => 'Correo Electrónico',
                'enable-wysiwyg'        => 'Habilitar Editor WYSIWYG',
                'file'                  => 'Archivo',
                'general'               => 'General',
                'image'                 => 'Imagen',
                'input-options'         => 'Opciones de Entrada',
                'input-validation'      => 'Validación de Entrada',
                'is-comparable'         => 'El Atributo es Comparativo',
                'is-configurable'       => 'Usar para Crear Productos Configurables',
                'is-filterable'         => 'Usar en Navegación por Capas',
                'is-required'           => 'Es Requerido',
                'is-unique'             => 'Es Único',
                'is-visible-on-front'   => 'Visible en la Página de Visualización de Productos en el Front-end',
                'label'                 => 'Etiqueta',
                'multiselect'           => 'Selección Múltiple',
                'no'                    => 'No',
                'numeric'               => 'Número',
                'option-deleted'        => 'Opción eliminada exitosamente',
                'options'               => 'Opciones',
                'position'              => 'Posición',
                'price'                 => 'Precio',
                'regex'                 => 'Expresión Regular',
                'regex-info'            => 'La expresión debe estar entre comillas dobles.',
                'save-btn'              => 'Guardar Atributo',
                'select'                => 'Seleccionar',
                'select-type'           => 'Tipo de Atributo de Selección',
                'swatch'                => 'Muestra de Color',
                'text'                  => 'Texto',
                'textarea'              => 'Área de Texto',
                'title'                 => 'Agregar Atributo',
                'type'                  => 'Tipo de Atributo',
                'url'                   => 'URL',
                'use-in-flat'           => 'Crear en Tabla Plana de Productos',
                'validations'           => 'Validaciones',
                'value-per-channel'     => 'Valor por Canal',
                'value-per-locale'      => 'Valor por Localización',
                'yes'                   => 'Sí',

                'option' => [
                    'color'    => 'Muestra de Color',
                    'dropdown' => 'Desplegable',
                    'image'    => 'Muestra de Imagen',
                    'save-btn' => 'Guardar Opción',
                    'text'     => 'Muestra de Texto',
                ],
            ],

            'edit' => [
                'add-attribute-options'  => 'Agregar Opciones de Atributo',
                'add-option'             => 'Agregar Opción',
                'add-options-info'       => 'Para crear varias combinaciones de Opciones de Atributo en el momento.',
                'add-row'                => 'Agregar Fila',
                'admin'                  => 'Admin',
                'admin-name'             => 'Nombre de Admin',
                'back-btn'               => 'Atrás',
                'boolean'                => 'Booleano',
                'checkbox'               => 'Casilla de Verificación',
                'code'                   => 'Código del Atributo',
                'color'                  => 'Color',
                'configuration'          => 'Configuración',
                'create-empty-option'    => 'Crear opción vacía predeterminada',
                'date'                   => 'Fecha',
                'datetime'               => 'Fecha y Hora',
                'decimal'                => 'Decimal',
                'default-value'          => 'Valor predeterminado',
                'email'                  => 'Correo Electrónico',
                'enable-wysiwyg'         => 'Habilitar Editor WYSIWYG',
                'file'                   => 'Archivo',
                'general'                => 'General',
                'image'                  => 'Imagen',
                'input-options'          => 'Opciones de Entrada',
                'input-validation'       => 'Validación de Entrada',
                'is-comparable'          => 'El Atributo es Comparativo',
                'is-configurable'        => 'Usar para Crear Productos Configurables',
                'is-filterable'          => 'Usar en Navegación por Capas',
                'is-required'            => 'Es Requerido',
                'is-unique'              => 'Es Único',
                'is-visible-on-front'    => 'Visible en la Página de Visualización de Productos en el Front-end',
                'label'                  => 'Etiqueta',
                'multiselect'            => 'Selección Múltiple',
                'no'                     => 'No',
                'numeric'                => 'Número',
                'option-deleted'         => 'Opción eliminada exitosamente',
                'options'                => 'Opciones',
                'position'               => 'Posición',
                'price'                  => 'Precio',
                'regex'                  => 'Expresión Regular',
                'regex-info'             => 'La expresión debe estar entre comillas dobles.',
                'save-btn'               => 'Guardar Atributo',
                'select'                 => 'Seleccionar',
                'select-type'            => 'Tipo de Atributo de Selección',
                'swatch'                 => 'Muestra de Color',
                'text'                   => 'Texto',
                'textarea'               => 'Área de Texto',
                'title'                  => 'Editar Atributo',
                'type'                   => 'Tipo de Atributo',
                'url'                    => 'URL',
                'use-in-flat'            => 'Crear en Tabla Plana de Productos',
                'validations'            => 'Validaciones',
                'value-per-channel'      => 'Valor por Canal',
                'value-per-locale'       => 'Valor por Localización',
                'yes'                    => 'Sí',

                'option' => [
                    'color'     => 'Muestra de Color',
                    'dropdown'  => 'Desplegable',
                    'image'     => 'Muestra de Imagen',
                    'save-btn'  => 'Guardar Opción',
                    'text'      => 'Muestra de Texto',
                ],
            ],

            'create-success'    => 'Atributo Creado Exitosamente',
            'delete-failed'     => 'Error al Eliminar el Atributo',
            'delete-success'    => 'Atributo Eliminado Exitosamente',
            'update-success'    => 'Atributo Actualizado Exitosamente',
            'user-define-error' => 'No se puede eliminar el Atributo del Sistema',
        ],

        'categories' => [
            'index' => [
                'add-btn' => 'Crear Categoría',
                'title'   => 'Categorías',

                'datagrid' => [
                    'active'         => 'Activo',
                    'delete'         => 'Eliminar',
                    'delete-success' => 'Las :resource seleccionadas se eliminaron correctamente',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'inactive'       => 'Inactivo',
                    'name'           => 'Nombre',
                    'no-of-products' => 'Visible en el menú',
                    'position'       => 'Posición',
                    'status'         => 'Estado',
                    'update-status'  => 'Actualizar Estado',
                ],
            ],

            'create' => [
                'add-banner'               => 'Agregar Banner',
                'add-logo'                 => 'Agregar Logo',
                'back-btn'                 => 'Atrás',
                'banner'                   => 'Banner',
                'banner-size'              => 'Proporción de aspecto del banner (1320px X 300px)',
                'description'              => 'Descripción',
                'description-and-images'   => 'Descripción e Imágenes',
                'description-only'         => 'Solo Descripción',
                'display-mode'             => 'Modo de Visualización',
                'enter-position'           => 'Ingresar Posición',
                'filterable-attributes'    => 'Atributos Filtrables',
                'general'                  => 'General',
                'logo'                     => 'Logo',
                'logo-size'                => 'La resolución del logo debe ser (110px X 110px)',
                'meta-description'         => 'Meta Descripción',
                'meta-keywords'            => 'Meta Palabras Clave',
                'meta-title'               => 'Meta Título',
                'name'                     => 'Nombre',
                'parent-category'          => 'Categoría Padre',
                'position'                 => 'Posición',
                'products-and-description' => 'Productos y Descripción',
                'products-only'            => 'Solo Productos',
                'save-btn'                 => 'Guardar Categoría',
                'select-display-mode'      => 'Seleccionar Modo de Visualización',
                'seo-details'              => 'Detalles de SEO',
                'settings'                 => 'Configuraciones',
                'slug'                     => 'Slug',
                'title'                    => 'Agregar Nueva Categoría',
                'visible-in-menu'          => 'Visible en el Menú',
            ],

            'edit' => [
                'add-banner'               => 'Agregar Banner',
                'add-logo'                 => 'Agregar Logo',
                'back-btn'                 => 'Atrás',
                'banner'                   => 'Banner',
                'banner-size'              => 'Proporción de aspecto del banner (1320px X 300px)',
                'description'              => 'Descripción',
                'description-and-images'   => 'Descripción e Imágenes',
                'description-only'         => 'Solo Descripción',
                'display-mode'             => 'Modo de Visualización',
                'enter-position'           => 'Ingresar Posición',
                'filterable-attributes'    => 'Atributos Filtrables',
                'general'                  => 'General',
                'logo'                     => 'Logo',
                'logo-size'                => 'La resolución del logo debe ser (110px X 110px)',
                'meta-description'         => 'Meta Descripción',
                'meta-keywords'            => 'Meta Palabras Clave',
                'meta-title'               => 'Meta Título',
                'name'                     => 'Nombre',
                'position'                 => 'Posición*',
                'products-and-description' => 'Productos y Descripción',
                'products-only'            => 'Solo Productos',
                'save-btn'                 => 'Guardar Categoría',
                'select-display-mode'      => 'Seleccionar Modo de Visualización',
                'select-parent-category'   => 'Seleccionar Categoría Padre*',
                'seo-details'              => 'Detalles de SEO',
                'settings'                 => 'Configuraciones',
                'slug'                     => 'Slug',
                'title'                    => 'Editar Categoría',
                'visible-in-menu'          => 'Visible en el Menú',
            ],

            'category'             => 'Categoría',
            'create-success'       => 'Categoría creada con éxito.',
            'delete-category-root' => 'No se puede eliminar la categoría raíz.',
            'delete-failed'        => 'Se produjo un error al eliminar la categoría',
            'delete-success'       => 'La categoría se eliminó con éxito.',
            'update-success'       => 'Categoría actualizada con éxito.',
        ],

        'families' => [
            'index' => [
                'add'    => 'Crear Familia de Atributos',
                'title'  => 'Familias',

                'datagrid' => [
                    'code'           => 'Código',
                    'delete'         => 'Eliminar',
                    'delete-success' => ':resource seleccionadas se eliminaron correctamente',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'method-error'   => 'Error. Método incorrecto detectado, por favor, verifica la configuración de acción masiva',
                    'name'           => 'Nombre',
                    'no-resource'    => 'El recurso proporcionado no es suficiente para la acción',
                    'partial-action' => 'Algunas acciones no se pudieron realizar debido a restricciones del sistema en :resource',
                    'update-success' => ':resource seleccionadas se actualizaron correctamente',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'Agregar Grupo',
                'add-group-title'                  => 'Agregar Nuevo Grupo',
                'back-btn'                         => 'Atrás',
                'code'                             => 'Código',
                'column'                           => 'Columna',
                'delete-group-btn'                 => 'Eliminar Grupo',
                'edit-group-info'                  => 'Doble clic para editar el Grupo',
                'enter-code'                       => 'Ingresar Código',
                'enter-name'                       => 'Ingresar Nombre',
                'general'                          => 'General',
                'group-code-already-exists'        => 'Ya existe un código de grupo de atributos.',
                'group-contains-system-attributes' => 'Este grupo contiene atributos del sistema. Primero mueve los atributos del sistema a otro grupo y luego inténtalo de nuevo.',
                'group-name-already-exists'        => 'Ya existe un nombre de grupo de atributos.',
                'groups'                           => 'Grupos',
                'groups-info'                      => 'Administrar grupos de familia de atributos',
                'main-column'                      => 'Columna Principal',
                'name'                             => 'Nombre',
                'removal-not-possible'             => 'No puedes eliminar atributos del sistema de la familia de atributos.',
                'right-column'                     => 'Columna de la Derecha',
                'save-btn'                         => 'Guardar Familia de Atributos',
                'select-group'                     => 'Por favor, selecciona un grupo de atributos.',
                'title'                            => 'Crear Familia de Atributos',
                'unassigned-attributes'            => 'Atributos no asignados',
                'unassigned-attributes-info'       => 'Arrastra estos atributos para agregarlos a las columnas o grupos.',
            ],

            'edit' => [
                'add-group-btn'                    => 'Agregar Grupo',
                'add-group-title'                  => 'Agregar Nuevo Grupo',
                'back-btn'                         => 'Atrás',
                'code'                             => 'Código',
                'column'                           => 'Columna',
                'delete-group-btn'                 => 'Eliminar Grupo',
                'edit-group-info'                  => 'Doble clic para editar el Grupo',
                'enter-code'                       => 'Ingresar Código',
                'enter-name'                       => 'Ingresar Nombre',
                'general'                          => 'General',
                'group-code-already-exists'        => 'Ya existe un código de grupo de atributos.',
                'group-contains-system-attributes' => 'Este grupo contiene atributos del sistema. Primero mueve los atributos del sistema a otro grupo y luego inténtalo de nuevo.',
                'group-name-already-exists'        => 'Ya existe un nombre de grupo de atributos.',
                'groups'                           => 'Grupos',
                'groups-info'                      => 'Administrar grupos de familia de atributos',
                'main-column'                      => 'Columna Principal',
                'name'                             => 'Nombre',
                'removal-not-possible'             => 'No puedes eliminar atributos del sistema de la familia de atributos.',
                'right-column'                     => 'Columna de la Derecha',
                'save-btn'                         => 'Guardar Familia de Atributos',
                'select-group'                     => 'Por favor, selecciona un grupo de atributos.',
                'title'                            => 'Editar Familia de Atributos',
                'unassigned-attributes'            => 'Atributos no asignados',
                'unassigned-attributes-info'       => 'Arrastra estos atributos para agregarlos a las columnas o grupos.',
            ],

            'attribute-family'        => 'Familia de Atributos',
            'attribute-product-error' => 'La familia se utiliza en productos.',
            'create-success'          => 'Familia creada con éxito.',
            'delete-failed'           => 'Se produjo un error al eliminar la familia.',
            'delete-success'          => 'Familia eliminada con éxito.',
            'family'                  => 'Familia',
            'last-delete-error'       => 'Se requiere al menos una familia.',
            'update-success'          => 'Familia actualizada con éxito.',
            'user-define-error'       => 'No se puede eliminar la familia de atributos del sistema',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => 'Clientes',
                'login-message' => 'Has iniciado sesión como :customer_name',

                'datagrid' => [
                    'active'         => 'Activo',
                    'address'        => ':address  Dirección(es)',
                    'address-count'  => 'Cantidad de Direcciones',
                    'channel'        => 'Canal',
                    'delete'         => 'Eliminar',
                    'delete-success' => 'Datos seleccionados eliminados correctamente',
                    'email'          => 'Correo Electrónico',
                    'gender'         => 'Género',
                    'group'          => 'Grupo',
                    'id'             => 'ID de Cliente',
                    'id-value'       => 'ID - :id',
                    'inactive'       => 'Inactivo',
                    'method-error'   => '¡Error! Método incorrecto detectado, por favor revisa la configuración de la acción masiva',
                    'name'           => 'Nombre del Cliente',
                    'no-resource'    => 'El recurso proporcionado no es suficiente para la acción',
                    'order'          => ':order Pedido(s)',
                    'order-count'    => 'Cantidad de Pedidos',
                    'order-pending'  => 'El cliente tiene pedidos pendientes',
                    'partial-action' => 'Algunas acciones no se realizaron debido a restricciones del sistema en :resource',
                    'phone'          => 'Número de Contacto',
                    'revenue'        => 'Ingresos',
                    'status'         => 'Estado',
                    'suspended'      => 'Suspendido',
                    'update-status'  => 'Actualizar Estado',
                    'update-success' => 'Clientes seleccionados actualizados correctamente',
                ],

                'create' => [
                    'contact-number'        => 'Número de Contacto',
                    'create-btn'            => 'Crear Cliente',
                    'create-success'        => 'Cliente creado exitosamente',
                    'customer-group'        => 'Grupo de Clientes',
                    'date-of-birth'         => 'Fecha de Nacimiento',
                    'email'                 => 'Correo Electrónico',
                    'female'                => 'Femenino',
                    'first-name'            => 'Primer Nombre',
                    'gender'                => 'Género',
                    'last-name'             => 'Apellido',
                    'male'                  => 'Masculino',
                    'other'                 => 'Otro',
                    'save-btn'              => 'Guardar Cliente',
                    'select-customer-group' => 'Seleccionar Grupo de Cliente',
                    'select-gender'         => 'Seleccionar Género',
                    'title'                 => 'Crear Nuevo Cliente',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => '¿Estás seguro de que deseas eliminar esta cuenta?',
                'active'                      => 'Activo',
                'address-delete-confirmation' => '¿Estás seguro de que deseas eliminar esta dirección?',
                'back-btn'                    => 'Volver',
                'create-order'                => 'Crear Pedido',
                'customer'                    => 'Cliente',
                'date-of-birth'               => 'DOB - :dob',
                'default-address'             => 'Dirección predeterminada',
                'delete-account'              => 'Eliminar cuenta',
                'delete'                      => 'Eliminar',
                'email'                       => 'Email - :email',
                'empty-description'           => 'Crea nuevas direcciones para el cliente',
                'empty-title'                 => 'Agregar dirección del cliente',
                'gender'                      => 'Género - :gender',
                'group'                       => 'Grupo - :group_code',
                'inactive'                    => 'Inactivo',
                'login-as-customer'           => 'Iniciar sesión como cliente',
                'note-created-success'        => 'Nota creada exitosamente',
                'order-create-confirmation'   => '¿Estás seguro de que deseas crear un pedido para este cliente?',
                'phone'                       => 'Teléfono - :phone',
                'set-as-default'              => 'Establecer como predeterminado',
                'suspended'                   => 'Suspendido',
                'title'                       => 'Vista del cliente',

                'address' => [
                    'count'  => 'Direcciones (:count)',

                    'create' => [
                        'city'               => 'Ciudad',
                        'company-name'       => 'Nombre de la empresa',
                        'country'            => 'País',
                        'create-btn'         => 'Crear',
                        'create-address-btn' => 'Agregar nueva dirección',
                        'default-address'    => 'Dirección predeterminada',
                        'email'              => 'Email',
                        'first-name'         => 'Nombre',
                        'last-name'          => 'Apellido',
                        'phone'              => 'Teléfono',
                        'post-code'          => 'Código postal',
                        'save-btn-title'     => 'Guardar dirección',
                        'select-country'     => 'Seleccionar país',
                        'state'              => 'Estado',
                        'street-address'     => 'Dirección',
                        'title'              => 'Crear dirección',
                        'vat-id'             => 'ID de IVA',
                    ],

                    'edit' => [
                        'city'            => 'Ciudad',
                        'company-name'    => 'Nombre de la empresa',
                        'country'         => 'País',
                        'default-address' => 'Dirección predeterminada',
                        'edit-btn'        => 'Editar',
                        'email'           => 'Email',
                        'first-name'      => 'Nombre',
                        'last-name'       => 'Apellido',
                        'phone'           => 'Teléfono',
                        'post-code'       => 'Código postal',
                        'save-btn-title'  => 'Guardar dirección',
                        'select-country'  => 'Seleccionar país',
                        'state'           => 'Estado',
                        'street-address'  => 'Dirección',
                        'title'           => 'Editar dirección',
                        'vat-id'          => 'ID de IVA',
                    ],

                    'address-delete-success' => 'Dirección eliminada exitosamente',
                    'create-success'         => 'Dirección creada exitosamente',
                    'set-default-success'    => 'Dirección predeterminada actualizada exitosamente',
                    'success-mass-delete'    => 'Eliminación masiva de direcciones exitosa',
                    'update-success'         => 'Dirección actualizada exitosamente',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'No hay reseñas disponibles',
                        'increment-id'   => 'ID de la factura',
                        'invoice-amount' => 'Monto de la factura',
                        'invoice-date'   => 'Fecha de la factura',
                        'order-id'       => 'ID del pedido',
                        'view'           => 'Ver',
                    ],

                    'orders' => [
                        'canceled'        => 'Cancelado',
                        'channel-name'    => 'Nombre del canal',
                        'closed'          => 'Cerrado',
                        'completed'       => 'Completado',
                        'customer-name'   => 'Nombre del cliente',
                        'date'            => 'Fecha',
                        'empty-order'     => 'No hay pedidos disponibles',
                        'email'           => 'Email',
                        'fraud'           => 'Fraude',
                        'grand-total'     => 'Total general',
                        'location'        => 'Ubicación',
                        'order-id'        => 'ID del pedido',
                        'pay-via'         => 'Pagar con',
                        'pending'         => 'Pendiente',
                        'pending-payment' => 'Pago pendiente',
                        'processing'      => 'Procesando',
                        'status'          => 'Estado',
                        'view'            => 'Ver',
                    ],

                    'reviews' => [
                        'approved'      => 'Aprobado',
                        'comment'       => 'Comentario',
                        'created-at'    => 'Creado el',
                        'disapproved'   => 'Desaprobado',
                        'empty-reviews' => 'No hay facturas disponibles',
                        'id'            => 'ID',
                        'invoice-date'  => 'Fecha de la factura',
                        'pending'       => 'Pendiente',
                        'product-id'    => 'ID del producto',
                        'product-name'  => 'Nombre del producto',
                        'rating'        => 'Calificación',
                        'status'        => 'Estado',
                        'title'         => 'Título',
                    ],
                ],

                'edit' => [
                    'contact-number'        => 'Número de contacto',
                    'customer-group'        => 'Grupo de clientes',
                    'date-of-birth'         => 'Fecha de nacimiento',
                    'edit-btn'              => 'Editar',
                    'email'                 => 'Email',
                    'female'                => 'Femenino',
                    'first-name'            => 'Nombre',
                    'gender'                => 'Género',
                    'last-name'             => 'Apellido',
                    'male'                  => 'Masculino',
                    'other'                 => 'Otro',
                    'save-btn'              => 'Guardar cliente',
                    'select-customer-group' => 'Seleccionar grupo de clientes',
                    'select-gender'         => 'Seleccionar género',
                    'status'                => 'Estado',
                    'suspended'             => 'Suspendido',
                    'title'                 => 'Editar cliente',
                ],

                'invoices' => [
                    'count'        => 'Facturas (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'Agregar nota',
                    'customer-not-notified' => ':date | Cliente <b>No notificado</b>',
                    'customer-notified'     => ':date | Cliente <b>Notificado</b>',
                    'note'                  => 'Nota',
                    'note-placeholder'      => 'Escribe tu nota aquí',
                    'notify-customer'       => 'Notificar al cliente',
                    'submit-btn-title'      => 'Enviar nota',
                ],

                'orders' => [
                    'count'         => 'Pedidos (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => 'Ingresos totales - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => 'Reseñas (:count)',
                ],

                'cart' => [
                    'delete-success' => 'Elemento del carrito eliminado exitosamente.',
                ],

                'wishlist' => [
                    'delete-success' => 'Elemento de la lista de deseos eliminado exitosamente.',
                ],

                'compare' => [
                    'delete-success' => 'Elemento de comparación eliminado exitosamente.',
                ],
            ],

            'delete-failed'  => 'Eliminación del cliente fallida',
            'delete-success' => 'Cliente eliminado exitosamente',
            'order-pending'  => 'Existen pedidos pendientes',
            'update-success' => 'Cliente actualizado exitosamente',
        ],

        'groups' => [
            'index' => [
                'title' => 'Grupos',

                'create' => [
                    'code'       => 'Código',
                    'create-btn' => 'Crear Grupo',
                    'name'       => 'Nombre',
                    'save-btn'   => 'Guardar Grupo',
                    'success'    => 'Grupo creado con éxito',
                    'title'      => 'Crear Nuevo Grupo',
                ],

                'edit'  => [
                    'delete-failed'  => 'Error al Eliminar el Grupo',
                    'delete-success' => 'Grupo Eliminado Exitosamente',
                    'group-default'  => 'No se puede eliminar el Grupo Predeterminado',
                    'success'        => 'Grupo Actualizado Exitosamente',
                    'title'          => 'Editar Grupo',
                ],

                'datagrid'  => [
                    'code'    => 'Código',
                    'delete'  => 'Eliminar',
                    'edit'    => 'Editar',
                    'id'      => 'ID',
                    'name'    => 'Nombre',
                ],
            ],
        ],

        'gdpr' => [
            'index' => [
                'title' => 'Solicitud de GDPR',

                'datagrid' => [
                    'completed'     => 'Completado',
                    'created-at'    => 'Creado en',
                    'customer-name' => 'Nombre del Cliente',
                    'declined'      => 'Rechazado',
                    'delete'        => 'Eliminar',
                    'edit'          => 'Editar',
                    'id'            => 'ID',
                    'message'       => 'Mensaje',
                    'pending'       => 'Pendiente',
                    'processing'    => 'Procesando',
                    'revoked'       => 'Widerrufen',
                    'status'        => 'Estado',
                    'type'          => 'Tipo',
                ],

                'modal' => [
                    'completed'     => 'Completado',
                    'declined'      => 'Rechazado',
                    'message'       => 'Mensaje',
                    'pending'       => 'Pendiente',
                    'processing'    => 'Procesando',
                    'revoked'       => 'Widerrufen',
                    'save-btn'      => 'Guardar',
                    'status'        => 'Estado',
                    'title'         => 'Editar Solicitud de Datos GDPR',
                    'type'          => 'Tipo',
                ],

                'update-success'              => 'Solicitud de Datos actualizada con éxito y correo electrónico enviado al cliente.',
                'delete-success'              => 'Solicitud de Datos eliminada con éxito.',
                'attribute-reason-error'      => 'No se puede eliminar.',
                'update-success-unsent-email' => 'Solicitud de Datos actualizada con éxito pero correo electrónico no enviado al cliente.',
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => 'Fecha',
                'description' => 'Descripción',
                'id'          => 'ID',
                'name'        => 'Nombre',
                'product'     => 'Producto',
                'rating'      => 'Calificación',
                'status'      => 'Estado',
                'title'       => 'Reseñas',

                'edit' => [
                    'approved'       => 'Aprobado',
                    'customer'       => 'Cliente',
                    'date'           => 'Fecha',
                    'disapproved'    => 'Desaprobado',
                    'id'             => 'ID',
                    'images'         => 'Imágenes',
                    'pending'        => 'Pendiente',
                    'product'        => 'Producto',
                    'rating'         => 'Calificación',
                    'review-comment' => 'Comentario',
                    'review-title'   => 'Título',
                    'save-btn'       => 'Guardar',
                    'status'         => 'Estado',
                    'title'          => 'Editar Reseña',
                    'update-success' => 'Actualización Exitosa',
                ],

                'datagrid' => [
                    'approved'               => 'Aprobado',
                    'comment'                => 'Comentario',
                    'customer-names'         => 'Nombre',
                    'date'                   => 'Fecha',
                    'delete'                 => 'Eliminar',
                    'delete-success'         => 'Reseña Eliminada Exitosamente',
                    'disapproved'            => 'Desaprobado',
                    'edit'                   => 'Editar',
                    'id'                     => 'ID',
                    'mass-delete-error'      => 'Algo salió mal',
                    'mass-delete-success'    => 'Reseñas Seleccionadas Eliminadas Exitosamente',
                    'mass-update-success'    => 'Reseñas Seleccionadas Actualizadas Exitosamente',
                    'pending'                => 'Pendiente',
                    'product'                => 'Producto',
                    'rating'                 => 'Calificación',
                    'review-id'              => 'ID - :review_id',
                    'status'                 => 'Estado',
                    'title'                  => 'Título',
                    'update-status'          => 'Actualizar Estado',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'Crear Plantilla',
                    'title'      => 'Plantillas de Correo Electrónico',

                    'datagrid' => [
                        'active'   => 'Activo',
                        'draft'    => 'Borrador',
                        'id'       => 'ID',
                        'inactive' => 'Inactivo',
                        'name'     => 'Nombre',
                        'status'   => 'Estado',
                    ],
                ],

                'create' => [
                    'active'         => 'Activo',
                    'back-btn'       => 'Atrás',
                    'content'        => 'Contenido',
                    'create-success' => 'Plantilla de correo electrónico creada exitosamente.',
                    'draft'          => 'Borrador',
                    'general'        => 'General',
                    'inactive'       => 'Inactivo',
                    'name'           => 'Nombre',
                    'save-btn'       => 'Guardar Plantilla',
                    'select-status'  => 'Seleccionar Estado',
                    'status'         => 'Estado',
                    'title'          => 'Crear Plantilla',
                ],

                'edit' => [
                    'active'         => 'Activo',
                    'back-btn'       => 'Atrás',
                    'content'        => 'Contenido*',
                    'draft'          => 'Borrador',
                    'general'        => 'General',
                    'inactive'       => 'Inactivo',
                    'name'           => 'Nombre',
                    'save-btn'       => 'Guardar Plantilla',
                    'status'         => 'Estado',
                    'title'          => 'Editar Plantilla',
                    'update-success' => 'Actualizado exitosamente',
                ],

                'delete-failed'  => ':name Eliminación Fallida',
                'delete-success' => 'Plantilla eliminada exitosamente',
                'email-template' => 'Plantilla de Correo Electrónico',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn' => 'Crear Campaña',
                    'title'      => 'Campañas',

                    'datagrid' => [
                        'active'   => 'Activo',
                        'delete'   => 'Eliminar',
                        'edit'     => 'Editar',
                        'id'       => 'ID',
                        'inactive' => 'Inactivo',
                        'name'     => 'Nombre',
                        'status'   => 'Estado',
                        'subject'  => 'Asunto',
                    ],
                ],

                'create' => [
                    'active'          => 'Activo',
                    'back-btn'        => 'Atrás',
                    'channel'         => 'Canal',
                    'customer-group'  => 'Grupo de clientes',
                    'email-template'  => 'Plantilla de correo electrónico',
                    'event'           => 'Evento',
                    'general'         => 'General',
                    'inactive'        => 'Inactivo',
                    'name'            => 'Nombre',
                    'save-btn'        => 'Guardar campaña',
                    'select-channel'  => 'Seleccionar canal',
                    'select-event'    => 'Seleccionar evento',
                    'select-group'    => 'Seleccionar grupo',
                    'select-status'   => 'Seleccionar estado',
                    'select-template' => 'Seleccionar plantilla',
                    'setting'         => 'Configuración',
                    'status'          => 'Estado',
                    'subject'         => 'Asunto',
                    'title'           => 'Crear campaña',
                ],

                'edit' => [
                    'active'          => 'Activo',
                    'audience'        => 'Audiencia',
                    'back-btn'        => 'Atrás',
                    'channel'         => 'Canal',
                    'customer-group'  => 'Grupo de clientes',
                    'email-template'  => 'Plantilla de correo electrónico',
                    'event'           => 'Evento',
                    'general'         => 'General',
                    'inactive'        => 'Inactivo',
                    'name'            => 'Nombre',
                    'save-btn'        => 'Guardar campaña',
                    'select-event'    => 'Seleccionar evento',
                    'select-status'   => 'Seleccionar estado',
                    'select-template' => 'Seleccionar plantilla',
                    'status'          => 'Estado',
                    'subject'         => 'Asunto',
                    'title'           => 'Editar campaña',
                ],

                'create-success' => 'Campaña creada exitosamente.',
                'delete-failed'  => ':name Eliminación fallida',
                'delete-success' => 'Campaña eliminada exitosamente',
                'email-campaign' => 'Campaña por correo electrónico',
                'update-success' => 'Campaña actualizada exitosamente.',
            ],

            'events' => [
                'index'  => [
                    'create-btn' => 'Crear Evento',
                    'event'      => 'Evento',
                    'title'      => 'Eventos',

                    'datagrid' => [
                        'actions' => 'Acciones',
                        'date'    => 'Fecha',
                        'delete'  => 'Eliminar',
                        'edit'    => 'Editar',
                        'id'      => 'ID',
                        'name'    => 'Nombre',
                    ],

                    'create' => [
                        'date'           => 'Fecha',
                        'delete-warning' => '¿Estás seguro de que deseas realizar esta acción?',
                        'description'    => 'Descripción',
                        'general'        => 'General',
                        'name'           => 'Nombre',
                        'save-btn'       => 'Guardar Evento',
                        'success'        => 'Eventos Creados Exitosamente',
                        'title'          => 'Crear Eventos',
                    ],

                    'edit'  => [
                        'success' => 'Eventos Actualizados Exitosamente',
                        'title'   => 'Editar Eventos',
                    ],
                ],

                'delete-failed'  => 'Eliminación de :name Fallida',
                'delete-success' => 'Eventos Eliminados Exitosamente',
                'edit-error'     => 'No se puede editar el Evento',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'Suscripciones al boletín',

                    'datagrid' => [
                        'actions'    => 'Acciones',
                        'delete'     => 'Eliminar',
                        'edit'       => 'Editar',
                        'email'      => 'Correo electrónico',
                        'false'      => 'Falso',
                        'id'         => 'ID',
                        'subscribed' => 'Suscrito',
                        'true'       => 'Verdadero',
                    ],

                    'edit' => [
                        'back-btn'      => 'Atrás',
                        'email'         => 'Correo electrónico',
                        'false'         => 'Falso',
                        'save-btn'      => 'Guardar suscriptor',
                        'subscribed'    => 'Suscrito',
                        'success'       => 'Suscripción al boletín actualizada con éxito',
                        'title'         => 'Editar suscriptor del boletín',
                        'true'          => 'Verdadero',
                        'update-failed' => 'No se actualizó la suscripción al boletín',
                    ],
                ],

                'delete-failed'  => 'Error al eliminar el suscriptor',
                'delete-success' => 'Suscriptor eliminado con éxito',
                'delete-warning' => '¿Estás seguro de que quieres realizar esta acción?',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => 'Reglas del Carrito',
                'catalog-rule-title' => 'Reglas de Catálogo',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'Crear Regla del Carrito',
                    'title'      => 'Reglas del Carrito',

                    'datagrid' => [
                        'active'      => 'Activo',
                        'copy'        => 'Copiar',
                        'copy-of'     => ':valor',
                        'coupon-code' => 'Código de Cupón',
                        'delete'      => 'Eliminar',
                        'draft'       => 'Borrador',
                        'edit'        => 'Editar',
                        'end'         => 'Fin',
                        'id'          => 'ID',
                        'inactive'    => 'Inactivo',
                        'name'        => 'Nombre',
                        'priority'    => 'Prioridad',
                        'start'       => 'Inicio',
                        'status'      => 'Estado',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'Tipo de Acción',
                    'actions'                                   => 'Acciones',
                    'add-condition'                             => 'Agregar Condición',
                    'additional'                                => 'Adicional',
                    'all-conditions-true'                       => 'Todas las Condiciones Son Verdaderas',
                    'any-conditions-true'                       => 'Cualquier Condición Es Verdadera',
                    'apply-to-shipping'                         => 'Aplicar al Envío',
                    'attribute-family'                          => 'Familia de Atributos',
                    'attribute-name-children-only'              => ':attribute_name (Solo Hijos)',
                    'attribute-name-parent-only'                => ':attribute_name (Solo Padres)',
                    'auto-generate-coupon'                      => 'Generación Automática de Cupón',
                    'back-btn'                                  => 'Volver',
                    'buy-x-get-y-free'                          => 'Comprar X y Obtener Y Gratis',
                    'buy-x-quantity'                            => 'Comprar X Cantidad',
                    'cart-attribute'                            => 'Atributo del Carrito',
                    'cart-item-attribute'                       => 'Atributo del Artículo del Carrito',
                    'categories'                                => 'Categorías',
                    'channels'                                  => 'Canales',
                    'children-categories'                       => 'Categorías Hijas',
                    'choose-condition-to-add'                   => 'Elegir condición para agregar',
                    'condition-type'                            => 'Tipo de Condición',
                    'conditions'                                => 'Condiciones',
                    'contain'                                   => 'Contiene',
                    'contains'                                  => 'Contiene',
                    'coupon-code'                               => 'Código de Cupón',
                    'coupon-type'                               => 'Tipo de Cupón',
                    'create-success'                            => 'Regla del carrito creada con éxito',
                    'customer-groups'                           => 'Grupos de Clientes',
                    'description'                               => 'Descripción',
                    'discount-amount'                           => 'Cantidad de Descuento',
                    'does-not-contain'                          => 'No Contiene',
                    'end-of-other-rules'                        => 'Fin de Otras Reglas',
                    'equals-or-greater-than'                    => 'Es Igual o Mayor Que',
                    'equals-or-less-than'                       => 'Es Igual o Menor Que',
                    'fixed-amount'                              => 'Cantidad Fija',
                    'fixed-amount-whole-cart'                   => 'Cantidad Fija para Todo el Carrito',
                    'free-shipping'                             => 'Envío Gratuito',
                    'from'                                      => 'Desde',
                    'general'                                   => 'General',
                    'greater-than'                              => 'Mayor Que',
                    'is-equal-to'                               => 'Es Igual a',
                    'is-not-equal-to'                           => 'No Es Igual a',
                    'less-than'                                 => 'Menor Que',
                    'marketing-time'                            => 'Tiempo de Marketing',
                    'maximum-quantity-allowed-to-be-discounted' => 'Cantidad Máxima Permitida para Descuento',
                    'name'                                      => 'Nombre',
                    'no'                                        => 'No',
                    'no-coupon'                                 => 'Sin Cupón',
                    'parent-categories'                         => 'Categorías Padres',
                    'payment-method'                            => 'Método de Pago',
                    'percentage-product-price'                  => 'Porcentaje del Precio del Producto',
                    'price-in-cart'                             => 'Precio en el Carrito',
                    'priority'                                  => 'Prioridad',
                    'product-attribute'                         => 'Atributo del Producto',
                    'qty-in-cart'                               => 'Cantidad en el Carrito',
                    'save-btn'                                  => 'Guardar Regla del Carrito',
                    'settings'                                  => 'Configuración',
                    'shipping-country'                          => 'País de Envío',
                    'shipping-method'                           => 'Método de Envío',
                    'shipping-postcode'                         => 'Código Postal de Envío',
                    'shipping-state'                            => 'Estado de Envío',
                    'specific-coupon'                           => 'Cupón Específico',
                    'status'                                    => 'Estado',
                    'subtotal'                                  => 'Subtotal',
                    'title'                                     => 'Crear Regla del Carrito',
                    'to'                                        => 'Hasta',
                    'total-items-qty'                           => 'Cantidad Total de Artículos',
                    'total-weight'                              => 'Peso Total',
                    'uses-per-coupon'                           => 'Usos por Cupón',
                    'uses-per-customer'                         => 'Usos por Cliente',
                    'uses-per-customer-control-info'            => 'Se utilizará solo para clientes registrados.',
                    'yes'                                       => 'Sí',
                ],

                'edit' => [
                    'action-type'                               => 'Tipo de Acción',
                    'actions'                                   => 'Acciones',
                    'add-condition'                             => 'Agregar Condición',
                    'additional'                                => 'Adicional',
                    'all-conditions-true'                       => 'Todas las Condiciones Son Verdaderas',
                    'alphabetical'                              => 'Alfabético',
                    'alphanumeric'                              => 'Alfanumérico',
                    'any-conditions-true'                       => 'Cualquier Condición Es Verdadera',
                    'apply-to-shipping'                         => 'Aplicar al Envío',
                    'attribute-family'                          => 'Familia de Atributos',
                    'attribute-name-children-only'              => ':attribute_name (Solo Hijos)',
                    'attribute-name-parent-only'                => ':attribute_name (Solo Padres)',
                    'auto-generate-coupon'                      => 'Generación Automática de Cupón',
                    'back-btn'                                  => 'Volver',
                    'buy-x-get-y-free'                          => 'Comprar X y Obtener Y Gratis',
                    'buy-x-quantity'                            => 'Comprar X Cantidad',
                    'cart-attribute'                            => 'Atributo del Carrito',
                    'cart-item-attribute'                       => 'Atributo del Artículo del Carrito',
                    'categories'                                => 'Categorías',
                    'channels'                                  => 'Canales',
                    'children-categories'                       => 'Categorías Hijas',
                    'choose-condition-to-add'                   => 'Elegir condición para agregar',
                    'code-format'                               => 'Formato del Código',
                    'code-prefix'                               => 'Prefijo del Código',
                    'code-suffix'                               => 'Sufijo del Código',
                    'condition-type'                            => 'Tipo de Condición',
                    'conditions'                                => 'Condiciones',
                    'contain'                                   => 'Contiene',
                    'contains'                                  => 'Contiene',
                    'coupon-code'                               => 'Código de Cupón',
                    'coupon-length'                             => 'Longitud del Cupón',
                    'coupon-qty'                                => 'Cantidad de Cupones',
                    'coupon-type'                               => 'Tipo de Cupón',
                    'customer-group'                            => 'Grupo de Clientes',
                    'customer-groups'                           => 'Grupos de Clientes',
                    'description'                               => 'Descripción',
                    'discount-amount'                           => 'Cantidad de Descuento',
                    'does-not-contain'                          => 'No Contiene',
                    'end-of-other-rules'                        => 'Fin de Otras Reglas',
                    'equals-or-greater-than'                    => 'Es Igual o Mayor Que',
                    'equals-or-less-than'                       => 'Es Igual o Menor Que',
                    'fixed-amount'                              => 'Cantidad Fija',
                    'fixed-amount-whole-cart'                   => 'Cantidad Fija para Todo el Carrito',
                    'free-shipping'                             => 'Envío Gratuito',
                    'from'                                      => 'Desde',
                    'general'                                   => 'General',
                    'generate'                                  => 'Generar',
                    'greater-than'                              => 'Mayor Que',
                    'is-equal-to'                               => 'Es Igual a',
                    'is-not-equal-to'                           => 'No Es Igual a',
                    'less-than'                                 => 'Menor Que',
                    'marketing-time'                            => 'Tiempo de Marketing',
                    'maximum-quantity-allowed-to-be-discounted' => 'Cantidad Máxima Permitida para Descuento',
                    'name'                                      => 'Nombre',
                    'no'                                        => 'No',
                    'no-coupon'                                 => 'Sin Cupón',
                    'numeric'                                   => 'Numérico',
                    'parent-categories'                         => 'Categorías Padres',
                    'payment-method'                            => 'Método de Pago',
                    'percentage-product-price'                  => 'Porcentaje del Precio del Producto',
                    'price-in-cart'                             => 'Precio en el Carrito',
                    'priority'                                  => 'Prioridad',
                    'product-attribute'                         => 'Atributo del Producto',
                    'qty-in-cart'                               => 'Cantidad en el Carrito',
                    'save-btn'                                  => 'Guardar Regla del Carrito',
                    'settings'                                  => 'Configuración',
                    'shipping-country'                          => 'País de Envío',
                    'shipping-method'                           => 'Método de Envío',
                    'shipping-postcode'                         => 'Código Postal de Envío',
                    'shipping-state'                            => 'Estado de Envío',
                    'specific-coupon'                           => 'Cupón Específico',
                    'status'                                    => 'Estado',
                    'subtotal'                                  => 'Subtotal',
                    'title'                                     => 'Editar Regla del Carrito',
                    'to'                                        => 'Hasta',
                    'total-items-qty'                           => 'Cantidad Total de Artículos',
                    'total-weight'                              => 'Peso Total',
                    'update-success'                            => 'Regla del carrito actualizada con éxito',
                    'uses-per-coupon'                           => 'Usos por Cupón',
                    'uses-per-customer'                         => 'Usos por Cliente',
                    'uses-per-customer-control-info'            => 'Se utilizará solo para clientes registrados.',
                    'yes'                                       => 'Sí',
                ],

                'delete-failed'  => 'Falló la Eliminación de la Regla del Carrito',
                'delete-success' => 'Regla del Carrito Eliminada Exitosamente',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => 'Crear Regla del Catálogo',
                    'title'      => 'Reglas del Catálogo',

                    'datagrid' => [
                        'active'   => 'Activo',
                        'delete'   => 'Eliminar',
                        'edit'     => 'Editar',
                        'end'      => 'Fin',
                        'id'       => 'ID',
                        'inactive' => 'Inactivo',
                        'name'     => 'Nombre',
                        'priority' => 'Prioridad',
                        'start'    => 'Inicio',
                        'status'   => 'Estado',
                    ],
                ],

                'create' => [
                    'action-type'              => 'Tipo de Acción',
                    'actions'                  => 'Acciones',
                    'add-condition'            => 'Agregar Condición',
                    'all-conditions-true'      => 'Todas las Condiciones son Verdaderas',
                    'any-conditions-true'      => 'Cualquier Condición es Verdadera',
                    'attribute-family'         => 'Familia de Atributos',
                    'back-btn'                 => 'Volver',
                    'categories'               => 'Categorías',
                    'channels'                 => 'Canales',
                    'choose-condition-to-add'  => 'Elegir Condición para Agregar',
                    'condition-type'           => 'Tipo de Condición',
                    'conditions'               => 'Condiciones',
                    'contain'                  => 'Contiene',
                    'contains'                 => 'Contiene',
                    'customer-groups'          => 'Grupos de Clientes',
                    'description'              => 'Descripción',
                    'discount-amount'          => 'Cantidad de Descuento',
                    'does-not-contain'         => 'No contiene',
                    'end-other-rules'          => 'Finalizar Otras Reglas',
                    'equals-or-greater-than'   => 'Es igual o mayor que',
                    'equals-or-less-than'      => 'Es igual o menor que',
                    'fixed-amount'             => 'Cantidad Fija',
                    'from'                     => 'Desde',
                    'general'                  => 'General',
                    'greater-than'             => 'Mayor que',
                    'is-equal-to'              => 'Es igual a',
                    'is-not-equal-to'          => 'No es igual a',
                    'less-than'                => 'Menor que',
                    'marketing-time'           => 'Tiempo de Marketing',
                    'name'                     => 'Nombre',
                    'no'                       => 'No',
                    'percentage-product-price' => 'Porcentaje del Precio del Producto',
                    'priority'                 => 'Prioridad',
                    'product-attribute'        => 'Atributo del Producto',
                    'save-btn'                 => 'Guardar Regla del Catálogo',
                    'settings'                 => 'Configuración',
                    'status'                   => 'Estado',
                    'title'                    => 'Crear Regla del Catálogo',
                    'to'                       => 'Hasta',
                    'yes'                      => 'Sí',
                ],

                'edit' => [
                    'action-type'              => 'Tipo de Acción',
                    'actions'                  => 'Acciones',
                    'add-condition'            => 'Agregar Condición',
                    'all-conditions-true'      => 'Todas las Condiciones son Verdaderas',
                    'any-conditions-true'      => 'Cualquier Condición es Verdadera',
                    'back-btn'                 => 'Volver',
                    'categories'               => 'Categorías',
                    'channels'                 => 'Canales',
                    'choose-condition-to-add'  => 'Elegir Condición para Agregar',
                    'condition-type'           => 'Tipo de Condición',
                    'conditions'               => 'Condiciones',
                    'contain'                  => 'Contiene',
                    'contains'                 => 'Contiene',
                    'customer-groups'          => 'Grupos de Clientes',
                    'description'              => 'Descripción',
                    'discount-amount'          => 'Cantidad de Descuento',
                    'does-not-contain'         => 'No contiene',
                    'end-other-rules'          => 'Finalizar Otras Reglas',
                    'equals-or-greater-than'   => 'Es igual o mayor que',
                    'equals-or-less-than'      => 'Es igual o menor que',
                    'fixed-amount'             => 'Cantidad Fija',
                    'from'                     => 'Desde',
                    'general'                  => 'General',
                    'greater-than'             => 'Mayor que',
                    'is-equal-to'              => 'Es igual a',
                    'is-not-equal-to'          => 'No es igual a',
                    'less-than'                => 'Menor que',
                    'marketing-time'           => 'Tiempo de Marketing',
                    'name'                     => 'Nombre',
                    'no'                       => 'No',
                    'percentage-product-price' => 'Porcentaje del Precio del Producto',
                    'priority'                 => 'Prioridad',
                    'product-attribute'        => 'Atributo del Producto',
                    'save-btn'                 => 'Guardar Regla del Catálogo',
                    'settings'                 => 'Configuración',
                    'status'                   => 'Estado',
                    'title'                    => 'Editar Regla del Catálogo',
                    'to'                       => 'Hasta',
                    'yes'                      => 'Sí',
                ],

                'create-success' => 'Regla del Catálogo creada exitosamente',
                'delete-success' => 'Regla del Catálogo eliminada exitosamente',
                'update-success' => 'Regla del Catálogo actualizada exitosamente',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => 'No se puede eliminar la regla del carrito',
                'delete-success'              => 'Cupón de regla del carrito eliminado con éxito',
                'mass-delete-success'         => 'Elementos seleccionados eliminados con éxito',
                'success'                     => ':name creado con éxito',

                'datagrid' => [
                    'coupon-code'     => 'Código de cupón',
                    'created-date'    => 'Fecha de creación',
                    'delete'          => 'Eliminar',
                    'expiration-date' => 'Fecha de caducidad',
                    'id'              => 'ID',
                    'times-used'      => 'Veces utilizado',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => 'Crear término de búsqueda',
                    'title'      => 'Términos de búsqueda',

                    'datagrid' => [
                        'actions'             => 'Acciones',
                        'channel'             => 'Canal',
                        'delete'              => 'Eliminar',
                        'edit'                => 'Editar',
                        'id'                  => 'ID',
                        'locale'              => 'Localización',
                        'mass-delete-success' => 'Términos de búsqueda seleccionados eliminados con éxito',
                        'redirect-url'        => 'URL de redirección',
                        'results'             => 'Resultados',
                        'search-query'        => 'Consulta de búsqueda',
                        'uses'                => 'Usos',
                    ],

                    'create' => [
                        'channel'        => 'Canal',
                        'delete-warning' => '¿Estás seguro de que quieres realizar esta acción?',
                        'locale'         => 'Localización',
                        'redirect-url'   => 'URL de redirección',
                        'results'        => 'Resultados',
                        'save-btn'       => 'Guardar término de búsqueda',
                        'search-query'   => 'Consulta de búsqueda',
                        'success'        => 'Término de búsqueda creado con éxito',
                        'title'          => 'Crear término de búsqueda',
                        'uses'           => 'Usos',
                    ],

                    'edit' => [
                        'delete-success' => 'Término de búsqueda eliminado con éxito',
                        'success'        => 'Término de búsqueda actualizado con éxito',
                        'title'          => 'Editar término de búsqueda',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => 'Crear Sinónimo de Búsqueda',
                    'title'      => 'Sinónimos de Búsqueda',

                    'datagrid' => [
                        'actions'             => 'Acciones',
                        'delete'              => 'Eliminar',
                        'edit'                => 'Editar',
                        'id'                  => 'ID',
                        'mass-delete-success' => 'Sinónimos de Búsqueda Seleccionados Eliminados con Éxito',
                        'name'                => 'Nombre',
                        'terms'               => 'Términos',
                    ],

                    'create' => [
                        'delete-warning' => '¿Estás seguro de que deseas realizar esta acción?',
                        'name'           => 'Nombre',
                        'save-btn'       => 'Guardar Sinónimo de Búsqueda',
                        'success'        => 'Sinónimo de Búsqueda creado exitosamente',
                        'terms'          => 'Términos',
                        'terms-info'     => 'Ingrese sinónimos como una lista separada por comas, por ejemplo, "zapatos, calzado." Esto amplía la búsqueda para incluir todos los términos.',
                        'title'          => 'Crear Sinónimo de Búsqueda',
                    ],

                    'edit' => [
                        'delete-success' => 'Sinónimo de Búsqueda eliminado exitosamente',
                        'success'        => 'Sinónimo de Búsqueda actualizado exitosamente',
                        'title'          => 'Editar Sinónimo de Búsqueda',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'Crear Mapa del sitio',
                    'sitemap'    => 'Mapa del sitio',
                    'title'      => 'Mapas del sitio',

                    'datagrid' => [
                        'actions'         => 'Acciones',
                        'delete'          => 'Eliminar',
                        'edit'            => 'Editar',
                        'file-name'       => 'Nombre del archivo',
                        'id'              => 'ID',
                        'link-for-google' => 'Enlace para Google',
                        'path'            => 'Ruta',
                    ],

                    'create' => [
                        'delete-warning' => '¿Estás seguro de que deseas realizar esta acción?',
                        'file-name'      => 'Nombre del archivo',
                        'file-name-info' => 'Ejemplo: sitemap.xml',
                        'path'           => 'Ruta',
                        'path-info'      => 'Ejemplo: "/sitemap/" o "/" para la ruta base',
                        'save-btn'       => 'Guardar Mapa del sitio',
                        'success'        => 'Mapa del sitio creado exitosamente',
                        'title'          => 'Crear Mapa del sitio',
                    ],

                    'edit' => [
                        'delete-success' => 'Mapa del sitio eliminado exitosamente',
                        'success'        => 'Mapa del sitio actualizado exitosamente',
                        'title'          => 'Editar Mapa del sitio',
                    ],
                ],

                'edit' => [
                    'back-btn'       => 'Volver',
                    'file-name'      => 'Nombre del archivo',
                    'file-name-info' => 'Ejemplo: sitemap.xml',
                    'general'        => 'General',
                    'path'           => 'Ruta',
                    'path-info'      => 'Ejemplo: "/sitemap/" o "/" para la ruta base',
                    'save-btn'       => 'Guardar Mapa del sitio',
                ],

                'delete-failed' => ':name Eliminado Fallido',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => 'Crear reescritura de URL',
                    'title'      => 'Reescrituras de URL',

                    'datagrid' => [
                        'actions'             => 'Acciones',
                        'category'            => 'Categoría',
                        'cms-page'            => 'Página de CMS',
                        'delete'              => 'Eliminar',
                        'edit'                => 'Editar',
                        'for'                 => 'Para',
                        'id'                  => 'ID',
                        'locale'              => 'Localización',
                        'mass-delete-success' => 'Reescrituras de URL seleccionadas eliminadas correctamente',
                        'permanent-redirect'  => 'Permanente (301)',
                        'product'             => 'Producto',
                        'redirect-type'       => 'Tipo de redirección',
                        'request-path'        => 'Ruta de solicitud',
                        'target-path'         => 'Ruta de destino',
                        'temporary-redirect'  => 'Temporal (302)',
                    ],

                    'create' => [
                        'category'           => 'Categoría',
                        'cms-page'           => 'Página de CMS',
                        'delete-warning'     => '¿Está seguro de que desea realizar esta acción?',
                        'for'                => 'Para',
                        'locale'             => 'Localización',
                        'permanent-redirect' => 'Permanente (301)',
                        'product'            => 'Producto',
                        'redirect-type'      => 'Tipo de redirección',
                        'request-path'       => 'Ruta de solicitud',
                        'save-btn'           => 'Guardar reescritura de URL',
                        'success'            => 'Reescritura de URL creada correctamente',
                        'target-path'        => 'Ruta de destino',
                        'temporary-redirect' => 'Temporal (302)',
                        'title'              => 'Crear reescritura de URL',
                    ],

                    'edit' => [
                        'delete-success' => 'Reescritura de URL eliminada correctamente',
                        'success'        => 'Reescritura de URL actualizada correctamente',
                        'title'          => 'Editar reescritura de URL',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => 'El :name ya ha sido tomado.',
            'channel'       => 'Canal',
            'create-btn'    => 'Crear Página',
            'language'      => 'Idioma',
            'title'         => 'Páginas',

            'datagrid' => [
                'channel'             => 'Canal',
                'delete'              => 'Eliminar',
                'edit'                => 'Editar',
                'id'                  => 'ID',
                'mass-delete-success' => 'Datos Seleccionados Eliminados Exitosamente',
                'page-title'          => 'Título de la Página',
                'url-key'             => 'Clave de URL',
                'view'                => 'Ver',
            ],
        ],

        'create' => [
            'channels'         => 'Canales',
            'content'          => 'Contenido',
            'description'      => 'Descripción',
            'general'          => 'General',
            'meta-description' => 'Meta Descripción',
            'meta-keywords'    => 'Meta Palabras Clave',
            'meta-title'       => 'Meta Título',
            'page-title'       => 'Título',
            'save-btn'         => 'Guardar Página',
            'seo'              => 'SEO',
            'title'            => 'Crear Página',
            'url-key'          => 'Clave de URL',
        ],

        'edit' => [
            'back-btn'         => 'Volver',
            'channels'         => 'Canales',
            'content'          => 'Contenido',
            'description'      => 'Descripción',
            'general'          => 'General',
            'meta-description' => 'Meta Descripción',
            'meta-keywords'    => 'Meta Palabras Clave',
            'meta-title'       => 'Meta Título',
            'page-title'       => 'Título de la Página',
            'preview-btn'      => 'Vista Previa de la Página',
            'save-btn'         => 'Guardar Página',
            'seo'              => 'SEO',
            'title'            => 'Editar Página',
            'url-key'          => 'Clave de URL',
        ],

        'create-success' => 'CMS creado exitosamente.',
        'delete-success' => 'CMS eliminado exitosamente.',
        'no-resource'    => 'El recurso no existe.',
        'update-success' => 'CMS actualizado exitosamente.',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => 'Crear Idioma',
                'locale'     => 'Idioma',
                'logo-size'  => 'La resolución de la imagen debe ser de 24px x 16px',
                'title'      => 'Idiomas',

                'datagrid' => [
                    'actions'   => 'Acciones',
                    'code'      => 'Código',
                    'delete'    => 'Eliminar',
                    'direction' => 'Dirección',
                    'edit'      => 'Editar',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => 'Nombre',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'Código',
                    'direction'        => 'Dirección',
                    'locale-logo'      => 'Logotipo del Idioma',
                    'name'             => 'Nombre',
                    'save-btn'         => 'Guardar Idioma',
                    'select-direction' => 'Seleccionar dirección',
                    'title'            => 'Crear Idioma',
                ],

                'edit' => [
                    'title'   => 'Editar Idioma',
                ],

                'create-success'    => 'Idioma creado exitosamente.',
                'delete-failed'     => 'Error al eliminar el idioma',
                'delete-success'    => 'Idioma eliminado exitosamente.',
                'delete-warning'    => '¿Estás seguro de que deseas realizar esta acción?',
                'last-delete-error' => 'Se requiere al menos un idioma.',
                'update-success'    => 'Idioma actualizado exitosamente.',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => 'Crear Moneda',
                'currency'   => 'Moneda',
                'title'      => 'Monedas',

                'datagrid' => [
                    'actions'        => 'Acciones',
                    'code'           => 'Código',
                    'delete'         => 'Eliminar',
                    'edit'           => 'Editar',
                    'id'             => 'ID',
                    'method-error'   => '¡Error! Se detectó un método incorrecto, por favor verifique la configuración de la acción masiva',
                    'name'           => 'Nombre',
                    'no-resource'    => 'El recurso proporcionado no es suficiente para la acción',
                    'partial-action' => 'Algunas acciones no se realizaron debido a restricciones del sistema en :resource',
                    'update-success' => ':resource seleccionadas se actualizaron correctamente',
                ],

                'create' => [
                    'code'                   => 'Código',
                    'create-btn'             => 'Crear Moneda',
                    'currency-position'      => 'Posición de la Moneda',
                    'decimal'                => 'Decimal',
                    'decimal-separator'      => 'Separador Decimal',
                    'decimal-separator-note' => 'El campo :attribute solo puede aceptar los operadores coma (,) y punto (.)',
                    'delete-warning'         => '¿Estás seguro de que deseas realizar esta acción?',
                    'general'                => 'General',
                    'group-separator'        => 'Separador de Grupos',
                    'group-separator-note'   => 'El campo :attribute solo puede aceptar los caracteres coma (,), punto (.), apóstrofe (\'), y espacio ( ).',
                    'name'                   => 'Nombre',
                    'save-btn'               => 'Guardar Moneda',
                    'symbol'                 => 'Símbolo',
                    'title'                  => 'Crear Nueva Moneda',
                ],

                'edit' => [
                    'title' => 'Editar Moneda',
                ],

                'create-success'    => 'Moneda creada exitosamente.',
                'delete-failed'     => 'Error al eliminar la Moneda',
                'delete-success'    => 'Moneda eliminada exitosamente.',
                'last-delete-error' => 'Se requiere al menos una Moneda.',
                'update-success'    => 'Moneda actualizada exitosamente.',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'Acción',
                    'allowed-errors'      => 'Errores Permitidos',
                    'back-btn'            => 'Volver',
                    'create-update'       => 'Crear/Actualizar',
                    'delete'              => 'Eliminar',
                    'download-sample'     => 'Descargar Muestra',
                    'field-separator'     => 'Separador de Campos',
                    'file-info-example'   => 'Por ejemplo, en caso de imágenes de productos, los archivos deben ubicarse en /project-root/storage/app/import/product-images',
                    'file-info'           => 'Usar la ruta relativa a /project-root/storage/app/import, por ejemplo, product-images, import-images.',
                    'file'                => 'Archivo',
                    'general'             => 'General',
                    'images-directory'    => 'Ruta del Directorio de Imágenes',
                    'process-in-queue'    => 'Procesar en Cola',
                    'results'             => 'Resultados',
                    'save-btn'            => 'Guardar Importación',
                    'settings'            => 'Configuraciones',
                    'skip-errors'         => 'Saltar Errores',
                    'stop-on-errors'      => 'Detener en Errores',
                    'title'               => 'Crear Importación',
                    'type'                => 'Tipo',
                    'validation-strategy' => 'Estrategia de Validación',
                ],

                'edit' => [
                    'action'              => 'Acción',
                    'allowed-errors'      => 'Errores Permitidos',
                    'back-btn'            => 'Volver',
                    'create-update'       => 'Crear/Actualizar',
                    'current-file'        => 'Archivo Subido Actual',
                    'delete'              => 'Eliminar',
                    'download-sample'     => 'Descargar Muestra',
                    'field-separator'     => 'Separador de Campos',
                    'file-info-example'   => 'Por ejemplo, en caso de imágenes de productos, los archivos deben ubicarse en /project-root/storage/import/app/product-images.',
                    'file-info'           => 'Usar la ruta relativa a /project-root/storage/app/import, por ejemplo, product-images, import-images.',
                    'file'                => 'Archivo',
                    'general'             => 'General',
                    'images-directory'    => 'Ruta del Directorio de Imágenes',
                    'process-in-queue'    => 'Procesar en Cola',
                    'results'             => 'Resultados',
                    'save-btn'            => 'Guardar Importación',
                    'settings'            => 'Configuraciones',
                    'skip-errors'         => 'Saltar Errores',
                    'stop-on-errors'      => 'Detener en Errores',
                    'title'               => 'Editar Importación',
                    'type'                => 'Tipo',
                    'validation-strategy' => 'Estrategia de Validación',
                ],

                'index' => [
                    'button-title' => 'Crear Importación',
                    'title'        => 'Importaciones',

                    'datagrid' => [
                        'actions'       => 'Acciones',
                        'completed-at'  => 'Completado en',
                        'created'       => 'Creado',
                        'delete'        => 'Eliminar',
                        'deleted'       => 'Eliminado',
                        'edit'          => 'Editar',
                        'error-file'    => 'Archivo de Error',
                        'id'            => 'ID',
                        'started-at'    => 'Iniciado en',
                        'state'         => 'Estado',
                        'summary'       => 'Resumen',
                        'updated'       => 'Actualizado',
                        'uploaded-file' => 'Archivo Subido',
                    ],
                ],

                'import' => [
                    'back-btn'                => 'Volver',
                    'completed-batches'       => 'Total de Lotes Completados:',
                    'download-error-report'   => 'Descargar Informe Completo',
                    'edit-btn'                => 'Editar',
                    'imported-info'           => '¡Felicidades! Tu importación fue exitosa.',
                    'importing-info'          => 'Importando en Proceso',
                    'indexing-info'           => 'Indexación de Recursos (Precio, Inventario y Búsqueda Elástica) en Progreso',
                    'linking-info'            => 'Vinculación de Recursos en Progreso',
                    'progress'                => 'Progreso:',
                    'title'                   => 'Importación',
                    'total-batches'           => 'Total de Lotes:',
                    'total-created'           => 'Total de Registros Creados:',
                    'total-deleted'           => 'Total de Registros Eliminados:',
                    'total-errors'            => 'Total de Errores:',
                    'total-invalid-rows'      => 'Total de Filas No Válidas:',
                    'total-rows-processed'    => 'Total de Filas Procesadas:',
                    'total-updated'           => 'Total de Registros Actualizados:',
                    'validate-info'           => 'Haz clic en Validar Datos para verificar tu importación.',
                    'validate'                => 'Validar',
                    'validating-info'         => 'Los datos están siendo leídos y validados',
                    'validation-failed-info'  => 'Tu importación no es válida. Por favor, corrige los siguientes errores e intenta nuevamente.',
                    'validation-success-info' => 'Tu importación es válida. Haz clic en Importar para comenzar el proceso de importación.',
                ],

                'create-success'    => 'Importación creada exitosamente.',
                'delete-failed'     => 'Error inesperado al eliminar la importación.',
                'delete-success'    => 'Importación eliminada exitosamente.',
                'not-valid'         => 'La importación no es válida',
                'nothing-to-import' => 'No hay recursos para importar.',
                'setup-queue-error' => 'Por favor, cambia tu controlador de cola a "database" o "redis" para iniciar el proceso de importación.',
                'update-success'    => 'Importación actualizada exitosamente.',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => 'Crear Tipo de Cambio',
                'exchange-rate' => 'Tipo de Cambio',
                'title'         => 'Tipos de Cambio',
                'update-rates'  => 'Actualizar Tipo de Cambio',

                'create' => [
                    'delete-warning'         => '¿Estás seguro de que deseas realizar esta acción?',
                    'rate'                   => 'Tasa',
                    'save-btn'               => 'Guardar Tipo de Cambio',
                    'select-target-currency' => 'Seleccionar moneda objetivo',
                    'source-currency'        => 'Moneda Fuente',
                    'target-currency'        => 'Moneda Objetivo',
                    'title'                  => 'Crear Tipo de Cambio',
                ],

                'edit' => [
                    'title'   => 'Editar Tipos de Cambio',
                ],

                'datagrid' => [
                    'actions'       => 'Acciones',
                    'currency-name' => 'Nombre de la Moneda',
                    'delete'        => 'Eliminar',
                    'edit'          => 'Editar',
                    'exchange-rate' => 'Tipo de Cambio',
                    'id'            => 'ID',
                ],

                'create-success' => 'Tipo de Cambio Creado Exitosamente',
                'delete-error'   => 'Error al Eliminar el Tipo de Cambio',
                'delete-success' => 'Tipo de Cambio Eliminado Exitosamente',
                'update-success' => 'Tipo de Cambio Actualizado Exitosamente',
            ],
        ],

        'inventory-sources' => [
            'index'  => [
                'create-btn' => 'Crear fuente de inventario',
                'title'      => 'Fuentes de Inventario',

                'datagrid' => [
                    'active'   => 'Activo',
                    'code'     => 'Código',
                    'delete'   => 'Eliminar',
                    'edit'     => 'Editar',
                    'id'       => 'ID',
                    'inactive' => 'Inactivo',
                    'name'     => 'Nombre',
                    'priority' => 'Prioridad',
                    'status'   => 'Estado',
                ],
            ],

            'create' => [
                'add-title'      => 'Agregar Fuente de Inventario',
                'address'        => 'Dirección de la Fuente',
                'back-btn'       => 'Volver',
                'city'           => 'Ciudad',
                'code'           => 'Código',
                'contact-email'  => 'Email',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Información de Contacto',
                'contact-name'   => 'Nombre',
                'contact-number' => 'Número de Contacto',
                'country'        => 'País',
                'description'    => 'Descripción',
                'general'        => 'General',
                'latitude'       => 'Latitud',
                'longitude'      => 'Longitud',
                'name'           => 'Nombre',
                'postcode'       => 'Código Postal',
                'priority'       => 'Prioridad',
                'save-btn'       => 'Guardar Fuente de Inventario',
                'select-country' => 'Seleccionar País',
                'select-state'   => 'Seleccionar Estado',
                'settings'       => 'Configuración',
                'state'          => 'Estado',
                'status'         => 'Estado',
                'street'         => 'Calle',
                'title'          => 'Fuentes de Inventario',
            ],

            'edit' => [
                'back-btn'          => 'Volver',
                'city'              => 'Ciudad',
                'code'              => 'Código',
                'contact-email'     => 'Email',
                'contact-fax'       => 'Fax',
                'contact-info'      => 'Información de Contacto',
                'contact-name'      => 'Nombre',
                'contact-number'    => 'Número de Contacto',
                'country'           => 'País',
                'description'       => 'Descripción',
                'general'           => 'General',
                'latitude'          => 'Latitud',
                'longitude'         => 'Longitud',
                'name'              => 'Nombre',
                'postcode'          => 'Código Postal',
                'priority'          => 'Prioridad',
                'save-btn'          => 'Guardar Fuentes de Inventario',
                'select-country'    => 'Seleccionar País',
                'select-state'      => 'Seleccionar Estado',
                'settings'          => 'Configuración',
                'source-address'    => 'Dirección de la Fuente',
                'state'             => 'Estado',
                'status'            => 'Estado',
                'street'            => 'Calle',
                'title'             => 'Editar Fuentes de Inventario',
            ],

            'create-success'    => 'Fuente de Inventario creada exitosamente',
            'delete-failed'     => 'Error al eliminar Fuentes de Inventario',
            'delete-success'    => 'Fuentes de Inventario eliminadas exitosamente',
            'last-delete-error' => 'No se pueden eliminar las últimas Fuentes de Inventario',
            'update-success'    => 'Fuentes de Inventario actualizadas exitosamente',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => '¿Estás seguro de que deseas eliminar?',
                    'tax-category'   => 'Categoría de Impuestos',
                    'title'          => 'Categorías de Impuestos',

                    'datagrid' => [
                        'actions' => 'Acciones',
                        'code'    => 'Código',
                        'delete'  => 'Eliminar',
                        'edit'    => 'Editar',
                        'id'      => 'ID',
                        'name'    => 'Nombre',
                    ],

                    'create' => [
                        'add-tax-rates' => 'Agregar Tasas de Impuestos',
                        'code'          => 'Código',
                        'description'   => 'Descripción',
                        'empty-text'    => 'Las Tasas de Impuestos no están disponibles, por favor crea nuevas Tasas de Impuestos.',
                        'general'       => 'Categoría de Impuestos',
                        'name'          => 'Nombre',
                        'save-btn'      => 'Guardar Categoría de Impuestos',
                        'select'        => 'Seleccionar',
                        'tax-rates'     => 'Tasas de Impuestos',
                        'title'         => 'Crear Categoría de Impuestos',
                    ],

                    'edit' => [
                        'title' => 'Editar Categorías de Impuestos',
                    ],

                    'can-not-delete' => 'No se pueden eliminar las categorías asignadas a las tasas de impuestos.',
                    'create-success' => 'Nueva Categoría de Impuestos Creada',
                    'delete-failed'  => 'Error al Eliminar Categoría de Impuestos',
                    'delete-success' => 'Categoría de Impuestos Eliminada Exitosamente',
                    'update-success' => 'Categoría de Impuestos Actualizada Exitosamente',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => 'Crear tasa de impuestos',
                    'tax-rate'     => 'Tasa de Impuestos',
                    'title'        => 'Tasas de Impuestos',

                    'datagrid' => [
                        'country'    => 'País',
                        'delete'     => 'Eliminar',
                        'edit'       => 'Editar',
                        'id'         => 'ID',
                        'identifier' => 'Identificador',
                        'state'      => 'Estado',
                        'tax-rate'   => 'Tasa de Impuestos',
                        'zip-code'   => 'Código Postal',
                        'zip-from'   => 'Desde Código Postal',
                        'zip-to'     => 'Hasta Código Postal',
                    ],
                ],

                'create' => [
                    'back-btn'       => 'Volver',
                    'country'        => 'País',
                    'general'        => 'General',
                    'identifier'     => 'Identificador',
                    'is-zip'         => 'Habilitar Rango de Código Postal',
                    'save-btn'       => 'Guardar Tasa de Impuestos',
                    'select-country' => 'Seleccionar País',
                    'select-state'   => 'Seleccionar Estado',
                    'settings'       => 'Configuración',
                    'state'          => 'Estado',
                    'tax-rate'       => 'Tasa',
                    'title'          => 'Crear Tasa de Impuestos',
                    'zip-code'       => 'Código Postal',
                    'zip-from'       => 'Desde Código Postal',
                    'zip-to'         => 'Hasta Código Postal',
                ],

                'edit' => [
                    'back-btn'       => 'Volver',
                    'country'        => 'País',
                    'identifier'     => 'Identificador',
                    'save-btn'       => 'Guardar Tasa de Impuestos',
                    'select-country' => 'Seleccionar País',
                    'select-state'   => 'Seleccionar Estado',
                    'settings'       => 'Configuración',
                    'state'          => 'Estado',
                    'tax-rate'       => 'Tasa',
                    'title'          => 'Editar Tasa de Impuestos',
                    'zip-code'       => 'Código Postal',
                    'zip-from'       => 'Desde Código Postal',
                    'zip-to'         => 'Hasta Código Postal',
                ],

                'create-success' => 'Tasa de Impuestos creada exitosamente.',
                'delete-failed'  => 'Error al eliminar Tasa de Impuestos',
                'delete-success' => 'Tasa de Impuestos eliminada exitosamente',
                'update-success' => 'Tasa de Impuestos Actualizada Exitosamente',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'Crear Canal',
                'delete-failed'     => 'Error al eliminar Canal',
                'delete-success'    => 'Canal eliminado exitosamente.',
                'last-delete-error' => 'Error al eliminar el último Canal.',
                'title'             => 'Canales',

                'datagrid' => [
                    'code'      => 'Código',
                    'delete'    => 'Eliminar',
                    'edit'      => 'Editar',
                    'host-name' => 'Nombre del Host',
                    'id'        => 'ID',
                    'name'      => 'Nombre',
                ],
            ],

            'create' => [
                'allowed-ips'             => 'IPs Permitidas',
                'cancel'                  => 'Volver',
                'code'                    => 'Código',
                'create-success'          => 'Canal creado exitosamente.',
                'currencies'              => 'Monedas',
                'currencies-and-locales'  => 'Monedas y Localidades',
                'default-currency'        => 'Moneda Predeterminada',
                'default-locale'          => 'Localidad Predeterminada',
                'description'             => 'Descripción',
                'design'                  => 'Diseño',
                'favicon'                 => 'Favicon',
                'favicon-size'            => 'La resolución de la imagen debe ser de 16px X 16px',
                'general'                 => 'General',
                'hostname'                => 'Nombre del Host',
                'hostname-placeholder'    => 'https://www.example.com (No agregar barra al final.)',
                'inventory-sources'       => 'Fuentes de Inventario',
                'last-delete-error'       => 'Se requiere al menos un Canal.',
                'locales'                 => 'Localidades',
                'logo'                    => 'Logo',
                'logo-size'               => 'La resolución de la imagen debe ser de 192px X 50px',
                'maintenance-mode-text'   => 'Mensaje',
                'name'                    => 'Nombre',
                'root-category'           => 'Categoría Raíz',
                'save-btn'                => 'Guardar Canal',
                'select-default-currency' => 'Seleccionar moneda predeterminada',
                'select-default-locale'   => 'Seleccionar idioma predeterminado',
                'select-root-category'    => 'Seleccionar categoría raíz',
                'select-theme'            => 'Seleccionar tema',
                'seo'                     => 'SEO de la página de inicio',
                'seo-description'         => 'Meta descripción',
                'seo-keywords'            => 'Meta palabras clave',
                'seo-title'               => 'Meta título',
                'settings'                => 'Configuración',
                'status'                  => 'Estado',
                'theme'                   => 'Tema',
                'title'                   => 'Crear Canal',
            ],

            'edit' => [
                'allowed-ips'            => 'IPs Permitidas',
                'back-btn'               => 'Volver',
                'code'                   => 'Código',
                'currencies'             => 'Monedas',
                'currencies-and-locales' => 'Monedas y Localidades',
                'default-currency'       => 'Moneda Predeterminada',
                'default-locale'         => 'Localidad Predeterminada',
                'description'            => 'Descripción',
                'design'                 => 'Diseño',
                'favicon'                => 'Favicon',
                'favicon-size'           => 'La resolución de la imagen debe ser de 16px X 16px',
                'general'                => 'General',
                'hostname'               => 'Nombre del Host',
                'hostname-placeholder'   => 'https://www.example.com (No agregar barra al final.)',
                'inventory-sources'      => 'Fuentes de Inventario',
                'last-delete-error'      => 'Se requiere al menos un Canal.',
                'locales'                => 'Localidades',
                'logo'                   => 'Logo',
                'logo-size'              => 'La resolución de la imagen debe ser de 192px X 50px',
                'maintenance-mode'       => 'Modo de mantenimiento',
                'maintenance-mode-text'  => 'Mensaje',
                'name'                   => 'Nombre',
                'root-category'          => 'Categoría Raíz',
                'save-btn'               => 'Guardar Canal',
                'seo'                    => 'SEO de la página de inicio',
                'seo-description'        => 'Meta descripción',
                'seo-keywords'           => 'Meta palabras clave',
                'seo-title'              => 'Meta título',
                'status'                 => 'Estado',
                'theme'                  => 'Tema',
                'title'                  => 'Editar Canal',
                'update-success'         => 'Canal actualizado exitosamente',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => 'Administrador',
                'title' => 'Usuarios',
                'user'  => 'Usuario',

                'create' => [
                    'confirm-password'  => 'Confirmar Contraseña',
                    'email'             => 'Email',
                    'name'              => 'Nombre',
                    'password'          => 'Contraseña',
                    'role'              => 'Rol',
                    'save-btn'          => 'Guardar Usuario',
                    'status'            => 'Estado',
                    'title'             => 'Crear Usuario',
                    'upload-image-info' => 'Subir una imagen de perfil (110px X 110px) en formato PNG o JPG',
                ],

                'datagrid' => [
                    'actions'  => 'Acciones',
                    'active'   => 'Activo',
                    'delete'   => 'Borrar',
                    'edit'     => 'Editar',
                    'email'    => 'Email',
                    'id'       => 'ID',
                    'inactive' => 'Inactivo',
                    'name'     => 'Nombre',
                    'role'     => 'Rol',
                    'status'   => 'Estado',
                ],

                'edit' => [
                    'title' => 'Editar Usuario',
                ],
            ],

            'edit' => [
                'back-btn'         => 'Volver',
                'confirm-password' => 'Confirmar Contraseña',
                'email'            => 'Email',
                'general'          => 'General',
                'name'             => 'Nombre',
                'password'         => 'Contraseña',
                'role'             => 'Rol',
                'save-btn'         => 'Guardar Usuario',
                'status'           => 'Estado',
                'title'            => 'Editar Usuario',
            ],

            'activate-warning'   => 'Tu cuenta aún no ha sido activada, por favor, contacta al administrador.',
            'cannot-change'      => 'No se puede cambiar el usuario.',
            'create-success'     => 'Usuario creado con éxito.',
            'delete-failed'      => 'Error al eliminar el usuario.',
            'delete-self-error'  => 'No puedes eliminar tu propia cuenta.',
            'delete-success'     => 'Usuario eliminado con éxito.',
            'delete-warning'     => '¿Estás seguro de que quieres realizar esta acción?',
            'incorrect-password' => 'Contraseña incorrecta',
            'last-delete-error'  => 'Error al eliminar el último usuario.',
            'login-error'        => 'Por favor, verifica tus credenciales e intenta nuevamente.',
            'update-success'     => 'Usuario actualizado con éxito.',
        ],

        'roles' => [
            'index' => [
                'create-btn' => 'Crear Rol',
                'title'      => 'Roles',

                'datagrid' => [
                    'all'               => 'Todos',
                    'custom'            => 'Personalizado',
                    'delete'            => 'Eliminar',
                    'edit'              => 'Editar',
                    'id'                => 'Id',
                    'name'              => 'Nombre',
                    'permission-type'   => 'Tipo de Permiso',
                ],
            ],

            'create' => [
                'access-control' => 'Control de Acceso',
                'all'            => 'Todos',
                'back-btn'       => 'Volver',
                'custom'         => 'Personalizado',
                'description'    => 'Descripción',
                'general'        => 'General',
                'name'           => 'Nombre',
                'permissions'    => 'Permisos',
                'save-btn'       => 'Guardar Rol',
                'title'          => 'Crear Rol',
            ],

            'edit' => [
                'access-control' => 'Control de Acceso',
                'all'            => 'Todos',
                'back-btn'       => 'Volver',
                'custom'         => 'Personalizado',
                'description'    => 'Descripción',
                'general'        => 'General',
                'name'           => 'Nombre',
                'permissions'    => 'Permisos',
                'save-btn'       => 'Guardar Rol',
                'title'          => 'Editar Rol',
            ],

            'being-used'        => 'El Rol ya está en uso en el Usuario del Administrador',
            'create-success'    => 'Roles creados exitosamente',
            'delete-failed'     => 'Error al eliminar el Rol',
            'delete-success'    => 'Rol eliminado exitosamente',
            'last-delete-error' => 'No se puede eliminar el último Rol',
            'update-success'    => 'Rol actualizado exitosamente',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'Crear Tema',
                'title'      => 'Temas',

                'datagrid' => [
                    'active'        => 'Activo',
                    'channel_name'  => 'Nombre del Canal',
                    'change-status' => 'Cambiar estado',
                    'delete'        => 'Eliminar',
                    'id'            => 'ID',
                    'inactive'      => 'Inactivo',
                    'name'          => 'Nombre',
                    'sort-order'    => 'Orden de Clasificación',
                    'status'        => 'Estado',
                    'theme'         => 'Tema',
                    'type'          => 'Tipo',
                    'view'          => 'Ver',
                ],
            ],

            'create' => [
                'name'       => 'Nombre',
                'save-btn'   => 'Guardar tema',
                'sort-order' => 'Orden de Clasificación',
                'themes'     => 'Temas',
                'title'      => 'Crear Tema',

                'type' => [
                    'category-carousel' => 'Carrusel de Categoría',
                    'footer-links'      => 'Enlaces del Pie de Página',
                    'image-carousel'    => 'Carrusel de imágenes',
                    'product-carousel'  => 'Carrusel de Productos',
                    'services-content'  => 'Contenido de servicios',
                    'static-content'    => 'Contenido Estático',
                    'title'             => 'Tipo',
                ],
            ],

            'edit' => [
                'active'                        => 'Activo',
                'add-filter-btn'                => 'Agregar Filtro',
                'add-footer-link-btn'           => 'Agregar Enlace del Pie de Página',
                'add-image-btn'                 => 'Agregar Imagen',
                'add-link'                      => 'Agregar Enlace',
                'asc'                           => 'Asc',
                'back'                          => 'Volver',
                'category-carousel'             => 'Carrusel de Categoría',
                'category-carousel-description' => 'Muestra categorías dinámicas de forma atractiva utilizando un carrusel de categorías receptivo.',
                'channels'                      => 'Canales',
                'column'                        => 'Columna',
                'create-filter'                 => 'Crear Filtro',
                'css'                           => 'CSS',
                'delete'                        => 'Eliminar',
                'desc'                          => 'Desc',
                'edit'                          => 'Editar',
                'featured'                      => 'Destacado',
                'filter-title'                  => 'Título',
                'filters'                       => 'Filtros',
                'footer-link'                   => 'Enlaces del Pie de Página',
                'footer-link-description'       => 'Navega a través de los enlaces del pie de página para explorar el sitio web de manera fluida y obtener información.',
                'footer-link-form-title'        => 'Enlace del Pie de Página',
                'footer-title'                  => 'Título',
                'general'                       => 'General',
                'html'                          => 'HTML',
                'image'                         => 'Imagen',
                'image-size'                    => 'El tamaño de la imagen debe ser (1920px x 700px)',
                'image-title'                   => 'Título de la imagen',
                'image-upload-message'          => 'Solo se permiten imágenes (.jpeg, .jpg, .png, .webp, ..).',
                'inactive'                      => 'Inactivo',
                'key'                           => 'Clave: :key',
                'key-input'                     => 'Clave',
                'limit'                         => 'Límite',
                'link'                          => 'Enlace',
                'name'                          => 'Nombre',
                'new'                           => 'Nuevo',
                'no'                            => 'No',
                'parent-id'                     => 'ID del Padre',
                'parent-id-hint'                => 'Puedes introducir múltiples IDs de padres como valores separados por comas (por ejemplo: 12,15,34)',
                'category-id'                   => 'ID de categoría',
                'preview'                       => 'Vista Previa',
                'product-carousel'              => 'Carrusel de Productos',
                'product-carousel-description'  => 'Muestra productos de forma elegante con un carrusel de productos dinámico y receptivo.',
                'save-btn'                      => 'Guardar',
                'select'                        => 'Seleccionar',
                'slider'                        => 'Deslizador',
                'slider-add-btn'                => 'Agregar Deslizador',
                'slider-description'            => 'Personalización de temas relacionada con el deslizador.',
                'slider-image'                  => 'Imagen del Deslizador',
                'slider-required'               => 'El campo de deslizador es obligatorio.',
                'sort'                          => 'Ordenar',
                'sort-order'                    => 'Orden de Clasificación',
                'static-content'                => 'Contenido Estático',
                'static-content-description'    => 'Mejora la interacción con contenido estático conciso e informativo para tu audiencia.',
                'status'                        => 'Estado',
                'themes'                        => 'Temas',
                'title'                         => 'Editar Tema',
                'update-slider'                 => 'Actualizar Deslizador',
                'url'                           => 'URL',
                'value'                         => 'Valor: :value',
                'value-input'                   => 'Valor',

                'services-content' => [
                    'add-btn'            => 'Agregar servicios',
                    'channels'           => 'Canales',
                    'delete'             => 'Eliminar',
                    'description'        => 'Descripción',
                    'general'            => 'General',
                    'name'               => 'Nombre',
                    'save-btn'           => 'Guardar',
                    'service-icon'       => 'Icono de servicio',
                    'service-icon-class' => 'Clase de icono de servicio',
                    'service-info'       => 'Personalización de temas relacionados con el servicio.',
                    'services'           => 'Servicios',
                    'sort-order'         => 'Orden de clasificación',
                    'status'             => 'Estado',
                    'title'              => 'Título',
                    'update-service'     => 'Actualizar servicios',
                ],
                'yes'                           => 'Sí',
            ],

            'create-success' => 'Tema creado con éxito',
            'delete-success' => 'Tema eliminado con éxito',
            'update-success' => 'Tema actualizado con éxito',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => 'Carros Abandonados',
                'abandoned-products'            => 'Productos Abandonados',
                'abandoned-rate'                => 'Tasa de Abandono',
                'abandoned-revenue'             => 'Ingresos Abandonados',
                'added-to-cart'                 => 'Añadido al Carro',
                'added-to-cart-info'            => 'Solo :progress visitantes añadieron productos al carrito',
                'all-channels'                  => 'Todos los Canales',
                'average-order-value-over-time' => 'Valor Promedio del Pedido a lo largo del Tiempo',
                'average-sales'                 => 'Valor Promedio del Pedido',
                'count'                         => 'Conteo',
                'end-date'                      => 'Fecha de Finalización',
                'id'                            => 'ID',
                'interval'                      => 'Intervalo',
                'name'                          => 'Nombre',
                'orders'                        => 'Órdenes',
                'orders-over-time'              => 'Órdenes a lo largo del Tiempo',
                'payment-method'                => 'Método de Pago',
                'product-views'                 => 'Vistas de Producto',
                'product-views-info'            => 'Solo :progress visitantes ven productos',
                'purchase-funnel'               => 'Embudo de Compra',
                'purchased'                     => 'Comprado',
                'purchased-info'                => 'Solo :progress visitantes realizan compras',
                'refunds'                       => 'Reembolsos',
                'refunds-over-time'             => 'Reembolsos a lo largo del Tiempo',
                'sales-over-time'               => 'Ventas a lo largo del Tiempo',
                'shipping-collected'            => 'Envío Recaudado',
                'shipping-collected-over-time'  => 'Envío Recaudado a lo largo del Tiempo',
                'start-date'                    => 'Fecha de Inicio',
                'tax-collected'                 => 'Impuestos Recaudados',
                'tax-collected-over-time'       => 'Impuestos Recaudados a lo largo del Tiempo',
                'title'                         => 'Ventas',
                'top-payment-methods'           => 'Métodos de Pago Principales',
                'top-shipping-methods'          => 'Métodos de Envío Principales',
                'top-tax-categories'            => 'Categorías de Impuestos Principales',
                'total'                         => 'Total',
                'total-orders'                  => 'Total de Órdenes',
                'total-sales'                   => 'Total de Ventas',
                'total-visits'                  => 'Total de visitas',
                'total-visits-info'             => 'Total de visitantes en la tienda',
                'view-details'                  => 'Ver Detalles',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'Todos los Canales',
                'count'                       => 'Conteo',
                'customers'                   => 'Clientes',
                'customers-over-time'         => 'Clientes a lo largo del Tiempo',
                'customers-traffic'           => 'Tráfico de Clientes',
                'customers-with-most-orders'  => 'Clientes con Más Órdenes',
                'customers-with-most-reviews' => 'Clientes con Más Reseñas',
                'customers-with-most-sales'   => 'Clientes con Más Ventas',
                'email'                       => 'Correo Electrónico',
                'end-date'                    => 'Fecha de Finalización',
                'id'                          => 'ID',
                'interval'                    => 'Intervalo',
                'name'                        => 'Nombre',
                'orders'                      => 'Órdenes',
                'reviews'                     => 'Reseñas',
                'start-date'                  => 'Fecha de Inicio',
                'title'                       => 'Clientes',
                'top-customer-groups'         => 'Grupos de Clientes Principales',
                'total'                       => 'Total',
                'total-customers'             => 'Total de Clientes',
                'total-visitors'              => 'Total de Visitantes',
                'traffic-over-week'           => 'Tráfico a lo largo de la Semana',
                'unique-visitors'             => 'Visitantes Únicos',
                'view-details'                => 'Ver Detalles',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'Todos los Canales',
                'channel'                          => 'Canal',
                'end-date'                         => 'Fecha de Finalización',
                'id'                               => 'ID',
                'interval'                         => 'Intervalo',
                'last-search-terms'                => 'Últimos términos de búsqueda',
                'locale'                           => 'Configuración regional',
                'name'                             => 'Nombre',
                'orders'                           => 'Órdenes',
                'price'                            => 'Precio',
                'products-added-over-time'         => 'Productos Agregados a lo largo del Tiempo',
                'products-with-most-reviews'       => 'Productos con Más Reseñas',
                'products-with-most-visits'        => 'Productos con Más Visitas',
                'quantities'                       => 'Cantidades',
                'quantities-sold-over-time'        => 'Cantidades Vendidas a lo largo del Tiempo',
                'results'                          => 'Resultados',
                'revenue'                          => 'Ingresos',
                'reviews'                          => 'Reseñas',
                'search-term'                      => 'Término de búsqueda',
                'start-date'                       => 'Fecha de Inicio',
                'title'                            => 'Productos',
                'top-search-terms'                 => 'Términos de búsqueda principales',
                'top-selling-products-by-quantity' => 'Productos Más Vendidos por Cantidad',
                'top-selling-products-by-revenue'  => 'Productos Más Vendidos por Ingresos',
                'total'                            => 'Total',
                'total-products-added-to-wishlist' => 'Productos Agregados a la Lista de Deseos',
                'total-sold-quantities'            => 'Cantidad de Productos Vendidos',
                'uses'                             => 'Usos',
                'view-details'                     => 'Ver Detalles',
                'visits'                           => 'Visitas',
            ],
        ],

        'view' => [
            'all-channels'  => 'Todos los Canales',
            'back-btn'      => 'Atrás',
            'day'           => 'Día',
            'end-date'      => 'Fecha de Finalización',
            'export-csv'    => 'Exportar CSV',
            'export-xls'    => 'Exportar XLS',
            'month'         => 'Mes',
            'not-available' => 'o hay registros disponibles.',
            'start-date'    => 'Fecha de Inicio',
            'year'          => 'Año',
        ],

        'empty' => [
            'info'  => 'No hay datos disponibles para el intervalo seleccionado',
            'title' => 'No hay datos disponibles',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => 'Volver',
            'delete'                       => 'Borrar',
            'enable-at-least-one-payment'  => 'Activa al menos un método de pago.',
            'enable-at-least-one-shipping' => 'Activa al menos un método de envío.',
            'no-result-found'              => 'Sin resultados',
            'save-btn'                     => 'Guardar Configuración',
            'save-message'                 => 'Configuración guardada correctamente',
            'search'                       => 'Buscar',
            'select-country'               => 'Selecciona País',
            'select-state'                 => 'Selecciona Provincia',
            'title'                        => 'Configuración',

            'general' => [
                'info'  => 'Establecer opciones de unidades.',
                'title' => 'General',

                'general' => [
                    'info'  => 'Configura las opciones de unidades y activa o desactiva las opciones de Migas de Pan y Visitantes.',
                    'title' => 'General',

                    'unit-options' => [
                        'info'        => 'Establecer opciones de unidades.',
                        'title'       => 'Opciones de Unidades',
                        'title-info'  => 'Configura el peso en libras (lbs) o kilogramos (kgs).',
                        'weight-unit' => 'Unidad de Peso',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'Migas de pan de la tienda',
                        'title'      => 'Migas de pan',
                        'title-info' => 'Habilita o deshabilita la navegación de migas de pan en la tienda.',
                    ],

                    'visitor-options' => [
                        'enable'     => 'Habilitar opciones de visitantes',
                        'title'      => 'Opciones de visitantes',
                        'title-info' => 'Permite controlar el sitio para rastrear y contar el número de visitas, ayudando a monitorear la actividad y el compromiso general de los visitantes.',
                    ],
                ],

                'content' => [
                    'info'  => 'Establecer el título de la oferta del encabezado y scripts personalizados.',
                    'title' => 'Contenido',

                    'header-offer' => [
                        'title'             => 'Título de la Oferta del Encabezado',
                        'title-info'        => 'Configurar el Título de la Oferta del Encabezado con el título de la oferta, título de redirección y enlace de redirección.',
                        'offer-title'       => 'Título de la Oferta',
                        'redirection-title' => 'Título de Redirección',
                        'redirection-link'  => 'Enlace de Redirección',
                    ],

                    'speculation-rules' => [
                        'enable-speculation' => 'Habilitar reglas de especulación',
                        'info'               => 'Configura los ajustes para habilitar o deshabilitar la lógica de especulación automática.',
                        'title'              => 'Reglas de especulación',

                        'prerender' => [
                            'conservative'           => 'Conservador',
                            'eager'                  => 'Ansioso',
                            'eagerness'              => 'Nivel de anticipación del prerender',
                            'eagerness-info'         => 'Controla cuán agresivamente se aplican las reglas de especulación. Opciones: ansioso (máximo), moderado (predeterminado), conservador (bajo).',
                            'enabled'                => 'Habilitar reglas de especulación para prerender',
                            'ignore-url-params'      => 'Ignorar parámetros de URL para prerender',
                            'ignore-url-params-info' => 'Especifica los parámetros de URL a ignorar en las reglas de especulación. Usa una barra vertical (|) para separar múltiples parámetros.',
                            'ignore-urls'            => 'Ignorar URLs para prerender',
                            'ignore-urls-info'       => 'Introduce las URLs que deben excluirse de la lógica de especulación. Separa múltiples URLs con una barra vertical (|).',
                            'info'                   => 'Configura el estado de las reglas de especulación.',
                            'moderate'               => 'Moderado',
                        ],

                        'prefetch' => [
                            'conservative'           => 'Conservador',
                            'eager'                  => 'Ansioso',
                            'eagerness'              => 'Nivel de anticipación del prefetch',
                            'eagerness-info'         => 'Controla cuán agresivamente se aplican las reglas de especulación. Opciones: ansioso (máximo), moderado (predeterminado), conservador (bajo).',
                            'enabled'                => 'Habilitar reglas de especulación para prefetch',
                            'ignore-url-params'      => 'Ignorar parámetros de URL para prefetch',
                            'ignore-url-params-info' => 'Especifica los parámetros de URL a ignorar en las reglas de especulación. Usa una barra vertical (|) para separar múltiples parámetros.',
                            'ignore-urls'            => 'Ignorar URLs para prefetch',
                            'ignore-urls-info'       => 'Introduce las URLs que deben excluirse de la lógica de especulación. Separa múltiples URLs con una barra vertical (|).',
                            'info'                   => 'Configura el estado de las reglas de especulación.',
                            'moderate'               => 'Moderado',
                        ],
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'CSS Personalizado',
                        'custom-javascript' => 'Javascript Personalizado',
                        'title'             => 'Scripts Personalizados',
                        'title-info'        => 'Los scripts personalizados son piezas de código personalizadas creadas para agregar funciones o características específicas al software, mejorando sus capacidades de manera única.',
                    ],
                ],

                'design' => [
                    'info'  => 'Configurar el logotipo y el icono de favicon para el panel de administración.',
                    'title' => 'Diseño',

                    'admin-logo' => [
                        'favicon'    => 'Favicon',
                        'logo-image' => 'Imagen de Logotipo',
                        'title'      => 'Logotipo de Administrador',
                        'title-info' => 'Configure imágenes de logotipo y favicon para la interfaz de su sitio web para una mejor marca y reconocimiento.',
                    ],

                    'menu-category' => [
                        'default'         => 'Menú predeterminado',
                        'info'            => 'Esta configuración controla la visibilidad de las categorías en el menú de encabezado. Puedes elegir mostrar solo las categorías principales o todas las categorías anidadas.',
                        'preview-default' => 'Vista previa del menú predeterminado',
                        'preview-sidebar' => 'Vista previa del menú lateral',
                        'sidebar'         => 'Menú lateral',
                        'title'           => 'Vista de categoría del menú',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Configurar opciones de Magic AI y permitir algunas opciones para automatizar la creación de contenido.',
                    'title' => 'Magic AI',

                    'settings' => [
                        'api-key'        => 'Clave de API',
                        'enabled'        => 'Habilitado',
                        'llm-api-domain' => 'Dominio de API LLM',
                        'organization'   => 'Organización',
                        'title'          => 'Configuración General',
                        'title-info'     => 'Mejora tu experiencia con la función de Magic AI ingresando tu exclusiva Clave de API e indicando la Organización pertinente para una integración sin esfuerzo. Toma el control de tus credenciales de OpenAI y personaliza la configuración según tus necesidades específicas.',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'Indicación de Descripción de Categoría',
                        'cms-page-content-prompt'          => 'Indicación de Contenido de Página CMS',
                        'enabled'                          => 'Habilitado',
                        'product-description-prompt'       => 'Indicación de Descripción de Producto',
                        'product-short-description-prompt' => 'Indicación de Descripción Corta de Producto',
                        'title'                            => 'Generación de Contenido',
                        'title-info'                       => 'Esta función habilitará el Magic AI para cada editor WYSIWYG, donde quieras gestionar el contenido utilizando la IA.<br/><br/>Cuando esté habilitado, ve a cualquier editor para generar contenido.',
                    ],

                    'image-generation' => [
                        'enabled'    => 'Habilitado',
                        'title'      => 'Generación de Imágenes',
                        'title-info' => 'Esta función habilitará el Magic AI para cada carga de imágenes, donde quieras generar imágenes utilizando DALL-E.<br/><br/>Cuando esté habilitado, ve a cualquier carga de imágenes para generar imágenes.',
                    ],

                    'review-translation' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Habilitado',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt-4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Modelo',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Traducción de Reseñas',
                        'title-info'          => 'Proporcionar opción al cliente o visitante para traducir la reseña del cliente al inglés.<br/><br/>Cuando esté habilitado, ve a la reseña y encontrarás el botón "Traducir al inglés" si la reseña está en otro idioma que no sea inglés.',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],

                    'checkout-message' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Habilitado',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt 4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Modelo',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'prompt'              => 'Indicación',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Mensaje Personalizado de Pago',
                        'title-info'          => 'Crea un mensaje de pago personalizado para los clientes en la página de agradecimiento, adaptando el contenido para resonar con las preferencias individuales y mejorando la experiencia post-compra en general.',
                        'vicuna'              => 'Vicuna',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],
                ],

                'gdpr' => [
                    'title' => 'GDPR',
                    'info'  => 'Configuraciones de cumplimiento de GDPR',

                    'settings' => [
                        'title'   => 'Configuraciones de cumplimiento de GDPR',
                        'info'    => 'Administre las configuraciones de cumplimiento de GDPR, incluida la política de privacidad. Habilite o deshabilite las funciones de GDPR según sea necesario.',
                        'enabled' => 'Habilitar GDPR',
                    ],

                    'agreement' => [
                        'title'          => 'Acuerdo de GDPR',
                        'info'           => 'Administre el consentimiento de los clientes de acuerdo con las regulaciones de GDPR. Habilite el consentimiento obligatorio para la recopilación y el procesamiento de datos.',
                        'enable'         => 'Habilitar consentimiento del cliente',
                        'checkbox-label' => 'Etiqueta de la casilla de verificación para el consentimiento',
                        'content'        => 'Contenido del consentimiento',
                    ],

                    'cookie' => [
                        'bottom-left'  => 'Abajo a la izquierda',
                        'bottom-right' => 'Abajo a la derecha',
                        'center'       => 'Centro',
                        'description'  => 'Descripción',
                        'enable'       => 'Habilitar notificación de cookies',
                        'identifier'   => 'Identificador de bloque estático',
                        'info'         => 'Configure las configuraciones de consentimiento de cookies para informar a los usuarios sobre la recopilación de datos y cumplir con las políticas de privacidad.',
                        'position'     => 'Posición de visualización del bloque de cookies',
                        'title'        => 'Configuraciones de notificación de cookies',
                        'top-left'     => 'Arriba a la izquierda',
                        'top-right'    => 'Arriba a la derecha',
                    ],

                    'cookie-consent' => [
                        'title'                  => 'Administre sus configuraciones de cookies',
                        'info'                   => 'Controle cómo se utilizan sus datos seleccionando las configuraciones de cookies preferidas. Ajuste los permisos para diferentes tipos de cookies.',
                        'strictly-necessary'     => 'Estrictamente necesario',
                        'basic-interaction'      => 'Interacción y funcionalidad básica',
                        'experience-enhancement' => 'Mejora de la experiencia',
                        'measurement'            => 'Medición',
                        'targeting-advertising'  => 'Segmentación y publicidad',
                    ],
                ],

                'sitemap' => [
                    'info'  => 'Configurar opciones del mapa del sitio.',
                    'title' => 'Mapa del Sitio',

                    'settings' => [
                        'enabled' => 'Habilitado',
                        'info'    => 'Habilitar o deshabilitar el mapa del sitio para su sitio web para mejorar la optimización de motores de búsqueda y mejorar la experiencia del usuario.',
                        'title'   => 'Configuraciones',
                    ],

                    'file-limits' => [
                        'info'             => 'Configurar opciones de límites de archivo.',
                        'max-file-size'    => 'Tamaño máximo de archivo',
                        'max-url-per-file' => 'Número máximo de URLs por archivo',
                        'title'            => 'Límites de Archivo',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'Catálogo',
                'title' => 'Catálogo',

                'products' => [
                    'info'  => 'Página de vista del producto, página de vista del carrito, escaparate, revisión y compartir atributos en redes sociales.',
                    'title' => 'Productos',

                    'settings' => [
                        'compare-options'     => 'Opciones de comparación',
                        'image-search-option' => 'Opción de búsqueda de imágenes',
                        'title'               => 'Configuración',
                        'title-info'          => 'La configuración se refiere a las opciones configurables que controlan el comportamiento de un sistema, aplicación o dispositivo, adaptadas a las preferencias y requisitos del usuario.',
                        'wishlist-options'    => 'Opciones de lista de deseos',
                    ],

                    'search' => [
                        'admin-mode'            => 'Modo de búsqueda de administrador',
                        'admin-mode-info'       => 'La búsqueda mega, la cuadrícula de datos y otras funcionalidades de búsqueda en el panel de administración se basarán en el motor de búsqueda seleccionado.',
                        'database'              => 'Base de datos',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => 'Longitud máxima de consulta',
                        'max-query-length-info' => 'Establecer la longitud máxima de consulta para las consultas de búsqueda.',
                        'min-query-length'      => 'Longitud mínima de consulta',
                        'min-query-length-info' => 'Establecer la longitud mínima de consulta para las consultas de búsqueda.',
                        'search-engine'         => 'Motor de búsqueda',
                        'storefront-mode'       => 'Modo de búsqueda de tienda en línea',
                        'storefront-mode-info'  => 'La funcionalidad de búsqueda en la tienda en línea se basará en el motor de búsqueda seleccionado, incluida la página de categoría, la página de búsqueda y otras funcionalidades de búsqueda.',
                        'title'                 => 'Búsqueda',
                        'title-info'            => 'Para configurar el motor de búsqueda para las búsquedas de productos, puede elegir entre una base de datos y Elasticsearch según sus requisitos. Si tiene un gran número de productos, se recomienda Elasticsearch.',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'Permitir pago de invitados',
                        'allow-guest-checkout-hint' => 'Sugerencia: si está activado, esta opción se puede configurar para cada producto específicamente.',
                        'title'                     => 'Pago de invitados',
                        'title-info'                => 'El pago de invitados permite a los clientes comprar productos sin crear una cuenta, agilizando el proceso de compra para mayor comodidad y transacciones más rápidas.',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => 'Número permitido de productos relacionados',
                        'allow-no-of-up-sells-products' => 'Número permitido de productos de venta cruzada',
                        'title'                         => 'Configuración de la página de vista de producto',
                        'title-info'                    => 'La configuración de la página de vista de producto implica ajustar el diseño y los elementos en la página de visualización de un producto, mejorando la experiencia del usuario y la presentación de información.',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'Número permitido de productos de venta cruzada',
                        'title'                            => 'Configuración de la página de vista del carrito',
                        'title-info'                       => 'La configuración de la página de vista del carrito implica organizar elementos, detalles y opciones en la página del carrito de compras, mejorando la interacción del usuario y el flujo de compra.',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => 'Permitir a los clientes comprar productos directamente',
                        'cheapest-first'         => 'Más barato primero',
                        'comma-separated'        => 'Separado por comas',
                        'default-list-mode'      => 'Modo de lista predeterminado',
                        'expensive-first'        => 'Más caro primero',
                        'from-a-z'               => 'De la A a la Z',
                        'from-z-a'               => 'De la Z a la A',
                        'grid'                   => 'Cuadrícula',
                        'latest-first'           => 'Más reciente primero',
                        'list'                   => 'Lista',
                        'oldest-first'           => 'Más antiguo primero',
                        'products-per-page'      => 'Productos por página',
                        'sort-by'                => 'Ordenar por',
                        'title'                  => 'Tienda en línea',
                        'title-info'             => 'La tienda en línea es la interfaz orientada al cliente de una tienda en línea, que muestra productos, categorías y navegación para una experiencia de compra perfecta.',
                    ],

                    'small-image' => [
                        'height'      => 'Altura',
                        'placeholder' => 'Marcador de posición de imagen pequeña',
                        'title'       => 'Imagen pequeña',
                        'title-info'  => 'La imagen pequeña es la interfaz orientada al cliente de una tienda en línea, que muestra productos, categorías y navegación para una experiencia de compra perfecta.',
                        'width'       => 'Ancho',
                    ],

                    'medium-image' => [
                        'height'      => 'Altura',
                        'placeholder' => 'Marcador de posición de imagen mediana',
                        'title'       => 'Imagen mediana',
                        'title-info'  => 'La imagen mediana se refiere a una imagen de tamaño moderado que ofrece un equilibrio entre el detalle y el espacio en la pantalla, comúnmente utilizada para fines visuales.',
                        'width'       => 'Ancho',
                    ],

                    'large-image' => [
                        'height'      => 'Altura',
                        'placeholder' => 'Marcador de posición de imagen grande',
                        'title'       => 'Imagen grande',
                        'title-info'  => 'La imagen grande representa una imagen de alta resolución que proporciona un mayor detalle e impacto visual, a menudo utilizada para mostrar productos o gráficos.',
                        'width'       => 'Ancho',
                    ],

                    'review' => [
                        'allow-customer-review'   => 'Permitir reseñas de clientes',
                        'allow-guest-review'      => 'Permitir reseñas de invitados',
                        'censoring-reviewer-name' => 'Censurar Nombre del Reseñador',
                        'display-review-count'    => 'Muestra el recuento de reseñas para las calificaciones.',
                        'display-star-count'      => 'Muestra el recuento de estrellas en las calificaciones.',
                        'summary'                 => 'Resumen',
                        'title'                   => 'Reseña',
                        'title-info'              => 'Evaluación o valoración de algo, a menudo involucrando opiniones y comentarios.',
                    ],

                    'attribute' => [
                        'file-upload-size'  => 'Tamaño máximo de carga de archivos (en Kb)',
                        'image-upload-size' => 'Tamaño máximo de carga de imágenes (en Kb)',
                        'title'             => 'Atributo',
                        'title-info'        => 'Característica o propiedad que define un objeto, influyendo en su comportamiento, apariencia o función.',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Configure la configuración de compartir en redes sociales para habilitar el compartir de productos en Instagram, Twitter, WhatsApp, Facebook, Pinterest, LinkedIn y por correo electrónico.',
                        'title'                       => 'Compartir en redes sociales',
                        'share-message'               => 'Mensaje de compartir',
                        'share'                       => 'Compartir',
                        'enable-social-share'         => '¿Habilitar compartir en redes sociales?',
                        'enable-share-whatsapp-info'  => 'El enlace de compartir de WhatsApp solo aparecerá en dispositivos móviles.',
                        'enable-share-whatsapp'       => '¿Habilitar compartir en WhatsApp?',
                        'enable-share-twitter'        => '¿Habilitar compartir en Twitter?',
                        'enable-share-pinterest'      => '¿Habilitar compartir en Pinterest?',
                        'enable-share-linkedin'       => '¿Habilitar compartir en LinkedIn?',
                        'enable-share-facebook'       => '¿Habilitar compartir en Facebook?',
                        'enable-share-email'          => '¿Habilitar compartir por correo electrónico?',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => 'Configurar productos y categorías.',
                    'title' => 'Fragmentos enriquecidos',

                    'products' => [
                        'enable'          => 'Habilitar',
                        'show-categories' => 'Mostrar categorías',
                        'show-images'     => 'Mostrar imágenes',
                        'show-offers'     => 'Mostrar ofertas',
                        'show-ratings'    => 'Mostrar calificaciones',
                        'show-reviews'    => 'Mostrar reseñas',
                        'show-sku'        => 'Mostrar SKU',
                        'show-weight'     => 'Mostrar peso',
                        'title'           => 'Productos',
                        'info'            => 'Configure opciones de stock del producto para permitir pedidos pendientes, establecer cantidades mínimas y máximas en el carrito, y definir umbrales de falta de stock.',
                    ],

                    'categories' => [
                        'enable'                  => 'Habilitar',
                        'show-search-input-field' => 'Mostrar campo de entrada de búsqueda',
                        'title'                   => 'Categorías',
                        'title-info'              => '"Categorías" se refiere a grupos o clasificaciones que ayudan a organizar y agrupar productos o artículos similares para facilitar la navegación y búsqueda.',
                    ],
                ],

                'inventory' => [
                    'title'      => 'Inventario',
                    'title-info' => 'Configure la configuración de inventario para permitir pedidos pendientes y definir el umbral de falta de stock.',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'Permitir pedidos pendientes',
                        'max-qty-allowed-in-cart' => 'Cantidad máxima permitida en el carrito de compras',
                        'min-qty-allowed-in-cart' => 'Cantidad mínima permitida en el carrito de compras',
                        'out-of-stock-threshold'  => 'Umbral de falta de stock',
                        'title'                   => 'Opción de stock de producto',
                        'info'                    => 'Configurar opciones de stock de productos para permitir pedidos pendientes, establecer cantidades mínimas y máximas en el carrito y definir umbrales de falta de stock.',
                    ],
                ],
            ],

            'customer' => [
                'info'  => 'Cliente',
                'title' => 'Cliente',

                'address' => [
                    'info'  => 'Establecer país, estado, código postal y líneas en una dirección de calle.',
                    'title' => 'Dirección',

                    'requirements' => [
                        'city'       => 'Ciudad',
                        'country'    => 'País',
                        'state'      => 'Estado',
                        'title'      => 'Requisitos',
                        'title-info' => 'Los requisitos son las condiciones, características o especificaciones necesarias para que algo se cumpla, logre o satisfaga con éxito.',
                        'zip'        => 'Código Postal',
                    ],

                    'information' => [
                        'street-lines' => 'Líneas en una dirección de calle',
                        'title'        => 'Información',
                        'title-info'   => '"Líneas en una dirección de calle" se refiere a segmentos individuales de una dirección, a menudo separados por comas, que proporcionan información de ubicación como número de casa, calle, ciudad y más.',
                    ],
                ],

                'captcha' => [
                    'info'  => 'Establecer clave del sitio, clave secreta y estado.',
                    'title' => 'Google Captcha',

                    'credentials' => [
                        'secret-key' => 'Clave Secreta',
                        'site-key'   => 'Clave del Sitio',
                        'status'     => 'Estado',
                        'title'      => 'Credenciales',
                        'title-info' => '"Mapa del sitio: Diseño del sitio web para motores de búsqueda. Clave secreta: Código seguro para cifrado de datos, autenticación o protección de acceso a la API."',
                    ],

                    'validations' => [
                        'captcha'  => '¡Algo salió mal! Por favor, inténtelo de nuevo.',
                        'required' => 'Por favor, seleccione CAPTCHA',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'Configurar lista de deseos, redirección de inicio de sesión, suscripciones al boletín, opción de grupo predeterminado, verificaciones de correo electrónico e inicio de sesión social.',
                    'title'         => 'Configuración',

                    'login-as-customer' => [
                        'allow-option' => 'Permitir inicio de sesión como cliente',
                        'title'        => 'Iniciar sesión como cliente',
                        'title-info'   => 'Habilitar la funcionalidad "Iniciar sesión como cliente".',
                    ],

                    'wishlist' => [
                        'allow-option' => 'Permitir opción de lista de deseos',
                        'title'        => 'Lista de deseos',
                        'title-info'   => 'Habilitar o deshabilitar la opción de lista de deseos.',
                    ],

                    'login-options' => [
                        'account'          => 'Cuenta',
                        'home'             => 'Inicio',
                        'redirect-to-page' => 'Redirigir al cliente a la página seleccionada',
                        'title'            => 'Opciones de inicio de sesión',
                        'title-info'       => 'Configure las opciones de inicio de sesión para determinar la página de redirección para los clientes después de iniciar sesión.',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'Permitir boletín de noticias',
                        'news-letter-info' => 'Habilitar la opción de suscripción al boletín en la página de registro.',
                        'title'            => 'Opciones de creación de cuenta nuevas',
                        'title-info'       => 'Establezca opciones para nuevas cuentas, incluyendo asignar un grupo de clientes predeterminado y habilitar la opción de suscripción al boletín durante el registro.',

                        'default-group' => [
                            'general'    => 'General',
                            'guest'      => 'Invitado',
                            'title'      => 'Grupo predeterminado',
                            'title-info' => 'Asigne un grupo de clientes específico como predeterminado para los nuevos clientes.',
                            'wholesale'  => 'Mayorista',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'Permitir suscripción al boletín',
                        'title'        => 'Suscripción al boletín',
                        'title-info'   => '"Información del boletín" contiene actualizaciones, ofertas o contenido compartido regularmente a través de correos electrónicos a los suscriptores, manteniéndolos informados y comprometidos.',
                    ],

                    'email' => [
                        'email-verification' => 'Permitir verificación de correo electrónico',
                        'title'              => 'Verificación de correo electrónico',
                        'title-info'         => '"Verificación de correo electrónico" confirma la autenticidad de una dirección de correo electrónico, a menudo enviando un enlace de confirmación, mejorando la seguridad de la cuenta y la confiabilidad de la comunicación.',
                    ],

                    'social-login' => [
                        'title' => 'Inicio de sesión social',
                        'info'  => '"El inicio de sesión social" permite a los usuarios acceder a un sitio web utilizando sus cuentas de redes sociales, simplificando los procesos de registro e inicio de sesión.',

                        'google' => [
                            'enable-google' => 'Habilitar Google',

                            'client-id' => [
                                'title'      => 'ID de cliente',
                                'title-info' => 'Identificador único proporcionado por Google al crear tu aplicación OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secreto de cliente',
                                'title-info' => 'Clave secreta asociada a tu cliente OAuth de Google. Mantenla confidencial.',
                            ],

                            'redirect' => [
                                'title'      => 'Redirección',
                                'title-info' => 'URL de retorno donde los usuarios son redirigidos después de autenticarse con Google. Debe coincidir con la URL configurada en tu consola de Google.',
                            ],
                        ],

                        'facebook' => [
                            'enable-facebook' => 'Habilitar Facebook',

                            'client-id' => [
                                'title'      => 'ID de cliente',
                                'title-info' => 'ID de la aplicación proporcionado por Facebook al crear una aplicación en la consola de desarrolladores.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secreto de cliente',
                                'title-info' => 'Secreto de la aplicación asociado a tu aplicación de Facebook. Mantenlo seguro y privado.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirección',
                                'title-info' => 'URL de retorno donde los usuarios son redirigidos después de autenticarse con Facebook. Debe coincidir con la URL configurada en la configuración de tu aplicación de Facebook.',
                            ],
                        ],

                        'github' => [
                            'enable-github' => 'Habilitar GitHub',

                            'client-id' => [
                                'title'      => 'ID de cliente',
                                'title-info' => 'Identificador único proporcionado por GitHub al crear tu aplicación OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secreto de cliente',
                                'title-info' => 'Clave secreta asociada a tu cliente OAuth de GitHub. Mantenla confidencial.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirección',
                                'title-info' => 'URL de retorno donde los usuarios son redirigidos después de autenticarse con GitHub. Debe coincidir con la URL configurada en tu consola de GitHub.',
                            ],
                        ],

                        'linkedin' => [
                            'enable-linkedin' => 'Habilitar LinkedIn',

                            'client-id' => [
                                'title'      => 'ID de cliente',
                                'title-info' => 'Identificador único proporcionado por LinkedIn al crear tu aplicación OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secreto de cliente',
                                'title-info' => 'Clave secreta asociada a tu cliente OAuth de LinkedIn. Mantenla confidencial.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirección',
                                'title-info' => 'URL de retorno donde los usuarios son redirigidos después de autenticarse con LinkedIn. Debe coincidir con la URL configurada en tu consola de LinkedIn.',
                            ],
                        ],

                        'twitter' => [
                            'enable-twitter' => 'Habilitar Twitter',

                            'client-id' => [
                                'title'      => 'ID de cliente',
                                'title-info' => 'Identificador único proporcionado por Twitter al crear tu aplicación OAuth.',
                            ],

                            'client-secret' => [
                                'title'      => 'Secreto de cliente',
                                'title-info' => 'Clave secreta asociada a tu cliente OAuth de Twitter. Mantenla confidencial.',
                            ],

                            'redirect' => [
                                'title'      => 'URL de redirección',
                                'title-info' => 'URL de retorno donde los usuarios son redirigidos después de autenticarse con Twitter. Debe coincidir con la URL configurada en tu consola de Twitter.',
                            ],
                        ],
                    ],
                ],
            ],

            'email' => [
                'info'  => 'Correo electrónico',
                'title' => 'Correo electrónico',

                'email-settings' => [
                    'admin-email'           => 'Correo electrónico del administrador',
                    'admin-email-tip'       => 'La dirección de correo electrónico del administrador de este canal para recibir correos electrónicos',
                    'admin-name'            => 'Nombre del administrador',
                    'admin-name-tip'        => 'Este nombre se mostrará en todos los correos electrónicos del administrador',
                    'admin-page-limit'      => 'Elementos por página predeterminados (Administrador)',
                    'contact-email'         => 'Correo electrónico de contacto',
                    'contact-email-tip'     => 'La dirección de correo electrónico se mostrará en la parte inferior de sus correos electrónicos',
                    'contact-name'          => 'Nombre de contacto',
                    'contact-name-tip'      => 'Este nombre se mostrará en la parte inferior de sus correos electrónicos',
                    'email-sender-name'     => 'Nombre del remitente del correo electrónico',
                    'email-sender-name-tip' => 'Este nombre se mostrará en la bandeja de entrada de los clientes',
                    'info'                  => 'Establecer nombre del remitente del correo electrónico, dirección de correo electrónico de la tienda, nombre del administrador y dirección de correo electrónico del administrador.',
                    'shop-email-from'       => 'Dirección de correo electrónico de la tienda',
                    'shop-email-from-tip'   => 'La dirección de correo electrónico de este canal para enviar correos electrónicos a sus clientes',
                    'title'                 => 'Configuración de correo electrónico',
                ],

                'notifications' => [
                    'cancel-order'                                     => 'Enviar una notificación al cliente después de cancelar un pedido',
                    'cancel-order-mail-to-admin'                       => 'Enviar un correo electrónico de notificación al administrador después de cancelar un pedido',
                    'customer'                                         => 'Enviar las credenciales de la cuenta del cliente después del registro',
                    'customer-registration-confirmation-mail-to-admin' => 'Enviar un correo electrónico de confirmación al administrador después del registro del cliente',
                    'info'                                             => 'Configure para recibir correos electrónicos para verificación de cuenta, confirmaciones de pedidos, actualizaciones sobre facturas, reembolsos, envíos y cancelaciones de pedidos.',
                    'new-inventory-source'                             => 'Enviar un correo electrónico de notificación a la fuente de inventario después de crear un envío',
                    'new-invoice'                                      => 'Enviar un correo electrónico de notificación al cliente después de crear una nueva factura',
                    'new-invoice-mail-to-admin'                        => 'Enviar un correo electrónico de notificación al administrador después de crear una nueva factura',
                    'new-order'                                        => 'Enviar un correo electrónico de confirmación al cliente después de realizar un nuevo pedido',
                    'new-order-mail-to-admin'                          => 'Enviar un correo electrónico de confirmación al administrador después de realizar un nuevo pedido',
                    'new-refund'                                       => 'Enviar un correo electrónico de notificación al cliente después de crear un reembolso',
                    'new-refund-mail-to-admin'                         => 'Enviar un correo electrónico de notificación al administrador después de crear un nuevo reembolso',
                    'new-shipment'                                     => 'Enviar un correo electrónico de notificación al cliente después de crear un envío',
                    'new-shipment-mail-to-admin'                       => 'Enviar un correo electrónico de notificación al administrador después de crear un nuevo envío',
                    'registration'                                     => 'Enviar un correo electrónico de confirmación después del registro del cliente',
                    'title'                                            => 'Notificaciones',
                    'verification'                                     => 'Enviar un correo electrónico de verificación después del registro del cliente',
                ],
            ],

            'sales' => [
                'info'  => 'Ventas',
                'title' => 'Ventas',

                'shipping-setting' => [
                    'info'  => 'Configurar la configuración de envío, incluyendo país, estado, ciudad, dirección, código postal, nombre de la tienda, número de IVA, número de contacto y detalles bancarios.',
                    'title' => 'Configuración de envío',

                    'origin' => [
                        'bank-details'   => 'Detalles bancarios',
                        'city'           => 'Ciudad',
                        'contact-number' => 'Número de contacto',
                        'country'        => 'País',
                        'state'          => 'Estado',
                        'store-name'     => 'Nombre de la tienda',
                        'street-address' => 'Dirección',
                        'title'          => 'Origen',
                        'title-info'     => 'El origen del envío se refiere al lugar donde los bienes o productos se originan antes de ser transportados a su destino.',
                        'vat-number'     => 'Número de IVA',
                        'zip'            => 'Código postal',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => 'Configurar los métodos de envío, incluyendo envío gratuito, tarifa plana y opciones adicionales según sea necesario.',
                    'title' => 'Métodos de envío',

                    'free-shipping' => [
                        'description' => 'Descripción',
                        'page-title'  => 'Envío gratuito',
                        'status'      => 'Estado',
                        'title'       => 'Título',
                        'title-info'  => '"Envío gratuito" se refiere a un método de envío en el que se renuncia al costo de envío y el vendedor cubre los gastos de envío para entregar los bienes al comprador.',
                    ],

                    'flat-rate-shipping' => [
                        'description' => 'Descripción',
                        'page-title'  => 'Envío con tarifa plana',
                        'rate'        => 'Tarifa',
                        'status'      => 'Estado',
                        'title'       => 'Título',
                        'title-info'  => 'El envío con tarifa plana es un método de envío en el que se cobra una tarifa fija por el envío, independientemente del peso, tamaño o distancia del paquete. Esto simplifica los costos de envío y puede ser ventajoso tanto para compradores como para vendedores.',
                        'type'        => [
                            'per-order' => 'Por pedido',
                            'per-unit'  => 'Por unidad',
                            'title'     => 'Tipo',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => 'Monedas aceptadas',
                    'accepted-currencies-info'       => 'Agregar códigos de moneda separados por comas, por ejemplo, USD, INR, ...',
                    'business-account'               => 'Cuenta de empresa',
                    'cash-on-delivery'               => 'Pago contra entrega',
                    'cash-on-delivery-info'          => 'Método de pago en el que los clientes pagan en efectivo al recibir los bienes o servicios en su puerta.',
                    'client-id'                      => 'ID de cliente',
                    'client-id-info'                 => 'Usar "sb" para pruebas.',
                    'client-secret'                  => 'Clave secreta del cliente',
                    'client-secret-info'             => 'Agregar aquí tu clave secreta',
                    'description'                    => 'Descripción',
                    'generate-invoice'               => 'Generar automáticamente la factura después de realizar un pedido',
                    'generate-invoice-applicable'    => 'Aplicable si se habilita la generación automática de facturas',
                    'info'                           => 'Configurar la información de los métodos de pago',
                    'instructions'                   => 'Instrucciones',
                    'logo'                           => 'Logo',
                    'logo-information'               => 'La resolución de la imagen debe ser de 55px x 45px',
                    'mailing-address'                => 'Enviar cheque a',
                    'money-transfer'                 => 'Transferencia de dinero',
                    'money-transfer-info'            => 'Transferencia de fondos de una persona o cuenta a otra, a menudo de forma electrónica, con diversos fines como transacciones o remesas.',
                    'page-title'                     => 'Métodos de pago',
                    'paid'                           => 'Pagado',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'Botón inteligente de PayPal: simplifica los pagos en línea con botones personalizables para transacciones seguras y multimétodo en sitios web y aplicaciones.',
                    'paypal-standard'                => 'PayPal estándar',
                    'paypal-standard-info'           => 'PayPal estándar es una opción de pago básica de PayPal para negocios en línea, que permite a los clientes pagar con sus cuentas de PayPal o tarjetas de crédito/débito.',
                    'pending'                        => 'Pendiente',
                    'pending-payment'                => 'Pago pendiente',
                    'processing'                     => 'Procesando',
                    'sandbox'                        => 'Entorno de pruebas',
                    'set-invoice-status'             => 'Establecer el estado de la factura después de crearla a',
                    'set-order-status'               => 'Establecer el estado del pedido después de crear la factura a',
                    'sort-order'                     => 'Orden de clasificación',
                    'status'                         => 'Estado',
                    'title'                          => 'Título',
                ],

                'order-settings' => [
                    'info'               => 'Configurar números de pedido, pedidos mínimos y pedidos pendientes.',
                    'title'              => 'Configuración de pedidos',

                    'order-number' => [
                        'generator'   => 'Generador de números de pedido',
                        'info'        => 'Identificador único asignado a un pedido específico de un cliente, que ayuda al seguimiento, la comunicación y la referencia durante todo el proceso de compra.',
                        'length'      => 'Longitud del número de pedido',
                        'prefix'      => 'Prefijo del número de pedido',
                        'suffix'      => 'Sufijo del número de pedido',
                        'title'       => 'Configuración del número de pedido',
                    ],

                    'minimum-order' => [
                        'description'             => 'Descripción',
                        'enable'                  => 'Habilitar',
                        'include-discount-amount' => 'Incluir monto de descuento',
                        'include-tax-amount'      => 'Incluir impuesto en el monto',
                        'info'                    => 'Criterios configurados que especifican la cantidad o el valor mínimo requerido para que un pedido se procese o califique para beneficios.',
                        'minimum-order-amount'    => 'Monto mínimo del pedido',
                        'title'                   => 'Configuración del pedido mínimo',
                    ],

                    'reorder' => [
                        'admin-reorder'      => 'Reordenar como administrador',
                        'admin-reorder-info' => 'Habilitar o deshabilitar la función de reordenar para los usuarios administradores.',
                        'info'               => 'Habilitar o deshabilitar la función de reordenar para los usuarios administradores.',
                        'shop-reorder'       => 'Reordenar como tienda',
                        'shop-reorder-info'  => 'Habilitar o deshabilitar la función de reordenar para los usuarios de la tienda.',
                        'title'              => 'Permitir reordenar',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'Permitir pedidos pendientes',
                        'info'              => 'Las opciones de stock son contratos de inversión que otorgan el derecho de comprar o vender acciones de una empresa a un precio predeterminado, influyendo en las ganancias potenciales.',
                        'title'             => 'Opciones de stock',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => 'Configurar el número de factura, los plazos de pago, el diseño del comprobante de factura y los recordatorios de factura.',
                    'title' => 'Configuración de facturas',

                    'invoice-number' => [
                        'generator'  => 'Generador de números de factura',
                        'info'       => 'Configuración de reglas o parámetros para generar y asignar números de identificación únicos a las facturas con fines organizativos y de seguimiento.',
                        'length'     => 'Longitud del número de factura',
                        'prefix'     => 'Prefijo del número de factura',
                        'suffix'     => 'Sufijo del número de factura',
                        'title'      => 'Configuración del número de factura',
                    ],

                    'payment-terms' => [
                        'due-duration'      => 'Duración del vencimiento',
                        'due-duration-day'  => ':due-duration día',
                        'due-duration-days' => ':due-duration días',
                        'info'              => 'Condiciones acordadas que dictan cuándo y cómo se debe realizar el pago de bienes o servicios por parte del comprador al vendedor.',
                        'title'             => 'Términos de pago',
                    ],

                    'pdf-print-outs' => [
                        'footer-text'      => 'Texto de pie de página',
                        'footer-text-info' => 'Introduce el texto que aparecerá en el pie de página del PDF.',
                        'info'             => 'Configurar las impresiones en PDF para mostrar el ID de la factura, el ID del pedido en el encabezado e incluir el logotipo de la factura.',
                        'invoice-id-info'  => 'Configurar la visualización del ID de la factura en el encabezado de la factura.',
                        'invoice-id-title' => 'Mostrar ID de factura en el encabezado',
                        'logo'             => 'Logotipo',
                        'logo-info'        => 'La resolución de la imagen debe ser de 131px X 30px.',
                        'order-id-info'    => 'Configurar la visualización del ID del pedido en el encabezado de la factura.',
                        'order-id-title'   => 'Mostrar ID de pedido en el encabezado',
                        'title'            => 'Impresiones en PDF',
                    ],

                    'invoice-reminders' => [
                        'info'                       => 'Notificaciones o comunicaciones automatizadas enviadas a los clientes para recordarles los pagos próximos o vencidos de las facturas.',
                        'interval-between-reminders' => 'Intervalo entre recordatorios',
                        'maximum-limit-of-reminders' => 'Límite máximo de recordatorios',
                        'title'                      => 'Recordatorios de factura',
                    ],
                ],

                'taxes' => [
                    'title'      => 'Impuestos',
                    'title-info' => 'Los impuestos son tarifas obligatorias impuestas por los gobiernos sobre bienes, servicios o transacciones, recaudadas por los vendedores y remitidas a las autoridades.',

                    'categories' => [
                        'title'      => 'Categorías de impuestos',
                        'title-info' => 'Las categorías de impuestos son clasificaciones para diferentes tipos de impuestos, como el impuesto sobre las ventas, el impuesto al valor agregado o el impuesto de consumo, que se utilizan para categorizar y aplicar tasas impositivas a productos o servicios.',
                        'product'    => 'Categoría de impuesto predeterminada del producto',
                        'shipping'   => 'Categoría de impuesto del envío',
                        'none'       => 'Ninguno',
                    ],

                    'calculation' => [
                        'title'            => 'Configuración de cálculo',
                        'title-info'       => 'Detalles sobre el costo de bienes o servicios, incluyendo el precio base, descuentos, impuestos y cargos adicionales.',
                        'based-on'         => 'Cálculo basado en',
                        'shipping-address' => 'Dirección de envío',
                        'billing-address'  => 'Dirección de facturación',
                        'shipping-origin'  => 'Origen del envío',
                        'product-prices'   => 'Precios de productos',
                        'shipping-prices'  => 'Precios de envío',
                        'excluding-tax'    => 'Excluyendo impuestos',
                        'including-tax'    => 'Incluyendo impuestos',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'País predeterminado',
                        'default-post-code' => 'Código postal predeterminado',
                        'default-state'     => 'Estado predeterminado',
                        'title'             => 'Cálculo de destino predeterminado',
                        'title-info'        => 'Determinación automatizada de un destino estándar o inicial basado en factores o configuraciones predefinidos.',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'Configuración de visualización del carrito de compras',
                        'title-info'              => 'Configurar la visualización de los impuestos en el carrito de compras',
                        'display-prices'          => 'Mostrar precios',
                        'display-subtotal'        => 'Mostrar subtotal',
                        'display-shipping-amount' => 'Mostrar monto de envío',
                        'excluding-tax'           => 'Excluyendo impuestos',
                        'including-tax'           => 'Incluyendo impuestos',
                        'both'                    => 'Excluyendo e incluyendo ambos',
                    ],

                    'sales' => [
                        'title'                   => 'Configuración de visualización de pedidos, facturas y reembolsos',
                        'title-info'              => 'Configurar la visualización de los impuestos en los pedidos, facturas y reembolsos',
                        'display-prices'          => 'Mostrar precios',
                        'display-subtotal'        => 'Mostrar subtotal',
                        'display-shipping-amount' => 'Mostrar monto de envío',
                        'excluding-tax'           => 'Excluyendo impuestos',
                        'including-tax'           => 'Incluyendo impuestos',
                        'both'                    => 'Excluyendo e incluyendo ambos',
                    ],
                ],

                'checkout' => [
                    'title' => 'Finalizar compra',
                    'info'  => 'Configurar pago como invitado, habilitar o deshabilitar el carrito mini, resumen del carrito.',

                    'shopping-cart' => [
                        'cart-page'              => 'Página del carrito',
                        'cart-page-info'         => 'Controlar la visibilidad de la página del carrito para mejorar la experiencia de compra del usuario.',
                        'cross-sell'             => 'Productos de venta cruzada',
                        'cross-sell-info'        => 'Habilitar productos de venta cruzada para aumentar las oportunidades de ventas adicionales.',
                        'estimate-shipping'      => 'Envío estimado',
                        'estimate-shipping-info' => 'Habilitar el envío estimado para proporcionar los costos de envío por adelantado.',
                        'guest-checkout'         => 'Permitir compra como invitado',
                        'guest-checkout-info'    => 'Habilitar la compra como invitado para un proceso de compra más rápido y sin complicaciones.',
                        'info'                   => 'Habilitar la compra como invitado, la página del carrito, los productos de venta cruzada y el envío estimado para mejorar la comodidad del usuario y agilizar el proceso de compra para aumentar las ventas.',
                        'title'                  => 'Carrito de compras',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'Mostrar cantidades de productos',
                        'display-number-in-cart'  => 'Mostrar número de productos en el carrito',
                        'info'                    => 'Habilitar la configuración de Mi carrito para mostrar un resumen de las cantidades de productos y mostrar el número total de productos en el carrito para un seguimiento fácil.',
                        'summary'                 => 'Resumen',
                        'title'                   => 'Mi carrito',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'Mostrar mini carrito',
                        'info'                 => 'Habilitar la configuración del mini carrito para mostrar el mini carrito y mostrar información de oferta del mini carrito para acceder rápidamente a los detalles del carrito y las promociones.',
                        'mini-cart-offer-info' => 'Información de oferta del mini carrito',
                        'title'                => 'Mini carrito',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'Cuenta',
                'app-version'   => 'Versión : :version',
                'logout'        => 'Cerrar Sesión',
                'my-account'    => 'Mi Cuenta',
                'notifications' => 'Notificaciones',
                'visit-shop'    => 'Visitar Tienda',

                'mega-search' => [
                    'categories'                      => 'Categorías',
                    'customers'                       => 'Clientes',
                    'explore-all-categories'          => 'Explorar todas las categorías',
                    'explore-all-customers'           => 'Explorar todos los clientes',
                    'explore-all-matching-categories' => 'Explorar todas las categorías que coinciden con \":query\" (:count)',
                    'explore-all-matching-customers'  => 'Explorar todos los clientes que coinciden con \":query\" (:count)',
                    'explore-all-matching-orders'     => 'Explorar todos los pedidos que coinciden con \":query\" (:count)',
                    'explore-all-matching-products'   => 'Explorar todos los productos que coinciden con \":query\" (:count)',
                    'explore-all-orders'              => 'Explorar todos los pedidos',
                    'explore-all-products'            => 'Explorar todos los productos',
                    'orders'                          => 'Pedidos',
                    'products'                        => 'Productos',
                    'sku'                             => 'SKU: :sku',
                    'title'                           => 'Búsqueda Avanzada',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => 'Familias de atributos',
                'attributes'               => 'Atributos',
                'booking-product'          => 'Reservas',
                'campaigns'                => 'Campañas',
                'catalog'                  => 'Catálogo',
                'categories'               => 'Categorías',
                'channels'                 => 'Canales',
                'cms'                      => 'CMS',
                'collapse'                 => 'Colapsar',
                'communications'           => 'Comunicaciones',
                'configure'                => 'Configurar',
                'currencies'               => 'Monedas',
                'customers'                => 'Clientes',
                'dashboard'                => 'Panel de control',
                'data-transfer'            => 'Transferencia de datos',
                'discount'                 => 'Descuento',
                'email-templates'          => 'Plantillas de correo',
                'events'                   => 'Eventos',
                'exchange-rates'           => 'Tasas de cambio',
                'gdpr-data-requests'       => 'Solicitudes de datos GDPR',
                'groups'                   => 'Grupos',
                'imports'                  => 'Importaciones',
                'inventory-sources'        => 'Fuentes de inventario',
                'invoices'                 => 'Facturas',
                'locales'                  => 'Idiomas',
                'marketing'                => 'Marketing',
                'mode'                     => 'Modo oscuro',
                'newsletter-subscriptions' => 'Suscripciones al boletín',
                'orders'                   => 'Pedidos',
                'products'                 => 'Productos',
                'promotions'               => 'Promociones',
                'refunds'                  => 'Reembolsos',
                'reporting'                => 'Informes',
                'reviews'                  => 'Reseñas',
                'roles'                    => 'Roles',
                'sales'                    => 'Ventas',
                'search-seo'               => 'Búsqueda y SEO',
                'search-synonyms'          => 'Sinónimos de búsqueda',
                'search-terms'             => 'Términos de búsqueda',
                'settings'                 => 'Configuraciones',
                'shipments'                => 'Envíos',
                'sitemaps'                 => 'Mapas del sitio',
                'tax-categories'           => 'Categorías de impuestos',
                'tax-rates'                => 'Tasas de impuestos',
                'taxes'                    => 'Impuestos',
                'themes'                   => 'Temas',
                'transactions'             => 'Transacciones',
                'url-rewrites'             => 'Reescrituras de URL',
                'users'                    => 'Usuarios',
            ],

            'powered-by' => [
                'description' => 'Desarrollado por :bagisto, un proyecto de código abierto de :webkul.',
            ],
        ],

        'datagrid' => [
            'index' => [
                'must-select-a-mass-action'        => 'Debe seleccionar una acción masiva.',
                'must-select-a-mass-action-option' => 'Debe seleccionar una opción de acción masiva.',
                'no-records-selected'              => 'No se han seleccionado registros.',
            ],

            'toolbar' => [
                'length-of' => ':length de',
                'of'        => 'de',
                'per-page'  => 'Por página',
                'results'   => ':total Resultados',
                'selected'  => ':total Seleccionado',

                'mass-actions' => [
                    'select-action' => 'Seleccionar Acción',
                    'select-option' => 'Seleccionar Opción',
                    'submit'        => 'Enviar',
                ],

                'filter' => [
                    'apply-filters-btn' => 'Aplicar filtros',
                    'back-btn'          => 'Atrás',
                    'create-new-filter' => 'Crear nuevo filtro',
                    'custom-filters'    => 'Filtros personalizados',
                    'delete-error'      => 'Algo salió mal al eliminar el filtro, por favor intente de nuevo.',
                    'delete-success'    => 'El filtro se ha eliminado correctamente.',
                    'empty-description' => 'No hay filtros seleccionados disponibles para guardar. Por favor, seleccione filtros para guardar.',
                    'empty-title'       => 'Agregar filtros para guardar',
                    'name'              => 'Nombre',
                    'quick-filters'     => 'Filtros rápidos',
                    'save-btn'          => 'Guardar',
                    'save-filter'       => 'Guardar filtro',
                    'saved-success'     => 'El filtro se ha guardado correctamente.',
                    'selected-filters'  => 'Filtros seleccionados',
                    'title'             => 'Filtro',
                    'update'            => 'Actualizar',
                    'update-filter'     => 'Actualizar filtro',
                    'updated-success'   => 'El filtro se ha actualizado correctamente.',
                ],

                'search' => [
                    'title' => 'Buscar',
                ],
            ],

            'filters' => [
                'select' => 'Seleccionar.',
                'title'  => 'Filtros',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => 'Escribe al menos 2 caracteres...',
                        'no-results'        => 'No se encontraron resultados...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'Limpiar Todo',
                    'title'     => 'Filtros Personalizados',
                ],

                'boolean-options' => [
                    'false' => 'Falso',
                    'true'  => 'Verdadero',
                ],

                'date-options' => [
                    'last-month'        => 'Mes Anterior',
                    'last-six-months'   => 'Últimos 6 Meses',
                    'last-three-months' => 'Últimos 3 Meses',
                    'this-month'        => 'Este Mes',
                    'this-week'         => 'Esta Semana',
                    'this-year'         => 'Este Año',
                    'today'             => 'Hoy',
                    'yesterday'         => 'Ayer',
                ],
            ],

            'table' => [
                'actions'              => 'Acciones',
                'no-records-available' => 'No hay Registros Disponibles.',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => 'Aceptar',
                'disagree-btn' => 'Cancelar',
                'message'      => '¿Estás seguro de que quieres realizar esta acción?',
                'title'        => '¿Estás seguro?',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => 'Agregar producto seleccionado',
                'empty-info'    => 'No hay productos disponibles para el término de búsqueda.',
                'empty-title'   => 'No se encontraron productos',
                'product-image' => 'Imagen del producto',
                'qty'           => ':qty disponible',
                'sku'           => 'SKU - :sku',
                'title'         => 'Seleccionar productos',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => 'Agregar Imagen',
                'ai-add-image-btn'  => 'Magia IA',
                'ai-btn-info'       => 'Generar Imagen',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => 'Solo se permiten archivos de imagen (.jpeg, .jpg, .png, ..).',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => 'Aplicar',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => 'Generar',
                    'generating'       => 'Generando...',
                    'hd'               => 'HD',
                    'model'            => 'Modelo',
                    'number-of-images' => 'Número de Imágenes',
                    'prompt'           => 'Indicación',
                    'quality'          => 'Calidad',
                    'regenerate'       => 'Regenerar',
                    'regenerating'     => 'Regenerando...',
                    'size'             => 'Tamaño',
                    'standard'         => 'Estándar',
                    'title'            => 'Generación de Imágenes con IA',
                ],

                'placeholders'  => [
                    'front'     => 'Frontal',
                    'next'      => 'Siguiente',
                    'size'      => 'Tamaño',
                    'use-cases' => 'Casos de Uso',
                    'zoom'      => 'Zoom',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'Agregar Video',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Solo se permiten archivos de video (.mp4, .mov, .ogg ..).',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'Magia IA',

            'ai-generation' => [
                'apply'                    => 'Aplicar',
                'deepseek-r1-8b'           => 'DeepSeek R1 (8b)',
                'enabled'                  => 'Habilitado',
                'gemini-2-0-flash'         => 'Gemini 2.0 Flash',
                'generate'                 => 'Generar',
                'generated-content'        => 'Contenido Generado',
                'generated-content-info'   => 'El contenido generado por IA puede ser engañoso. Por favor, revise el contenido generado antes de aplicarlo.',
                'generating'               => 'Generando...',
                'gpt-4-turbo'              => 'OpenAI gpt-4 Turbo',
                'gpt-4o'                   => 'OpenAI gpt-4o',
                'gpt-4o-mini'              => 'OpenAI gpt-4o mini',
                'llama-groq'               => 'Llama 3.3 (Groq)',
                'llama3-1-8b'              => 'Llama 3.1 (8B)',
                'llama3-2-1b'              => 'Llama 3.2 (1B)',
                'llama3-2-3b'              => 'Llama 3.2 (3B)',
                'llama3-8b'                => 'Llama 3 (8B)',
                'llava-7b'                 => 'Llava (7b)',
                'mistral-7b'               => 'Mistral (7b)',
                'model'                    => 'Modelo',
                'orca-mini'                => 'Orca Mini',
                'phi3-5'                   => 'Phi 3.5',
                'prompt'                   => 'Indicación',
                'qwen2-5-0-5b'             => 'Qwen 2.5 (0.5b)',
                'qwen2-5-1-5b'             => 'Qwen 2.5 (1.5b)',
                'qwen2-5-14b'              => 'Qwen 2.5 (14b)',
                'qwen2-5-3b'               => 'Qwen 2.5 (3b)',
                'qwen2-5-7b'               => 'Qwen 2.5 (7b)',
                'starling-lm-7b'           => 'Starling-lm (7b)',
                'title'                    => 'Asistencia de IA',
                'vicuna-13b'               => 'Vicuna (13b)',
                'vicuna-7b'                => 'Vicuna (7b)',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => 'Direcciones',
        'attribute-families'       => 'Familias de Atributos',
        'attributes'               => 'Atributos',
        'campaigns'                => 'Campañas',
        'cancel'                   => 'Cancelar',
        'cart-rules'               => 'Reglas del Carrito',
        'catalog-rules'            => 'Reglas del Catálogo',
        'catalog'                  => 'Catálogo',
        'categories'               => 'Categorías',
        'channels'                 => 'Canales',
        'cms'                      => 'CMS',
        'communications'           => 'Comunicaciones',
        'configure'                => 'Configurar',
        'copy'                     => 'Copiar',
        'create'                   => 'crear',
        'currencies'               => 'Monedas',
        'customers'                => 'Clientes',
        'dashboard'                => 'Tablero',
        'data-transfer'            => 'Transferencia de datos',
        'delete'                   => 'Eliminar',
        'edit'                     => 'Editar',
        'email-templates'          => 'Plantillas de Correo Electrónico',
        'events'                   => 'Eventos',
        'exchange-rates'           => 'Tasas de Cambio',
        'gdpr'                     => 'RGPD',
        'groups'                   => 'Grupos',
        'import'                   => 'Importar',
        'imports'                  => 'Importaciones',
        'inventory-sources'        => 'Fuentes de Inventario',
        'invoices'                 => 'Facturas',
        'locales'                  => 'Idiomas',
        'marketing'                => 'Marketing',
        'newsletter-subscriptions' => 'Suscripciones al Boletín',
        'note'                     => 'Nota',
        'orders'                   => 'Pedidos',
        'products'                 => 'Productos',
        'promotions'               => 'Promociones',
        'refunds'                  => 'Reembolsos',
        'reporting'                => 'Informes',
        'reviews'                  => 'Reseñas',
        'roles'                    => 'Roles',
        'sales'                    => 'Ventas',
        'search-seo'               => 'Búsqueda y SEO',
        'search-synonyms'          => 'Sinónimos de Búsqueda',
        'search-terms'             => 'Términos de búsqueda',
        'settings'                 => 'Configuración',
        'shipments'                => 'Envíos',
        'sitemaps'                 => 'Mapas del Sitio',
        'subscribers'              => 'Suscriptores del Boletín',
        'tax-categories'           => 'Categorías de Impuestos',
        'tax-rates'                => 'Tasas de Impuestos',
        'taxes'                    => 'Impuestos',
        'themes'                   => 'Temas',
        'transactions'             => 'Transacciones',
        'url-rewrites'             => 'Reescrituras de URL',
        'users'                    => 'Usuarios',
        'view'                     => 'Ver',
    ],

    'errors' => [
        'dashboard' => 'Tablero',
        'go-back'   => 'Regresar',
        'support'   => 'Si el problema persiste, contáctenos en <a href=":link" class=":class">:email</a> para obtener ayuda.',

        '404' => [
            'description' => '¡Ups! La página que estás buscando está de vacaciones. Parece que no pudimos encontrar lo que buscabas.',
            'title'       => '404 Página no Encontrada',
        ],

        '401' => [
            'description' => '¡Ups! Parece que no tienes permiso para acceder a esta página. Parece que te faltan las credenciales necesarias.',
            'title'       => '401 No Autorizado',
        ],

        '403' => [
            'description' => '¡Ups! Esta página está fuera de límites. Parece que no tienes los permisos necesarios para ver este contenido.',
            'title'       => '403 Prohibido',
        ],

        '500' => [
            'description' => '¡Ups! Algo salió mal. Parece que tenemos problemas para cargar la página que estás buscando.',
            'title'       => '500 Error Interno del Servidor',
        ],

        '503' => [
            'description' => '¡Ups! Parece que estamos temporalmente fuera de servicio por mantenimiento. Por favor, vuelve a intentarlo en un momento.',
            'title'       => '503 Servicio No Disponible',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Descargar',
        'export'     => 'Exportar',
        'no-records' => 'Nada que exportar',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'Este slug se está utilizando en categorías o productos.',
        'slug-reserved'   => 'Este slug está reservado.',
    ],

    'footer' => [
        'copy-right' => 'Desarrollado por <a href="https://bagisto.com/" target="_blank">Bagisto</a>, Un Proyecto Comunitario por <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => 'Estimado :admin_name',
        'thanks' => 'Si necesitas cualquier tipo de ayuda, por favor contáctanos en <a href=":link" style=":style">:email</a>.<br/>¡Gracias!',

        'admin' => [
            'forgot-password' => [
                'description'    => 'Recibes este correo electrónico porque hemos recibido una solicitud para restablecer la contraseña de tu cuenta.',
                'greeting'       => '¡Contraseña olvidada!',
                'reset-password' => 'Restablecer contraseña',
                'subject'        => 'Correo electrónico para restablecer la contraseña',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => 'Se ha creado correctamente una nueva cuenta de cliente. Ahora pueden iniciar sesión con sus credenciales de dirección de correo electrónico y contraseña. Una vez que hayan iniciado sesión, tendrán acceso a varios servicios, incluida la capacidad de revisar pedidos anteriores, administrar listas de deseos y actualizar la información de su cuenta.',
                'greeting'    => '¡Damos una cálida bienvenida al nuevo cliente, :customer_name que acaba de registrarse con nosotros!',
                'subject'     => 'Registro de nuevo cliente',
            ],

            'gdpr' => [
                'new-delete-request' => 'Nueva solicitud para eliminar datos',
                'new-update-request' => 'Nueva solicitud para actualizar datos',

                'new-request' => [
                    'customer-name'  => 'Nombre del cliente : ',
                    'delete-summary' => 'Resumen de la solicitud de eliminación',
                    'message'        => 'Mensaje : ',
                    'request-status' => 'Estado de la solicitud : ',
                    'request-type'   => 'Tipo de solicitud : ',
                    'update-summary' => 'Resumen de la solicitud de actualización',
                ],

                'status-update' => [
                    'subject'        => 'La solicitud GDPR ha sido actualizada',
                    'summary'        => 'El estado de la solicitud GDPR ha sido actualizado',
                    'request-status' => 'Estado de la solicitud:',
                    'request-type'   => 'Tipo de solicitud:',
                    'message'        => 'Mensaje:',
                ],
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Tienes un nuevo pedido :order_id realizado el :created_at',
                'subject'  => 'Confirmación de Nuevo Pedido',
                'summary'  => 'Resumen del Pedido',
                'title'    => '¡Confirmación de Pedido!',
            ],

            'invoiced' => [
                'greeting' => 'Tu factura #:invoice_id para el pedido :order_id se ha creado el :created_at',
                'subject'  => 'Confirmación de Nueva Factura',
                'summary'  => 'Resumen de la Factura',
                'title'    => '¡Confirmación de Factura!',
            ],

            'shipped' => [
                'greeting' => 'Has enviado el pedido :order_id realizado el :created_at',
                'subject'  => 'Confirmación de Nuevo Envío',
                'summary'  => 'Resumen del Envío',
                'title'    => '¡Pedido Enviado!',
            ],

            'inventory-source' => [
                'greeting' => 'Has enviado el pedido :order_id realizado el :created_at',
                'subject'  => 'Confirmación de Nuevo Envío',
                'summary'  => 'Resumen del Envío',
                'title'    => '¡Pedido Enviado!',
            ],

            'refunded' => [
                'greeting' => 'Has reembolsado el pedido :order_id realizado el :created_at',
                'subject'  => 'Confirmación de Nuevo Reembolso',
                'summary'  => 'Resumen del Reembolso',
                'title'    => '¡Pedido Reembolsado!',
            ],

            'canceled' => [
                'greeting' => 'Has cancelado el pedido :order_id realizado el :created_at',
                'subject'  => 'Confirmación de Cancelación de Pedido',
                'summary'  => 'Resumen del Pedido',
                'title'    => '¡Pedido Cancelado!',
            ],

            'billing-address'            => 'Dirección de Facturación',
            'carrier'                    => 'Transportista',
            'contact'                    => 'Contacto',
            'discount'                   => 'Descuento',
            'excl-tax'                   => 'Excl. Impuestos: ',
            'grand-total'                => 'Total General',
            'name'                       => 'Nombre',
            'payment'                    => 'Pago',
            'price'                      => 'Precio',
            'qty'                        => 'Cantidad',
            'shipping-address'           => 'Dirección de Envío',
            'shipping-handling-excl-tax' => 'Envío y Manipulación (Excl. Impuestos)',
            'shipping-handling-incl-tax' => 'Envío y Manipulación (Incl. Impuestos)',
            'shipping-handling'          => 'Envío y Manipulación',
            'shipping'                   => 'Envío',
            'sku'                        => 'SKU',
            'subtotal-excl-tax'          => 'Subtotal (Excl. Impuestos)',
            'subtotal-incl-tax'          => 'Subtotal (Incl. Impuestos)',
            'subtotal'                   => 'Subtotal',
            'tax'                        => 'Impuestos',
            'tracking-number'            => 'Número de Seguimiento: :tracking_number',
        ],
    ],
];
