<?php

return [
    'users' => [
        'sessions' => [
            'email'                  => 'E-Mail-Adresse',
            'forget-password-link'   => 'Passwort vergessen?',
            'password'               => 'Passwort',
            'powered-by-description' => 'Powered by :bagisto, ein Open-Source-Projekt von :webkul.',
            'submit-btn'             => 'Anmelden',
            'title'                  => 'Anmelden',
        ],

        'forget-password' => [
            'create' => [
                'email'                  => 'Registrierte E-Mail',
                'email-not-exist'        => 'E-Mail existiert nicht',
                'page-title'             => 'Passwort vergessen',
                'powered-by-description' => 'Powered by :bagisto, ein Open-Source-Projekt von :webkul.',
                'reset-link-sent'        => 'Link zum Zurücksetzen des Passworts gesendet',
                'sign-in-link'           => 'Zurück zur Anmeldung?',
                'submit-btn'             => 'Zurücksetzen',
                'title'                  => 'Passwort wiederherstellen',
            ],
        ],

        'reset-password' => [
            'back-link-title'        => 'Zurück zur Anmeldung?',
            'confirm-password'       => 'Passwort bestätigen',
            'email'                  => 'Registrierte E-Mail',
            'password'               => 'Passwort',
            'powered-by-description' => 'Powered by :bagisto, ein Open-Source-Projekt von :webkul.',
            'submit-btn'             => 'Passwort zurücksetzen',
            'title'                  => 'Passwort zurücksetzen',
        ],
    ],

    'notifications' => [
        'description-text' => 'Alle Benachrichtigungen auflisten',
        'marked-success'   => 'Alle Benachrichtigungen wurden als gelesen markiert',
        'no-record'        => 'Kein Datensatz gefunden',
        'of'               => 'von',
        'per-page'         => 'Pro Seite',
        'read-all'         => 'Als gelesen markieren',
        'title'            => 'Benachrichtigungen',
        'view-all'         => 'Alle anzeigen',

        'order-status-messages' => [
            'all'             => 'Alle',
            'canceled'        => 'Bestellung storniert',
            'closed'          => 'Bestellung geschlossen',
            'completed'       => 'Bestellung abgeschlossen',
            'pending'         => 'Bestellung ausstehend',
            'pending-payment' => 'Zahlung ausstehend',
            'processing'      => 'Bestellung in Bearbeitung',
        ],
    ],

    'account' => [
        'edit' => [
            'back-btn'          => 'Zurück',
            'change-password'   => 'Passwort ändern',
            'confirm-password'  => 'Passwort bestätigen',
            'current-password'  => 'Aktuelles Passwort',
            'email'             => 'E-Mail',
            'general'           => 'Allgemein',
            'invalid-password'  => 'Das von Ihnen eingegebene aktuelle Passwort ist falsch.',
            'name'              => 'Name',
            'password'          => 'Passwort',
            'profile-image'     => 'Profilbild',
            'save-btn'          => 'Konto speichern',
            'title'             => 'Mein Konto',
            'update-success'    => 'Konto erfolgreich aktualisiert',
            'upload-image-info' => 'Laden Sie ein Profilbild (110px X 110px) im PNG- oder JPG-Format hoch',
        ],
    ],

    'dashboard' => [
        'index' => [
            'add-customer'                => 'Kunde hinzufügen',
            'add-product'                 => 'Produkt hinzufügen',
            'all-channels'                => 'Alle Kanäle',
            'attribute-code'              => 'Attributcode',
            'average-sale'                => 'Durchschnittlicher Bestellumsatz',
            'color'                       => 'Farbe',
            'customer-info'               => 'Kein Kunde mit den meisten Verkäufen gefunden',
            'customer-with-most-sales'    => 'Kunde mit den meisten Verkäufen',
            'date-duration'               => ':start - :end',
            'decreased'                   => ':progress%',
            'empty-threshold'             => 'Leerstand-Schwelle',
            'empty-threshold-description' => 'Es sind keine Produkte verfügbar',
            'end-date'                    => 'Enddatum',
            'from'                        => 'Von',
            'increased'                   => ':progress%',
            'more-products'               => ':product_count+ weitere Bilder',
            'order'                       => ':total_orders Bestellungen',
            'order-count'                 => ':count Bestellungen',
            'order-id'                    => 'Bestellnummer #:id',
            'overall-details'             => 'Gesamtdetails',
            'pay-by'                      => 'Bezahlen mit - :method',
            'product-count'               => ':count Produkte',
            'product-image'               => 'Produktbild',
            'product-info'                => 'Fügen Sie verwandte Produkte unterwegs hinzu.',
            'product-number'              => 'Produkt - :product_number',
            'revenue'                     => 'Einnahmen: :total',
            'sale-count'                  => ':count Verkäufe',
            'sales'                       => 'Verkäufe',
            'sku'                         => 'Artikelnummer (SKU) - :sku',
            'start-date'                  => 'Startdatum',
            'stock-threshold'             => 'Lagerbestandsschwelle',
            'store-stats'                 => 'Geschäftsstatistiken',
            'title'                       => 'Dashboard',
            'to'                          => 'Bis',
            'today-customers'             => 'Kunden heute',
            'today-details'               => 'Details für heute',
            'today-orders'                => 'Bestellungen heute',
            'today-sales'                 => 'Umsatz heute',
            'top-performing-categories'   => 'Top-Kategorien',
            'top-selling-products'        => 'Bestverkaufte Produkte',
            'total-customers'             => 'Gesamtkunden',
            'total-orders'                => 'Gesamtbestellungen',
            'total-sales'                 => 'Gesamtumsatz',
            'total-stock'                 => ':total_stock Lagerbestand',
            'total-unpaid-invoices'       => 'Gesamtunbezahlte Rechnungen',
            'unique-visitors'             => ':count Eindeutig',
            'user-info'                   => 'Schnelle Übersicht über Geschehnisse in Ihrem Geschäft',
            'user-name'                   => 'Hallo, :user_name!',
            'visitors'                    => 'Besucher',
        ],
    ],

    'sales' => [
        'orders' => [
            'index' => [
                'create-btn' => 'Bestellung erstellen',
                'title'      => 'Bestellungen',

                'search-customer' => [
                    'create-btn'  => 'Kunden erstellen',
                    'empty-info'  => 'Keine Kunden verfügbar für Suchbegriff.',
                    'empty-title' => 'Keine Kunden gefunden',
                    'search-by'   => 'Suche nach E-Mail oder Name',
                    'title'       => 'Kunden auswählen',
                ],

                'datagrid' => [
                    'canceled'        => 'Storniert',
                    'channel-name'    => 'Kanal',
                    'closed'          => 'Geschlossen',
                    'completed'       => 'Abgeschlossen',
                    'customer'        => 'Kunde',
                    'date'            => 'Datum',
                    'email'           => 'E-Mail',
                    'fraud'           => 'Betrug',
                    'grand-total'     => 'Gesamtsumme',
                    'id'              => 'Bestellnummer #:id',
                    'items'           => 'Artikel',
                    'location'        => 'Ort',
                    'order-id'        => 'Bestellnummer',
                    'pay-by'          => 'Bezahlen mit - :method',
                    'pay-via'         => 'Zahlung via',
                    'pending-payment' => 'Zahlung ausstehend',
                    'pending'         => 'Ausstehend',
                    'processing'      => 'Bearbeitung',
                    'product-count'   => ':count + Mehr Produkte',
                    'status'          => 'Status',
                    'success'         => 'Erfolgreich',
                    'view'            => 'Ansehen',
                ],
            ],

            'create' => [
                'add-to-cart'             => 'In den Warenkorb',
                'back-btn'                => 'Zurück',
                'check-billing-address'   => 'Rechnungsadresse fehlt.',
                'check-shipping-address'  => 'Lieferadresse fehlt.',
                'configuration'           => 'Konfiguration',
                'coupon-already-applied'  => 'Gutscheincode bereits angewendet.',
                'coupon-applied'          => 'Gutscheincode erfolgreich angewendet.',
                'coupon-error'            => 'Gutscheincode kann nicht angewendet werden.',
                'coupon-not-found'        => 'Gutschein nicht gefunden',
                'coupon-remove'           => 'Gutscheincode erfolgreich entfernt.',
                'error'                   => 'Etwas ist schief gelaufen',
                'minimum-order-error'     => 'Der Mindestbestellwert wurde nicht erreicht.',
                'order-placed-success'    => 'Bestellung erfolgreich aufgegeben.',
                'payment-not-supported'   => 'Diese Zahlungsmethode wird nicht unterstützt',
                'save-btn'                => 'Bestellung erstellen',
                'specify-payment-method'  => 'Zahlungsmethode fehlt.',
                'specify-shipping-method' => 'Versandmethode fehlt.',
                'title'                   => 'Bestellung erstellen für :name',

                'types' => [
                    'simple' => [
                        'none'         => 'Keine',
                        'total-amount' => 'Gesamtsumme',
                    ],

                    'configurable' => [
                        'select-options' => 'Bitte eine Option auswählen',
                    ],

                    'bundle' => [
                        'none'         => 'Keine',
                        'total-amount' => 'Gesamtsumme',
                    ],

                    'grouped' => [
                        'name' => 'Name',
                    ],

                    'downloadable' => [
                        'title' => 'Links',
                    ],

                    'virtual' => [
                        'none'         => 'Keine',
                        'total-amount' => 'Gesamtsumme',
                    ],
                ],

                'cart' => [
                    'success-add-to-cart' => 'Produkt erfolgreich zum Warenkorb hinzugefügt',
                    'success-remove'      => 'Artikel erfolgreich aus dem Warenkorb entfernt',
                    'success-update'      => 'Warenkorbartikel erfolgreich aktualisiert',

                    'items' => [
                        'add-product'       => 'Produkt hinzufügen',
                        'amount-per-unit'   => ':amount pro Einheit x :qty Menge',
                        'delete'            => 'Löschen',
                        'empty-description' => 'Keine Artikel im Warenkorb gefunden.',
                        'empty-title'       => 'Leere Warenkorbartikel',
                        'excl-tax'          => 'Ohne MwSt',
                        'move-to-wishlist'  => 'Zur Wunschliste hinzufügen',
                        'see-details'       => 'Details anzeigen',
                        'sku'               => 'SKU - :sku',
                        'sub-total'         => 'Zwischensumme - :sub_total',
                        'title'             => 'Warenkorbartikel',

                        'search' => [
                            'add-to-cart'   => 'In den Warenkorb',
                            'available-qty' => ':qty verfügbar',
                            'empty-info'    => 'Keine Produkte für den Suchbegriff verfügbar.',
                            'empty-title'   => 'Keine Produkte gefunden',
                            'product-image' => 'Produktbild',
                            'qty'           => 'Menge',
                            'sku'           => 'SKU - :sku',
                            'title'         => 'Produkte suchen',
                        ],
                    ],

                    'address' => [
                        'add-btn'          => 'Adresse hinzufügen',
                        'add-new'          => 'Neue Adresse hinzufügen',
                        'add-new-address'  => 'Neue Adresse hinzufügen',
                        'addresses'        => 'Adressen',
                        'back'             => 'Zurück',
                        'billing-address'  => 'Rechnungsadresse',
                        'city'             => 'Stadt',
                        'company-name'     => 'Firmenname',
                        'confirm'          => 'Bestätigen',
                        'country'          => 'Land',
                        'edit-btn'         => 'Adresse bearbeiten',
                        'email'            => 'E-Mail',
                        'first-name'       => 'Vorname',
                        'last-name'        => 'Nachname',
                        'postcode'         => 'PLZ',
                        'proceed'          => 'Weiter',
                        'same-as-billing'  => 'Gleiche Adresse für Versand verwenden?',
                        'save'             => 'Speichern',
                        'save-address'     => 'In Adressbuch speichern',
                        'select-country'   => 'Land auswählen',
                        'select-state'     => 'Bundesland auswählen',
                        'shipping-address' => 'Lieferadresse',
                        'state'            => 'Bundesland',
                        'street-address'   => 'Straße und Hausnummer',
                        'telephone'        => 'Telefon',
                        'title'            => 'Adresse',
                        'vat-id'           => 'USt-IdNr.',
                    ],

                    'payment' => [
                        'title' => 'Zahlung',
                    ],

                    'shipping' => [
                        'title' => 'Versand',
                    ],

                    'summary' => [
                        'apply-coupon'             => 'Gutschein anwenden',
                        'discount-amount'          => 'Rabattbetrag',
                        'enter-your-code'          => 'Geben Sie Ihren Code ein',
                        'grand-total'              => 'Gesamtsumme',
                        'place-order'              => 'Bestellung aufgeben',
                        'processing'               => 'In Bearbeitung',
                        'shipping-amount-excl-tax' => 'Versandkosten (exkl. MwSt.)',
                        'shipping-amount-incl-tax' => 'Versandkosten (inkl. MwSt.)',
                        'shipping-amount'          => 'Versandkosten',
                        'sub-total-excl-tax'       => 'Zwischensumme (exkl. MwSt.)',
                        'sub-total-incl-tax'       => 'Zwischensumme (inkl. MwSt.)',
                        'sub-total'                => 'Zwischensumme',
                        'tax'                      => 'MwSt.',
                        'title'                    => 'Bestellübersicht',
                    ],
                ],

                'cart-items' => [
                    'add-to-cart'       => 'In den Warenkorb',
                    'delete'            => 'Löschen',
                    'empty-description' => 'Keine Artikel im Warenkorb gefunden.',
                    'empty-title'       => 'Leerer Warenkorb',
                    'excl-tax'          => 'Ohne MwSt: ',
                    'see-details'       => 'Details anzeigen',
                    'sku'               => 'Artikelnummer - :sku',
                    'title'             => 'Warenkorbartikel',
                ],

                'recent-order-items' => [
                    'add-to-cart'       => 'In den Warenkorb',
                    'empty-description' => 'Keine Artikel in Ihren letzten Bestellungen gefunden.',
                    'empty-title'       => 'Leere Bestellungen',
                    'see-details'       => 'Details anzeigen',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Artikel der letzten Bestellungen',
                    'view'              => 'Ansehen',
                ],

                'wishlist-items' => [
                    'add-to-cart'       => 'In den Warenkorb',
                    'delete'            => 'Löschen',
                    'empty-description' => 'Keine Artikel in Ihrer Wunschliste gefunden.',
                    'empty-title'       => 'Leere Wunschliste',
                    'see-details'       => 'Details anzeigen',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Wunschliste',
                ],

                'compare-items' => [
                    'add-to-cart'       => 'In den Warenkorb',
                    'delete'            => 'Löschen',
                    'empty-description' => 'Keine Artikel in Ihrer Vergleichsliste gefunden.',
                    'empty-title'       => 'Leere Vergleichsliste',
                    'sku'               => 'SKU - :sku',
                    'title'             => 'Vergleichsliste',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount pro Einheit x :qty Menge',
                'billing-address'                => 'Rechnungsadresse',
                'cancel'                         => 'Abbrechen',
                'cancel-msg'                     => 'Sind Sie sicher, dass Sie diese Bestellung stornieren möchten?',
                'cancel-success'                 => 'Bestellung erfolgreich storniert',
                'canceled'                       => 'Storniert',
                'channel'                        => 'Kanal',
                'closed'                         => 'Geschlossen',
                'comment-success'                => 'Kommentar erfolgreich hinzugefügt.',
                'comments'                       => 'Kommentare',
                'completed'                      => 'Abgeschlossen',
                'contact'                        => 'Kontakt',
                'create-success'                 => 'Bestellung erfolgreich erstellt',
                'currency'                       => 'Währung',
                'customer'                       => 'Kunde',
                'customer-group'                 => 'Kundengruppe',
                'customer-not-notified'          => ':date | Kunde <b>nicht benachrichtigt</b>',
                'customer-notified'              => ':date | Kunde <b>benachrichtigt</b>',
                'discount'                       => 'Rabatt - :discount',
                'download-pdf'                   => 'PDF herunterladen',
                'fraud'                          => 'Betrug',
                'grand-total'                    => 'Gesamtsumme - :grand_total',
                'invoice-id'                     => 'Rechnung #:invoice',
                'invoices'                       => 'Rechnungen',
                'item-canceled'                  => 'Storniert (:qty_canceled)',
                'item-invoice'                   => 'In Rechnung gestellt (:qty_invoiced)',
                'item-ordered'                   => 'Bestellt (:qty_ordered)',
                'item-refunded'                  => 'Erstattet (:qty_refunded)',
                'item-shipped'                   => 'Versendet (:qty_shipped)',
                'name'                           => 'Name',
                'no-invoice-found'               => 'Keine Rechnung gefunden',
                'no-refund-found'                => 'Keine Rückerstattung gefunden',
                'no-shipment-found'              => 'Keine Sendungen gefunden',
                'notify-customer'                => 'Kunden benachrichtigen',
                'order-date'                     => 'Bestelldatum',
                'order-information'              => 'Bestellinformationen',
                'order-status'                   => 'Bestellstatus',
                'payment-and-shipping'           => 'Zahlung und Versand',
                'payment-method'                 => 'Zahlungsmethode',
                'pending'                        => 'Ausstehend',
                'pending_payment'                => 'Ausstehende Zahlung',
                'per-unit'                       => 'Pro Einheit',
                'price'                          => 'Preis - :price',
                'price-excl-tax'                 => 'Preis (ohne MwSt.) - :price',
                'price-incl-tax'                 => 'Preis (inkl. MwSt.) - :price',
                'processing'                     => 'In Bearbeitung',
                'quantity'                       => 'Menge',
                'refund'                         => 'Rückerstattung',
                'refund-id'                      => 'Rückerstattung #:refund',
                'refunded'                       => 'Erstattet',
                'reorder'                        => 'Erneut bestellen',
                'ship'                           => 'Versenden',
                'shipment'                       => 'Sendung #:shipment',
                'shipments'                      => 'Sendungen',
                'shipping-address'               => 'Lieferadresse',
                'shipping-and-handling'          => 'Versand und Bearbeitung',
                'shipping-and-handling-excl-tax' => 'Versand und Bearbeitung (ohne MwSt.)',
                'shipping-and-handling-incl-tax' => 'Versand und Bearbeitung (inkl. MwSt.)',
                'shipping-method'                => 'Versandmethode',
                'shipping-price'                 => 'Versandkosten',
                'sku'                            => 'Artikelnummer - :sku',
                'status'                         => 'Status',
                'sub-total'                      => 'Zwischensumme - :sub_total',
                'sub-total-excl-tax'             => 'Zwischensumme (ohne MwSt.) - :sub_total',
                'sub-total-incl-tax'             => 'Zwischensumme (inkl. MwSt.) - :sub_total',
                'submit-comment'                 => 'Kommentar absenden',
                'summary-discount'               => 'Rabatt',
                'summary-grand-total'            => 'Gesamtsumme',
                'summary-sub-total'              => 'Zwischensumme',
                'summary-sub-total-excl-tax'     => 'Zwischensumme (ohne MwSt.)',
                'summary-sub-total-incl-tax'     => 'Zwischensumme (inkl. MwSt.)',
                'summary-tax'                    => 'Steuer',
                'tax'                            => 'Steuer (:percent) - :tax',
                'title'                          => 'Bestellung #:order_id',
                'total-due'                      => 'Gesamtbetrag fällig',
                'total-paid'                     => 'Gesamtbetrag bezahlt',
                'total-refund'                   => 'Gesamterstattung',
                'view'                           => 'Ansehen',
                'write-your-comment'             => 'Schreiben Sie Ihren Kommentar',
            ],
        ],

        'shipments' => [
            'index' => [
                'title' => 'Lieferungen',

                'datagrid' => [
                    'id'               => 'ID',
                    'inventory-source' => 'Lagerquelle',
                    'order-date'       => 'Bestelldatum',
                    'order-id'         => 'Bestellnummer',
                    'shipment-date'    => 'Versanddatum',
                    'shipment-to'      => 'Versand an',
                    'total-qty'        => 'Gesamtmenge',
                    'view'             => 'Ansehen',
                ],
            ],

            'create' => [
                'amount-per-unit'  => ':amount pro Einheit x :qty Menge',
                'cancel-error'     => 'Die Bestellung kann nicht storniert werden',
                'carrier-name'     => 'Spediteurname',
                'create-btn'       => 'Lieferung erstellen',
                'creation-error'   => 'Fehler bei der Erstellung der Lieferung',
                'item-canceled'    => 'Storniert (:qty_canceled)',
                'item-invoice'     => 'In Rechnung gestellt (:qty_invoiced)',
                'item-ordered'     => 'Bestellt (:qty_ordered)',
                'item-refunded'    => 'Erstattet (:qty_refunded)',
                'item-shipped'     => 'Versendet (:qty_shipped)',
                'order-error'      => 'Lieferung ist ungültig',
                'per-unit'         => 'Pro Einheit',
                'qty-available'    => 'Verfügbare Menge',
                'qty-to-ship'      => 'Menge zum Versenden',
                'quantity-invalid' => 'Menge ungültig',
                'sku'              => 'Artikelnummer (SKU) - :sku',
                'source'           => 'Quelle',
                'success'          => 'Lieferung erfolgreich erstellt',
                'title'            => 'Neue Lieferung erstellen',
                'tracking-number'  => 'Sendungsnummer',
            ],

            'view' => [
                'billing-address'      => 'Rechnungsadresse',
                'carrier-title'        => 'Spediteurname',
                'channel'              => 'Kanal',
                'currency'             => 'Währung',
                'customer'             => 'Kunde',
                'email'                => 'E-Mail - :email',
                'inventory-source'     => 'Lagerquelle',
                'order-date'           => 'Bestelldatum',
                'order-id'             => 'Bestellnummer',
                'order-information'    => 'Bestellinformationen',
                'order-status'         => 'Bestellstatus',
                'ordered-items'        => 'Bestellte Artikel',
                'payment-and-shipping' => 'Zahlung und Versand',
                'payment-method'       => 'Zahlungsmethode',
                'product-image'        => 'Produktbild',
                'qty'                  => 'Menge - :qty',
                'shipping-address'     => 'Lieferadresse',
                'shipping-method'      => 'Versandmethode',
                'shipping-price'       => 'Versandpreis',
                'sku'                  => 'Artikelnummer (SKU) - :sku ',
                'title'                => 'Lieferung #:shipment_id',
                'tracking-number'      => 'Sendungsnummer',
            ],
        ],

        'refunds' => [
            'index' => [
                'title' => 'Rückerstattungen',

                'datagrid' => [
                    'billed-to'       => 'Abgerechnet an',
                    'id'              => 'ID',
                    'order-id'        => 'Bestellnummer',
                    'refund-date'     => 'Rückerstattungsdatum',
                    'refunded-amount' => 'Erstatteter Betrag',
                    'view'            => 'Ansehen',
                ],
            ],

            'view' => [
                'account-information'        => 'Kontoinformationen',
                'adjustment-fee'             => 'Anpassungsgebühr',
                'adjustment-refund'          => 'Anpassung Rückerstattung',
                'base-discounted-amount'     => 'Rabattierter Betrag - :base_discounted_amount',
                'billing-address'            => 'Rechnungsadresse',
                'currency'                   => 'Währung',
                'sub-total-amount-excl-tax'  => 'Zwischensumme (exkl. MwSt.) - :discounted_amount',
                'sub-total-amount-incl-tax'  => 'Zwischensumme (inkl. MwSt.) - :discounted_amount',
                'sub-total-amount'           => 'Zwischensumme - :discounted_amount',
                'grand-total'                => 'Gesamtsumme',
                'order-channel'              => 'Bestellkanal',
                'order-date'                 => 'Bestelldatum',
                'order-id'                   => 'Bestellnummer',
                'order-information'          => 'Bestellinformationen',
                'order-status'               => 'Bestellstatus',
                'payment-information'        => 'Zahlungsinformationen',
                'payment-method'             => 'Zahlungsmethode',
                'price-excl-tax'             => 'Preis (exkl. MwSt.) - :price',
                'price-incl-tax'             => 'Preis (inkl. MwSt.) - :price',
                'price'                      => 'Preis - :price',
                'product-image'              => 'Produktbild',
                'product-ordered'            => 'Bestellte Produkte',
                'qty'                        => 'Menge - :qty',
                'refund'                     => 'Rückerstattung',
                'shipping-address'           => 'Lieferadresse',
                'shipping-handling-excl-tax' => 'Versand & Bearbeitung (exkl. MwSt.)',
                'shipping-handling-incl-tax' => 'Versand & Bearbeitung (inkl. MwSt.)',
                'shipping-handling'          => 'Versand & Bearbeitung',
                'shipping-method'            => 'Versandmethode',
                'shipping-price'             => 'Versandpreis',
                'sku'                        => 'Artikelnummer (SKU) - :sku',
                'sub-total-excl-tax'         => 'Zwischensumme (exkl. MwSt.)',
                'sub-total-incl-tax'         => 'Zwischensumme (inkl. MwSt.)',
                'sub-total'                  => 'Zwischensumme',
                'tax'                        => 'MwSt.',
                'tax-amount'                 => 'MwSt.-Betrag - :tax_amount',
                'title'                      => 'Rückerstattung #:refund_id',
            ],

            'create' => [
                'adjustment-fee'              => 'Anpassungsgebühr',
                'adjustment-refund'           => 'Anpassung Rückerstattung',
                'amount-per-unit'             => ':amount pro Einheit x :qty Menge',
                'create-success'              => 'Rückerstattung erfolgreich erstellt',
                'creation-error'              => 'Erstellung einer Rückerstattung ist nicht erlaubt.',
                'discount-amount'             => 'Rabattbetrag',
                'grand-total'                 => 'Gesamtsumme',
                'invalid-qty'                 => 'Wir haben eine ungültige Menge zum Rechnungsstellen gefunden.',
                'invalid-refund-amount-error' => 'Rückerstattungsbetrag sollte nicht null sein.',
                'item-canceled'               => 'Storniert (:qty_canceled)',
                'item-invoice'                => 'In Rechnung gestellt (:qty_invoiced)',
                'item-ordered'                => 'Bestellt (:qty_ordered)',
                'item-refunded'               => 'Rückerstattet (:qty_refunded)',
                'item-shipped'                => 'Versendet (:qty_shipped)',
                'per-unit'                    => 'Pro Einheit',
                'price'                       => 'Preis',
                'qty-to-refund'               => 'Menge zur Rückerstattung',
                'refund-btn'                  => 'Rückerstattung',
                'refund-limit-error'          => 'Rückerstattungsbetrag :amount kann nicht verarbeitet werden.',
                'refund-shipping'             => 'Versandkosten zurückerstatten',
                'sku'                         => 'Artikelnummer (SKU) - :sku',
                'subtotal'                    => 'Zwischensumme',
                'tax-amount'                  => 'Steuerbetrag',
                'title'                       => 'Rückerstattung erstellen',
                'update-totals-btn'           => 'Totale aktualisieren',
            ],
        ],

        'invoices' => [
            'index' => [
                'title' => 'Rechnungen',

                'datagrid' => [
                    'action'              => 'Aktionen',
                    'days-left'           => 'Noch :count Tag(e)',
                    'days-overdue'        => ':count Tag(e) überfällig',
                    'grand-total'         => 'Gesamtsumme',
                    'id'                  => 'ID',
                    'invoice-date'        => 'Rechnungsdatum',
                    'mass-update-success' => 'Ausgewählte Rechnungen wurden erfolgreich aktualisiert.',
                    'order-id'            => 'Bestellnummer',
                    'overdue'             => 'Überfällig',
                    'overdue-by'          => 'Überfällig seit :count Tag(en)',
                    'paid'                => 'Bezahlt',
                    'pending'             => 'Ausstehend',
                    'status'              => 'Status',
                    'update-status'       => 'Status aktualisieren',
                ],
            ],

            'view' => [
                'amount-per-unit'                => ':amount pro Einheit x :qty Menge',
                'channel'                        => 'Kanal',
                'customer-email'                 => 'E-Mail - :email',
                'customer'                       => 'Kunde',
                'discount'                       => 'Rabattbetrag - :discount',
                'email'                          => 'E-Mail',
                'grand-total'                    => 'Gesamtsumme',
                'invoice-items'                  => 'Rechnungspositionen',
                'invoice-sent'                   => 'Rechnung erfolgreich gesendet',
                'invoice-status'                 => 'Rechnungsstatus',
                'order-date'                     => 'Bestelldatum',
                'order-id'                       => 'Bestellnummer',
                'order-information'              => 'Bestellinformationen',
                'order-status'                   => 'Bestellstatus',
                'price-excl-tax'                 => 'Preis (exkl. MwSt.) - :price',
                'price-incl-tax'                 => 'Preis (inkl. MwSt.) - :price',
                'price'                          => 'Preis - :price',
                'print'                          => 'Drucken',
                'product-image'                  => 'Produktbild',
                'qty'                            => 'Menge - :qty',
                'send-btn'                       => 'Senden',
                'send-duplicate-invoice'         => 'Doppelte Rechnung senden',
                'send'                           => 'Senden',
                'shipping-and-handling-excl-tax' => 'Versand und Bearbeitung (exkl. MwSt.)',
                'shipping-and-handling-incl-tax' => 'Versand und Bearbeitung (inkl. MwSt.)',
                'shipping-and-handling'          => 'Versand und Bearbeitung',
                'sku'                            => 'Artikelnummer (SKU) - :sku',
                'sub-total-excl-tax'             => 'Zwischensumme (exkl. MwSt.) - :sub_total',
                'sub-total-incl-tax'             => 'Zwischensumme (inkl. MwSt.) - :sub_total',
                'sub-total-summary-excl-tax'     => 'Zwischensumme (exkl. MwSt.)',
                'sub-total-summary-incl-tax'     => 'Zwischensumme (inkl. MwSt.)',
                'sub-total-summary'              => 'Zwischensumme',
                'sub-total'                      => 'Zwischensumme - :sub_total',
                'summary-discount'               => 'Rabattbetrag',
                'summary-tax'                    => 'MwSt.-Betrag',
                'tax'                            => 'MwSt.-Betrag - :tax',
                'title'                          => 'Rechnung #:invoice_id',
            ],

            'create' => [
                'amount-per-unit'    => ':amount Pro Einheit x :qty Menge',
                'create-invoice'     => 'Rechnung erstellen',
                'create-success'     => 'Rechnung erfolgreich erstellt',
                'create-transaction' => 'Transaktion erstellen',
                'creation-error'     => 'Bestellrechnungserstellung ist nicht erlaubt.',
                'invalid-qty'        => 'Wir haben eine ungültige Menge zum Rechnen von Artikeln gefunden.',
                'invoice'            => 'Rechnung',
                'new-invoice'        => 'Neue Rechnung',
                'product-error'      => 'Rechnung kann nicht ohne Produkte erstellt werden.',
                'product-image'      => 'Produktbild',
                'qty-to-invoiced'    => 'Menge zu verrechnen',
                'sku'                => 'SKU - :sku',
            ],

            'invoice-pdf' => [
                'bank-details'               => 'Bankverbindung',
                'bill-to'                    => 'Rechnung an',
                'contact-number'             => 'Kontaktnummer',
                'contact'                    => 'Kontakt',
                'date'                       => 'Rechnungsdatum',
                'discount'                   => 'Rabatt',
                'excl-tax'                   => 'Exkl. MwSt.:',
                'grand-total'                => 'Gesamtsumme',
                'invoice-id'                 => 'Rechnungsnummer',
                'invoice'                    => 'Rechnung',
                'order-date'                 => 'Bestelldatum',
                'order-id'                   => 'Bestellnummer',
                'payment-method'             => 'Zahlungsmethode',
                'payment-terms'              => 'Zahlungsbedingungen',
                'price'                      => 'Preis',
                'product-name'               => 'Produktname',
                'qty'                        => 'Menge',
                'ship-to'                    => 'Versand an',
                'shipping-handling-excl-tax' => 'Versand und Bearbeitung (exkl. MwSt.)',
                'shipping-handling-incl-tax' => 'Versand und Bearbeitung (inkl. MwSt.)',
                'shipping-handling'          => 'Versand und Bearbeitung',
                'shipping-method'            => 'Versandart',
                'sku'                        => 'Artikelnummer (SKU)',
                'subtotal-excl-tax'          => 'Zwischensumme (exkl. MwSt.)',
                'subtotal-incl-tax'          => 'Zwischensumme (inkl. MwSt.)',
                'subtotal'                   => 'Zwischensumme',
                'tax-amount'                 => 'MwSt.-Betrag',
                'tax'                        => 'MwSt.',
                'vat-number'                 => 'USt-IdNr.',
            ],
        ],

        'invoice-transaction' => [
            'id'               => 'ID',
            'transaction-date' => 'Transaktionsdatum',
            'transaction-id'   => 'Transaktions-ID',
            'view'             => 'Ansehen',
        ],

        'transactions' => [
            'index' => [
                'create-btn' => 'Transaktion erstellen',
                'title'      => 'Transaktionen',

                'datagrid' => [
                    'completed'          => 'Abgeschlossen',
                    'id'                 => 'ID',
                    'invoice-id'         => 'Rechnungs-ID',
                    'order-id'           => 'Bestellungs-ID',
                    'paid'               => 'Bezahlt',
                    'pending'            => 'Ausstehend',
                    'status'             => 'Status',
                    'transaction-amount' => 'Betrag',
                    'transaction-date'   => 'Datum',
                    'transaction-id'     => 'Transaktions-ID',
                    'view'               => 'Ansehen',
                ],

                'create' => [
                    'already-paid'               => 'Bereits bezahlt',
                    'amount'                     => 'Betrag',
                    'create-transaction'         => 'Transaktion erstellen',
                    'invoice-id'                 => 'Rechnungs-ID',
                    'invoice-missing'            => 'Rechnung fehlt',
                    'payment-method'             => 'Zahlungsmethode',
                    'save-transaction'           => 'Transaktion speichern',
                    'transaction-amount-exceeds' => 'Transaktionsbetrag überschreitet',
                    'transaction-amount-zero'    => 'Transaktionsbetrag ist null',
                    'transaction-saved'          => 'Transaktion erfolgreich gespeichert.',
                ],

                'view' => [
                    'amount'           => 'Betrag',
                    'created-at'       => 'Erstellt am',
                    'invoice-id'       => 'Rechnungsnummer',
                    'order-id'         => 'Bestellnummer',
                    'payment-details'  => 'Zahlungsdetails',
                    'payment-method'   => 'Zahlungsmethode',
                    'status'           => 'Status',
                    'title'            => 'Transaktionsdetails',
                    'transaction-id'   => 'Transaktions-ID',
                ],
            ],
        ],

        'booking' => [
            'index' => [
                'datagrid' => [
                    'created-date' => 'Erstellungsdatum',
                    'from'         => 'Von',
                    'id'           => 'ID',
                    'order-id'     => 'Bestellnummer',
                    'qty'          => 'Menge',
                    'to'           => 'Bis',
                    'view'         => 'Ansehen',
                ],

                'title'    => 'Buchungen',
            ],

            'calendar' => [
                'booking-date'     => 'Buchungsdatum',
                'booking-details'  => 'Buchungsdetails',
                'canceled'         => 'Storniert',
                'closed'           => 'Geschlossen',
                'done'             => 'Erledigt',
                'order-id'         => 'Bestellnummer',
                'pending'          => 'Ausstehend',
                'price'            => 'Preis',
                'status'           => 'Status',
                'time-slot'        => 'Zeitfenster:',
                'view-details'     => 'Details anzeigen',
            ],

            'title' => 'Buchungsprodukte',
        ],
    ],

    'catalog' => [
        'products' => [
            'index' => [
                'already-taken' => 'Der :name wurde bereits verwendet.',
                'create-btn'    => 'Produkt erstellen',
                'title'         => 'Produkte',

                'create' => [
                    'back-btn'                => 'Zurück',
                    'configurable-attributes' => 'Konfigurierbare Attribute',
                    'create-btn'              => 'Produkt erstellen',
                    'family'                  => 'Familie',
                    'save-btn'                => 'Produkt speichern',
                    'sku'                     => 'Artikelnummer',
                    'title'                   => 'Neues Produkt erstellen',
                    'type'                    => 'Typ',
                ],

                'datagrid' => [
                    'active'                 => 'Aktiv',
                    'attribute-family'       => 'Attributfamilie',
                    'attribute-family-value' => 'Attributfamilie - :attribute_family',
                    'category'               => 'Kategorie',
                    'channel'                => 'Kanal',
                    'copy-of'                => 'Kopie von :value',
                    'copy-of-slug'           => 'kopie-von-:value',
                    'delete'                 => 'Löschen',
                    'disable'                => 'Deaktivieren',
                    'id'                     => 'ID',
                    'id-value'               => 'ID - :id',
                    'image'                  => 'Bild',
                    'mass-delete-success'    => 'Ausgewählte Produkte wurden erfolgreich gelöscht',
                    'mass-update-success'    => 'Ausgewählte Produkte wurden erfolgreich aktualisiert',
                    'name'                   => 'Name',
                    'out-of-stock'           => 'Nicht vorrätig',
                    'price'                  => 'Preis',
                    'product-image'          => 'Produktbild',
                    'qty'                    => 'Menge',
                    'qty-value'              => ':qty verfügbar',
                    'sku'                    => 'Artikelnummer',
                    'sku-value'              => 'Artikelnummer - :sku',
                    'status'                 => 'Status',
                    'type'                   => 'Typ',
                    'update-status'          => 'Status aktualisieren',
                ],
            ],

            'edit' => [
                'preview'  => 'Vorschau',
                'remove'   => 'Entfernen',
                'save-btn' => 'Produkt speichern',
                'title'    => 'Produkt bearbeiten',

                'channels' => [
                    'title' => 'Kanäle',
                ],

                'price' => [
                    'group' => [
                        'add-group-price'           => 'Gruppenpreis hinzufügen',
                        'all-groups'                => 'Alle Gruppen',
                        'create-btn'                => 'Neu hinzufügen',
                        'discount-group-price-info' => 'Für :price Rabatt ab :qty Stück',
                        'edit-btn'                  => 'Bearbeiten',
                        'empty-info'                => 'Sonderpreise für Kunden in einer bestimmten Gruppe.',
                        'fixed-group-price-info'    => 'Für :qty Stück zum Festpreis von :price',
                        'title'                     => 'Kundengruppenpreis',

                        'create' => [
                            'all-groups'     => 'Alle Gruppen',
                            'create-title'   => 'Kundengruppenpreis erstellen',
                            'customer-group' => 'Kundengruppe',
                            'delete-btn'     => 'Löschen',
                            'discount'       => 'Rabatt',
                            'fixed'          => 'Festpreis',
                            'price'          => 'Preis',
                            'price-type'     => 'Preistyp',
                            'qty'            => 'Mindestmenge',
                            'save-btn'       => 'Speichern',
                            'update-title'   => 'Kundengruppenpreis aktualisieren',
                        ],
                    ],
                ],

                'inventories' => [
                    'pending-ordered-qty'      => 'Ausstehende Bestellmenge: :qty',
                    'pending-ordered-qty-info' => 'Die ausstehende Bestellmenge wird nach dem Versand von der jeweiligen Lagerquelle abgezogen. Im Falle einer Stornierung steht die ausstehende Menge zum Verkauf zur Verfügung.',
                    'title'                    => 'Bestände',
                ],

                'categories' => [
                    'title' => 'Kategorien',
                ],

                'images' => [
                    'info'  => 'Die Bildauflösung sollte etwa 560px X 609px sein',
                    'title' => 'Bilder',
                ],

                'videos' => [
                    'error' => 'Das :attribute darf nicht größer als :max Kilobyte sein. Bitte wählen Sie eine kleinere Datei aus.',
                    'info'  => 'Die maximale Video-Größe sollte etwa :size betragen',
                    'title' => 'Videos',
                ],

                'links' => [
                    'related-products' => [
                        'empty-info' => 'Fügen Sie verwandte Produkte hinzu.',
                        'info'       => 'Zusätzlich zum vom Kunden angesehenen Produkt werden ihm verwandte Produkte angezeigt.',
                        'title'      => 'Verwandte Produkte',
                    ],

                    'up-sells' => [
                        'empty-info' => 'Fügen Sie Upsell-Produkte hinzu.',
                        'info'       => 'Dem Kunden werden Upsell-Produkte angezeigt, die als Premium- oder qualitativ hochwertige Alternative zum derzeit angesehenen Produkt dienen.',
                        'title'      => 'Upsell-Produkte',
                    ],

                    'cross-sells' => [
                        'empty-info' => 'Fügen Sie Cross-Sell-Produkte hinzu.',
                        'info'       => 'In der Nähe des Einkaufswagens finden Sie diese "Impulskauf"-Produkte, die als Cross-Sell-Produkte positioniert sind, um die bereits in den Warenkorb gelegten Artikel zu ergänzen.',
                        'title'      => 'Cross-Sell-Produkte',
                    ],

                    'add-btn'           => 'Produkt hinzufügen',
                    'delete'            => 'Löschen',
                    'empty-info'        => 'Um :type Produkte hinzuzufügen.',
                    'empty-title'       => 'Produkt hinzufügen',
                    'image-placeholder' => 'Produktbild',
                    'sku'               => 'Artikelnummer - :sku',
                ],

                'types' => [
                    'simple' => [
                        'customizable-options' => [
                            'add-btn'           => 'Option hinzufügen',
                            'empty-info'        => 'Um anpassbare Optionen sofort zu erstellen.',
                            'empty-title'       => 'Option hinzufügen',
                            'info'              => 'Dies wird das einfache Produkt anpassen.',
                            'title'             => 'Anpassbarer Artikel',

                            'update-create' => [
                                'is-required'               => 'Erforderlich',
                                'max-characters'            => 'Maximale Zeichen',
                                'name'                      => 'Titel',
                                'no'                        => 'Nein',
                                'price'                     => 'Preis',
                                'save-btn'                  => 'Speichern',
                                'supported-file-extensions' => 'Unterstützte Dateierweiterungen',
                                'title'                     => 'Option',
                                'type'                      => 'Typ',
                                'yes'                       => 'Ja',
                            ],

                            'option' => [
                                'add-btn'     => 'Option hinzufügen',
                                'delete'      => 'Löschen',
                                'delete-btn'  => 'Löschen',
                                'edit-btn'    => 'Bearbeiten',
                                'empty-info'  => 'Um verschiedene Produktkombinationen sofort zu erstellen.',
                                'empty-title' => 'Option hinzufügen',

                                'types' => [
                                    'text' => [
                                        'title' => 'Text',
                                    ],

                                    'textarea' => [
                                        'title' => 'Textbereich',
                                    ],

                                    'checkbox' => [
                                        'title' => 'Kontrollkästchen',
                                    ],

                                    'radio' => [
                                        'title' => 'Radio',
                                    ],

                                    'select' => [
                                        'title' => 'Auswählen',
                                    ],

                                    'multiselect' => [
                                        'title' => 'Mehrfachauswahl',
                                    ],

                                    'date' => [
                                        'title' => 'Datum',
                                    ],

                                    'datetime' => [
                                        'title' => 'Datum und Uhrzeit',
                                    ],

                                    'time' => [
                                        'title' => 'Zeit',
                                    ],

                                    'file' => [
                                        'title' => 'Datei',
                                    ],
                                ],

                                'items' => [
                                    'update-create' => [
                                        'label'    => 'Beschriftung',
                                        'price'    => 'Preis',
                                        'save-btn' => 'Speichern',
                                        'title'    => 'Option',
                                    ],
                                ],
                            ],

                            'validations' => [
                                'associated-product' => 'Das Produkt ist bereits mit einem konfigurierbaren, gruppierten oder gebündelten Produkt verknüpft.',
                            ],
                        ],
                    ],

                    'configurable' => [
                        'add-btn'           => 'Variante hinzufügen',
                        'delete-btn'        => 'Löschen',
                        'edit-btn'          => 'Bearbeiten',
                        'empty-info'        => 'Um verschiedene Kombinationen von Produkten zu erstellen.',
                        'empty-title'       => 'Variante hinzufügen',
                        'image-placeholder' => ':qty Stück',
                        'info'              => 'Variantenprodukte basieren auf allen möglichen Kombinationen von Attributen.',
                        'qty'               => ':qty Stück',
                        'sku'               => 'Artikelnummer - :sku',
                        'title'             => 'Varianten',

                        'create' => [
                            'description'            => 'Beschreibung',
                            'name'                   => 'Name',
                            'save-btn'               => 'Hinzufügen',
                            'title'                  => 'Variante hinzufügen',
                            'variant-already-exists' => 'Diese Variante existiert bereits',
                        ],

                        'edit' => [
                            'disabled'        => 'Deaktiviert',
                            'edit-info'       => 'Wenn Sie detaillierte Produktinformationen aktualisieren möchten, gehen Sie zur',
                            'edit-link-title' => 'Produktdetailseite',
                            'enabled'         => 'Aktiviert',
                            'images'          => 'Bilder',
                            'name'            => 'Name',
                            'price'           => 'Preis',
                            'quantities'      => 'Mengen',
                            'save-btn'        => 'Speichern',
                            'sku'             => 'Artikelnummer',
                            'status'          => 'Status',
                            'title'           => 'Produkt',
                            'weight'          => 'Gewicht',
                        ],

                        'mass-edit' => [
                            'add-images'          => 'Bilder hinzufügen',
                            'apply-to-all-btn'    => 'Auf alle anwenden',
                            'apply-to-all-name'   => 'Einen Namen auf alle Varianten anwenden.',
                            'apply-to-all-sku'    => 'Einen Preis auf alle SKU anwenden.',
                            'apply-to-all-status' => 'Einen Status auf alle Varianten anwenden.',
                            'apply-to-all-weight' => 'Gewicht auf alle Varianten anwenden.',
                            'edit-inventories'    => 'Bestände bearbeiten',
                            'edit-names'          => 'Namen bearbeiten',
                            'edit-prices'         => 'Preise bearbeiten',
                            'edit-sku'            => 'SKU bearbeiten',
                            'edit-status'         => 'Status bearbeiten',
                            'edit-weight'         => 'Gewicht bearbeiten',
                            'name'                => 'Namen',
                            'price'               => 'Preis',
                            'remove-images'       => 'Bilder entfernen',
                            'remove-variants'     => 'Varianten entfernen',
                            'select-action'       => 'Aktion auswählen',
                            'select-variants'     => 'Varianten auswählen',
                            'status'              => 'Status',
                            'variant-name'        => 'Variantenname',
                            'variant-sku'         => 'Varianten-SKU',
                            'weight'              => 'Gewicht',
                        ],
                    ],

                    'grouped' => [
                        'add-btn'           => 'Produkt hinzufügen',
                        'default-qty'       => 'Standardmenge',
                        'delete'            => 'Löschen',
                        'empty-info'        => 'Um verschiedene Kombinationen von Produkten zu erstellen.',
                        'empty-title'       => 'Produkt hinzufügen',
                        'image-placeholder' => 'Produktbild',
                        'info'              => 'Ein Gruppenprodukt besteht aus eigenständigen Artikeln, die als Set präsentiert werden und Variationen oder Koordination nach Saison oder Thema ermöglichen. Jedes Produkt kann einzeln oder als Teil der Gruppe gekauft werden.',
                        'sku'               => 'Artikelnummer - :sku',
                        'title'             => 'Gruppenprodukte',
                    ],

                    'bundle' => [
                        'add-btn'           => 'Option hinzufügen',
                        'empty-info'        => 'Um Bündeloptionen zu erstellen.',
                        'empty-title'       => 'Option hinzufügen',
                        'image-placeholder' => 'Produktbild',
                        'info'              => 'Ein Bündelprodukt ist eine Packung mehrerer Artikel oder Dienstleistungen, die zusammen zu einem Sonderpreis verkauft werden und den Kunden Wert und Bequemlichkeit bieten.',
                        'title'             => 'Bündelartikel',

                        'update-create' => [
                            'checkbox'    => 'Checkbox',
                            'is-required' => 'Erforderlich',
                            'multiselect' => 'Multiselect',
                            'name'        => 'Titel',
                            'no'          => 'Nein',
                            'radio'       => 'Radio',
                            'save-btn'    => 'Speichern',
                            'select'      => 'Auswählen',
                            'title'       => 'Option',
                            'type'        => 'Typ',
                            'yes'         => 'Ja',
                        ],

                        'option' => [
                            'add-btn'     => 'Produkt hinzufügen',
                            'default-qty' => 'Standardmenge',
                            'delete'      => 'Löschen',
                            'delete-btn'  => 'Löschen',
                            'edit-btn'    => 'Bearbeiten',
                            'empty-info'  => 'Um verschiedene Kombinationen von Produkten zu erstellen.',
                            'empty-title' => 'Produkt hinzufügen',
                            'sku'         => 'Artikelnummer - :sku',

                            'types' => [
                                'checkbox' => [
                                    'info'  => 'Setzen Sie das Standardprodukt mit einem Kontrollkästchen.',
                                    'title' => 'Checkbox',
                                ],

                                'multiselect' => [
                                    'info'  => 'Setzen Sie das Standardprodukt mit einem Kontrollkästchen-Button.',
                                    'title' => 'Multiselect',
                                ],

                                'radio' => [
                                    'info'  => 'Setzen Sie das Standardprodukt mit einem Optionsfeld.',
                                    'title' => 'Radio',
                                ],

                                'select' => [
                                    'info'  => 'Setzen Sie das Standardprodukt mit einem Dropdown-Menü.',
                                    'title' => 'Auswählen',
                                ],
                            ],
                        ],
                    ],

                    'booking' => [
                        'available-from' => 'Verfügbar ab',
                        'available-to'   => 'Verfügbar bis',
                        'location'       => 'Ort',
                        'qty'            => 'Menge',
                        'title'          => 'Buchungstyp',

                        'available-every-week' => [
                            'no'    => 'Nein',
                            'title' => 'Jede Woche verfügbar',
                            'yes'   => 'Ja',
                        ],

                        'appointment' => [
                            'break-duration'         => 'Pausenzeit zwischen Slots (Minuten)',
                            'slot-duration'          => 'Slot-Dauer (Minuten)',

                            'same-slot-for-all-days' => [
                                'no'    => 'Nein',
                                'title' => 'Gleicher Slot für alle Tage',
                                'yes'   => 'Ja',
                            ],
                        ],

                        'default' => [
                            'add'              => 'Hinzufügen',
                            'break-duration'   => 'Pausenzeit zwischen Slots (Minuten)',
                            'close'            => 'Schließen',
                            'description'      => 'Buchungsinformationen',
                            'description-info' => 'Die Zeitdauer wird gemäß den Slots erstellt und angezeigt. Sie wird über alle Slots hinweg einzigartig sein und im Storefront sichtbar sein.',
                            'edit'             => 'Bearbeiten',
                            'many'             => 'Viele Buchungen für einen Tag',
                            'one'              => 'Eine Buchung für viele Tage',
                            'open'             => 'Öffnen',
                            'slot-add'         => 'Slots hinzufügen',
                            'slot-duration'    => 'Slot-Dauer (Minuten)',
                            'slot-title'       => 'Slots Zeitdauer',
                            'title'            => 'Standard',
                            'unavailable'      => 'Nicht verfügbar',

                            'modal'            => [
                                'slot' => [
                                    'add-title'  => 'Slots hinzufügen',
                                    'close'      => 'Schließen',
                                    'day'        => 'Tag',
                                    'edit-title' => 'Slots bearbeiten',
                                    'friday'     => 'Freitag',
                                    'from'       => 'Von',
                                    'from-day'   => 'Von Tag',
                                    'from-time'  => 'Von Zeit',
                                    'monday'     => 'Montag',
                                    'open'       => 'Öffnen',
                                    'saturday'   => 'Samstag',
                                    'save'       => 'Speichern',
                                    'select'     => 'Auswählen',
                                    'status'     => 'Status',
                                    'sunday'     => 'Sonntag',
                                    'thursday'   => 'Donnerstag',
                                    'to'         => 'Bis',
                                    'to-day'     => 'Bis Tag',
                                    'to-time'    => 'Bis Zeit',
                                    'tuesday'    => 'Dienstag',
                                    'wednesday'  => 'Mittwoch',
                                    'week'       => ':day',
                                ],
                            ],
                        ],

                        'event' => [
                            'add'                => 'Tickets hinzufügen',
                            'delete'             => 'Löschen',
                            'description'        => 'Beschreibung',
                            'description-info'   => 'Es sind keine Tickets verfügbar.',
                            'edit'               => 'Bearbeiten',
                            'name'               => 'Name',
                            'price'              => 'Preis',
                            'qty'                => 'Menge',
                            'special-price'      => 'Sonderpreis',
                            'special-price-from' => 'Sonderpreis ab',
                            'special-price-to'   => 'Sonderpreis bis',
                            'title'              => 'Tickets',
                            'valid-from'         => 'Gültig ab',
                            'valid-until'        => 'Gültig bis',

                            'modal'              => [
                                'edit' => 'Tickets bearbeiten',
                                'save' => 'Speichern',
                            ],
                        ],

                        'empty-info' => [
                            'tickets' => [
                                'add' => 'Tickets hinzufügen',
                            ],

                            'slots'   => [
                                'add'         => 'Slots hinzufügen',
                                'description' => 'Verfügbare Slots mit Zeitdauer.',
                            ],
                        ],

                        'rental' => [
                            'daily'        => 'Täglich',
                            'daily-hourly' => 'Sowohl täglich als auch stündlich',
                            'daily-price'  => 'Tagespreis',
                            'hourly'       => 'Stündlich',
                            'hourly-price' => 'Stundenpreis',
                            'title'        => 'Miettyp',

                            'same-slot-for-all-days' => [
                                'no'    => 'Nein',
                                'title' => 'Gleicher Slot für alle Tage',
                                'yes'   => 'Ja',
                            ],
                        ],

                        'slots' => [
                            'add'              => 'Slots hinzufügen',
                            'description-info' => 'Die Zeitdauer wird gemäß den Slots erstellt und angezeigt. Sie wird über alle Slots hinweg einzigartig sein und im Storefront sichtbar sein.',
                            'save'             => 'Speichern',
                            'title'            => 'Slots Zeitdauer',
                            'unavailable'      => 'Nicht verfügbar',

                            'action'           => [
                                'add' => 'Hinzufügen',
                            ],

                            'modal'            => [
                                'slot' => [
                                    'friday'     => 'Freitag',
                                    'from'       => 'Von',
                                    'monday'     => 'Montag',
                                    'saturday'   => 'Samstag',
                                    'sunday'     => 'Sonntag',
                                    'thursday'   => 'Donnerstag',
                                    'to'         => 'Bis',
                                    'tuesday'    => 'Dienstag',
                                    'wednesday'  => 'Mittwoch',
                                ],
                            ],
                        ],

                        'table' => [
                            'break-duration'            => 'Pausenzeit zwischen Slots (Minuten)',
                            'guest-capacity'            => 'Gästekapazität',
                            'guest-limit'               => 'Gästelimit pro Tisch',
                            'prevent-scheduling-before' => 'Verhindern Sie die Planung vor',
                            'slot-duration'             => 'Slot-Dauer (Minuten)',

                            'charged-per'               => [
                                'guest'  => 'Gast',
                                'table'  => 'Tisch',
                                'title'  => 'Berechnet pro',
                            ],

                            'same-slot-for-all-days'    => [
                                'no'    => 'Nein',
                                'title' => 'Gleicher Slot für alle Tage',
                                'yes'   => 'Ja',
                            ],
                        ],

                        'type' => [
                            'appointment' => 'Terminbuchung',
                            'default'     => 'Standardbuchung',
                            'event'       => 'Eventbuchung',
                            'many'        => 'Viele',
                            'one'         => 'Eins',
                            'rental'      => 'Mietbuchung',
                            'table'       => 'Tischbuchung',
                            'title'       => 'Typ',
                        ],

                        'validations' => [
                            'type-mismatch'      => 'Der Buchungstyp kann nicht geändert werden.',
                            'time-validation'    => 'Die Startzeit muss kleiner als die Endzeit sein.',
                            'overlap-validation' => 'Der Zeitraum überschneidet sich mit einem vorhandenen Zeitraum.',
                        ],
                    ],

                    'downloadable' => [
                        'links' => [
                            'add-btn'     => 'Link hinzufügen',
                            'delete-btn'  => 'Löschen',
                            'edit-btn'    => 'Bearbeiten',
                            'empty-info'  => 'Um einen Link hinzuzufügen.',
                            'empty-title' => 'Link hinzufügen',
                            'file'        => 'Datei: ',
                            'info'        => 'Der Typ "Herunterladbares Produkt" ermöglicht den Verkauf von digitalen Produkten wie eBooks, Softwareanwendungen, Musik, Spielen usw.',
                            'sample-file' => 'Beispiel-Datei: ',
                            'sample-url'  => 'Beispiel-URL: ',
                            'title'       => 'Herunterladbare Links',
                            'url'         => 'URL: ',

                            'update-create' => [
                                'downloads'   => 'Download erlaubt',
                                'file'        => 'Datei',
                                'file-type'   => 'Dateityp',
                                'name'        => 'Titel',
                                'price'       => 'Preis',
                                'sample'      => 'Beispiel',
                                'sample-type' => 'Beispieltyp',
                                'save-btn'    => 'Speichern',
                                'title'       => 'Link',
                                'url'         => 'URL',
                            ],
                        ],

                        'samples' => [
                            'add-btn'     => 'Beispiel hinzufügen',
                            'delete-btn'  => 'Löschen',
                            'edit-btn'    => 'Bearbeiten',
                            'empty-info'  => 'Um ein Beispiel hinzuzufügen.',
                            'empty-title' => 'Beispiel hinzufügen',
                            'file'        => 'Datei: ',
                            'info'        => 'Der Typ "Herunterladbares Produkt" ermöglicht den Verkauf von digitalen Produkten wie eBooks, Softwareanwendungen, Musik, Spielen usw.',
                            'title'       => 'Herunterladbare Beispiele',
                            'url'         => 'URL: ',

                            'update-create' => [
                                'file'        => 'Datei',
                                'file-type'   => 'Dateityp',
                                'name'        => 'Titel',
                                'save-btn'    => 'Speichern',
                                'title'       => 'Link',
                                'url'         => 'URL',
                            ],
                        ],
                    ],
                ],
            ],

            'create-success'          => 'Produkt erfolgreich erstellt',
            'delete-failed'           => 'Löschen des Produkts fehlgeschlagen',
            'delete-success'          => 'Produkt erfolgreich gelöscht',
            'product-copied'          => 'Produkt erfolgreich kopiert',
            'saved-inventory-message' => 'Produkt erfolgreich gespeichert',
            'update-success'          => 'Produkt erfolgreich aktualisiert',
        ],

        'attributes' => [
            'index' => [
                'create-btn' => 'Attribut erstellen',
                'title'      => 'Attribute',

                'datagrid' => [
                    'boolean'             => 'Boolesch',
                    'channel-based'       => 'Kanalbasiert',
                    'checkbox'            => 'Kontrollkästchen',
                    'code'                => 'Code',
                    'created-at'          => 'Erstellt am',
                    'date'                => 'Datum',
                    'date-time'           => 'Datum Zeit',
                    'delete'              => 'Löschen',
                    'edit'                => 'Bearbeiten',
                    'false'               => 'Falsch',
                    'file'                => 'Datei',
                    'id'                  => 'ID',
                    'image'               => 'Bild',
                    'locale-based'        => 'Ortsbasiert',
                    'mass-delete-success' => 'Ausgewähltes Attribut erfolgreich gelöscht',
                    'multiselect'         => 'Mehrfachauswahl',
                    'name'                => 'Name',
                    'price'               => 'Preis',
                    'required'            => 'Erforderlich',
                    'select'              => 'Auswählen',
                    'text'                => 'Text',
                    'textarea'            => 'Textbereich',
                    'true'                => 'Wahr',
                    'type'                => 'Typ',
                    'unique'              => 'Einzigartig',
                ],
            ],

            'create' => [
                'add-attribute-options' => 'Attributoptionen hinzufügen',
                'add-option'            => 'Option hinzufügen',
                'add-options-info'      => 'Um verschiedene Kombinationen von Attributoptionen schnell zu erstellen.',
                'add-row'               => 'Zeile hinzufügen',
                'admin'                 => 'Admin',
                'admin-name'            => 'Admin-Name',
                'back-btn'              => 'Zurück',
                'boolean'               => 'Boolesch',
                'checkbox'              => 'Checkbox',
                'code'                  => 'Attribut-Code',
                'color'                 => 'Farbe',
                'configuration'         => 'Konfiguration',
                'create-empty-option'   => 'Standard- leere Option erstellen',
                'date'                  => 'Datum',
                'datetime'              => 'Datetime',
                'decimal'               => 'Dezimal',
                'default-value'         => 'Standardwert',
                'email'                 => 'E-Mail',
                'enable-wysiwyg'        => 'Wysiwyg-Editor aktivieren',
                'file'                  => 'Datei',
                'general'               => 'Allgemein',
                'image'                 => 'Bild',
                'input-options'         => 'Eingabeoptionen',
                'input-validation'      => 'Eingabeüberprüfung',
                'is-comparable'         => 'Attribut ist vergleichbar',
                'is-configurable'       => 'Zum Erstellen von konfigurierbaren Produkten verwenden',
                'is-filterable'         => 'In Layered Navigation verwenden',
                'is-required'           => 'Erforderlich',
                'is-unique'             => 'Einzigartig',
                'is-visible-on-front'   => 'Auf der Produktansichtsseite auf der Vorderseite sichtbar',
                'label'                 => 'Bezeichnung',
                'multiselect'           => 'Multiselect',
                'no'                    => 'Nein',
                'numeric'               => 'Nummer',
                'option-deleted'        => 'Option erfolgreich gelöscht',
                'options'               => 'Optionen',
                'position'              => 'Position',
                'price'                 => 'Preis',
                'regex'                 => 'Regex',
                'regex-info'            => 'Der Ausdruck sollte in doppelten Anführungszeichen stehen.',
                'save-btn'              => 'Attribut speichern',
                'select'                => 'Auswählen',
                'select-type'           => 'Attributtyp auswählen',
                'swatch'                => 'Swatch',
                'text'                  => 'Text',
                'textarea'              => 'Textarea',
                'title'                 => 'Attribut hinzufügen',
                'type'                  => 'Attributtyp',
                'url'                   => 'URL',
                'use-in-flat'           => 'In der Produkt-Flachtabelle erstellen',
                'validations'           => 'Validierungen',
                'value-per-channel'     => 'Wert pro Kanal',
                'value-per-locale'      => 'Wert pro Sprache',
                'yes'                   => 'Ja',

                'option' => [
                    'color'    => 'Farbschwamm',
                    'dropdown' => 'Dropdown',
                    'image'    => 'Bildschwamm',
                    'save-btn' => 'Option speichern',
                    'text'     => 'Textschwamm',
                ],
            ],

            'edit' => [
                'add-attribute-options' => 'Attributoptionen hinzufügen',
                'add-option'            => 'Option hinzufügen',
                'add-options-info'      => 'Um verschiedene Kombinationen von Attributoptionen zu erstellen.',
                'add-row'               => 'Zeile hinzufügen',
                'admin'                 => 'Admin',
                'admin-name'            => 'Admin Name',
                'back-btn'              => 'Zurück',
                'boolean'               => 'Boolesch',
                'checkbox'              => 'Kontrollkästchen',
                'code'                  => 'Attributcode',
                'color'                 => 'Farbe',
                'configuration'         => 'Konfiguration',
                'create-empty-option'   => 'Standardmäßig leere Option erstellen',
                'date'                  => 'Datum',
                'datetime'              => 'Datum und Uhrzeit',
                'decimal'               => 'Dezimal',
                'default-value'         => 'Standardwert',
                'email'                 => 'E-Mail',
                'enable-wysiwyg'        => 'WYSIWYG-Editor aktivieren',
                'file'                  => 'Datei',
                'general'               => 'Allgemein',
                'image'                 => 'Bild',
                'input-options'         => 'Eingabeoptionen',
                'input-validation'      => 'Eingabevalidierung',
                'is-comparable'         => 'Attribut ist vergleichbar',
                'is-configurable'       => 'Zur Erstellung von konfigurierbaren Produkten verwenden',
                'is-filterable'         => 'In der Ebenennavigation verwenden',
                'is-required'           => 'Ist erforderlich',
                'is-unique'             => 'Ist eindeutig',
                'is-visible-on-front'   => 'Auf der Produktansichtsseite auf der Vorderseite sichtbar',
                'label'                 => 'Label',
                'multiselect'           => 'Mehrfachauswahl',
                'no'                    => 'Nein',
                'numeric'               => 'Nummer',
                'option-deleted'        => 'Option erfolgreich gelöscht',
                'options'               => 'Optionen',
                'position'              => 'Position',
                'price'                 => 'Preis',
                'regex'                 => 'Regex',
                'regex-info'            => 'Der Ausdruck sollte in doppelten Anführungszeichen stehen.',
                'save-btn'              => 'Attribut speichern',
                'select'                => 'Auswählen',
                'select-type'           => 'Attributtyp auswählen',
                'swatch'                => 'Farbmuster',
                'text'                  => 'Text',
                'textarea'              => 'Textarea',
                'title'                 => 'Attribut bearbeiten',
                'type'                  => 'Attributtyp',
                'url'                   => 'URL',
                'use-in-flat'           => 'In der Produkt-Flat-Tabelle erstellen',
                'validations'           => 'Validierungen',
                'value-per-channel'     => 'Wert pro Channel',
                'value-per-locale'      => 'Wert pro Locale',
                'yes'                   => 'Ja',

                'option' => [
                    'color'    => 'Farbmuster',
                    'dropdown' => 'Dropdown',
                    'image'    => 'Bildmuster',
                    'save-btn' => 'Option speichern',
                    'text'     => 'Textmuster',
                ],
            ],

            'create-success'    => 'Attribut erfolgreich erstellt',
            'delete-failed'     => 'Löschen des Attributs fehlgeschlagen',
            'delete-success'    => 'Attribut erfolgreich gelöscht',
            'update-success'    => 'Attribut erfolgreich aktualisiert',
            'user-define-error' => 'Systemattribut kann nicht gelöscht werden',
        ],

        'categories' => [
            'index' => [
                'add-btn' => 'Kategorie erstellen',
                'title'   => 'Kategorien',

                'datagrid' => [
                    'active'         => 'Aktiv',
                    'delete'         => 'Löschen',
                    'delete-success' => 'Ausgewählte :resource wurden erfolgreich gelöscht',
                    'edit'           => 'Bearbeiten',
                    'id'             => 'ID',
                    'inactive'       => 'Inaktiv',
                    'name'           => 'Name',
                    'no-of-products' => 'Im Menü sichtbar',
                    'position'       => 'Position',
                    'status'         => 'Status',
                    'update-status'  => 'Status aktualisieren',
                ],
            ],

            'create' => [
                'add-banner'               => 'Banner hinzufügen',
                'add-logo'                 => 'Logo hinzufügen',
                'back-btn'                 => 'Zurück',
                'banner'                   => 'Banner',
                'banner-size'              => 'Banner-Seitenverhältnis (1320px X 300px)',
                'description'              => 'Beschreibung',
                'description-and-images'   => 'Beschreibung und Bilder',
                'description-only'         => 'Nur Beschreibung',
                'display-mode'             => 'Anzeigemodus',
                'enter-position'           => 'Position eingeben',
                'filterable-attributes'    => 'Filterbare Attribute',
                'general'                  => 'Allgemein',
                'logo'                     => 'Logo',
                'logo-size'                => 'Logoresolution sollte (110px X 110px) sein',
                'meta-description'         => 'Meta-Beschreibung',
                'meta-keywords'            => 'Meta-Schlüsselwörter',
                'meta-title'               => 'Meta-Titel',
                'name'                     => 'Name',
                'parent-category'          => 'Übergeordnete Kategorie',
                'position'                 => 'Position',
                'products-and-description' => 'Produkte und Beschreibung',
                'products-only'            => 'Nur Produkte',
                'save-btn'                 => 'Kategorie speichern',
                'select-display-mode'      => 'Anzeigemodus auswählen',
                'seo-details'              => 'SEO-Details',
                'settings'                 => 'Einstellungen',
                'slug'                     => 'Slug',
                'title'                    => 'Neue Kategorie hinzufügen',
                'visible-in-menu'          => 'Im Menü sichtbar',
            ],

            'edit' => [
                'add-banner'               => 'Banner hinzufügen',
                'add-logo'                 => 'Logo hinzufügen',
                'back-btn'                 => 'Zurück',
                'banner'                   => 'Banner',
                'banner-size'              => 'Banner-Seitenverhältnis (1320px X 300px)',
                'description'              => 'Beschreibung',
                'description-and-images'   => 'Beschreibung und Bilder',
                'description-only'         => 'Nur Beschreibung',
                'display-mode'             => 'Anzeigemodus',
                'enter-position'           => 'Position eingeben',
                'filterable-attributes'    => 'Filterbare Attribute',
                'general'                  => 'Allgemein',
                'logo'                     => 'Logo',
                'logo-size'                => 'Logoresolution sollte (110px X 110px) sein',
                'meta-description'         => 'Meta-Beschreibung',
                'meta-keywords'            => 'Meta-Schlüsselwörter',
                'meta-title'               => 'Meta-Titel',
                'name'                     => 'Name',
                'position'                 => 'Position*',
                'products-and-description' => 'Produkte und Beschreibung',
                'products-only'            => 'Nur Produkte',
                'save-btn'                 => 'Kategorie speichern',
                'select-display-mode'      => 'Anzeigemodus auswählen',
                'select-parent-category'   => 'Übergeordnete Kategorie auswählen*',
                'seo-details'              => 'SEO-Details',
                'settings'                 => 'Einstellungen',
                'slug'                     => 'Slug',
                'title'                    => 'Kategorie bearbeiten',
                'visible-in-menu'          => 'Im Menü sichtbar',
            ],

            'category'             => 'Kategorie',
            'create-success'       => 'Kategorie erfolgreich erstellt.',
            'delete-category-root' => 'Die Stammkategorie kann nicht gelöscht werden.',
            'delete-failed'        => 'Fehler beim Löschen der Kategorie aufgetreten',
            'delete-success'       => 'Die Kategorie wurde erfolgreich gelöscht.',
            'update-success'       => 'Kategorie erfolgreich aktualisiert.',
        ],

        'families'   => [
            'index' => [
                'add'   => 'Attributfamilie erstellen',
                'title' => 'Familien',

                'datagrid' => [
                    'code'           => 'Code',
                    'delete'         => 'Löschen',
                    'delete-success' => 'Ausgewählte :resource wurden erfolgreich gelöscht',
                    'edit'           => 'Bearbeiten',
                    'id'             => 'ID',
                    'method-error'   => 'Fehler! Falsche Methode erkannt, bitte überprüfen Sie die Massenaktionskonfiguration',
                    'name'           => 'Name',
                    'no-resource'    => 'Die bereitgestellte Ressource reicht für die Aktion nicht aus',
                    'partial-action' => 'Einige Aktionen wurden aufgrund eingeschränkter Systemeinschränkungen auf :resource nicht durchgeführt',
                    'update-success' => 'Ausgewählte :resource wurden erfolgreich aktualisiert',
                ],
            ],

            'create' => [
                'add-group-btn'                    => 'Gruppe hinzufügen',
                'add-group-title'                  => 'Neue Gruppe hinzufügen',
                'back-btn'                         => 'Zurück',
                'code'                             => 'Code',
                'column'                           => 'Spalte',
                'delete-group-btn'                 => 'Gruppe löschen',
                'edit-group-info'                  => 'Doppelklicken Sie, um die Gruppe zu bearbeiten',
                'enter-code'                       => 'Code eingeben',
                'enter-name'                       => 'Name eingeben',
                'general'                          => 'Allgemein',
                'group-code-already-exists'        => 'Ein Attributgruppencode existiert bereits.',
                'group-contains-system-attributes' => 'Diese Gruppe enthält Systemattribute. Verschieben Sie zuerst Systemattribute in eine andere Gruppe und versuchen Sie es erneut.',
                'group-name-already-exists'        => 'Ein Attributgruppenname existiert bereits.',
                'groups'                           => 'Gruppen',
                'groups-info'                      => 'Verwalten Sie Attributfamilien-Gruppen',
                'main-column'                      => 'Hauptspalte',
                'name'                             => 'Name',
                'removal-not-possible'             => 'Sie können Systemattribute nicht aus der Attributfamilie entfernen.',
                'right-column'                     => 'Rechte Seitenleiste',
                'save-btn'                         => 'Attributfamilie speichern',
                'select-group'                     => 'Bitte wählen Sie eine Attributgruppe aus.',
                'title'                            => 'Attributfamilie erstellen',
                'unassigned-attributes'            => 'Nicht zugewiesene Attribute',
                'unassigned-attributes-info'       => 'Ziehen Sie diese Attribute, um sie in Spalten oder Gruppen hinzuzufügen.',
            ],

            'edit' => [
                'add-group-btn'                    => 'Gruppe hinzufügen',
                'add-group-title'                  => 'Neue Gruppe hinzufügen',
                'back-btn'                         => 'Zurück',
                'code'                             => 'Code',
                'column'                           => 'Spalte',
                'delete-group-btn'                 => 'Gruppe löschen',
                'edit-group-info'                  => 'Doppelklicken Sie, um die Gruppe zu bearbeiten',
                'enter-code'                       => 'Code eingeben',
                'enter-name'                       => 'Name eingeben',
                'general'                          => 'Allgemein',
                'group-code-already-exists'        => 'Ein Attributgruppencode existiert bereits.',
                'group-contains-system-attributes' => 'Diese Gruppe enthält Systemattribute. Verschieben Sie zuerst Systemattribute in eine andere Gruppe und versuchen Sie es erneut.',
                'group-name-already-exists'        => 'Ein Attributgruppenname existiert bereits.',
                'groups'                           => 'Gruppen',
                'groups-info'                      => 'Verwalten Sie Attributfamilien-Gruppen',
                'main-column'                      => 'Hauptspalte',
                'name'                             => 'Name',
                'removal-not-possible'             => 'Sie können Systemattribute nicht aus der Attributfamilie entfernen.',
                'right-column'                     => 'Rechte Seitenleiste',
                'save-btn'                         => 'Attributfamilie speichern',
                'select-group'                     => 'Bitte wählen Sie eine Attributgruppe aus.',
                'title'                            => 'Attributfamilie bearbeiten',
                'unassigned-attributes'            => 'Nicht zugewiesene Attribute',
                'unassigned-attributes-info'       => 'Ziehen Sie diese Attribute, um sie in Spalten oder Gruppen hinzuzufügen.',
            ],

            'attribute-family'        => 'Attributfamilie',
            'attribute-product-error' => 'Die Familie wird in Produkten verwendet.',
            'create-success'          => 'Familie erfolgreich erstellt.',
            'delete-failed'           => 'Fehler beim Löschen der Familie aufgetreten.',
            'delete-success'          => 'Familie erfolgreich gelöscht.',
            'family'                  => 'Familie',
            'last-delete-error'       => 'Mindestens eine Familie ist erforderlich.',
            'update-success'          => 'Familie erfolgreich aktualisiert.',
            'user-define-error'       => 'Systemattributfamilie kann nicht gelöscht werden.',
        ],
    ],

    'customers' => [
        'customers' => [
            'index' => [
                'title'         => 'Kunden',
                'login-message' => 'Sie haben sich angemeldet als :customer_name',

                'datagrid' => [
                    'active'         => 'Aktiv',
                    'address'        => ':address Adresse(n)',
                    'address-count'  => 'Anzahl der Adressen',
                    'channel'        => 'Kanal',
                    'delete'         => 'Löschen',
                    'delete-success' => 'Ausgewählte Daten erfolgreich gelöscht',
                    'email'          => 'E-Mail',
                    'gender'         => 'Geschlecht',
                    'group'          => 'Gruppe',
                    'id'             => 'Kunden-ID',
                    'id-value'       => 'ID - :id',
                    'inactive'       => 'Inaktiv',
                    'method-error'   => 'Fehler! Falsche Methode erkannt, bitte überprüfen Sie die Massenaktionskonfiguration',
                    'name'           => 'Kundenname',
                    'no-resource'    => 'Die bereitgestellten Ressourcen sind für die Aktion unzureichend',
                    'order'          => ':order Bestellung(en)',
                    'order-count'    => 'Anzahl der Bestellungen',
                    'order-pending'  => 'Der Kunde hat ausstehende Bestellungen',
                    'partial-action' => 'Einige Aktionen wurden aufgrund eingeschränkter Systembeschränkungen für :resource nicht durchgeführt',
                    'phone'          => 'Kontaktnummer',
                    'revenue'        => 'Umsatz',
                    'status'         => 'Status',
                    'suspended'      => 'Gesperrt',
                    'update-status'  => 'Status aktualisieren',
                    'update-success' => 'Ausgewählte Kunden erfolgreich aktualisiert',
                ],

                'create' => [
                    'contact-number'        => 'Kontaktnummer',
                    'create-btn'            => 'Kunden erstellen',
                    'create-success'        => 'Kunde erfolgreich erstellt',
                    'customer-group'        => 'Kundengruppe',
                    'date-of-birth'         => 'Geburtsdatum',
                    'email'                 => 'E-Mail',
                    'female'                => 'Weiblich',
                    'first-name'            => 'Vorname',
                    'gender'                => 'Geschlecht',
                    'last-name'             => 'Nachname',
                    'male'                  => 'Männlich',
                    'other'                 => 'Andere',
                    'save-btn'              => 'Kunde speichern',
                    'select-customer-group' => 'Kundengruppe auswählen',
                    'select-gender'         => 'Geschlecht auswählen',
                    'title'                 => 'Neuen Kunden erstellen',
                ],
            ],

            'view' => [
                'account-delete-confirmation' => 'Sind Sie sicher, dass Sie dieses Konto löschen möchten?',
                'active'                      => 'Aktiv',
                'address-delete-confirmation' => 'Sind Sie sicher, dass Sie diese Adresse löschen möchten?',
                'back-btn'                    => 'Zurück',
                'create-order'                => 'Bestellung erstellen',
                'customer'                    => 'Kunde',
                'date-of-birth'               => 'Geburtsdatum - :dob',
                'default-address'             => 'Standardadresse',
                'delete-account'              => 'Konto löschen',
                'delete'                      => 'Löschen',
                'email'                       => 'E-Mail - :email',
                'empty-description'           => 'Neue Adressen für den Kunden erstellen',
                'empty-title'                 => 'Kundenadresse hinzufügen',
                'gender'                      => 'Geschlecht - :gender',
                'group'                       => 'Gruppe - :group_code',
                'inactive'                    => 'Inaktiv',
                'login-as-customer'           => 'Als Kunde einloggen',
                'note-created-success'        => 'Notiz erfolgreich erstellt',
                'order-create-confirmation'   => 'Möchten Sie wirklich eine Bestellung für diesen Kunden erstellen?',
                'phone'                       => 'Telefon - :phone',
                'set-as-default'              => 'Als Standard festlegen',
                'suspended'                   => 'Gesperrt',
                'title'                       => 'Kundenansicht',

                'address' => [
                    'count'  => 'Adressen (:count)',

                    'create' => [
                        'city'               => 'Stadt',
                        'company-name'       => 'Firmenname',
                        'country'            => 'Land',
                        'create-btn'         => 'Erstellen',
                        'create-address-btn' => 'Neue Adresse hinzufügen',
                        'default-address'    => 'Standardadresse',
                        'email'              => 'E-Mail',
                        'first-name'         => 'Vorname',
                        'last-name'          => 'Nachname',
                        'phone'              => 'Telefon',
                        'post-code'          => 'Postleitzahl',
                        'save-btn-title'     => 'Adresse speichern',
                        'select-country'     => 'Land auswählen',
                        'state'              => 'Bundesland',
                        'street-address'     => 'Straßenadresse',
                        'title'              => 'Adresse erstellen',
                        'vat-id'             => 'USt-IdNr.',
                    ],

                    'edit' => [
                        'city'            => 'Stadt',
                        'company-name'    => 'Firmenname',
                        'country'         => 'Land',
                        'default-address' => 'Standardadresse',
                        'edit-btn'        => 'Bearbeiten',
                        'email'           => 'E-Mail',
                        'first-name'      => 'Vorname',
                        'last-name'       => 'Nachname',
                        'phone'           => 'Telefon',
                        'post-code'       => 'Postleitzahl',
                        'save-btn-title'  => 'Adresse speichern',
                        'select-country'  => 'Land auswählen',
                        'state'           => 'Bundesland',
                        'street-address'  => 'Straßenadresse',
                        'title'           => 'Adresse bearbeiten',
                        'vat-id'          => 'USt-IdNr.',
                    ],

                    'address-delete-success' => 'Adresse erfolgreich gelöscht',
                    'create-success'         => 'Adresse erfolgreich erstellt',
                    'set-default-success'    => 'Standardadresse erfolgreich aktualisiert',
                    'success-mass-delete'    => 'Massenlöschung von Adressen erfolgreich',
                    'update-success'         => 'Adresse erfolgreich aktualisiert',
                ],

                'datagrid' => [
                    'invoices' => [
                        'empty-invoice'  => 'Keine Bewertungen verfügbar',
                        'increment-id'   => 'Rechnungs-ID',
                        'invoice-amount' => 'Rechnungsbetrag',
                        'invoice-date'   => 'Rechnungsdatum',
                        'order-id'       => 'Bestellnummer',
                        'view'           => 'Ansehen',
                    ],

                    'orders' => [
                        'canceled'        => 'Storniert',
                        'channel-name'    => 'Kanalname',
                        'closed'          => 'Geschlossen',
                        'completed'       => 'Abgeschlossen',
                        'customer-name'   => 'Kundenname',
                        'date'            => 'Datum',
                        'empty-order'     => 'Keine Bestellungen verfügbar',
                        'email'           => 'E-Mail',
                        'fraud'           => 'Betrug',
                        'grand-total'     => 'Gesamtsumme',
                        'location'        => 'Ort',
                        'order-id'        => 'Bestellnummer',
                        'pay-via'         => 'Bezahlen mit',
                        'pending'         => 'Ausstehend',
                        'pending-payment' => 'Zahlung ausstehend',
                        'processing'      => 'In Bearbeitung',
                        'status'          => 'Status',
                        'view'            => 'Ansehen',
                    ],

                    'reviews' => [
                        'approved'      => 'Genehmigt',
                        'comment'       => 'Kommentar',
                        'created-at'    => 'Erstellt am',
                        'disapproved'   => 'Abgelehnt',
                        'empty-reviews' => 'Keine Rechnungen verfügbar',
                        'id'            => 'ID',
                        'invoice-date'  => 'Rechnungsdatum',
                        'pending'       => 'Ausstehend',
                        'product-id'    => 'Produkt-ID',
                        'product-name'  => 'Produktname',
                        'rating'        => 'Bewertung',
                        'status'        => 'Status',
                        'title'         => 'Titel',
                    ],
                ],

                'edit' => [
                    'contact-number'        => 'Kontaktnummer',
                    'customer-group'        => 'Kundengruppe',
                    'date-of-birth'         => 'Geburtsdatum',
                    'edit-btn'              => 'Bearbeiten',
                    'email'                 => 'E-Mail',
                    'female'                => 'Weiblich',
                    'first-name'            => 'Vorname',
                    'gender'                => 'Geschlecht',
                    'last-name'             => 'Nachname',
                    'male'                  => 'Männlich',
                    'other'                 => 'Andere',
                    'save-btn'              => 'Kunden speichern',
                    'select-customer-group' => 'Kundengruppe auswählen',
                    'select-gender'         => 'Geschlecht auswählen',
                    'status'                => 'Status',
                    'suspended'             => 'Gesperrt',
                    'title'                 => 'Kunde bearbeiten',
                ],

                'invoices' => [
                    'count'        => 'Rechnungen (:count)',
                    'increment-id' => '# :increment_id',
                ],

                'notes' => [
                    'add-note'              => 'Notiz hinzufügen',
                    'customer-not-notified' => ':date | Kunde <b>nicht benachrichtigt</b>',
                    'customer-notified'     => ':date | Kunde <b>benachrichtigt</b>',
                    'note'                  => 'Notiz',
                    'note-placeholder'      => 'Schreiben Sie hier Ihre Notiz',
                    'notify-customer'       => 'Kunden benachrichtigen',
                    'submit-btn-title'      => 'Notiz senden',
                ],

                'orders' => [
                    'count'         => 'Bestellungen (:count)',
                    'increment-id'  => '# :increment_id',
                    'total-revenue' => 'Gesamteinnahmen - :revenue',
                ],

                'reviews' => [
                    'id'    => 'ID - :id',
                    'count' => 'Bewertungen (:count)',
                ],

                'cart' => [
                    'delete-success' => 'Artikel aus dem Warenkorb erfolgreich entfernt.',
                ],

                'wishlist' => [
                    'delete-success' => 'Artikel aus der Wunschliste erfolgreich entfernt.',
                ],

                'compare' => [
                    'delete-success' => 'Artikel aus dem Vergleich erfolgreich entfernt.',
                ],
            ],

            'delete-failed'  => 'Kundenlöschung fehlgeschlagen',
            'delete-success' => 'Kunde erfolgreich gelöscht',
            'order-pending'  => 'Bestellungen stehen aus',
            'update-success' => 'Kunde erfolgreich aktualisiert',
        ],

        'groups' => [
            'index' => [
                'title' => 'Gruppen',

                'create' => [
                    'code'       => 'Code',
                    'create-btn' => 'Gruppe erstellen',
                    'name'       => 'Name',
                    'save-btn'   => 'Gruppe speichern',
                    'success'    => 'Gruppe erfolgreich erstellt',
                    'title'      => 'Neue Gruppe erstellen',
                ],

                'edit' => [
                    'delete-failed'  => 'Löschen der Gruppe fehlgeschlagen',
                    'delete-success' => 'Gruppe erfolgreich gelöscht',
                    'group-default'  => 'Standardgruppe kann nicht gelöscht werden',
                    'success'        => 'Gruppe erfolgreich aktualisiert',
                    'title'          => 'Gruppe bearbeiten',
                ],

                'datagrid' => [
                    'code'   => 'Code',
                    'delete' => 'Löschen',
                    'edit'   => 'Bearbeiten',
                    'id'     => 'ID',
                    'name'   => 'Name',
                ],
            ],
        ],

        'gdpr' => [
            'index' => [
                'title' => 'DSGVO-Anfrage',

                'datagrid' => [
                    'completed'     => 'Abgeschlossen',
                    'created-at'    => 'Erstellt am',
                    'customer-name' => 'Kundenname',
                    'declined'      => 'Abgelehnt',
                    'delete'        => 'Löschen',
                    'edit'          => 'Bearbeiten',
                    'id'            => 'ID',
                    'message'       => 'Nachricht',
                    'pending'       => 'Ausstehend',
                    'processing'    => 'In Bearbeitung',
                    'revoked'       => 'Widerrufen',
                    'status'        => 'Status',
                    'type'          => 'Typ',
                ],

                'modal' => [
                    'completed'     => 'Abgeschlossen',
                    'declined'      => 'Abgelehnt',
                    'message'       => 'Nachricht',
                    'pending'       => 'Ausstehend',
                    'processing'    => 'In Bearbeitung',
                    'revoked'       => 'Widerrufen',
                    'save-btn'      => 'Speichern',
                    'status'        => 'Status',
                    'title'         => 'DSGVO-Datenanfrage bearbeiten',
                    'type'          => 'Typ',
                ],

                'update-success'              => 'Datenanfrage erfolgreich aktualisiert und E-Mail an den Kunden gesendet.',
                'delete-success'              => 'Datenanfrage erfolgreich gelöscht.',
                'attribute-reason-error'      => 'Löschen nicht möglich.',
                'update-success-unsent-email' => 'Datenanfrage erfolgreich aktualisiert, aber E-Mail nicht an den Kunden gesendet.',
            ],
        ],

        'reviews' => [
            'index' => [
                'date'        => 'Datum',
                'description' => 'Beschreibung',
                'id'          => 'ID',
                'name'        => 'Name',
                'product'     => 'Produkt',
                'rating'      => 'Bewertung',
                'status'      => 'Status',
                'title'       => 'Bewertungen',

                'edit' => [
                    'approved'       => 'Genehmigt',
                    'customer'       => 'Kunde',
                    'date'           => 'Datum',
                    'disapproved'    => 'Abgelehnt',
                    'id'             => 'ID',
                    'images'         => 'Bilder',
                    'pending'        => 'Ausstehend',
                    'product'        => 'Produkt',
                    'rating'         => 'Bewertung',
                    'review-comment' => 'Kommentar',
                    'review-title'   => 'Titel',
                    'save-btn'       => 'Speichern',
                    'status'         => 'Status',
                    'title'          => 'Bewertung bearbeiten',
                    'update-success' => 'Erfolgreich aktualisiert',
                ],

                'datagrid' => [
                    'approved'            => 'Genehmigt',
                    'comment'             => 'Kommentar',
                    'customer-names'      => 'Name',
                    'date'                => 'Datum',
                    'delete'              => 'Löschen',
                    'delete-success'      => 'Bewertung erfolgreich gelöscht',
                    'disapproved'         => 'Abgelehnt',
                    'edit'                => 'Bearbeiten',
                    'id'                  => 'ID',
                    'mass-delete-error'   => 'Etwas ist schiefgelaufen',
                    'mass-delete-success' => 'Ausgewählte Bewertungen erfolgreich gelöscht',
                    'mass-update-success' => 'Ausgewählte Bewertungen erfolgreich aktualisiert',
                    'pending'             => 'Ausstehend',
                    'product'             => 'Produkt',
                    'rating'              => 'Bewertung',
                    'review-id'           => 'ID - :review_id',
                    'status'              => 'Status',
                    'title'               => 'Titel',
                    'update-status'       => 'Status aktualisieren',
                ],
            ],
        ],
    ],

    'marketing' => [
        'communications' => [
            'templates' => [
                'index' => [
                    'create-btn' => 'Vorlage erstellen',
                    'title'      => 'E-Mail-Vorlagen',

                    'datagrid' => [
                        'active'   => 'Aktiv',
                        'draft'    => 'Entwurf',
                        'id'       => 'ID',
                        'inactive' => 'Inaktiv',
                        'name'     => 'Name',
                        'status'   => 'Status',
                    ],
                ],

                'create' => [
                    'active'         => 'Aktiv',
                    'back-btn'       => 'Zurück',
                    'content'        => 'Inhalt',
                    'create-success' => 'E-Mail-Vorlage erfolgreich erstellt.',
                    'draft'          => 'Entwurf',
                    'general'        => 'Allgemein',
                    'inactive'       => 'Inaktiv',
                    'name'           => 'Name',
                    'save-btn'       => 'Vorlage speichern',
                    'select-status'  => 'Status auswählen',
                    'status'         => 'Status',
                    'title'          => 'Vorlage erstellen',
                ],

                'edit' => [
                    'active'         => 'Aktiv',
                    'back-btn'       => 'Zurück',
                    'content'        => 'Inhalt*',
                    'draft'          => 'Entwurf',
                    'general'        => 'Allgemein',
                    'inactive'       => 'Inaktiv',
                    'name'           => 'Name',
                    'save-btn'       => 'Vorlage speichern',
                    'status'         => 'Status',
                    'title'          => 'Vorlage bearbeiten',
                    'update-success' => 'Erfolgreich aktualisiert',
                ],

                'delete-failed'  => ':name konnte nicht gelöscht werden',
                'delete-success' => 'Vorlage erfolgreich gelöscht',
                'email-template' => 'E-Mail-Vorlage',
            ],

            'campaigns' => [
                'index' => [
                    'create-btn'  => 'Kampagne erstellen',
                    'title'       => 'Kampagnen',

                    'datagrid' => [
                        'active'   => 'Aktiv',
                        'delete'   => 'Löschen',
                        'edit'     => 'Bearbeiten',
                        'id'       => 'ID',
                        'inactive' => 'Inaktiv',
                        'name'     => 'Name',
                        'status'   => 'Status',
                        'subject'  => 'Betreff',
                    ],
                ],

                'create' => [
                    'active'          => 'Aktiv',
                    'back-btn'        => 'Zurück',
                    'channel'         => 'Kanal',
                    'customer-group'  => 'Kundengruppe',
                    'email-template'  => 'E-Mail-Vorlage',
                    'event'           => 'Ereignis',
                    'general'         => 'Allgemein',
                    'inactive'        => 'Inaktiv',
                    'name'            => 'Name',
                    'save-btn'        => 'Kampagne speichern',
                    'select-channel'  => 'Kanal auswählen',
                    'select-event'    => 'Ereignis auswählen',
                    'select-group'    => 'Gruppe auswählen',
                    'select-status'   => 'Status auswählen',
                    'select-template' => 'Vorlage auswählen',
                    'setting'         => 'Einstellung',
                    'status'          => 'Status',
                    'subject'         => 'Betreff',
                    'title'           => 'Kampagne erstellen',
                ],

                'edit' => [
                    'active'          => 'Aktiv',
                    'audience'        => 'Zielgruppe',
                    'back-btn'        => 'Zurück',
                    'channel'         => 'Kanal',
                    'customer-group'  => 'Kundengruppe',
                    'email-template'  => 'E-Mail-Vorlage',
                    'event'           => 'Ereignis',
                    'general'         => 'Allgemein',
                    'inactive'        => 'Inaktiv',
                    'name'            => 'Name',
                    'save-btn'        => 'Kampagne speichern',
                    'select-event'    => 'Ereignis auswählen',
                    'select-status'   => 'Status auswählen',
                    'select-template' => 'Vorlage auswählen',
                    'status'          => 'Status',
                    'subject'         => 'Betreff',
                    'title'           => 'Kampagne bearbeiten',
                ],

                'create-success' => 'Kampagne erfolgreich erstellt.',
                'delete-failed'  => ':name konnte nicht gelöscht werden',
                'delete-success' => 'Kampagne erfolgreich gelöscht',
                'email-campaign' => 'E-Mail-Kampagne',
                'update-success' => 'Kampagne erfolgreich aktualisiert.',
            ],

            'events' => [
                'index' => [
                    'create-btn' => 'Event erstellen',
                    'event'      => 'Veranstaltung',
                    'title'      => 'Veranstaltungen',

                    'datagrid' => [
                        'actions' => 'Aktionen',
                        'date'    => 'Datum',
                        'delete'  => 'Löschen',
                        'edit'    => 'Bearbeiten',
                        'id'      => 'ID',
                        'name'    => 'Name',
                    ],

                    'create' => [
                        'date'           => 'Datum',
                        'delete-warning' => 'Sind Sie sicher, dass Sie diese Aktion ausführen möchten?',
                        'description'    => 'Beschreibung',
                        'general'        => 'Allgemein',
                        'name'           => 'Name',
                        'save-btn'       => 'Veranstaltung speichern',
                        'success'        => 'Veranstaltungen erfolgreich erstellt',
                        'title'          => 'Veranstaltungen erstellen',
                    ],

                    'edit' => [
                        'success' => 'Veranstaltungen erfolgreich aktualisiert',
                        'title'   => 'Veranstaltungen bearbeiten',
                    ],
                ],

                'delete-failed'  => ':name Löschen fehlgeschlagen',
                'delete-success' => 'Veranstaltungen erfolgreich gelöscht',
                'edit-error'     => 'Veranstaltung kann nicht bearbeitet werden',
            ],

            'subscribers' => [
                'index' => [
                    'title' => 'Newsletter-Abonnements',

                    'datagrid' => [
                        'actions'    => 'Aktionen',
                        'delete'     => 'Löschen',
                        'edit'       => 'Bearbeiten',
                        'email'      => 'E-Mail',
                        'false'      => 'Nein',
                        'id'         => 'ID',
                        'subscribed' => 'Abonniert',
                        'true'       => 'Ja',
                    ],

                    'edit' => [
                        'back-btn'      => 'Zurück',
                        'email'         => 'E-Mail',
                        'false'         => 'Nein',
                        'save-btn'      => 'Abonnent speichern',
                        'subscribed'    => 'Abonniert',
                        'success'       => 'Newsletter-Abonnement erfolgreich aktualisiert',
                        'title'         => 'Newsletter-Abonnent bearbeiten',
                        'true'          => 'Ja',
                        'update-failed' => 'Newsletter-Abonnement nicht aktualisiert',
                    ],
                ],

                'delete-failed'  => 'Löschen des Abonnenten fehlgeschlagen',
                'delete-success' => 'Abonnent erfolgreich gelöscht',
                'delete-warning' => 'Sind Sie sicher, dass Sie diese Aktion durchführen möchten?',
            ],
        ],

        'promotions' => [
            'index' => [
                'cart-rule-title'    => 'Warenkorbregeln',
                'catalog-rule-title' => 'Katalogregeln',
            ],

            'cart-rules' => [
                'index' => [
                    'create-btn' => 'Warenkorbregel erstellen',
                    'title'      => 'Warenkorbregeln',

                    'datagrid' => [
                        'active'      => 'Aktiv',
                        'copy'        => 'Kopieren',
                        'copy-of'     => ':value',
                        'coupon-code' => 'Coupon-Code',
                        'delete'      => 'Löschen',
                        'draft'       => 'Entwurf',
                        'edit'        => 'Bearbeiten',
                        'end'         => 'Ende',
                        'id'          => 'ID',
                        'inactive'    => 'Inaktiv',
                        'name'        => 'Name',
                        'priority'    => 'Priorität',
                        'start'       => 'Start',
                        'status'      => 'Status',
                    ],
                ],

                'create' => [
                    'action-type'                               => 'Aktionstyp',
                    'actions'                                   => 'Aktionen',
                    'add-condition'                             => 'Bedingung hinzufügen',
                    'additional'                                => 'Zusätzlich',
                    'all-conditions-true'                       => 'Alle Bedingungen sind wahr',
                    'any-conditions-true'                       => 'Eine beliebige Bedingung ist wahr',
                    'apply-to-shipping'                         => 'Auf Versand anwenden',
                    'attribute-family'                          => 'Attributfamilie',
                    'attribute-name-children-only'              => ':attribute_name (Nur Unterkategorien)',
                    'attribute-name-parent-only'                => ':attribute_name (Nur Hauptkategorien)',
                    'auto-generate-coupon'                      => 'Coupon automatisch generieren',
                    'back-btn'                                  => 'Zurück',
                    'buy-x-get-y-free'                          => 'Kaufe X, erhalte Y kostenlos',
                    'buy-x-quantity'                            => 'Kaufe X Menge',
                    'cart-attribute'                            => 'Warenkorb-Attribut',
                    'cart-item-attribute'                       => 'Warenkorb-Artikelattribut',
                    'categories'                                => 'Kategorien',
                    'channels'                                  => 'Vertriebskanäle',
                    'children-categories'                       => 'Kategorien (Nur Unterkategorien)',
                    'choose-condition-to-add'                   => 'Bedingung zum Hinzufügen auswählen',
                    'condition-type'                            => 'Bedingungstyp',
                    'conditions'                                => 'Bedingungen',
                    'contain'                                   => 'Enthält',
                    'contains'                                  => 'Enthält',
                    'coupon-code'                               => 'Coupon-Code',
                    'coupon-type'                               => 'Coupon-Typ',
                    'create-success'                            => 'Warenkorbregel erfolgreich erstellt',
                    'customer-groups'                           => 'Kundengruppen',
                    'description'                               => 'Beschreibung',
                    'discount-amount'                           => 'Rabattbetrag',
                    'does-not-contain'                          => 'Enthält nicht',
                    'end-of-other-rules'                        => 'Ende anderer Regeln',
                    'equals-or-greater-than'                    => 'Gleich oder größer als',
                    'equals-or-less-than'                       => 'Gleich oder kleiner als',
                    'fixed-amount'                              => 'Fester Betrag',
                    'fixed-amount-whole-cart'                   => 'Fester Betrag für den gesamten Warenkorb',
                    'free-shipping'                             => 'Kostenloser Versand',
                    'from'                                      => 'Von',
                    'general'                                   => 'Allgemein',
                    'greater-than'                              => 'Größer als',
                    'is-equal-to'                               => 'Ist gleich',
                    'is-not-equal-to'                           => 'Ist nicht gleich',
                    'less-than'                                 => 'Kleiner als',
                    'marketing-time'                            => 'Marketingzeit',
                    'maximum-quantity-allowed-to-be-discounted' => 'Maximale Menge, die rabattiert werden darf',
                    'name'                                      => 'Name',
                    'no'                                        => 'Nein',
                    'no-coupon'                                 => 'Kein Coupon',
                    'parent-categories'                         => 'Kategorien (Nur Hauptkategorien)',
                    'payment-method'                            => 'Zahlungsmethode',
                    'percentage-product-price'                  => 'Prozentualer Produktpreis',
                    'price-in-cart'                             => 'Preis im Warenkorb',
                    'priority'                                  => 'Priorität',
                    'product-attribute'                         => 'Produktattribut',
                    'qty-in-cart'                               => 'Menge im Warenkorb',
                    'save-btn'                                  => 'Warenkorbregel speichern',
                    'settings'                                  => 'Einstellungen',
                    'shipping-country'                          => 'Land des Versands',
                    'shipping-method'                           => 'Versandart',
                    'shipping-postcode'                         => 'Postleitzahl des Versands',
                    'shipping-state'                            => 'Bundesland des Versands',
                    'specific-coupon'                           => 'Spezifischer Coupon',
                    'status'                                    => 'Status',
                    'subtotal'                                  => 'Zwischensumme',
                    'title'                                     => 'Warenkorbregel erstellen',
                    'to'                                        => 'Bis',
                    'total-items-qty'                           => 'Gesamtanzahl der Artikel',
                    'total-weight'                              => 'Gesamtgewicht',
                    'uses-per-coupon'                           => 'Verwendungen pro Coupon',
                    'uses-per-customer'                         => 'Verwendungen pro Kunde',
                    'uses-per-customer-control-info'            => 'Wird nur für eingeloggte Kunden verwendet.',
                    'yes'                                       => 'Ja',
                ],

                'edit' => [
                    'action-type'                               => 'Aktionstyp',
                    'actions'                                   => 'Aktionen',
                    'add-condition'                             => 'Bedingung hinzufügen',
                    'additional'                                => 'Zusätzlich',
                    'all-conditions-true'                       => 'Alle Bedingungen sind wahr',
                    'alphabetical'                              => 'Alphabetisch',
                    'alphanumeric'                              => 'Alphanumerisch',
                    'any-conditions-true'                       => 'Eine beliebige Bedingung ist wahr',
                    'apply-to-shipping'                         => 'Auf Versand anwenden',
                    'attribute-family'                          => 'Attributfamilie',
                    'attribute-name-children-only'              => ':attribute_name (nur Unterkategorien)',
                    'attribute-name-parent-only'                => ':attribute_name (nur Hauptkategorien)',
                    'auto-generate-coupon'                      => 'Coupon automatisch generieren',
                    'back-btn'                                  => 'Zurück',
                    'buy-x-get-y-free'                          => 'Kaufe X, erhalte Y kostenlos',
                    'buy-x-quantity'                            => 'Kaufe X Menge',
                    'cart-attribute'                            => 'Warenkorb-Attribut',
                    'cart-item-attribute'                       => 'Warenkorb-Artikelattribut',
                    'categories'                                => 'Kategorien',
                    'channels'                                  => 'Vertriebskanäle',
                    'children-categories'                       => 'Unterkategorien',
                    'choose-condition-to-add'                   => 'Bedingung zum Hinzufügen auswählen',
                    'code-format'                               => 'Code-Format',
                    'code-prefix'                               => 'Code-Präfix',
                    'code-suffix'                               => 'Code-Suffix',
                    'condition-type'                            => 'Bedingungstyp',
                    'conditions'                                => 'Bedingungen',
                    'contain'                                   => 'Enthält',
                    'contains'                                  => 'Enthält',
                    'coupon-code'                               => 'Coupon-Code',
                    'coupon-length'                             => 'Coupon-Länge',
                    'coupon-qty'                                => 'Coupon-Menge',
                    'coupon-type'                               => 'Coupon-Typ',
                    'customer-group'                            => 'Kundengruppe',
                    'customer-groups'                           => 'Kundengruppen',
                    'description'                               => 'Beschreibung',
                    'discount-amount'                           => 'Rabattbetrag',
                    'does-not-contain'                          => 'Enthält nicht',
                    'end-of-other-rules'                        => 'Ende anderer Regeln',
                    'equals-or-greater-than'                    => 'Gleich oder größer als',
                    'equals-or-less-than'                       => 'Gleich oder kleiner als',
                    'fixed-amount'                              => 'Fester Betrag',
                    'fixed-amount-whole-cart'                   => 'Fester Betrag für den gesamten Warenkorb',
                    'free-shipping'                             => 'Kostenloser Versand',
                    'from'                                      => 'Von',
                    'general'                                   => 'Allgemein',
                    'generate'                                  => 'Generieren',
                    'greater-than'                              => 'Größer als',
                    'is-equal-to'                               => 'Ist gleich',
                    'is-not-equal-to'                           => 'Ist nicht gleich',
                    'less-than'                                 => 'Kleiner als',
                    'marketing-time'                            => 'Marketingzeit',
                    'maximum-quantity-allowed-to-be-discounted' => 'Maximale Menge, die rabattiert werden darf',
                    'name'                                      => 'Name',
                    'no'                                        => 'Nein',
                    'no-coupon'                                 => 'Kein Coupon',
                    'numeric'                                   => 'Numerisch',
                    'parent-categories'                         => 'Hauptkategorien',
                    'payment-method'                            => 'Zahlungsmethode',
                    'percentage-product-price'                  => 'Prozentualer Produktpreis',
                    'price-in-cart'                             => 'Preis im Warenkorb',
                    'priority'                                  => 'Priorität',
                    'product-attribute'                         => 'Produktattribut',
                    'qty-in-cart'                               => 'Menge im Warenkorb',
                    'save-btn'                                  => 'Warenkorbregel speichern',
                    'settings'                                  => 'Einstellungen',
                    'shipping-country'                          => 'Land des Versands',
                    'shipping-method'                           => 'Versandart',
                    'shipping-postcode'                         => 'Postleitzahl des Versands',
                    'shipping-state'                            => 'Bundesland des Versands',
                    'specific-coupon'                           => 'Spezifischer Coupon',
                    'status'                                    => 'Status',
                    'subtotal'                                  => 'Zwischensumme',
                    'title'                                     => 'Warenkorbregel bearbeiten',
                    'to'                                        => 'Bis',
                    'total-items-qty'                           => 'Gesamtanzahl der Artikel',
                    'total-weight'                              => 'Gesamtgewicht',
                    'update-success'                            => 'Warenkorbregel erfolgreich aktualisiert',
                    'uses-per-coupon'                           => 'Verwendungen pro Coupon',
                    'uses-per-customer'                         => 'Verwendungen pro Kunde',
                    'uses-per-customer-control-info'            => 'Wird nur für eingeloggte Kunden verwendet.',
                    'yes'                                       => 'Ja',
                ],

                'delete-failed'  => 'Löschen der Warenkorbregel fehlgeschlagen',
                'delete-success' => 'Warenkorbregel erfolgreich gelöscht',
            ],

            'catalog-rules' => [
                'index' => [
                    'create-btn' => 'Katalogregel erstellen',
                    'title'      => 'Katalogregeln',

                    'datagrid' => [
                        'active'   => 'Aktiv',
                        'delete'   => 'Löschen',
                        'edit'     => 'Bearbeiten',
                        'end'      => 'Ende',
                        'id'       => 'ID',
                        'inactive' => 'Inaktiv',
                        'name'     => 'Name',
                        'priority' => 'Priorität',
                        'start'    => 'Start',
                        'status'   => 'Status',
                    ],
                ],

                'create' => [
                    'action-type'              => 'Aktionstyp',
                    'actions'                  => 'Aktionen',
                    'add-condition'            => 'Bedingung hinzufügen',
                    'all-conditions-true'      => 'Alle Bedingungen sind wahr',
                    'any-conditions-true'      => 'Eine beliebige Bedingung ist wahr',
                    'attribute-family'         => 'Attributfamilie',
                    'back-btn'                 => 'Zurück',
                    'categories'               => 'Kategorien',
                    'channels'                 => 'Vertriebskanäle',
                    'choose-condition-to-add'  => 'Bedingung zum Hinzufügen auswählen',
                    'condition-type'           => 'Bedingungstyp',
                    'conditions'               => 'Bedingungen',
                    'contain'                  => 'Enthält',
                    'contains'                 => 'Enthält',
                    'customer-groups'          => 'Kundengruppen',
                    'description'              => 'Beschreibung',
                    'discount-amount'          => 'Rabattbetrag',
                    'does-not-contain'         => 'Enthält nicht',
                    'end-other-rules'          => 'Ende anderer Regeln',
                    'equals-or-greater-than'   => 'Gleich oder größer als',
                    'equals-or-less-than'      => 'Gleich oder kleiner als',
                    'fixed-amount'             => 'Fester Betrag',
                    'from'                     => 'Von',
                    'general'                  => 'Allgemein',
                    'greater-than'             => 'Größer als',
                    'is-equal-to'              => 'Ist gleich',
                    'is-not-equal-to'          => 'Ist nicht gleich',
                    'less-than'                => 'Kleiner als',
                    'marketing-time'           => 'Marketingzeit',
                    'name'                     => 'Name',
                    'no'                       => 'Nein',
                    'percentage-product-price' => 'Prozentsatz vom Produktpreis',
                    'priority'                 => 'Priorität',
                    'product-attribute'        => 'Produktattribut',
                    'save-btn'                 => 'Katalogregel speichern',
                    'settings'                 => 'Einstellungen',
                    'status'                   => 'Status',
                    'title'                    => 'Katalogregel erstellen',
                    'to'                       => 'Bis',
                    'yes'                      => 'Ja',
                ],

                'edit' => [
                    'action-type'              => 'Aktionstyp',
                    'actions'                  => 'Aktionen',
                    'add-condition'            => 'Bedingung hinzufügen',
                    'all-conditions-true'      => 'Alle Bedingungen sind wahr',
                    'any-conditions-true'      => 'Eine beliebige Bedingung ist wahr',
                    'back-btn'                 => 'Zurück',
                    'categories'               => 'Kategorien',
                    'channels'                 => 'Vertriebskanäle',
                    'choose-condition-to-add'  => 'Bedingung zum Hinzufügen auswählen',
                    'condition-type'           => 'Bedingungstyp',
                    'conditions'               => 'Bedingungen',
                    'contain'                  => 'Enthält',
                    'contains'                 => 'Enthält',
                    'customer-groups'          => 'Kundengruppen',
                    'description'              => 'Beschreibung',
                    'discount-amount'          => 'Rabattbetrag',
                    'does-not-contain'         => 'Enthält nicht',
                    'end-other-rules'          => 'Ende anderer Regeln',
                    'equals-or-greater-than'   => 'Gleich oder größer als',
                    'equals-or-less-than'      => 'Gleich oder kleiner als',
                    'fixed-amount'             => 'Fester Betrag',
                    'from'                     => 'Von',
                    'general'                  => 'Allgemein',
                    'greater-than'             => 'Größer als',
                    'is-equal-to'              => 'Ist gleich',
                    'is-not-equal-to'          => 'Ist nicht gleich',
                    'less-than'                => 'Kleiner als',
                    'marketing-time'           => 'Marketingzeit',
                    'name'                     => 'Name',
                    'no'                       => 'Nein',
                    'percentage-product-price' => 'Prozentsatz vom Produktpreis',
                    'priority'                 => 'Priorität',
                    'product-attribute'        => 'Produktattribut',
                    'save-btn'                 => 'Katalogregel speichern',
                    'settings'                 => 'Einstellungen',
                    'status'                   => 'Status',
                    'title'                    => 'Katalogregel bearbeiten',
                    'to'                       => 'Bis',
                    'yes'                      => 'Ja',
                ],

                'create-success' => 'Katalogregel erfolgreich erstellt',
                'delete-success' => 'Katalogregel erfolgreich gelöscht',
                'update-success' => 'Katalogregel erfolgreich aktualisiert',
            ],

            'cart-rules-coupons' => [
                'cart-rule-not-defined-error' => 'Warenkorbregel kann nicht gelöscht werden',
                'delete-success'              => 'Warenkorb-Gutschein erfolgreich gelöscht',
                'mass-delete-success'         => 'Ausgewählte Elemente erfolgreich gelöscht',
                'success'                     => ':name erfolgreich erstellt',

                'datagrid' => [
                    'coupon-code'     => 'Gutscheincode',
                    'created-date'    => 'Erstellungsdatum',
                    'delete'          => 'Löschen',
                    'expiration-date' => 'Ablaufdatum',
                    'id'              => 'ID',
                    'times-used'      => 'Verwendete Male',
                ],
            ],
        ],

        'search-seo' => [
            'search-terms' => [
                'index' => [
                    'create-btn' => 'Suchbegriff erstellen',
                    'title'      => 'Suchbegriffe',

                    'datagrid' => [
                        'actions'             => 'Aktionen',
                        'channel'             => 'Kanal',
                        'delete'              => 'Löschen',
                        'edit'                => 'Bearbeiten',
                        'id'                  => 'ID',
                        'locale'              => 'Lokalisierung',
                        'mass-delete-success' => 'Ausgewählte Suchbegriffe erfolgreich gelöscht',
                        'redirect-url'        => 'Weiterleitungs-URL',
                        'results'             => 'Ergebnisse',
                        'search-query'        => 'Suchbegriff',
                        'uses'                => 'Verwendungen',
                    ],

                    'create' => [
                        'channel'        => 'Kanal',
                        'delete-warning' => 'Möchten Sie diese Aktion wirklich ausführen?',
                        'locale'         => 'Lokalisierung',
                        'redirect-url'   => 'Weiterleitungs-URL',
                        'results'        => 'Ergebnisse',
                        'save-btn'       => 'Suchbegriff speichern',
                        'search-query'   => 'Suchbegriff',
                        'success'        => 'Suchbegriff erfolgreich erstellt',
                        'title'          => 'Suchbegriff erstellen',
                        'uses'           => 'Verwendungen',
                    ],

                    'edit' => [
                        'delete-success' => 'Suchbegriff erfolgreich gelöscht',
                        'success'        => 'Suchbegriff erfolgreich aktualisiert',
                        'title'          => 'Suchbegriff bearbeiten',
                    ],
                ],
            ],

            'search-synonyms' => [
                'index' => [
                    'create-btn' => 'Suchsynonym erstellen',
                    'title'      => 'Suchsynonyme',

                    'datagrid' => [
                        'actions'             => 'Aktionen',
                        'delete'              => 'Löschen',
                        'edit'                => 'Bearbeiten',
                        'id'                  => 'ID',
                        'mass-delete-success' => 'Ausgewählte Suchsynonyme erfolgreich gelöscht',
                        'name'                => 'Name',
                        'terms'               => 'Begriffe',
                    ],

                    'create' => [
                        'delete-warning' => 'Sind Sie sicher, dass Sie diese Aktion durchführen möchten?',
                        'name'           => 'Name',
                        'save-btn'       => 'Suchsynonym speichern',
                        'success'        => 'Suchsynonym erfolgreich erstellt',
                        'terms'          => 'Begriffe',
                        'terms-info'     => 'Geben Sie Synonyme als durch Kommas getrennte Liste ein, z. B. "Schuhe, Schuhwerk." Dies erweitert die Suche, um alle Begriffe einzuschließen.',
                        'title'          => 'Suchsynonym erstellen',
                    ],

                    'edit' => [
                        'delete-success' => 'Suchsynonym erfolgreich gelöscht',
                        'success'        => 'Suchsynonym erfolgreich aktualisiert',
                        'title'          => 'Suchsynonym bearbeiten',
                    ],
                ],
            ],

            'sitemaps' => [
                'index' => [
                    'create-btn' => 'Sitemap erstellen',
                    'sitemap'    => 'Sitemap',
                    'title'      => 'Sitemaps',

                    'datagrid' => [
                        'actions'         => 'Aktionen',
                        'delete'          => 'Löschen',
                        'edit'            => 'Bearbeiten',
                        'file-name'       => 'Dateiname',
                        'id'              => 'ID',
                        'link-for-google' => 'Link für Google',
                        'path'            => 'Pfad',
                    ],

                    'create' => [
                        'delete-warning' => 'Sind Sie sicher, dass Sie diese Aktion ausführen möchten?',
                        'file-name'      => 'Dateiname',
                        'file-name-info' => 'Beispiel: sitemap.xml',
                        'path'           => 'Pfad',
                        'path-info'      => 'Beispiel: "/sitemap/" oder "/" für den Basispfad',
                        'save-btn'       => 'Sitemap speichern',
                        'success'        => 'Sitemap erfolgreich erstellt',
                        'title'          => 'Sitemap erstellen',
                    ],

                    'edit' => [
                        'delete-success' => 'Sitemap erfolgreich gelöscht',
                        'success'        => 'Sitemap erfolgreich aktualisiert',
                        'title'          => 'Sitemap bearbeiten',
                    ],
                ],

                'edit' => [
                    'back-btn'       => 'Zurück',
                    'file-name'      => 'Dateiname',
                    'file-name-info' => 'Beispiel: sitemap.xml',
                    'general'        => 'Allgemein',
                    'path'           => 'Pfad',
                    'path-info'      => 'Beispiel: "/sitemap/" oder "/" für den Basispfad',
                    'save-btn'       => 'Sitemap speichern',
                ],

                'delete-failed' => ':name Löschen fehlgeschlagen',
            ],

            'url-rewrites' => [
                'index' => [
                    'create-btn' => 'URL-Weiterleitung erstellen',
                    'title'      => 'URL-Weiterleitungen',

                    'datagrid' => [
                        'actions'             => 'Aktionen',
                        'category'            => 'Kategorie',
                        'cms-page'            => 'CMS-Seite',
                        'delete'              => 'Löschen',
                        'edit'                => 'Bearbeiten',
                        'for'                 => 'Für',
                        'id'                  => 'ID',
                        'locale'              => 'Lokalisierung',
                        'mass-delete-success' => 'Ausgewählte URL-Weiterleitungen erfolgreich gelöscht',
                        'permanent-redirect'  => 'Permanent (301)',
                        'product'             => 'Produkt',
                        'redirect-type'       => 'Weiterleitungstyp',
                        'request-path'        => 'Anforderungs-Pfad',
                        'target-path'         => 'Zielpfad',
                        'temporary-redirect'  => 'Temporär (302)',
                    ],

                    'create' => [
                        'category'           => 'Kategorie',
                        'cms-page'           => 'CMS-Seite',
                        'delete-warning'     => 'Sind Sie sicher, dass Sie diese Aktion ausführen möchten?',
                        'for'                => 'Für',
                        'locale'             => 'Lokalisierung',
                        'permanent-redirect' => 'Permanent (301)',
                        'product'            => 'Produkt',
                        'redirect-type'      => 'Weiterleitungstyp',
                        'request-path'       => 'Anforderungs-Pfad',
                        'save-btn'           => 'URL-Weiterleitung speichern',
                        'success'            => 'URL-Weiterleitung erfolgreich erstellt',
                        'target-path'        => 'Zielpfad',
                        'temporary-redirect' => 'Temporär (302)',
                        'title'              => 'URL-Weiterleitung erstellen',
                    ],

                    'edit' => [
                        'delete-success' => 'URL-Weiterleitung erfolgreich gelöscht',
                        'success'        => 'URL-Weiterleitung erfolgreich aktualisiert',
                        'title'          => 'URL-Weiterleitung bearbeiten',
                    ],
                ],
            ],
        ],
    ],

    'cms' => [
        'index' => [
            'already-taken' => 'Der :name wurde bereits verwendet.',
            'channel'       => 'Kanal',
            'create-btn'    => 'Seite erstellen',
            'language'      => 'Sprache',
            'title'         => 'Seiten',

            'datagrid' => [
                'channel'             => 'Kanal',
                'delete'              => 'Löschen',
                'edit'                => 'Bearbeiten',
                'id'                  => 'ID',
                'mass-delete-success' => 'Ausgewählte Daten erfolgreich gelöscht',
                'page-title'          => 'Seitentitel',
                'url-key'             => 'URL-Schlüssel',
                'view'                => 'Ansehen',
            ],
        ],

        'create' => [
            'channels'         => 'Kanäle',
            'content'          => 'Inhalt',
            'description'      => 'Beschreibung',
            'general'          => 'Allgemein',
            'meta-description' => 'Meta-Beschreibung',
            'meta-keywords'    => 'Meta-Schlüsselwörter',
            'meta-title'       => 'Meta-Titel',
            'page-title'       => 'Titel',
            'save-btn'         => 'Seite speichern',
            'seo'              => 'SEO',
            'title'            => 'Seite erstellen',
            'url-key'          => 'URL-Schlüssel',
        ],

        'edit' => [
            'back-btn'         => 'Zurück',
            'channels'         => 'Kanäle',
            'content'          => 'Inhalt',
            'description'      => 'Beschreibung',
            'general'          => 'Allgemein',
            'meta-description' => 'Meta-Beschreibung',
            'meta-keywords'    => 'Meta-Schlüsselwörter',
            'meta-title'       => 'Meta-Titel',
            'page-title'       => 'Seitentitel',
            'preview-btn'      => 'Seite anzeigen',
            'save-btn'         => 'Seite speichern',
            'seo'              => 'SEO',
            'title'            => 'Seite bearbeiten',
            'url-key'          => 'URL-Schlüssel',
        ],

        'create-success' => 'CMS erfolgreich erstellt.',
        'delete-success' => 'CMS erfolgreich gelöscht.',
        'no-resource'    => 'Ressource existiert nicht.',
        'update-success' => 'CMS erfolgreich aktualisiert.',
    ],

    'settings' => [
        'locales' => [
            'index' => [
                'create-btn' => 'Sprachversion erstellen',
                'locale'     => 'Sprachversion',
                'logo-size'  => 'Bildauflösung sollte wie 24px x 16px sein',
                'title'      => 'Sprachversionen',

                'datagrid' => [
                    'actions'   => 'Aktionen',
                    'code'      => 'Code',
                    'delete'    => 'Löschen',
                    'direction' => 'Richtung',
                    'edit'      => 'Bearbeiten',
                    'id'        => 'ID',
                    'ltr'       => 'LTR',
                    'name'      => 'Name',
                    'rtl'       => 'RTL',
                ],

                'create' => [
                    'code'             => 'Code',
                    'direction'        => 'Richtung',
                    'locale-logo'      => 'Sprachversionslogo',
                    'name'             => 'Name',
                    'save-btn'         => 'Sprachversion speichern',
                    'select-direction' => 'Richtung auswählen',
                    'title'            => 'Sprachversion erstellen',
                ],

                'edit' => [
                    'title' => 'Sprachversion bearbeiten',
                ],

                'create-success'    => 'Sprachversion erfolgreich erstellt.',
                'delete-failed'     => 'Löschen der Sprachversion fehlgeschlagen',
                'delete-success'    => 'Sprachversion erfolgreich gelöscht.',
                'delete-warning'    => 'Sind Sie sicher, dass Sie diese Aktion durchführen möchten?',
                'last-delete-error' => 'Mindestens eine Sprachversion ist erforderlich.',
                'update-success'    => 'Sprachversion erfolgreich aktualisiert.',
            ],
        ],

        'currencies' => [
            'index' => [
                'create-btn' => 'Währung erstellen',
                'currency'   => 'Währung',
                'title'      => 'Währungen',

                'datagrid' => [
                    'actions'        => 'Aktionen',
                    'code'           => 'Code',
                    'delete'         => 'Löschen',
                    'edit'           => 'Bearbeiten',
                    'id'             => 'ID',
                    'method-error'   => 'Fehler! Falsche Methode erkannt, bitte überprüfen Sie die Massenaktionskonfiguration',
                    'name'           => 'Name',
                    'no-resource'    => 'Die bereitgestellte Ressource ist nicht ausreichend für die Aktion',
                    'partial-action' => 'Einige Aktionen wurden aufgrund eingeschränkter Systemeinschränkungen für :resource nicht durchgeführt',
                    'update-success' => 'Ausgewählte :resource wurden erfolgreich aktualisiert',
                ],

                'create' => [
                    'code'                   => 'Code',
                    'create-btn'             => 'Währung erstellen',
                    'currency-position'      => 'Währungsposition',
                    'decimal'                => 'Dezimalstellen',
                    'decimal-separator'      => 'Dezimaltrennzeichen',
                    'decimal-separator-note' => 'Das :attribute-Feld kann nur die Operatoren Komma (,) und Punkt (.) akzeptieren',
                    'delete-warning'         => 'Sind Sie sicher, dass Sie diese Aktion durchführen möchten?',
                    'general'                => 'Allgemein',
                    'group-separator'        => 'Gruppentrennzeichen',
                    'group-separator-note'   => 'Das Feld :attribute darf nur die Zeichen Komma (,), Punkt (.), Apostroph (\') und Leerzeichen ( ) enthalten.',
                    'name'                   => 'Name',
                    'save-btn'               => 'Währung speichern',
                    'symbol'                 => 'Symbol',
                    'title'                  => 'Neue Währung erstellen',
                ],

                'edit' => [
                    'title' => 'Währung bearbeiten',
                ],

                'create-success'    => 'Währung erfolgreich erstellt.',
                'delete-failed'     => 'Löschen der Währung fehlgeschlagen',
                'delete-success'    => 'Währung erfolgreich gelöscht.',
                'last-delete-error' => 'Mindestens eine Währung ist erforderlich.',
                'update-success'    => 'Währung erfolgreich aktualisiert.',
            ],
        ],

        'data-transfer' => [
            'imports' => [
                'create' => [
                    'action'              => 'Aktion',
                    'allowed-errors'      => 'Zulässige Fehler',
                    'back-btn'            => 'Zurück',
                    'create-update'       => 'Erstellen/Aktualisieren',
                    'delete'              => 'Löschen',
                    'download-sample'     => 'Beispiel herunterladen',
                    'field-separator'     => 'Feldtrennzeichen',
                    'file'                => 'Datei',
                    'file-info'           => 'Verwenden Sie den relativen Pfad zu /project-root/storage/app/import, z. B. Produktbilder, Import-Bilder.',
                    'file-info-example'   => 'Beispiel: Bei Produktbildern sollten die Dateien im Ordner /project-root/storage/app/import/product-images platziert werden.',
                    'general'             => 'Allgemein',
                    'images-directory'    => 'Bilder-Verzeichnispfad',
                    'process-in-queue'    => 'In der Warteschlange verarbeiten',
                    'results'             => 'Ergebnisse',
                    'save-btn'            => 'Import speichern',
                    'settings'            => 'Einstellungen',
                    'skip-errors'         => 'Fehler überspringen',
                    'stop-on-errors'      => 'Bei Fehlern anhalten',
                    'title'               => 'Import erstellen',
                    'type'                => 'Typ',
                    'validation-strategy' => 'Validierungsstrategie',
                ],

                'edit' => [
                    'action'              => 'Aktion',
                    'allowed-errors'      => 'Zulässige Fehler',
                    'back-btn'            => 'Zurück',
                    'create-update'       => 'Erstellen/Aktualisieren',
                    'current-file'        => 'Aktuelle hochgeladene Datei',
                    'delete'              => 'Löschen',
                    'download-sample'     => 'Beispiel herunterladen',
                    'field-separator'     => 'Feldtrennzeichen',
                    'file'                => 'Datei',
                    'file-info'           => 'Verwenden Sie den relativen Pfad zu /project-root/storage/app/import, z. B. Produktbilder, Import-Bilder.',
                    'file-info-example'   => 'Beispiel: Bei Produktbildern sollten die Dateien im Ordner /project-root/storage/app/import/product-images platziert werden.',
                    'general'             => 'Allgemein',
                    'images-directory'    => 'Bilder-Verzeichnispfad',
                    'process-in-queue'    => 'In der Warteschlange verarbeiten',
                    'results'             => 'Ergebnisse',
                    'save-btn'            => 'Import speichern',
                    'settings'            => 'Einstellungen',
                    'skip-errors'         => 'Fehler überspringen',
                    'stop-on-errors'      => 'Bei Fehlern anhalten',
                    'title'               => 'Import bearbeiten',
                    'type'                => 'Typ',
                    'validation-strategy' => 'Validierungsstrategie',
                ],

                'index' => [
                    'button-title' => 'Import erstellen',
                    'title'        => 'Importe',

                    'datagrid' => [
                        'actions'       => 'Aktionen',
                        'completed-at'  => 'Abgeschlossen am',
                        'created'       => 'Erstellt',
                        'delete'        => 'Löschen',
                        'deleted'       => 'Gelöscht',
                        'edit'          => 'Bearbeiten',
                        'error-file'    => 'Fehlerhafte Datei',
                        'id'            => 'ID',
                        'started-at'    => 'Gestartet am',
                        'state'         => 'Status',
                        'summary'       => 'Zusammenfassung',
                        'updated'       => 'Aktualisiert',
                        'uploaded-file' => 'Hochgeladene Datei',
                    ],
                ],

                'import' => [
                    'back-btn'                => 'Zurück',
                    'completed-batches'       => 'Insgesamt abgeschlossene Chargen:',
                    'download-error-report'   => 'Vollständigen Bericht herunterladen',
                    'edit-btn'                => 'Bearbeiten',
                    'imported-info'           => 'Herzlichen Glückwunsch! Ihr Import war erfolgreich.',
                    'importing-info'          => 'Import läuft',
                    'indexing-info'           => 'Ressourcenindexierung (Preis, Inventar und Elastic Search) läuft',
                    'linking-info'            => 'Verknüpfung von Ressourcen läuft',
                    'progress'                => 'Fortschritt:',
                    'title'                   => 'Import',
                    'total-batches'           => 'Insgesamt Chargen:',
                    'total-created'           => 'Insgesamt erstellte Datensätze:',
                    'total-deleted'           => 'Insgesamt gelöschte Datensätze:',
                    'total-errors'            => 'Insgesamt Fehler:',
                    'total-invalid-rows'      => 'Insgesamt ungültige Zeilen:',
                    'total-rows-processed'    => 'Insgesamt verarbeitete Zeilen:',
                    'total-updated'           => 'Insgesamt aktualisierte Datensätze:',
                    'validate'                => 'Validieren',
                    'validate-info'           => 'Klicken Sie auf "Daten validieren", um Ihren Import zu überprüfen.',
                    'validating-info'         => 'Die Daten werden gelesen und validiert',
                    'validation-failed-info'  => 'Ihr Import ist ungültig. Bitte beheben Sie die folgenden Fehler und versuchen Sie es erneut.',
                    'validation-success-info' => 'Ihr Import ist gültig. Klicken Sie auf "Importieren", um den Importvorgang zu starten.',
                ],

                'create-success'    => 'Import erfolgreich erstellt.',
                'delete-failed'     => 'Löschen des Imports fehlgeschlagen.',
                'delete-success'    => 'Import erfolgreich gelöscht.',
                'not-valid'         => 'Import ist ungültig',
                'nothing-to-import' => 'Es gibt keine Ressourcen zum Importieren.',
                'setup-queue-error' => 'Bitte ändern Sie Ihren Warteschlangentreiber auf "Datenbank" oder "Redis", um den Importprozess zu starten.',
                'update-success'    => 'Import erfolgreich aktualisiert.',
            ],
        ],

        'exchange-rates' => [
            'index' => [
                'create-btn'    => 'Wechselkurs erstellen',
                'exchange-rate' => 'Wechselkurs',
                'title'         => 'Wechselkurse',
                'update-rates'  => 'Wechselkurs aktualisieren',

                'create' => [
                    'delete-warning'         => 'Sind Sie sicher, dass Sie diese Aktion durchführen möchten?',
                    'rate'                   => 'Kurs',
                    'save-btn'               => 'Wechselkurs speichern',
                    'select-target-currency' => 'Zielwährung auswählen',
                    'source-currency'        => 'Quellwährung',
                    'target-currency'        => 'Zielwährung',
                    'title'                  => 'Wechselkurs erstellen',
                ],

                'edit' => [
                    'title' => 'Wechselkurse bearbeiten',
                ],

                'datagrid' => [
                    'actions'       => 'Aktionen',
                    'currency-name' => 'Währungsname',
                    'delete'        => 'Löschen',
                    'edit'          => 'Bearbeiten',
                    'exchange-rate' => 'Wechselkurs',
                    'id'            => 'ID',
                ],

                'create-success' => 'Wechselkurs erfolgreich erstellt',
                'delete-error'   => 'Fehler beim Löschen des Wechselkurses',
                'delete-success' => 'Wechselkurs erfolgreich gelöscht',
                'update-success' => 'Wechselkurs erfolgreich aktualisiert',
            ],
        ],

        'inventory-sources' => [
            'index' => [
                'create-btn' => 'Inventarquelle erstellen',
                'title'      => 'Lagerorte',

                'datagrid' => [
                    'active'   => 'Aktiv',
                    'code'     => 'Code',
                    'delete'   => 'Löschen',
                    'edit'     => 'Bearbeiten',
                    'id'       => 'ID',
                    'inactive' => 'Inaktiv',
                    'name'     => 'Name',
                    'priority' => 'Priorität',
                    'status'   => 'Status',
                ],
            ],

            'create' => [
                'add-title'      => 'Lagerort hinzufügen',
                'address'        => 'Lagerortadresse',
                'back-btn'       => 'Zurück',
                'city'           => 'Stadt',
                'code'           => 'Code',
                'contact-email'  => 'E-Mail',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Kontaktinformationen',
                'contact-name'   => 'Name',
                'contact-number' => 'Kontakttelefon',
                'country'        => 'Land',
                'description'    => 'Beschreibung',
                'general'        => 'Allgemein',
                'latitude'       => 'Breitengrad',
                'longitude'      => 'Längengrad',
                'name'           => 'Name',
                'postcode'       => 'Postleitzahl',
                'priority'       => 'Priorität',
                'save-btn'       => 'Lagerorte speichern',
                'select-country' => 'Land auswählen',
                'select-state'   => 'Bundesland auswählen',
                'settings'       => 'Einstellungen',
                'state'          => 'Bundesland',
                'status'         => 'Status',
                'street'         => 'Straße',
                'title'          => 'Lagerorte',
            ],

            'edit' => [
                'back-btn'       => 'Zurück',
                'city'           => 'Stadt',
                'code'           => 'Code',
                'contact-email'  => 'E-Mail',
                'contact-fax'    => 'Fax',
                'contact-info'   => 'Kontaktinformationen',
                'contact-name'   => 'Name',
                'contact-number' => 'Kontakttelefon',
                'country'        => 'Land',
                'description'    => 'Beschreibung',
                'general'        => 'Allgemein',
                'latitude'       => 'Breitengrad',
                'longitude'      => 'Längengrad',
                'name'           => 'Name',
                'postcode'       => 'Postleitzahl',
                'priority'       => 'Priorität',
                'save-btn'       => 'Lagerorte speichern',
                'select-country' => 'Land auswählen',
                'select-state'   => 'Bundesland auswählen',
                'settings'       => 'Einstellungen',
                'source-address' => 'Lagerortadresse',
                'state'          => 'Bundesland',
                'status'         => 'Status',
                'street'         => 'Straße',
                'title'          => 'Lagerorte bearbeiten',
            ],

            'create-success'    => 'Lagerort erfolgreich erstellt',
            'delete-failed'     => 'Lagerorte löschen fehlgeschlagen',
            'delete-success'    => 'Lagerorte erfolgreich gelöscht',
            'last-delete-error' => 'Der letzte Lagerort kann nicht gelöscht werden',
            'update-success'    => 'Lagerorte erfolgreich aktualisiert',
        ],

        'taxes' => [
            'categories' => [
                'index' => [
                    'delete-warning' => 'Möchten Sie wirklich löschen?',
                    'tax-category'   => 'Steuerkategorie',
                    'title'          => 'Steuerkategorien',

                    'datagrid' => [
                        'actions' => 'Aktionen',
                        'code'    => 'Code',
                        'delete'  => 'Löschen',
                        'edit'    => 'Bearbeiten',
                        'id'      => 'ID',
                        'name'    => 'Name',
                    ],

                    'create' => [
                        'add-tax-rates' => 'Steuersätze hinzufügen',
                        'code'          => 'Code',
                        'description'   => 'Beschreibung',
                        'empty-text'    => 'Steuersätze sind nicht verfügbar. Bitte erstellen Sie neue Steuersätze.',
                        'general'       => 'Steuerkategorie',
                        'name'          => 'Name',
                        'save-btn'      => 'Steuerkategorie speichern',
                        'select'        => 'Auswählen',
                        'tax-rates'     => 'Steuersätze',
                        'title'         => 'Steuerkategorie erstellen',
                    ],

                    'edit' => [
                        'title'   => 'Steuerkategorien bearbeiten',
                    ],

                    'can-not-delete' => 'Steuersätze zugewiesene Kategorien können nicht gelöscht werden.',
                    'create-success' => 'Neue Steuerkategorie erstellt',
                    'delete-failed'  => 'Steuerkategorie löschen fehlgeschlagen',
                    'delete-success' => 'Steuerkategorie erfolgreich gelöscht',
                    'update-success' => 'Steuerkategorie erfolgreich aktualisiert',
                ],
            ],

            'rates' => [
                'index' => [
                    'button-title' => 'Steuerquote erstellen',
                    'tax-rate'     => 'Steuersatz',
                    'title'        => 'Steuersätze',

                    'datagrid' => [
                        'country'    => 'Land',
                        'delete'     => 'Löschen',
                        'edit'       => 'Bearbeiten',
                        'id'         => 'ID',
                        'identifier' => 'Bezeichner',
                        'state'      => 'Bundesland',
                        'tax-rate'   => 'Steuersatz',
                        'zip-code'   => 'Postleitzahl',
                        'zip-from'   => 'Postleitzahl Von',
                        'zip-to'     => 'Postleitzahl Bis',
                    ],
                ],

                'create' => [
                    'back-btn'       => 'Zurück',
                    'country'        => 'Land',
                    'general'        => 'Allgemein',
                    'identifier'     => 'Bezeichner',
                    'is-zip'         => 'PLZ-Bereich aktivieren',
                    'save-btn'       => 'Steuersatz speichern',
                    'select-country' => 'Land auswählen',
                    'select-state'   => 'Bundesland auswählen',
                    'settings'       => 'Einstellungen',
                    'state'          => 'Bundesland',
                    'tax-rate'       => 'Satz',
                    'title'          => 'Steuersatz erstellen',
                    'zip-code'       => 'Postleitzahl',
                    'zip-from'       => 'PLZ Von',
                    'zip-to'         => 'PLZ Bis',
                ],

                'edit' => [
                    'back-btn'       => 'Zurück',
                    'country'        => 'Land',
                    'identifier'     => 'Bezeichner',
                    'save-btn'       => 'Steuersatz speichern',
                    'select-country' => 'Land auswählen',
                    'select-state'   => 'Bundesland auswählen',
                    'settings'       => 'Einstellungen',
                    'state'          => 'Bundesland',
                    'tax-rate'       => 'Satz',
                    'title'          => 'Steuersatz bearbeiten',
                    'zip-code'       => 'Postleitzahl',
                    'zip-from'       => 'PLZ Von',
                    'zip-to'         => 'PLZ Bis',
                ],

                'create-success' => 'Steuersatz erfolgreich erstellt.',
                'delete-failed'  => 'Steuersatz konnte nicht gelöscht werden.',
                'delete-success' => 'Steuersatz erfolgreich gelöscht.',
                'update-success' => 'Steuersatz erfolgreich aktualisiert.',
            ],
        ],

        'channels' => [
            'index' => [
                'create-btn'        => 'Kanal erstellen',
                'delete-failed'     => 'Kanal konnte nicht gelöscht werden',
                'delete-success'    => 'Kanal erfolgreich gelöscht.',
                'last-delete-error' => 'Der letzte Kanal konnte nicht gelöscht werden.',
                'title'             => 'Kanäle',

                'datagrid' => [
                    'code'      => 'Code',
                    'delete'    => 'Löschen',
                    'edit'      => 'Bearbeiten',
                    'host-name' => 'Host-Name',
                    'id'        => 'ID',
                    'name'      => 'Name',
                ],
            ],

            'create' => [
                'allowed-ips'             => 'Erlaubte IPs',
                'cancel'                  => 'Zurück',
                'code'                    => 'Code',
                'create-success'          => 'Kanal erfolgreich erstellt.',
                'currencies'              => 'Währungen',
                'currencies-and-locales'  => 'Währungen und Lokalisierungen',
                'default-currency'        => 'Standard-Währung',
                'default-locale'          => 'Standard-Lokalisierung',
                'description'             => 'Beschreibung',
                'design'                  => 'Design',
                'favicon'                 => 'Favicon',
                'favicon-size'            => 'Bildauflösung sollte wie 16px X 16px sein',
                'general'                 => 'Allgemein',
                'hostname'                => 'Hostname',
                'hostname-placeholder'    => 'https://www.example.com (Fügen Sie am Ende keinen Schrägstrich hinzu.)',
                'inventory-sources'       => 'Lagerquellen',
                'last-delete-error'       => 'Mindestens ein Kanal ist erforderlich.',
                'locales'                 => 'Lokalisierungen',
                'logo'                    => 'Logo',
                'logo-size'               => 'Bildauflösung sollte wie 192px X 50px sein',
                'maintenance-mode-text'   => 'Nachricht',
                'name'                    => 'Name',
                'root-category'           => 'Stammkategorie',
                'save-btn'                => 'Kanal speichern',
                'select-default-currency' => 'Standard-Währung auswählen',
                'select-default-locale'   => 'Standard-Sprache auswählen',
                'select-root-category'    => 'Wurzelkategorie auswählen',
                'select-theme'            => 'Thema auswählen',
                'seo'                     => 'SEO der Startseite',
                'seo-description'         => 'Meta-Beschreibung',
                'seo-keywords'            => 'Meta-Schlüsselwörter',
                'seo-title'               => 'Meta-Titel',
                'settings'                => 'Einstellungen',
                'status'                  => 'Status',
                'theme'                   => 'Thema',
                'title'                   => 'Kanal erstellen',
            ],

            'edit' => [
                'allowed-ips'            => 'Erlaubte IPs',
                'back-btn'               => 'Zurück',
                'code'                   => 'Code',
                'currencies'             => 'Währungen',
                'currencies-and-locales' => 'Währungen und Lokalisierungen',
                'default-currency'       => 'Standard-Währung',
                'default-locale'         => 'Standard-Lokalisierung',
                'description'            => 'Beschreibung',
                'design'                 => 'Design',
                'favicon'                => 'Favicon',
                'favicon-size'           => 'Bildauflösung sollte wie 16px X 16px sein',
                'general'                => 'Allgemein',
                'hostname'               => 'Hostname',
                'hostname-placeholder'   => 'https://www.example.com (Fügen Sie am Ende keinen Schrägstrich hinzu.)',
                'inventory-sources'      => 'Lagerquellen',
                'last-delete-error'      => 'Mindestens ein Kanal ist erforderlich.',
                'locales'                => 'Lokalisierungen',
                'logo'                   => 'Logo',
                'logo-size'              => 'Bildauflösung sollte wie 192px X 50px sein',
                'maintenance-mode'       => 'Wartungsmodus',
                'maintenance-mode-text'  => 'Nachricht',
                'name'                   => 'Name',
                'root-category'          => 'Stammkategorie',
                'save-btn'               => 'Kanal speichern',
                'seo'                    => 'SEO der Startseite',
                'seo-description'        => 'Meta-Beschreibung',
                'seo-keywords'           => 'Meta-Schlüsselwörter',
                'seo-title'              => 'Meta-Titel',
                'status'                 => 'Status',
                'theme'                  => 'Thema',
                'title'                  => 'Kanal bearbeiten',
                'update-success'         => 'Aktualisierung erfolgreich',
            ],
        ],

        'users' => [
            'index' => [
                'admin' => 'Administrator',
                'title' => 'Benutzer',
                'user'  => 'Benutzer',

                'create' => [
                    'confirm-password'  => 'Passwort bestätigen',
                    'email'             => 'E-Mail',
                    'name'              => 'Name',
                    'password'          => 'Passwort',
                    'role'              => 'Rolle',
                    'save-btn'          => 'Benutzer speichern',
                    'status'            => 'Status',
                    'title'             => 'Benutzer erstellen',
                    'upload-image-info' => 'Laden Sie ein Profilbild (110px X 110px) im PNG- oder JPG-Format hoch',
                ],

                'datagrid' => [
                    'actions'  => 'Aktionen',
                    'active'   => 'Aktiv',
                    'delete'   => 'Löschen',
                    'edit'     => 'Bearbeiten',
                    'email'    => 'E-Mail',
                    'id'       => 'ID',
                    'inactive' => 'Inaktiv',
                    'name'     => 'Name',
                    'role'     => 'Rolle',
                    'status'   => 'Status',
                ],

                'edit' => [
                    'title' => 'Benutzer bearbeiten',
                ],
            ],

            'edit' => [
                'back-btn'         => 'Zurück',
                'confirm-password' => 'Passwort bestätigen',
                'email'            => 'E-Mail',
                'general'          => 'Allgemein',
                'name'             => 'Name',
                'password'         => 'Passwort',
                'role'             => 'Rolle',
                'save-btn'         => 'Benutzer speichern',
                'status'           => 'Status',
                'title'            => 'Benutzer bearbeiten',
            ],

            'activate-warning'   => 'Ihr Konto wurde noch nicht aktiviert. Bitte kontaktieren Sie den Administrator.',
            'cannot-change'      => 'Benutzer kann nicht geändert werden.',
            'create-success'     => 'Benutzer erfolgreich erstellt.',
            'delete-failed'      => 'Benutzerlöschung fehlgeschlagen.',
            'delete-self-error'  => 'Sie können Ihr eigenes Konto nicht löschen.',
            'delete-success'     => 'Benutzer erfolgreich gelöscht.',
            'delete-warning'     => 'Sind Sie sicher, dass Sie diese Aktion ausführen möchten?',
            'incorrect-password' => 'Falsches Passwort',
            'last-delete-error'  => 'Letzte Benutzerlöschung fehlgeschlagen.',
            'login-error'        => 'Bitte überprüfen Sie Ihre Anmeldeinformationen und versuchen Sie es erneut.',
            'update-success'     => 'Benutzer erfolgreich aktualisiert.',
        ],

        'roles' => [
            'index' => [
                'create-btn' => 'Rolle erstellen',
                'title'      => 'Rollen',

                'datagrid' => [
                    'all'             => 'Alle',
                    'custom'          => 'Benutzerdefiniert',
                    'delete'          => 'Löschen',
                    'edit'            => 'Bearbeiten',
                    'id'              => 'ID',
                    'name'            => 'Name',
                    'permission-type' => 'Berechtigungstyp',
                ],
            ],

            'create' => [
                'access-control' => 'Zugangskontrolle',
                'all'            => 'Alle',
                'back-btn'       => 'Zurück',
                'custom'         => 'Benutzerdefiniert',
                'description'    => 'Beschreibung',
                'general'        => 'Allgemein',
                'name'           => 'Name',
                'permissions'    => 'Berechtigungen',
                'save-btn'       => 'Rolle speichern',
                'title'          => 'Rolle erstellen',
            ],

            'edit' => [
                'access-control' => 'Zugangskontrolle',
                'all'            => 'Alle',
                'back-btn'       => 'Zurück',
                'custom'         => 'Benutzerdefiniert',
                'description'    => 'Beschreibung',
                'general'        => 'Allgemein',
                'name'           => 'Name',
                'permissions'    => 'Berechtigungen',
                'save-btn'       => 'Rolle speichern',
                'title'          => 'Rolle bearbeiten',
            ],

            'being-used'        => 'Rolle wird bereits von einem Administrator verwendet',
            'create-success'    => 'Rolle erfolgreich erstellt',
            'delete-failed'     => 'Löschen der Rolle fehlgeschlagen',
            'delete-success'    => 'Rolle erfolgreich gelöscht',
            'last-delete-error' => 'Letzte Rolle kann nicht gelöscht werden',
            'update-success'    => 'Rolle erfolgreich aktualisiert',
        ],

        'themes' => [
            'index' => [
                'create-btn' => 'Thema erstellen',
                'title'      => 'Themen',

                'datagrid' => [
                    'active'        => 'Aktiv',
                    'channel_name'  => 'Kanalname',
                    'change-status' => 'Status ändern',
                    'delete'        => 'Löschen',
                    'id'            => 'ID',
                    'inactive'      => 'Inaktiv',
                    'name'          => 'Name',
                    'sort-order'    => 'Sortierreihenfolge',
                    'status'        => 'Status',
                    'theme'         => 'Thema',
                    'type'          => 'Typ',
                    'view'          => 'Ansehen',
                ],
            ],

            'create' => [
                'name'       => 'Name',
                'save-btn'   => 'Thema speichern',
                'sort-order' => 'Sortierreihenfolge',
                'themes'     => 'Themen',
                'title'      => 'Thema erstellen',

                'type' => [
                    'category-carousel' => 'Kategorie Karussell',
                    'footer-links'      => 'Fußzeilen-Links',
                    'image-carousel'    => 'Bildkarussell',
                    'product-carousel'  => 'Produkt Karussell',
                    'services-content'  => 'Inhalt der Dienste',
                    'static-content'    => 'Statischer Inhalt',
                    'title'             => 'Typ',
                ],
            ],

            'edit' => [
                'active'                        => 'Aktiv',
                'add-filter-btn'                => 'Filter hinzufügen',
                'add-footer-link-btn'           => 'Fußzeilen-Link hinzufügen',
                'add-image-btn'                 => 'Bild hinzufügen',
                'add-link'                      => 'Link hinzufügen',
                'asc'                           => 'aufsteigend',
                'back'                          => 'Zurück',
                'category-carousel'             => 'Kategorie Karussell',
                'category-carousel-description' => 'Dynamische Kategorien attraktiv mit einem responsiven Kategorie-Karussell anzeigen.',
                'channels'                      => 'Kanäle',
                'column'                        => 'Spalte',
                'create-filter'                 => 'Filter erstellen',
                'css'                           => 'CSS',
                'delete'                        => 'Löschen',
                'desc'                          => 'absteigend',
                'edit'                          => 'Bearbeiten',
                'featured'                      => 'Hervorgehoben',
                'filter-title'                  => 'Titel',
                'filters'                       => 'Filter',
                'footer-link'                   => 'Fußzeilen-Links',
                'footer-link-description'       => 'Durch Fußzeilen-Links nahtlos durch die Website navigieren und Informationen erhalten.',
                'footer-link-form-title'        => 'Fußzeilen-Link',
                'footer-title'                  => 'Titel',
                'general'                       => 'Allgemein',
                'html'                          => 'HTML',
                'image'                         => 'Bild',
                'image-size'                    => 'Die Bildauflösung sollte (1920px X 700px) sein',
                'image-title'                   => 'Bildtitel',
                'image-upload-message'          => 'Nur Bilder (.jpeg, .jpg, .png, .webp, ..) sind erlaubt.',
                'inactive'                      => 'Inaktiv',
                'key'                           => 'Schlüssel: :key',
                'key-input'                     => 'Schlüssel',
                'limit'                         => 'Limit',
                'link'                          => 'Link',
                'name'                          => 'Name',
                'new'                           => 'Neu',
                'no'                            => 'Nein',
                'parent-id'                     => 'Eltern-ID',
                'parent-id-hint'                => 'Sie können mehrere Eltern-IDs als durch Kommas getrennte Werte eingeben (z.B.: 12,15,34)',
                'category-id'                   => 'Kategorien-ID',
                'preview'                       => 'Vorschau',
                'product-carousel'              => 'Produkt Karussell',
                'product-carousel-description'  => 'Produkte mit einem dynamischen und responsiven Produkt Karussell elegant präsentieren.',
                'save-btn'                      => 'Speichern',
                'select'                        => 'Auswählen',
                'slider'                        => 'Slider',
                'slider-add-btn'                => 'Slider hinzufügen',
                'slider-description'            => 'Themenanpassung im Zusammenhang mit dem Slider.',
                'slider-image'                  => 'Slider-Bild',
                'slider-required'               => 'Slider-Feld ist erforderlich.',
                'sort'                          => 'Sortieren',
                'sort-order'                    => 'Sortierreihenfolge',
                'static-content'                => 'Statischer Inhalt',
                'static-content-description'    => 'Verbessern Sie die Interaktion mit prägnantem, informativem statischem Inhalt für Ihr Publikum.',
                'status'                        => 'Status',
                'themes'                        => 'Themen',
                'title'                         => 'Thema bearbeiten',
                'update-slider'                 => 'Slider aktualisieren',
                'url'                           => 'URL',
                'value'                         => 'Wert: :value',
                'value-input'                   => 'Wert',

                'services-content' => [
                    'add-btn'            => 'Dienstleistungen hinzufügen',
                    'channels'           => 'Kanäle',
                    'delete'             => 'Löschen',
                    'description'        => 'Beschreibung',
                    'general'            => 'Allgemein',
                    'name'               => 'Name',
                    'save-btn'           => 'Speichern',
                    'service-icon'       => 'Service-Icon',
                    'service-icon-class' => 'Service-Icon-Klasse',
                    'service-info'       => 'Themenbezogene Anpassung von Diensten.',
                    'services'           => 'Dienstleistungen',
                    'sort-order'         => 'Sortierreihenfolge',
                    'status'             => 'Status',
                    'title'              => 'Titel',
                    'update-service'     => 'Dienstleistungen aktualisieren',
                ],
                'yes'                           => 'Ja',
            ],

            'create-success' => 'Thema erfolgreich erstellt',
            'delete-success' => 'Thema erfolgreich gelöscht',
            'update-success' => 'Thema erfolgreich aktualisiert',
        ],
    ],

    'reporting' => [
        'sales' => [
            'index' => [
                'abandoned-carts'               => 'Verlassene Warenkörbe',
                'abandoned-products'            => 'Verlassene Produkte',
                'abandoned-rate'                => 'Abbruchrate',
                'abandoned-revenue'             => 'Abgebrochene Einnahmen',
                'added-to-cart'                 => 'Zum Warenkorb hinzugefügt',
                'added-to-cart-info'            => 'Nur :progress Besucher haben Produkte zum Warenkorb hinzugefügt',
                'all-channels'                  => 'Alle Kanäle',
                'average-order-value-over-time' => 'Durchschnittlicher Bestellwert im Laufe der Zeit',
                'average-sales'                 => 'Durchschnittlicher Bestellwert',
                'count'                         => 'Anzahl',
                'end-date'                      => 'Enddatum',
                'id'                            => 'ID',
                'interval'                      => 'Intervall',
                'name'                          => 'Name',
                'orders'                        => 'Bestellungen',
                'orders-over-time'              => 'Bestellungen im Laufe der Zeit',
                'payment-method'                => 'Zahlungsmethode',
                'product-views'                 => 'Produktansichten',
                'product-views-info'            => 'Nur :progress Besucher betrachten Produkte',
                'purchase-funnel'               => 'Kauftrichter',
                'purchased'                     => 'Gekauft',
                'purchased-info'                => 'Nur :progress Besucher tätigen den Kauf',
                'refunds'                       => 'Rückerstattungen',
                'refunds-over-time'             => 'Rückerstattungen im Laufe der Zeit',
                'sales-over-time'               => 'Umsatz im Laufe der Zeit',
                'shipping-collected'            => 'Versandkosten gesammelt',
                'shipping-collected-over-time'  => 'Versandkosten im Laufe der Zeit gesammelt',
                'start-date'                    => 'Startdatum',
                'tax-collected'                 => 'Steuern gesammelt',
                'tax-collected-over-time'       => 'Steuern im Laufe der Zeit gesammelt',
                'title'                         => 'Verkäufe',
                'top-payment-methods'           => 'Top-Zahlungsmethoden',
                'top-shipping-methods'          => 'Top-Versandmethoden',
                'top-tax-categories'            => 'Top-Steuerkategorien',
                'total'                         => 'Gesamt',
                'total-orders'                  => 'Gesamtbestellungen',
                'total-sales'                   => 'Gesamtumsatz',
                'total-visits'                  => 'Gesamtbesuche',
                'total-visits-info'             => 'Gesamtbesucher im Geschäft',
                'view-details'                  => 'Details anzeigen',
            ],
        ],

        'customers' => [
            'index' => [
                'all-channels'                => 'Alle Kanäle',
                'count'                       => 'Anzahl',
                'customers'                   => 'Kunden',
                'customers-over-time'         => 'Kunden im Laufe der Zeit',
                'customers-traffic'           => 'Kundentraffic',
                'customers-with-most-orders'  => 'Kunden mit den meisten Bestellungen',
                'customers-with-most-reviews' => 'Kunden mit den meisten Bewertungen',
                'customers-with-most-sales'   => 'Kunden mit den meisten Verkäufen',
                'email'                       => 'E-Mail',
                'end-date'                    => 'Enddatum',
                'id'                          => 'ID',
                'interval'                    => 'Intervall',
                'name'                        => 'Name',
                'orders'                      => 'Bestellungen',
                'reviews'                     => 'Bewertungen',
                'start-date'                  => 'Startdatum',
                'title'                       => 'Kunden',
                'top-customer-groups'         => 'Top-Kundengruppen',
                'total'                       => 'Gesamt',
                'total-customers'             => 'Gesamtkunden',
                'total-visitors'              => 'Gesamtbesucher',
                'traffic-over-week'           => 'Traffic über die Woche',
                'unique-visitors'             => 'Eindeutige Besucher',
                'view-details'                => 'Details anzeigen',
            ],
        ],

        'products' => [
            'index' => [
                'all-channels'                     => 'Alle Kanäle',
                'channel'                          => 'Kanal',
                'end-date'                         => 'Enddatum',
                'id'                               => 'ID',
                'interval'                         => 'Intervall',
                'last-search-terms'                => 'Zuletzt gesuchte Begriffe',
                'locale'                           => 'Standort',
                'name'                             => 'Name',
                'orders'                           => 'Bestellungen',
                'price'                            => 'Preis',
                'products-added-over-time'         => 'Produkte im Laufe der Zeit hinzugefügt',
                'products-with-most-reviews'       => 'Produkte mit den meisten Bewertungen',
                'products-with-most-visits'        => 'Produkte mit den meisten Besuchen',
                'quantities'                       => 'Mengen',
                'quantities-sold-over-time'        => 'Mengen im Laufe der Zeit verkauft',
                'results'                          => 'Ergebnisse',
                'revenue'                          => 'Einnahmen',
                'reviews'                          => 'Bewertungen',
                'search-term'                      => 'Suchbegriff',
                'start-date'                       => 'Startdatum',
                'title'                            => 'Produkte',
                'top-search-terms'                 => 'Top-Suchbegriffe',
                'top-selling-products-by-quantity' => 'Top-Verkaufsprodukte nach Menge',
                'top-selling-products-by-revenue'  => 'Top-Verkaufsprodukte nach Einnahmen',
                'total'                            => 'Gesamt',
                'total-products-added-to-wishlist' => 'Produkte zur Wunschliste hinzugefügt',
                'total-sold-quantities'            => 'Verkaufte Produktmenge',
                'uses'                             => 'Verwendungen',
                'view-details'                     => 'Details anzeigen',
                'visits'                           => 'Besuche',
            ],
        ],

        'view' => [
            'all-channels'  => 'Alle Kanäle',
            'back-btn'      => 'Zurück',
            'day'           => 'Tag',
            'end-date'      => 'Enddatum',
            'export-csv'    => 'CSV exportieren',
            'export-xls'    => 'XLS exportieren',
            'month'         => 'Monat',
            'not-available' => 'Keine Datensätze verfügbar.',
            'start-date'    => 'Startdatum',
            'year'          => 'Jahr',
        ],

        'empty' => [
            'info'  => 'Keine Daten für den ausgewählten Zeitraum verfügbar',
            'title' => 'Keine Daten verfügbar',
        ],
    ],

    'configuration' => [
        'index' => [
            'back-btn'                     => 'Zurück',
            'delete'                       => 'Löschen',
            'enable-at-least-one-payment'  => 'Aktivieren Sie mindestens eine Zahlungsmethode.',
            'enable-at-least-one-shipping' => 'Aktivieren Sie mindestens eine Versandmethode.',
            'no-result-found'              => 'Kein Ergebnis gefunden',
            'save-btn'                     => 'Konfiguration speichern',
            'save-message'                 => 'Konfiguration erfolgreich gespeichert',
            'search'                       => 'Suche',
            'select-country'               => 'Land auswählen',
            'select-state'                 => 'Bundesland auswählen',
            'title'                        => 'Konfiguration',

            'general' => [
                'info'  => 'Einheitsoptionen festlegen.',
                'title' => 'Allgemein',

                'general' => [
                    'info'  => 'Konfigurieren Sie die Einheitseinstellungen und aktivieren oder deaktivieren Sie die Optionen für Breadcrumbs und Besucher.',
                    'title' => 'Allgemein',

                    'unit-options' => [
                        'info'        => 'Einheitsoptionen festlegen.',
                        'title'       => 'Einheitsoptionen',
                        'title-info'  => 'Konfigurieren Sie das Gewicht in Pfund (lbs) oder Kilogramm (kg).',
                        'weight-unit' => 'Gewichtseinheit',
                    ],

                    'breadcrumbs' => [
                        'shop'       => 'Shop-Breadcrumbs',
                        'title'      => 'Breadcrumbs',
                        'title-info' => 'Aktivieren oder deaktivieren Sie die Breadcrumbs-Navigation im Shop.',
                    ],

                    'visitor-options' => [
                        'enable'     => 'Besucheroptionen aktivieren',
                        'title'      => 'Besucheroptionen',
                        'title-info' => 'Ermöglicht die Kontrolle über die Website, um die Anzahl der Besuche zu verfolgen und zu zählen, was hilft, die allgemeine Besucheraktivität und das Engagement zu überwachen.',
                    ],
                ],

                'content' => [
                    'info'  => 'Legen Sie den Titel des Header-Angebots und benutzerdefinierte Skripte fest.',
                    'title' => 'Inhalt',

                    'header-offer' => [
                        'title'             => 'Titel des Header-Angebots',
                        'title-info'        => 'Konfigurieren Sie den Titel des Header-Angebots mit Titel des Angebots, Umleitungstitel und Umleitungslink.',
                        'offer-title'       => 'Angebotstitel',
                        'redirection-title' => 'Umleitungstitel',
                        'redirection-link'  => 'Umleitungslink',
                    ],

                    'speculation-rules' => [
                        'enable-speculation' => 'Spekulationsregeln aktivieren',
                        'info'               => 'Konfigurieren Sie die Einstellungen zum Aktivieren oder Deaktivieren der automatischen Spekulationslogik.',
                        'title'              => 'Spekulationsregeln',

                        'prerender' => [
                            'conservative'           => 'Konservativ',
                            'eager'                  => 'Eifrig',
                            'eagerness'              => 'Prerender-Eifer-Stufe',
                            'eagerness-info'         => 'Steuert, wie aggressiv die Spekulationsregeln angewendet werden. Optionen: eifrig (maximal), moderat (Standard), konservativ (niedrig).',
                            'enabled'                => 'Prerender-Spekulationsregeln aktivieren',
                            'ignore-url-params'      => 'Prerender-URL-Parameter ignorieren',
                            'ignore-url-params-info' => 'Geben Sie URL-Parameter an, die in den Spekulationsregeln ignoriert werden sollen. Verwenden Sie ein Pipe-Zeichen (|) zur Trennung mehrerer Parameter.',
                            'ignore-urls'            => 'Prerender-URLs ignorieren',
                            'ignore-urls-info'       => 'Geben Sie URLs an, die von der Spekulationslogik ausgeschlossen werden sollen. Trennen Sie mehrere URLs mit einem Pipe-Zeichen (|).',
                            'info'                   => 'Legen Sie den Status der Spekulationsregeln fest.',
                            'moderate'               => 'Moderat',
                        ],

                        'prefetch' => [
                            'conservative'           => 'Konservativ',
                            'eager'                  => 'Eifrig',
                            'eagerness'              => 'Prefetch-Eifer-Stufe',
                            'eagerness-info'         => 'Steuert, wie aggressiv die Spekulationsregeln angewendet werden. Optionen: eifrig (maximal), moderat (Standard), konservativ (niedrig).',
                            'enabled'                => 'Prefetch-Spekulationsregeln aktivieren',
                            'ignore-url-params'      => 'Prefetch-URL-Parameter ignorieren',
                            'ignore-url-params-info' => 'Geben Sie URL-Parameter an, die in den Spekulationsregeln ignoriert werden sollen. Verwenden Sie ein Pipe-Zeichen (|) zur Trennung mehrerer Parameter.',
                            'ignore-urls'            => 'Prefetch-URLs ignorieren',
                            'ignore-urls-info'       => 'Geben Sie URLs an, die von der Spekulationslogik ausgeschlossen werden sollen. Trennen Sie mehrere URLs mit einem Pipe-Zeichen (|).',
                            'info'                   => 'Legen Sie den Status der Spekulationsregeln fest.',
                            'moderate'               => 'Moderat',
                        ],
                    ],

                    'custom-scripts' => [
                        'custom-css'        => 'Benutzerdefiniertes CSS',
                        'custom-javascript' => 'Benutzerdefiniertes JavaScript',
                        'title'             => 'Benutzerdefinierte Skripte',
                        'title-info'        => 'Benutzerdefinierte Skripte sind personalisierte Codefragmente, die erstellt wurden, um bestimmte Funktionen oder Features zur Software hinzuzufügen und ihre Fähigkeiten einzigartig zu verbessern.',
                    ],
                ],

                'design' => [
                    'info'  => 'Legen Sie das Logo und das Favicon-Symbol für das Admin-Panel fest.',
                    'title' => 'Design',

                    'admin-logo' => [
                        'favicon'    => 'Favicon',
                        'logo-image' => 'Logo-Bild',
                        'title'      => 'Admin-Logo',
                        'title-info' => 'Konfigurieren Sie das Logo und das Favicon-Bild für das Frontend Ihrer Website für eine bessere Markenbildung und Wiedererkennung.',
                    ],

                    'menu-category' => [
                        'default'         => 'Standardmenü',
                        'info'            => 'Diese Einstellung steuert die Sichtbarkeit der Kategorien im Kopfmenü. Sie können wählen, ob nur übergeordnete Kategorien oder alle verschachtelten Kategorien angezeigt werden sollen.',
                        'preview-default' => 'Standardmenü-Vorschau',
                        'preview-sidebar' => 'Seitenleistenmenü-Vorschau',
                        'sidebar'         => 'Seitenleistenmenü',
                        'title'           => 'Menükategorie-Ansicht',
                    ],
                ],

                'magic-ai' => [
                    'info'  => 'Legen Sie Magic AI-Optionen fest und erlauben Sie einige Optionen, um die Erstellung von Inhalten zu automatisieren.',
                    'title' => 'Magic AI',

                    'settings' => [
                        'api-key'        => 'API-Schlüssel',
                        'enabled'        => 'Aktiviert',
                        'llm-api-domain' => 'LLM API-Domain',
                        'organization'   => 'Organisation',
                        'title'          => 'Allgemeine Einstellungen',
                        'title-info'     => 'Verbessern Sie Ihre Erfahrung mit der Magic AI-Funktion, indem Sie Ihren exklusiven API-Schlüssel eingeben und die entsprechende Organisation für eine mühelose Integration angeben. Übernehmen Sie die Kontrolle über Ihre OpenAI-Anmeldeinformationen und passen Sie die Einstellungen an Ihre spezifischen Bedürfnisse an.',
                    ],

                    'content-generation' => [
                        'category-description-prompt'      => 'Kategoriebeschreibungsaufforderung',
                        'cms-page-content-prompt'          => 'CMS-Seiteninhalt-Aufforderung',
                        'enabled'                          => 'Aktiviert',
                        'product-description-prompt'       => 'Produktbeschreibungsaufforderung',
                        'product-short-description-prompt' => 'Kurze Produktbeschreibungsaufforderung',
                        'title'                            => 'Inhaltsgenerierung',
                        'title-info'                       => 'Diese Funktion aktiviert die Magic AI für jeden WYSIWYG-Editor, in dem Sie Inhalte mithilfe von KI verwalten möchten.<br/><br/>Wenn Sie aktiviert ist, gehen Sie zu einem beliebigen Editor, um Inhalte zu generieren.',
                    ],

                    'image-generation' => [
                        'enabled'    => 'Aktiviert',
                        'title'      => 'Bildgenerierung',
                        'title-info' => 'Diese Funktion aktiviert die Magic AI für jeden Bild-Upload, bei dem Sie Bilder mithilfe von DALL-E generieren möchten.<br/><br/>Wenn Sie aktiviert ist, gehen Sie zu einem beliebigen Bild-Upload, um ein Bild zu generieren.',
                    ],

                    'review-translation' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Aktiviert',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt-4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Modell',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Bewertungsübersetzung',
                        'title-info'          => 'Bieten Sie Kunden oder Besuchern die Möglichkeit, Kundenbewertungen ins Englische zu übersetzen.<br/><br/>Wenn aktiviert, gehen Sie zur Bewertung und Sie finden die Schaltfläche „Ins Englische übersetzen“, wenn Sie eine andere Sprache als Englisch bewerten.',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],

                    'checkout-message' => [
                        'deepseek-r1-8b'      => 'DeepSeek R1 (8b)',
                        'enabled'             => 'Aktiviert',
                        'gemini-2-0-flash'    => 'Gemini 2.0 Flash',
                        'gpt-4-turbo'         => 'OpenAI gpt 4 Turbo',
                        'gpt-4o'              => 'OpenAI gpt-4o',
                        'gpt-4o-mini'         => 'OpenAI gpt-4o mini',
                        'llama-groq'          => 'Llama 3.3 (Groq)',
                        'llama3-1-8b'         => 'Llama 3.1 (8B)',
                        'llama3-2-1b'         => 'Llama 3.2 (1B)',
                        'llama3-2-3b'         => 'Llama 3.2 (3B)',
                        'llama3-8b'           => 'Llama 3 (8B)',
                        'llava-7b'            => 'Llava (7b)',
                        'mistral-7b'          => 'Mistral (7b)',
                        'model'               => 'Modell',
                        'orca-mini'           => 'Orca Mini',
                        'phi3-5'              => 'Phi 3.5',
                        'prompt'              => 'Aufforderung',
                        'qwen2-5-0-5b'        => 'Qwen 2.5 (0.5b)',
                        'qwen2-5-1-5b'        => 'Qwen 2.5 (1.5b)',
                        'qwen2-5-14b'         => 'Qwen 2.5 (14b)',
                        'qwen2-5-3b'          => 'Qwen 2.5 (3b)',
                        'qwen2-5-7b'          => 'Qwen 2.5 (7b)',
                        'starling-lm-7b'      => 'Starling-lm (7b)',
                        'title'               => 'Personalisierte Checkout-Nachricht',
                        'title-info'          => 'Erstellen Sie eine personalisierte Checkout-Nachricht für Kunden auf der Danke-Seite, die den Inhalt an individuelle Vorlieben anpasst und das gesamte Einkaufserlebnis nach dem Kauf verbessert.',
                        'vicuna'              => 'Vicuna',
                        'vicuna-13b'          => 'Vicuna (13b)',
                        'vicuna-7b'           => 'Vicuna (7b)',
                    ],
                ],

                'gdpr' => [
                    'title' => 'DSGVO',
                    'info'  => 'DSGVO-Konformitätseinstellungen',

                    'settings' => [
                        'title'   => 'DSGVO-Konformitätseinstellungen',
                        'info'    => 'Verwalten Sie die DSGVO-Konformitätseinstellungen, einschließlich der Datenschutzvereinbarung. Aktivieren oder deaktivieren Sie die DSGVO-Funktionen nach Bedarf.',
                        'enabled' => 'DSGVO aktivieren',
                    ],

                    'agreement' => [
                        'title'          => 'DSGVO-Vereinbarung',
                        'info'           => 'Verwalten Sie die Zustimmung der Kunden gemäß den DSGVO-Vorschriften. Aktivieren Sie die Zustimmungspflicht für die Datenerfassung und -verarbeitung.',
                        'enable'         => 'Kundenzustimmung aktivieren',
                        'checkbox-label' => 'Checkbox-Beschriftung für die Zustimmung',
                        'content'        => 'Inhalt der Zustimmung',
                    ],

                    'cookie' => [
                        'bottom-left'  => 'Unten links',
                        'bottom-right' => 'Unten rechts',
                        'center'       => 'Mitte',
                        'description'  => 'Beschreibung',
                        'enable'       => 'Cookie-Benachrichtigung aktivieren',
                        'identifier'   => 'Statischer Block-Identifier',
                        'info'         => 'Konfigurieren Sie die Cookie-Zustimmungseinstellungen, um Benutzer über die Datenerfassung zu informieren und die Datenschutzbestimmungen einzuhalten.',
                        'position'     => 'Anzeigeposition des Cookie-Blocks',
                        'title'        => 'Cookie-Benachrichtigungseinstellungen',
                        'top-left'     => 'Oben links',
                        'top-right'    => 'Oben rechts',
                    ],

                    'cookie-consent' => [
                        'title'                  => 'Verwalten Sie Ihre Cookie-Einstellungen',
                        'info'                   => 'Kontrollieren Sie, wie Ihre Daten verwendet werden, indem Sie die bevorzugten Cookie-Einstellungen auswählen. Passen Sie die Berechtigungen für verschiedene Arten von Cookies an.',
                        'strictly-necessary'     => 'Unbedingt erforderlich',
                        'basic-interaction'      => 'Grundlegende Interaktion und Funktionalität',
                        'experience-enhancement' => 'Erlebnisverbesserung',
                        'measurement'            => 'Messung',
                        'targeting-advertising'  => 'Targeting und Werbung',
                    ],
                ],

                'sitemap' => [
                    'info'  => 'Sitemap-Optionen festlegen.',
                    'title' => 'Sitemap',

                    'settings' => [
                        'enabled' => 'Aktiviert',
                        'info'    => 'Aktivieren oder deaktivieren Sie die Sitemap für Ihre Website, um die Suchmaschinenoptimierung zu verbessern und die Benutzererfahrung zu steigern.',
                        'title'   => 'Einstellungen',
                    ],

                    'file-limits' => [
                        'info'             => 'Dateigrößenbeschränkungen festlegen.',
                        'max-file-size'    => 'Maximale Dateigröße',
                        'max-url-per-file' => 'Maximale Anzahl von URLs pro Datei',
                        'title'            => 'Dateibeschränkungen',
                    ],
                ],
            ],

            'catalog' => [
                'info'  => 'Katalog',
                'title' => 'Katalog',

                'products' => [
                    'info'  => 'Produktansichtsseite, Warenkorbansichtsseite, Storefront, Bewertung und Attribut-Sozialfreigabe.',
                    'title' => 'Produkte',

                    'settings' => [
                        'compare-options'     => 'Vergleichsoptionen',
                        'image-search-option' => 'Bildsuche-Option',
                        'title'               => 'Einstellungen',
                        'title-info'          => 'Einstellungen beziehen sich auf konfigurierbare Optionen, die das Verhalten eines Systems, einer Anwendung oder eines Geräts steuern und an Benutzerpräferenzen und -anforderungen angepasst sind.',
                        'wishlist-options'    => 'Wunschlistenoptionen',
                    ],

                    'search' => [
                        'admin-mode'            => 'Admin-Suchmodus',
                        'admin-mode-info'       => 'Die Mega-Suche, das Datagrid und andere Suchfunktionen im Admin-Panel basieren auf der ausgewählten Suchmaschine.',
                        'database'              => 'Datenbank',
                        'elastic'               => 'Elastic Search',
                        'max-query-length'      => 'Maximale Abfragelänge',
                        'max-query-length-info' => 'Legen Sie die maximale Abfragelänge für Suchanfragen fest.',
                        'min-query-length'      => 'Minimale Abfragelänge',
                        'min-query-length-info' => 'Legen Sie die minimale Abfragelänge für Suchanfragen fest.',
                        'search-engine'         => 'Suchmaschine',
                        'storefront-mode'       => 'Storefront-Suchmodus',
                        'storefront-mode-info'  => 'Die Suchfunktionen auf der Storefront basieren auf der ausgewählten Suchmaschine, einschließlich Kategorieseite, Suchseite und anderen Suchfunktionen.',
                        'title'                 => 'Suche',
                        'title-info'            => 'Um die Suchmaschine für Produktsuchen einzurichten, können Sie je nach Ihren Anforderungen zwischen einer Datenbank und Elasticsearch wählen. Bei einer großen Anzahl von Produkten wird Elasticsearch empfohlen.',
                    ],

                    'guest-checkout' => [
                        'allow-guest-checkout'      => 'Gast-Checkout erlauben',
                        'allow-guest-checkout-hint' => 'Hinweis: Wenn diese Option aktiviert ist, kann sie für jedes Produkt spezifisch konfiguriert werden.',
                        'title'                     => 'Gast-Checkout',
                        'title-info'                => 'Der Gast-Checkout ermöglicht es Kunden, Produkte zu kaufen, ohne ein Konto zu erstellen, um den Kaufprozess für Bequemlichkeit und schnellere Transaktionen zu optimieren.',
                    ],

                    'product-view-page' => [
                        'allow-no-of-related-products'  => 'Zulässige Anzahl verwandter Produkte',
                        'allow-no-of-up-sells-products' => 'Zulässige Anzahl von Up-Sell-Produkten',
                        'title'                         => 'Konfiguration der Produktansichtsseite',
                        'title-info'                    => 'Die Konfiguration der Produktansichtsseite umfasst die Anpassung des Layouts und der Elemente auf der Anzeigeseite eines Produkts, um die Benutzererfahrung und die Präsentation von Informationen zu verbessern.',
                    ],

                    'cart-view-page' => [
                        'allow-no-of-cross-sells-products' => 'Zulässige Anzahl von Cross-Sell-Produkten',
                        'title'                            => 'Konfiguration der Warenkorbansichtsseite',
                        'title-info'                       => 'Die Konfiguration der Warenkorbansichtsseite umfasst die Anordnung von Artikeln, Details und Optionen auf der Einkaufswagen-Seite, um die Benutzerinteraktion und den Kaufvorgang zu verbessern.',
                    ],

                    'storefront' => [
                        'buy-now-button-display' => 'Kunden ermöglichen, Produkte direkt zu kaufen',
                        'cheapest-first'         => 'Günstigste zuerst',
                        'comma-separated'        => 'Durch Komma getrennt',
                        'default-list-mode'      => 'Standard-Listenmodus',
                        'expensive-first'        => 'Teuerste zuerst',
                        'from-a-z'               => 'Von A-Z',
                        'from-z-a'               => 'Von Z-A',
                        'grid'                   => 'Raster',
                        'latest-first'           => 'Neueste zuerst',
                        'list'                   => 'Liste',
                        'oldest-first'           => 'Älteste zuerst',
                        'products-per-page'      => 'Produkte pro Seite',
                        'sort-by'                => 'Sortieren nach',
                        'title'                  => 'Storefront',
                        'title-info'             => 'Die Storefront ist die kundenorientierte Benutzeroberfläche eines Online-Shops, auf der Produkte, Kategorien und Navigation für ein nahtloses Einkaufserlebnis präsentiert werden.',
                    ],

                    'small-image' => [
                        'height'      => 'Höhe',
                        'placeholder' => 'Platzhalter für kleines Bild',
                        'title'       => 'Kleines Bild',
                        'title-info'  => 'Die Storefront ist die kundenorientierte Benutzeroberfläche eines Online-Shops, auf der Produkte, Kategorien und Navigation für ein nahtloses Einkaufserlebnis präsentiert werden.',
                        'width'       => 'Breite',
                    ],

                    'medium-image' => [
                        'height'      => 'Höhe',
                        'placeholder' => 'Platzhalter für mittleres Bild',
                        'title'       => 'Mittleres Bild',
                        'title-info'  => 'Ein mittelgroßes Bild bietet eine ausgewogene Darstellung von Details und Bildschirmplatz und wird häufig für visuelle Elemente verwendet.',
                        'width'       => 'Breite',
                    ],

                    'large-image' => [
                        'height'      => 'Höhe',
                        'placeholder' => 'Platzhalter für großes Bild',
                        'title'       => 'Großes Bild',
                        'title-info'  => 'Ein großes Bild stellt ein hochauflösendes Bild dar, das eine verbesserte Detailgenauigkeit und visuelle Wirkung bietet und häufig zur Präsentation von Produkten oder Grafiken verwendet wird.',
                        'width'       => 'Breite',
                    ],

                    'review' => [
                        'allow-customer-review'   => 'Kundenbewertungen zulassen',
                        'allow-guest-review'      => 'Gastbewertungen zulassen',
                        'censoring-reviewer-name' => 'Zensur des Rezensentennamens',
                        'display-review-count'    => 'Zeigen Sie die Anzahl der Rezensionen für Bewertungen an.',
                        'display-star-count'      => 'Zeigen Sie die Anzahl der Sterne in Bewertungen an.',
                        'summary'                 => 'Zusammenfassung',
                        'title'                   => 'Bewertung',
                        'title-info'              => 'Bewertung oder Einschätzung von etwas, oft mit Meinungen und Feedback.',
                    ],

                    'attribute' => [
                        'file-upload-size'  => 'Zulässige Dateigröße für Upload (in Kb)',
                        'image-upload-size' => 'Zulässige Bildgröße für Upload (in Kb)',
                        'title'             => 'Attribut',
                        'title-info'        => 'Merkmale oder Eigenschaften, die ein Objekt definieren und sein Verhalten, Aussehen oder seine Funktion beeinflussen.',
                    ],

                    'social-share' => [
                        'title-info'                  => 'Konfigurieren Sie die Einstellungen für die soziale Freigabe, um das Teilen von Produkten auf Instagram, Twitter, WhatsApp, Facebook, Pinterest, LinkedIn und per E-Mail zu ermöglichen.',
                        'title'                       => 'Soziale Freigabe',
                        'share-message'               => 'Freigabemeldung',
                        'share'                       => 'Teilen',
                        'enable-social-share'         => 'Soziale Freigabe aktivieren?',
                        'enable-share-whatsapp-info'  => 'Der What\'s App-Teilen-Link wird nur auf mobilen Geräten angezeigt.',
                        'enable-share-whatsapp'       => 'Teilen in What\'s App aktivieren?',
                        'enable-share-twitter'        => 'Teilen in Twitter aktivieren?',
                        'enable-share-pinterest'      => 'Teilen in Pinterest aktivieren?',
                        'enable-share-linkedin'       => 'Teilen in Linkedin aktivieren?',
                        'enable-share-facebook'       => 'Teilen in Facebook aktivieren?',
                        'enable-share-email'          => 'Teilen per E-Mail aktivieren?',
                    ],
                ],

                'rich-snippets' => [
                    'info'  => 'Produkte und Kategorien festlegen.',
                    'title' => 'Rich Snippets',

                    'products' => [
                        'enable'          => 'Aktivieren',
                        'show-categories' => 'Kategorien anzeigen',
                        'show-images'     => 'Bilder anzeigen',
                        'show-offers'     => 'Angebote anzeigen',
                        'show-ratings'    => 'Bewertungen anzeigen',
                        'show-reviews'    => 'Rezensionen anzeigen',
                        'show-sku'        => 'SKU anzeigen',
                        'show-weight'     => 'Gewicht anzeigen',
                        'title'           => 'Produkte',
                        'info'            => 'Konfigurieren Sie die Produktbestandsoptionen, um Rückstände zu ermöglichen, setzen Sie Mindest- und Höchstwerte für den Warenkorb und definieren Sie Ausverkaufsgrenzen.',
                    ],

                    'categories' => [
                        'enable'                  => 'Aktivieren',
                        'show-search-input-field' => 'Sucheingabefeld anzeigen',
                        'title'                   => 'Kategorien',
                        'title-info'              => '"Kategorien" beziehen sich auf Gruppen oder Klassifizierungen, die dazu dienen, ähnliche Produkte oder Artikel für eine einfachere Suche und Navigation zusammenzufassen und zu organisieren.',
                    ],
                ],

                'inventory' => [
                    'title'      => 'Bestand',
                    'title-info' => 'Konfigurieren Sie die Bestandsoptionen, um Rückstände zuzulassen und die Schwelle für nicht vorrätige Artikel festzulegen.',

                    'product-stock-options' => [
                        'allow-back-orders'       => 'Rückstände zulassen',
                        'max-qty-allowed-in-cart' => 'Maximale Menge im Warenkorb erlaubt',
                        'min-qty-allowed-in-cart' => 'Minimale Menge im Warenkorb erlaubt',
                        'out-of-stock-threshold'  => 'Schwelle für nicht vorrätige Artikel',
                        'title'                   => 'Produktbestandsoption',
                        'info'                    => 'Konfigurieren Sie die Produktbestandsoptionen, um Rückstände zuzulassen, Mindest- und Höchstbestellmengen festzulegen und die Schwelle für nicht vorrätige Artikel zu definieren.',
                    ],
                ],
            ],

            'customer' => [
                'info'  => 'Kunde',
                'title' => 'Kunde',

                'address' => [
                    'info'  => 'Land, Bundesland, Postleitzahl und Straßenadresse festlegen.',
                    'title' => 'Adresse',

                    'requirements' => [
                        'city'       => 'Stadt',
                        'country'    => 'Land',
                        'state'      => 'Bundesland',
                        'title'      => 'Anforderungen',
                        'title-info' => 'Anforderungen sind die Bedingungen, Merkmale oder Spezifikationen, die für etwas erfüllt, erreicht oder erfolgreich erfüllt werden müssen.',
                        'zip'        => 'Postleitzahl',
                    ],

                    'information' => [
                        'street-lines' => 'Zeilen in einer Straßenadresse',
                        'title'        => 'Informationen',
                        'title-info'   => '"Zeilen in einer Straßenadresse" beziehen sich auf einzelne Segmente einer Adresse, die oft durch Kommas getrennt sind und Standortinformationen wie Hausnummer, Straße, Stadt und mehr liefern.',
                    ],
                ],

                'captcha' => [
                    'info'  => 'Site-Schlüssel, geheimer Schlüssel und Status festlegen.',
                    'title' => 'Google Captcha',

                    'credentials' => [
                        'secret-key' => 'Geheimer Schlüssel',
                        'site-key'   => 'Site-Schlüssel',
                        'status'     => 'Status',
                        'title'      => 'Anmeldeinformationen',
                        'title-info' => '"Sitemap: Website-Layout-Karte für Suchmaschinen. Geheimer Schlüssel: Sicherer Code für die Verschlüsselung, Authentifizierung oder den Schutz des API-Zugriffs."',
                    ],

                    'validations' => [
                        'captcha'  => 'Etwas ist schief gelaufen! Bitte versuchen Sie es erneut.',
                        'required' => 'Bitte wählen Sie CAPTCHA aus.',
                    ],
                ],

                'settings' => [
                    'settings-info' => 'Wunschliste, Login-Weiterleitung, Newsletter-Abonnements, Standardgruppenoption, E-Mail-Verifizierungen und Social Login festlegen.',
                    'title'         => 'Einstellungen',

                    'login-as-customer' => [
                        'allow-option' => 'Als Kunde einloggen erlauben',
                        'title'        => 'Als Kunde einloggen',
                        'title-info'   => 'Aktivieren Sie die Funktion "Als Kunde einloggen".',
                    ],

                    'wishlist' => [
                        'allow-option' => 'Wunschliste-Option erlauben',
                        'title'        => 'Wunschliste',
                        'title-info'   => 'Aktivieren oder deaktivieren Sie die Wunschliste-Option.',
                    ],

                    'login-options' => [
                        'account'          => 'Konto',
                        'home'             => 'Startseite',
                        'redirect-to-page' => 'Kunden zur ausgewählten Seite weiterleiten',
                        'title'            => 'Login-Optionen',
                        'title-info'       => 'Konfigurieren Sie die Login-Optionen, um die Weiterleitungsseite für Kunden nach dem Login festzulegen.',
                    ],

                    'create-new-account-option' => [
                        'news-letter'      => 'Newsletter erlauben',
                        'news-letter-info' => 'Aktivieren Sie die Option für Newsletter-Abonnements auf der Anmeldeseite.',
                        'title'            => 'Optionen für neues Konto erstellen',
                        'title-info'       => 'Setzen Sie Optionen für neue Konten, einschließlich Zuweisung einer Standard-Kundengruppe und Aktivierung der Newsletter-Abonnement-Option während der Anmeldung.',

                        'default-group' => [
                            'general'    => 'Allgemein',
                            'guest'      => 'Gast',
                            'title'      => 'Standardgruppe',
                            'title-info' => 'Weisen Sie neuen Kunden eine bestimmte Kundengruppe als Standard zu.',
                            'wholesale'  => 'Großhandel',
                        ],
                    ],

                    'newsletter' => [
                        'subscription' => 'Newsletter-Abonnement erlauben',
                        'title'        => 'Newsletter-Abonnement',
                        'title-info'   => '"Newsletter-Informationen" enthält regelmäßig per E-Mail geteilte Updates, Angebote oder Inhalte, um Abonnenten auf dem Laufenden zu halten und zu engagieren.',
                    ],

                    'email' => [
                        'email-verification' => 'E-Mail-Verifizierung erlauben',
                        'title'              => 'E-Mail-Verifizierung',
                        'title-info'         => 'Die "E-Mail-Verifizierung" bestätigt die Echtheit einer E-Mail-Adresse, oft durch das Senden eines Bestätigungslinks, um die Kontosicherheit und die Zuverlässigkeit der Kommunikation zu verbessern.',
                    ],

                    'social-login' => [
                        'title' => 'Soziale Anmeldung',
                        'info'  => '"Soziale Anmeldung" ermöglicht es Benutzern, eine Website mit ihren Social-Media-Konten zu betreten und vereinfacht so den Registrierungs- und Anmeldeprozess.',

                        'google' => [
                            'enable-google' => 'Google aktivieren',

                            'client-id' => [
                                'title'      => 'Client-ID',
                                'title-info' => 'Eindeutige Kennung, die von Google beim Erstellen Ihrer OAuth-Anwendung bereitgestellt wird.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client-Geheimnis',
                                'title-info' => 'Geheimer Schlüssel, der mit Ihrem Google-OAuth-Client verknüpft ist. Bewahren Sie ihn vertraulich auf.',
                            ],

                            'redirect' => [
                                'title'      => 'Weiterleitungs-URL',
                                'title-info' => 'Rückruf-URL, zu der Benutzer nach der Authentifizierung mit Google weitergeleitet werden. Muss mit der in Ihrer Google-Konsole konfigurierten URL übereinstimmen.',
                            ],
                        ],

                        'facebook' => [
                            'enable-facebook' => 'Facebook aktivieren',

                            'client-id' => [
                                'title'      => 'Client-ID',
                                'title-info' => 'App-ID, die von Facebook beim Erstellen einer Anwendung in der Facebook-Entwicklerkonsole bereitgestellt wird.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client-Geheimnis',
                                'title-info' => 'App-Geheimnis, das mit Ihrer Facebook-Anwendung verknüpft ist. Bewahren Sie es sicher und privat auf.',
                            ],

                            'redirect' => [
                                'title'      => 'Weiterleitungs-URL',
                                'title-info' => 'Rückruf-URL, zu der Benutzer nach der Authentifizierung mit Facebook weitergeleitet werden. Muss mit der in den App-Einstellungen von Facebook konfigurierten URL übereinstimmen.',
                            ],
                        ],

                        'github' => [
                            'enable-github' => 'GitHub aktivieren',

                            'client-id' => [
                                'title'      => 'Client-ID',
                                'title-info' => 'Eindeutige Kennung, die von GitHub beim Erstellen Ihrer OAuth-Anwendung bereitgestellt wird.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client-Geheimnis',
                                'title-info' => 'Geheimer Schlüssel, der mit Ihrem GitHub-OAuth-Client verknüpft ist. Bewahren Sie ihn vertraulich auf.',
                            ],

                            'redirect' => [
                                'title'      => 'Weiterleitungs-URL',
                                'title-info' => 'Rückruf-URL, zu der Benutzer nach der Authentifizierung mit GitHub weitergeleitet werden. Muss mit der in Ihrer GitHub-Konsole konfigurierten URL übereinstimmen.',
                            ],
                        ],

                        'linkedin' => [
                            'enable-linkedin' => 'LinkedIn aktivieren',

                            'client-id' => [
                                'title'      => 'Client-ID',
                                'title-info' => 'Eindeutige Kennung, die von LinkedIn beim Erstellen Ihrer OAuth-Anwendung bereitgestellt wird.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client-Geheimnis',
                                'title-info' => 'Geheimer Schlüssel, der mit Ihrem LinkedIn-OAuth-Client verknüpft ist. Bewahren Sie ihn vertraulich auf.',
                            ],

                            'redirect' => [
                                'title'      => 'Weiterleitungs-URL',
                                'title-info' => 'Rückruf-URL, zu der Benutzer nach der Authentifizierung mit LinkedIn weitergeleitet werden. Muss mit der in Ihrer LinkedIn-Konsole konfigurierten URL übereinstimmen.',
                            ],
                        ],

                        'twitter' => [
                            'enable-twitter' => 'Twitter aktivieren',

                            'client-id' => [
                                'title'      => 'Client-ID',
                                'title-info' => 'Eindeutige Kennung, die von Twitter beim Erstellen Ihrer OAuth-Anwendung bereitgestellt wird.',
                            ],

                            'client-secret' => [
                                'title'      => 'Client-Geheimnis',
                                'title-info' => 'Geheimer Schlüssel, der mit Ihrem Twitter-OAuth-Client verknüpft ist. Bewahren Sie ihn vertraulich auf.',
                            ],

                            'redirect' => [
                                'title'      => 'Weiterleitungs-URL',
                                'title-info' => 'Rückruf-URL, zu der Benutzer nach der Authentifizierung mit Twitter weitergeleitet werden. Muss mit der in Ihrer Twitter-Konsole konfigurierten URL übereinstimmen.',
                            ],
                        ],
                    ],
                ],
            ],

            'email' => [
                'info'  => 'E-Mail',
                'title' => 'E-Mail',

                'email-settings' => [
                    'admin-email'           => 'Admin E-Mail',
                    'admin-email-tip'       => 'Die E-Mail-Adresse des Admins für diesen Kanal, um E-Mails zu erhalten',
                    'admin-name'            => 'Admin Name',
                    'admin-name-tip'        => 'Dieser Name wird in allen Admin-E-Mails angezeigt',
                    'admin-page-limit'      => 'Standard Anzahl pro Seite (Admin)',
                    'contact-email'         => 'Kontakt E-Mail',
                    'contact-email-tip'     => 'Die E-Mail-Adresse wird am Ende Ihrer E-Mails angezeigt',
                    'contact-name'          => 'Kontakt Name',
                    'contact-name-tip'      => 'Dieser Name wird am Ende Ihrer E-Mails angezeigt',
                    'email-sender-name'     => 'E-Mail Absender Name',
                    'email-sender-name-tip' => 'Dieser Name wird im Posteingang des Kunden angezeigt',
                    'info'                  => 'Setzen Sie den E-Mail Absender Namen, die Shop E-Mail-Adresse, den Admin Namen und die Admin E-Mail-Adresse.',
                    'shop-email-from'       => 'Shop E-Mail-Adresse',
                    'shop-email-from-tip'   => 'Die E-Mail-Adresse dieses Kanals, um E-Mails an Ihre Kunden zu senden',
                    'title'                 => 'E-Mail Einstellungen',
                ],

                'notifications' => [
                    'cancel-order'                                     => 'Senden Sie eine Benachrichtigung an den Kunden, nachdem eine Bestellung storniert wurde',
                    'cancel-order-mail-to-admin'                       => 'Senden Sie eine Benachrichtigungs-E-Mail an den Administrator nach der Stornierung einer Bestellung',
                    'customer'                                         => 'Senden Sie die Anmeldeinformationen des Kundenkontos nach der Registrierung',
                    'customer-registration-confirmation-mail-to-admin' => 'Senden Sie eine Bestätigungs-E-Mail an den Administrator nach der Kundenregistrierung',
                    'info'                                             => 'Konfigurieren Sie den Empfang von E-Mails für Kontobestätigungen, Bestellbestätigungen, Updates zu Rechnungen, Rückerstattungen, Sendungen und Stornierungen von Bestellungen.',
                    'new-inventory-source'                             => 'Senden Sie eine Benachrichtigungs-E-Mail an die Lagerquelle nach Erstellung einer Sendung',
                    'new-invoice'                                      => 'Senden Sie eine Benachrichtigungs-E-Mail an den Kunden nach Erstellung einer neuen Rechnung',
                    'new-invoice-mail-to-admin'                        => 'Senden Sie eine Benachrichtigungs-E-Mail an den Administrator nach Erstellung einer neuen Rechnung',
                    'new-order'                                        => 'Senden Sie eine Bestätigungs-E-Mail an den Kunden nach Aufgabe einer neuen Bestellung',
                    'new-order-mail-to-admin'                          => 'Senden Sie eine Bestätigungs-E-Mail an den Administrator nach Aufgabe einer neuen Bestellung',
                    'new-refund'                                       => 'Senden Sie eine Benachrichtigungs-E-Mail an den Kunden nach Erstellung einer Rückerstattung',
                    'new-refund-mail-to-admin'                         => 'Senden Sie eine Benachrichtigungs-E-Mail an den Administrator nach Erstellung einer neuen Rückerstattung',
                    'new-shipment'                                     => 'Senden Sie eine Benachrichtigungs-E-Mail an den Kunden nach Erstellung einer Sendung',
                    'new-shipment-mail-to-admin'                       => 'Senden Sie eine Benachrichtigungs-E-Mail an den Administrator nach Erstellung einer neuen Sendung',
                    'registration'                                     => 'Senden Sie eine Bestätigungs-E-Mail nach der Kundenregistrierung',
                    'title'                                            => 'Benachrichtigungen',
                    'verification'                                     => 'Senden Sie eine Bestätigungs-E-Mail nach der Kundenregistrierung',
                ],
            ],

            'sales' => [
                'info'  => 'Verkäufe',
                'title' => 'Verkäufe',

                'shipping-setting' => [
                    'info'  => 'Versandeinstellungen konfigurieren, einschließlich Land, Bundesland, Stadt, Straßenadresse, Postleitzahl, Geschäftsname, Umsatzsteuer-Identifikationsnummer, Kontakttelefonnummer und Bankdaten.',
                    'title' => 'Versandeinstellungen',

                    'origin' => [
                        'bank-details'   => 'Bankdaten',
                        'city'           => 'Stadt',
                        'contact-number' => 'Kontakttelefonnummer',
                        'country'        => 'Land',
                        'state'          => 'Bundesland',
                        'store-name'     => 'Geschäftsname',
                        'street-address' => 'Straßenadresse',
                        'title'          => 'Herkunft',
                        'title-info'     => 'Der Versandursprung bezieht sich auf den Ort, an dem Waren oder Produkte vor dem Transport zu ihrem Bestimmungsort hergestellt werden.',
                        'vat-number'     => 'Umsatzsteuer-Identifikationsnummer',
                        'zip'            => 'Postleitzahl',
                    ],
                ],

                'shipping-methods' => [
                    'info'  => 'Versandmethoden konfigurieren, einschließlich kostenloser Versand, Pauschalpreis und zusätzliche Optionen nach Bedarf.',
                    'title' => 'Versandmethoden',

                    'free-shipping' => [
                        'description' => 'Beschreibung',
                        'page-title'  => 'Kostenloser Versand',
                        'status'      => 'Status',
                        'title'       => 'Titel',
                        'title-info'  => '"Kostenloser Versand" bezieht sich auf eine Versandmethode, bei der die Versandkosten erlassen werden und der Verkäufer die Versandkosten für die Lieferung der Ware an den Käufer übernimmt.',
                    ],

                    'flat-rate-shipping' => [
                        'description' => 'Beschreibung',
                        'page-title'  => 'Pauschalpreis-Versand',
                        'rate'        => 'Preis',
                        'status'      => 'Status',
                        'title'       => 'Titel',
                        'title-info'  => 'Der Pauschalpreis-Versand ist eine Versandmethode, bei der eine feste Gebühr für den Versand erhoben wird, unabhängig vom Gewicht, der Größe oder der Entfernung des Pakets. Dies vereinfacht die Versandkosten und kann sowohl für Käufer als auch Verkäufer vorteilhaft sein.',
                        'type'        => [
                            'per-order' => 'Pro Bestellung',
                            'per-unit'  => 'Pro Einheit',
                            'title'     => 'Typ',
                        ],
                    ],
                ],

                'payment-methods' => [
                    'accepted-currencies'            => 'Akzeptierte Währungen',
                    'accepted-currencies-info'       => 'Fügen Sie Währungscodes durch Kommas getrennt hinzu, z.B. USD, INR, ...',
                    'business-account'               => 'Geschäftskonto',
                    'cash-on-delivery'               => 'Nachnahme',
                    'cash-on-delivery-info'          => 'Zahlungsmethode, bei der Kunden bar bezahlen, wenn sie die Ware oder Dienstleistung an ihrer Haustür erhalten.',
                    'client-id'                      => 'Client-ID',
                    'client-id-info'                 => 'Verwenden Sie "sb" für Tests.',
                    'client-secret'                  => 'Client Secret',
                    'client-secret-info'             => 'Fügen Sie hier Ihren geheimen Schlüssel hinzu',
                    'description'                    => 'Beschreibung',
                    'generate-invoice'               => 'Automatisch eine Rechnung nach Bestellung erstellen',
                    'generate-invoice-applicable'    => 'Gilt, wenn die automatische Rechnungserstellung aktiviert ist',
                    'info'                           => 'Zahlungsmethodeninformationen festlegen',
                    'instructions'                   => 'Anweisungen',
                    'logo'                           => 'Logo',
                    'logo-information'               => 'Die Bildauflösung sollte etwa 55px x 45px betragen',
                    'mailing-address'                => 'Scheck senden an',
                    'money-transfer'                 => 'Geldüberweisung',
                    'money-transfer-info'            => 'Überweisung von Geldern von einer Person oder einem Konto auf ein anderes, oft elektronisch, für verschiedene Zwecke wie Transaktionen oder Überweisungen.',
                    'page-title'                     => 'Zahlungsmethoden',
                    'paid'                           => 'Bezahlt',
                    'paypal-smart-button'            => 'PayPal',
                    'paypal-smart-button-info'       => 'PayPal Smart Button: Vereinfacht Online-Zahlungen mit anpassbaren Schaltflächen für sichere, mehrstufige Transaktionen auf Websites und Apps.',
                    'paypal-standard'                => 'PayPal Standard',
                    'paypal-standard-info'           => 'PayPal Standard ist eine grundlegende PayPal-Zahlungsoption für Online-Unternehmen, mit der Kunden mit ihrem PayPal-Konto oder Kredit-/Debitkarten bezahlen können.',
                    'pending'                        => 'Ausstehend',
                    'pending-payment'                => 'Ausstehende Zahlung',
                    'processing'                     => 'In Bearbeitung',
                    'sandbox'                        => 'Sandbox',
                    'set-invoice-status'             => 'Den Rechnungsstatus nach Erstellung der Rechnung auf',
                    'set-order-status'               => 'Den Bestellstatus nach Erstellung der Rechnung auf',
                    'sort-order'                     => 'Sortierreihenfolge',
                    'status'                         => 'Status',
                    'title'                          => 'Titel',
                ],

                'order-settings' => [
                    'info'               => 'Setzen Sie Bestellnummern, Mindestbestellungen und Nachbestellungen.',
                    'title'              => 'Bestelleinstellungen',

                    'order-number' => [
                        'generator'   => 'Bestellnummern-Generator',
                        'info'        => 'Eindeutige Kennung, die einer bestimmten Kundenbestellung zugewiesen wird und die Verfolgung, Kommunikation und Referenzierung während des Kaufprozesses erleichtert.',
                        'length'      => 'Länge der Bestellnummer',
                        'prefix'      => 'Präfix der Bestellnummer',
                        'suffix'      => 'Suffix der Bestellnummer',
                        'title'       => 'Einstellungen für Bestellnummer',
                    ],

                    'minimum-order' => [
                        'description'             => 'Beschreibung',
                        'enable'                  => 'Aktivieren',
                        'include-discount-amount' => 'Rabattbetrag einschließen',
                        'include-tax-amount'      => 'Steuern zum Betrag hinzufügen',
                        'info'                    => 'Konfigurierte Kriterien, die die niedrigste erforderliche Menge oder den niedrigsten erforderlichen Wert für eine Bestellung festlegen, um verarbeitet zu werden oder Vorteile zu erhalten.',
                        'minimum-order-amount'    => 'Mindestbestellmenge',
                        'title'                   => 'Einstellungen für Mindestbestellung',
                    ],

                    'reorder' => [
                        'admin-reorder'      => 'Admin erneut bestellen',
                        'admin-reorder-info' => 'Aktivieren oder deaktivieren Sie die Funktion zur erneuten Bestellung für Administratoren.',
                        'info'               => 'Aktivieren oder deaktivieren Sie die Funktion zur erneuten Bestellung für Administratoren.',
                        'shop-reorder'       => 'Shop erneut bestellen',
                        'shop-reorder-info'  => 'Aktivieren oder deaktivieren Sie die Funktion zur erneuten Bestellung für Shop-Benutzer.',
                        'title'              => 'Erneute Bestellung zulassen',
                    ],

                    'stock-options' => [
                        'allow-back-orders' => 'Nachbestellungen zulassen',
                        'info'              => 'Aktienoptionen sind Anlageverträge, die das Recht zum Kauf oder Verkauf von Unternehmensaktien zu einem vorher festgelegten Preis gewähren und potenzielle Gewinne beeinflussen.',
                        'title'             => 'Aktienoptionen',
                    ],
                ],

                'invoice-settings' => [
                    'info'  => 'Setzen Sie Rechnungsnummer, Zahlungsbedingungen, Rechnungsschein-Design und Rechnungserinnerungen.',
                    'title' => 'Rechnungseinstellungen',

                    'invoice-number' => [
                        'generator'  => 'Rechnungsnummer-Generator',
                        'info'       => 'Konfiguration von Regeln oder Parametern zur Generierung und Zuweisung eindeutiger Identifikationsnummern für Rechnungen zu organisatorischen und Nachverfolgungszwecken.',
                        'length'     => 'Länge der Rechnungsnummer',
                        'prefix'     => 'Präfix der Rechnungsnummer',
                        'suffix'     => 'Suffix der Rechnungsnummer',
                        'title'      => 'Einstellungen für Rechnungsnummer',
                    ],

                    'payment-terms' => [
                        'due-duration'      => 'Fälligkeitsdauer',
                        'due-duration-day'  => ':due-duration Tag',
                        'due-duration-days' => ':due-duration Tage',
                        'info'              => 'Vereinbarte Bedingungen, die festlegen, wann und wie die Zahlung für Waren oder Dienstleistungen vom Käufer an den Verkäufer erfolgen soll.',
                        'title'             => 'Zahlungsbedingungen',
                    ],

                    'pdf-print-outs' => [
                        'footer-text'      => 'Fußzeilentext',
                        'footer-text-info' => 'Geben Sie den Text ein, der in der Fußzeile des PDFs erscheint.',
                        'info'             => 'Konfigurieren Sie PDF-Druckausgaben, um die Rechnungs-ID, die Bestell-ID im Header anzuzeigen und das Rechnungslogo einzuschließen.',
                        'invoice-id-info'  => 'Konfigurieren Sie die Anzeige der Rechnungs-ID im Rechnungskopf.',
                        'invoice-id-title' => 'Rechnungs-ID im Header anzeigen',
                        'logo'             => 'Logo',
                        'logo-info'        => 'Die Bildauflösung sollte etwa 131px x 30px betragen.',
                        'order-id-info'    => 'Konfigurieren Sie die Anzeige der Bestell-ID im Rechnungskopf.',
                        'order-id-title'   => 'Bestell-ID im Header anzeigen',
                        'title'            => 'PDF-Druckausgaben',
                    ],

                    'invoice-reminders' => [
                        'info'                       => 'Automatisierte Benachrichtigungen oder Mitteilungen, die an Kunden gesendet werden, um sie an bevorstehende oder überfällige Zahlungen für Rechnungen zu erinnern.',
                        'interval-between-reminders' => 'Intervall zwischen Erinnerungen',
                        'maximum-limit-of-reminders' => 'Maximale Anzahl von Erinnerungen',
                        'title'                      => 'Rechnungserinnerungen',
                    ],
                ],

                'taxes' => [
                    'title'      => 'Steuern',
                    'title-info' => 'Steuern sind obligatorische Gebühren, die von Regierungen für Waren, Dienstleistungen oder Transaktionen erhoben werden und von Verkäufern eingezogen und an die Behörden abgeführt werden.',

                    'categories' => [
                        'title'      => 'Steuerkategorien',
                        'title-info' => 'Steuerkategorien sind Klassifizierungen für verschiedene Arten von Steuern, wie z.B. Umsatzsteuer, Mehrwertsteuer oder Verbrauchssteuer, die zur Kategorisierung und Anwendung von Steuersätzen auf Produkte oder Dienstleistungen verwendet werden.',
                        'product'    => 'Standardsteuerkategorie für Produkte',
                        'shipping'   => 'Steuerkategorie für Versand',
                        'none'       => 'Keine',
                    ],

                    'calculation' => [
                        'title'            => 'Berechnungseinstellungen',
                        'title-info'       => 'Details zu den Kosten von Waren oder Dienstleistungen, einschließlich Grundpreis, Rabatten, Steuern und zusätzlichen Gebühren.',
                        'based-on'         => 'Berechnung basierend auf',
                        'shipping-address' => 'Lieferadresse',
                        'billing-address'  => 'Rechnungsadresse',
                        'shipping-origin'  => 'Versandursprung',
                        'product-prices'   => 'Produktpreise',
                        'shipping-prices'  => 'Versandpreise',
                        'excluding-tax'    => 'Ohne Steuern',
                        'including-tax'    => 'Inklusive Steuern',
                    ],

                    'default-destination-calculation' => [
                        'default-country'   => 'Standardland',
                        'default-post-code' => 'Standard-Postleitzahl',
                        'default-state'     => 'Standard-Bundesland',
                        'title'             => 'Standardzielberechnung',
                        'title-info'        => 'Automatische Bestimmung eines Standard- oder Anfangsziels basierend auf vordefinierten Faktoren oder Einstellungen.',
                    ],

                    'shopping-cart' => [
                        'title'                   => 'Einstellungen zur Anzeige im Warenkorb',
                        'title-info'              => 'Legen Sie die Anzeige von Steuern im Warenkorb fest',
                        'display-prices'          => 'Preise anzeigen',
                        'display-subtotal'        => 'Zwischensumme anzeigen',
                        'display-shipping-amount' => 'Versandkosten anzeigen',
                        'excluding-tax'           => 'Ohne Steuern',
                        'including-tax'           => 'Inklusive Steuern',
                        'both'                    => 'Sowohl ohne als auch mit Steuern',
                    ],

                    'sales' => [
                        'title'                   => 'Einstellungen zur Anzeige in Bestellungen, Rechnungen und Rückerstattungen',
                        'title-info'              => 'Legen Sie die Anzeige von Steuern in Bestellungen, Rechnungen und Rückerstattungen fest',
                        'display-prices'          => 'Preise anzeigen',
                        'display-subtotal'        => 'Zwischensumme anzeigen',
                        'display-shipping-amount' => 'Versandkosten anzeigen',
                        'excluding-tax'           => 'Ohne Steuern',
                        'including-tax'           => 'Inklusive Steuern',
                        'both'                    => 'Sowohl ohne als auch mit Steuern',
                    ],
                ],

                'checkout' => [
                    'title' => 'Kasse',
                    'info'  => 'Gast-Checkout einrichten, Mini-Warenkorb aktivieren oder deaktivieren, Warenkorbzusammenfassung.',

                    'shopping-cart' => [
                        'cart-page'              => 'Warenkorbseite',
                        'cart-page-info'         => 'Steuerung der Sichtbarkeit der Warenkorbseite, um das Einkaufserlebnis für Benutzer zu verbessern.',
                        'cross-sell'             => 'Zusatzverkäufe',
                        'cross-sell-info'        => 'Aktivieren Sie Zusatzverkäufe, um zusätzliche Verkaufsmöglichkeiten zu fördern.',
                        'estimate-shipping'      => 'Versandkosten schätzen',
                        'estimate-shipping-info' => 'Aktivieren Sie die Schätzung der Versandkosten, um Benutzern sofortige Versandkosten anzubieten.',
                        'guest-checkout'         => 'Gastbestellung erlauben',
                        'guest-checkout-info'    => 'Aktivieren Sie die Gastbestellung für einen schnelleren und problemloseren Kaufprozess.',
                        'info'                   => 'Aktivieren Sie die Gastbestellung, die Warenkorbseite, Zusatzverkäufe und die Schätzung der Versandkosten, um den Benutzerkomfort zu verbessern und den Einkaufsprozess zu optimieren, um den Umsatz zu steigern.',
                        'title'                  => 'Warenkorb',
                    ],

                    'my-cart' => [
                        'display-item-quantities' => 'Anzeige der Artikelmenge',
                        'display-number-in-cart'  => 'Anzeige der Anzahl der Artikel im Warenkorb',
                        'info'                    => 'Aktivieren Sie die Einstellungen für "Mein Warenkorb", um eine Zusammenfassung der Artikelmenge anzuzeigen und die Gesamtanzahl der Artikel im Warenkorb für eine einfache Verfolgung anzuzeigen.',
                        'summary'                 => 'Zusammenfassung',
                        'title'                   => 'Mein Warenkorb',
                    ],

                    'mini-cart' => [
                        'display-mini-cart'    => 'Mini-Warenkorb anzeigen',
                        'info'                 => 'Aktivieren Sie die Einstellungen für den Mini-Warenkorb, um den Mini-Warenkorb anzuzeigen und Informationen zum Mini-Warenkorbangebot anzuzeigen, um schnell auf Warenkorbdetails und Werbeaktionen zugreifen zu können.',
                        'mini-cart-offer-info' => 'Informationen zum Mini-Warenkorbangebot',
                        'title'                => 'Mini-Warenkorb',
                    ],
                ],
            ],
        ],
    ],

    'components' => [
        'layouts' => [
            'header' => [
                'account-title' => 'Konto',
                'app-version'   => 'Version: :version',
                'logout'        => 'Abmelden',
                'my-account'    => 'Mein Konto',
                'notifications' => 'Benachrichtigungen',
                'visit-shop'    => 'Zum Shop',

                'mega-search' => [
                    'categories'                      => 'Kategorien',
                    'customers'                       => 'Kunden',
                    'explore-all-categories'          => 'Alle Kategorien erkunden',
                    'explore-all-customers'           => 'Alle Kunden erkunden',
                    'explore-all-matching-categories' => 'Erkunden Sie alle Kategorien, die zu \":query\" passen (:count)',
                    'explore-all-matching-customers'  => 'Erkunden Sie alle Kunden, die zu \":query\" passen (:count)',
                    'explore-all-matching-orders'     => 'Erkunden Sie alle Bestellungen, die zu \":query\" passen (:count)',
                    'explore-all-matching-products'   => 'Erkunden Sie alle Produkte, die zu \":query\" passen (:count)',
                    'explore-all-orders'              => 'Alle Bestellungen erkunden',
                    'explore-all-products'            => 'Alle Produkte erkunden',
                    'orders'                          => 'Bestellungen',
                    'products'                        => 'Produkte',
                    'sku'                             => 'Artikelnummer: :sku',
                    'title'                           => 'Mega-Suche',
                ],
            ],

            'sidebar' => [
                'attribute-families'       => 'Attribut-Familien',
                'attributes'               => 'Attribute',
                'booking-product'          => 'Buchungen',
                'campaigns'                => 'Kampagnen',
                'catalog'                  => 'Katalog',
                'categories'               => 'Kategorien',
                'channels'                 => 'Kanäle',
                'cms'                      => 'CMS',
                'collapse'                 => 'Einklappen',
                'communications'           => 'Kommunikation',
                'configure'                => 'Konfigurieren',
                'currencies'               => 'Währungen',
                'customers'                => 'Kunden',
                'dashboard'                => 'Dashboard',
                'data-transfer'            => 'Datentransfer',
                'discount'                 => 'Rabatt',
                'email-templates'          => 'E-Mail-Vorlagen',
                'events'                   => 'Ereignisse',
                'exchange-rates'           => 'Wechselkurse',
                'gdpr-data-requests'       => 'GDPR-Datenanfragen',
                'groups'                   => 'Gruppen',
                'imports'                  => 'Importe',
                'inventory-sources'        => 'Inventarquellen',
                'invoices'                 => 'Rechnungen',
                'locales'                  => 'Standorte',
                'marketing'                => 'Marketing',
                'mode'                     => 'Dunkler Modus',
                'newsletter-subscriptions' => 'Newsletter-Abonnements',
                'orders'                   => 'Bestellungen',
                'products'                 => 'Produkte',
                'promotions'               => 'Aktionen',
                'refunds'                  => 'Rückerstattungen',
                'reporting'                => 'Berichterstattung',
                'reviews'                  => 'Bewertungen',
                'roles'                    => 'Rollen',
                'sales'                    => 'Vertrieb',
                'search-seo'               => 'Suche & SEO',
                'search-synonyms'          => 'Suchsynonyme',
                'search-terms'             => 'Suchbegriffe',
                'settings'                 => 'Einstellungen',
                'shipments'                => 'Versand',
                'sitemaps'                 => 'Sitemaps',
                'tax-categories'           => 'Steuerkategorien',
                'tax-rates'                => 'Steuersätze',
                'taxes'                    => 'Steuern',
                'themes'                   => 'Themen',
                'transactions'             => 'Transaktionen',
                'url-rewrites'             => 'URL-Rewrites',
                'users'                    => 'Benutzer',
            ],

            'powered-by' => [
                'description' => 'Bereitgestellt von :bagisto, ein Open-Source-Projekt von :webkul.',
            ],
        ],

        'datagrid' => [
            'toolbar' => [
                'length-of' => ':length von',
                'of'        => 'von',
                'per-page'  => 'Pro Seite',
                'results'   => ':total Ergebnisse',
                'selected'  => ':total Ausgewählt',

                'index' => [
                    'no-records-selected'              => 'Es wurden keine Datensätze ausgewählt.',
                    'must-select-a-mass-action-option' => 'Sie müssen eine Option für die Massenaktion auswählen.',
                    'must-select-a-mass-action'        => 'Sie müssen eine Massenaktion auswählen.',
                ],

                'mass-actions' => [
                    'select-action' => 'Aktion auswählen',
                    'select-option' => 'Option auswählen',
                    'submit'        => 'Senden',
                ],

                'filter' => [
                    'apply-filters-btn' => 'Filter anwenden',
                    'back-btn'          => 'Zurück',
                    'create-new-filter' => 'Neuen Filter erstellen',
                    'custom-filters'    => 'Benutzerdefinierte Filter',
                    'delete-error'      => 'Beim Löschen des Filters ist etwas schief gelaufen, bitte versuchen Sie es erneut.',
                    'delete-success'    => 'Filter wurde erfolgreich gelöscht.',
                    'empty-description' => 'Es sind keine ausgewählten Filter zum Speichern verfügbar. Bitte wählen Sie Filter zum Speichern aus.',
                    'empty-title'       => 'Filter zum Speichern hinzufügen',
                    'name'              => 'Name',
                    'quick-filters'     => 'Schnellfilter',
                    'save-btn'          => 'Speichern',
                    'save-filter'       => 'Filter speichern',
                    'saved-success'     => 'Filter wurde erfolgreich gespeichert.',
                    'selected-filters'  => 'Ausgewählte Filter',
                    'title'             => 'Filter',
                    'update'            => 'Aktualisieren',
                    'update-filter'     => 'Filter aktualisieren',
                    'updated-success'   => 'Der Filter wurde erfolgreich aktualisiert.',
                ],

                'search' => [
                    'title' => 'Suchen',
                ],
            ],

            'filters' => [
                'select' => 'Auswählen',
                'title'  => 'Filter',

                'dropdown' => [
                    'searchable' => [
                        'atleast-two-chars' => 'Mindestens 2 Zeichen eingeben...',
                        'no-results'        => 'Keine Ergebnisse gefunden...',
                    ],
                ],

                'custom-filters' => [
                    'clear-all' => 'Alles löschen',
                    'title'     => 'Benutzerdefinierte Filter',
                ],

                'boolean-options' => [
                    'false' => 'Falsch',
                    'true'  => 'Wahr',
                ],

                'date-options' => [
                    'last-month'        => 'Letzter Monat',
                    'last-six-months'   => 'Letzte 6 Monate',
                    'last-three-months' => 'Letzte 3 Monate',
                    'this-month'        => 'Diesen Monat',
                    'this-week'         => 'Diese Woche',
                    'this-year'         => 'Dieses Jahr',
                    'today'             => 'Heute',
                    'yesterday'         => 'Gestern',
                ],
            ],

            'table' => [
                'actions'              => 'Aktionen',
                'no-records-available' => 'Keine Datensätze verfügbar.',
            ],
        ],

        'modal' => [
            'confirm' => [
                'agree-btn'    => 'Zustimmen',
                'disagree-btn' => 'Nicht zustimmen',
                'message'      => 'Möchtest du diese Aktion wirklich ausführen?',
                'title'        => 'Bist du sicher?',
            ],
        ],

        'products' => [
            'search' => [
                'add-btn'       => 'Ausgewähltes Produkt hinzufügen',
                'empty-info'    => 'Keine Produkte für den Suchbegriff verfügbar.',
                'empty-title'   => 'Keine Produkte gefunden',
                'product-image' => 'Produktbild',
                'qty'           => ':qty verfügbar',
                'sku'           => 'SKU - :sku',
                'title'         => 'Produkte auswählen',
            ],
        ],

        'media' => [
            'images' => [
                'add-image-btn'     => 'Bild hinzufügen',
                'ai-add-image-btn'  => 'Magie KI',
                'ai-btn-info'       => 'Bild generieren',
                'allowed-types'     => 'png, jpeg, jpg',
                'not-allowed-error' => 'Nur Bilddateien (.jpeg, .jpg, .png, ..) sind erlaubt.',

                'ai-generation' => [
                    '1024x1024'        => '1024x1024',
                    '1024x1792'        => '1024x1792',
                    '1792x1024'        => '1792x1024',
                    'apply'            => 'Anwenden',
                    'dall-e-2'         => 'Dall.E 2',
                    'dall-e-3'         => 'Dall.E 3',
                    'generate'         => 'Generieren',
                    'generating'       => 'Generiere...',
                    'hd'               => 'HD',
                    'model'            => 'Modell',
                    'number-of-images' => 'Anzahl der Bilder',
                    'prompt'           => 'Aufforderung',
                    'quality'          => 'Qualität',
                    'regenerate'       => 'Neu generieren',
                    'regenerating'     => 'Regeneriere...',
                    'size'             => 'Größe',
                    'standard'         => 'Standard',
                    'title'            => 'KI-Bildgenerierung',
                ],

                'placeholders' => [
                    'front'     => 'Vorderseite',
                    'next'      => 'Nächste',
                    'size'      => 'Größe',
                    'use-cases' => 'Verwendungszwecke',
                    'zoom'      => 'Vergrößern',
                ],
            ],

            'videos' => [
                'add-video-btn'     => 'Video hinzufügen',
                'allowed-types'     => 'mp4, webm, mkv',
                'not-allowed-error' => 'Nur Videodateien (.mp4, .mov, .ogg ..) sind erlaubt.',
            ],
        ],

        'tinymce' => [
            'ai-btn-tile' => 'Magie KI',

            'ai-generation' => [
                'apply'                    => 'Anwenden',
                'deepseek-r1-8b'           => 'DeepSeek R1 (8b)',
                'enabled'                  => 'Aktiviert',
                'gemini-2-0-flash'         => 'Gemini 2.0 Flash',
                'generate'                 => 'Generieren',
                'generated-content'        => 'Generierter Inhalt',
                'generated-content-info'   => 'KI-Inhalte können irreführend sein. Bitte überprüfen Sie den generierten Inhalt, bevor Sie ihn anwenden.',
                'generating'               => 'Generiere...',
                'gpt-4-turbo'              => 'OpenAI gpt-4 Turbo',
                'gpt-4o'                   => 'OpenAI gpt-4o',
                'gpt-4o-mini'              => 'OpenAI gpt-4o mini',
                'llama-groq'               => 'Llama 3.3 (Groq)',
                'llama3-1-8b'              => 'Llama 3.1 (8B)',
                'llama3-2-1b'              => 'Llama 3.2 (1B)',
                'llama3-2-3b'              => 'Llama 3.2 (3B)',
                'llama3-8b'                => 'Llama 3 (8B)',
                'llava-7b'                 => 'Llava (7b)',
                'mistral-7b'               => 'Mistral (7b)',
                'model'                    => 'Modell',
                'orca-mini'                => 'Orca Mini',
                'phi3-5'                   => 'Phi 3.5',
                'prompt'                   => 'Aufforderung',
                'qwen2-5-0-5b'             => 'Qwen 2.5 (0.5b)',
                'qwen2-5-1-5b'             => 'Qwen 2.5 (1.5b)',
                'qwen2-5-14b'              => 'Qwen 2.5 (14b)',
                'qwen2-5-3b'               => 'Qwen 2.5 (3b)',
                'qwen2-5-7b'               => 'Qwen 2.5 (7b)',
                'starling-lm-7b'           => 'Starling-lm (7b)',
                'title'                    => 'KI-Unterstützung',
                'vicuna-13b'               => 'Vicuna (13b)',
                'vicuna-7b'                => 'Vicuna (7b)',
            ],
        ],
    ],

    'acl' => [
        'addresses'                => 'Adressen',
        'attribute-families'       => 'Attributfamilien',
        'attributes'               => 'Attribute',
        'campaigns'                => 'Kampagnen',
        'cancel'                   => 'Abbrechen',
        'cart-rules'               => 'Warenkorbregeln',
        'catalog-rules'            => 'Katalogregeln',
        'catalog'                  => 'Katalog',
        'categories'               => 'Kategorien',
        'channels'                 => 'Kanäle',
        'cms'                      => 'CMS',
        'communications'           => 'Kommunikationen',
        'configure'                => 'Konfigurieren',
        'copy'                     => 'Kopieren',
        'create'                   => 'erstellen',
        'currencies'               => 'Währungen',
        'customers'                => 'Kunden',
        'dashboard'                => 'Dashboard',
        'data-transfer'            => 'Datentransfer',
        'delete'                   => 'Löschen',
        'edit'                     => 'Bearbeiten',
        'email-templates'          => 'E-Mail-Vorlagen',
        'events'                   => 'Ereignisse',
        'exchange-rates'           => 'Wechselkurse',
        'gdpr'                     => 'DSGVO',
        'groups'                   => 'Gruppen',
        'import'                   => 'Importieren',
        'imports'                  => 'Importe',
        'inventory-sources'        => 'Inventarquellen',
        'invoices'                 => 'Rechnungen',
        'locales'                  => 'Sprachen',
        'marketing'                => 'Marketing',
        'newsletter-subscriptions' => 'Newsletter-Abonnements',
        'note'                     => 'Notiz',
        'orders'                   => 'Bestellungen',
        'products'                 => 'Produkte',
        'promotions'               => 'Promotionen',
        'refunds'                  => 'Rückerstattungen',
        'reporting'                => 'Berichterstattung',
        'reviews'                  => 'Bewertungen',
        'roles'                    => 'Rollen',
        'sales'                    => 'Verkäufe',
        'search-seo'               => 'Suche & SEO',
        'search-synonyms'          => 'Suchsynonyme',
        'search-terms'             => 'Suchbegriffe',
        'settings'                 => 'Einstellungen',
        'shipments'                => 'Lieferungen',
        'sitemaps'                 => 'Sitemaps',
        'subscribers'              => 'Newsletter-Abonnenten',
        'tax-categories'           => 'Steuerkategorien',
        'tax-rates'                => 'Steuersätze',
        'taxes'                    => 'Steuern',
        'themes'                   => 'Themes',
        'transactions'             => 'Transaktionen',
        'url-rewrites'             => 'URL-Rewrites',
        'users'                    => 'Benutzer',
        'view'                     => 'Ansehen',
    ],

    'errors' => [
        'dashboard' => 'Dashboard',
        'go-back'   => 'Zurück',
        'support'   => 'Wenn das Problem weiterhin besteht, erreichen Sie uns unter <a href=":link" class=":class">:email</a> für Unterstützung.',

        '404' => [
            'description' => 'Hoppla! Die Seite, die Sie suchen, macht gerade Urlaub. Es scheint, als könnten wir nicht finden, wonach Sie gesucht haben.',
            'title'       => '404 Seite nicht gefunden',
        ],

        '401' => [
            'description' => 'Hoppla! Es sieht so aus, als hätten Sie keine Berechtigung, auf diese Seite zuzugreifen. Es scheint, als fehlten Ihnen die erforderlichen Zugangsdaten.',
            'title'       => '401 Nicht autorisiert',
        ],

        '403' => [
            'description' => 'Hoppla! Diese Seite ist tabu. Es sieht so aus, als hätten Sie nicht die erforderlichen Berechtigungen, um diesen Inhalt anzuzeigen.',
            'title'       => '403 Zugriff verweigert',
        ],

        '500' => [
            'description' => 'Hoppla! Etwas ist schiefgelaufen. Es scheint, als hätten wir Probleme beim Laden der von Ihnen gesuchten Seite.',
            'title'       => '500 Interner Serverfehler',
        ],

        '503' => [
            'description' => 'Hoppla! Es sieht so aus, als wären wir vorübergehend wegen Wartungsarbeiten nicht erreichbar. Bitte versuchen Sie es später erneut.',
            'title'       => '503 Dienst nicht verfügbar',
        ],
    ],

    'export' => [
        'csv'        => 'CSV',
        'download'   => 'Herunterladen',
        'export'     => 'Exportieren',
        'no-records' => 'Nichts zu exportieren',
        'xls'        => 'XLS',
        'xlsx'       => 'XLSX',
    ],

    'validations' => [
        'slug-being-used' => 'Dieser Slug wird entweder in Kategorien oder Produkten verwendet.',
        'slug-reserved'   => 'Dieser Slug ist reserviert.',
    ],

    'footer' => [
        'copy-right' => 'Powered by <a href="https://bagisto.com/" target="_blank">Bagisto</a>, ein Community-Projekt von <a href="https://webkul.com/" target="_blank">Webkul</a>',
    ],

    'emails' => [
        'dear'   => 'Liebe:r :admin_name',
        'thanks' => 'Wenn Sie irgendwelche Hilfe benötigen, kontaktieren Sie uns bitte unter <a href=":link" style=":style">:email</a>.<br/>Vielen Dank!',

        'admin' => [
            'forgot-password' => [
                'description'    => 'Sie erhalten diese E-Mail, weil wir eine Anfrage zum Zurücksetzen des Passworts für Ihr Konto erhalten haben.',
                'greeting'       => 'Passwort vergessen!',
                'reset-password' => 'Passwort zurücksetzen',
                'subject'        => 'E-Mail zum Zurücksetzen des Passworts',
            ],
        ],

        'customers' => [
            'registration' => [
                'description' => 'Ein neues Kundenkonto wurde erfolgreich erstellt. Sie können sich nun mit ihrer E-Mail-Adresse und ihrem Passwort anmelden. Sobald sie angemeldet sind, haben sie Zugriff auf verschiedene Dienste, einschließlich der Möglichkeit, frühere Bestellungen einzusehen, Wunschlisten zu verwalten und ihre Kontoinformationen zu aktualisieren.',
                'greeting'    => 'Wir heißen den neuen Kunden :customer_name, der sich gerade bei uns registriert hat, herzlich willkommen!',
                'subject'     => 'Neukundenregistrierung',
            ],

            'gdpr' => [
                'new-delete-request' => 'Neue Anfrage zum Löschen von Daten',
                'new-update-request' => 'Neue Anfrage zur Aktualisierung von Daten',

                'new-request' => [
                    'customer-name'  => 'Kundenname : ',
                    'delete-summary' => 'Zusammenfassung der Löschanforderung',
                    'message'        => 'Nachricht : ',
                    'request-status' => 'Anfragestatus : ',
                    'request-type'   => 'Anfragetyp : ',
                    'update-summary' => 'Zusammenfassung der Aktualisierungsanforderung',
                ],

                'status-update' => [
                    'subject'        => 'GDPR-Anfrage wurde aktualisiert',
                    'summary'        => 'Der Status der GDPR-Anfrage wurde aktualisiert',
                    'request-status' => 'Anfragestatus:',
                    'request-type'   => 'Anfragetyp:',
                    'message'        => 'Nachricht:',
                ],
            ],
        ],

        'orders' => [
            'created' => [
                'greeting' => 'Sie haben eine neue Bestellung :order_id am :created_at aufgegeben',
                'subject'  => 'Neue Bestellbestätigung',
                'summary'  => 'Zusammenfassung der Bestellung',
                'title'    => 'Bestellbestätigung!',
            ],

            'invoiced' => [
                'greeting' => 'Ihre Rechnung #:invoice_id für Bestellung :order_id wurde am :created_at erstellt',
                'subject'  => 'Neue Rechnungsbestätigung',
                'summary'  => 'Zusammenfassung der Rechnung',
                'title'    => 'Rechnungsbestätigung!',
            ],

            'shipped' => [
                'greeting' => 'Sie haben die Bestellung :order_id am :created_at versandt',
                'subject'  => 'Neue Versandbestätigung',
                'summary'  => 'Zusammenfassung des Versands',
                'title'    => 'Bestellung versandt!',
            ],

            'inventory-source' => [
                'greeting' => 'Sie haben die Bestellung :order_id am :created_at versandt',
                'subject'  => 'Neue Versandbestätigung',
                'summary'  => 'Zusammenfassung des Versands',
                'title'    => 'Bestellung versandt!',
            ],

            'refunded' => [
                'greeting' => 'Sie haben die Rückerstattung für die Bestellung :order_id am :created_at durchgeführt',
                'subject'  => 'Neue Rückerstattungsbestätigung',
                'summary'  => 'Zusammenfassung der Rückerstattung',
                'title'    => 'Bestellung zurückerstattet!',
            ],

            'canceled' => [
                'greeting' => 'Sie haben die Bestellung :order_id am :created_at storniert',
                'subject'  => 'Neue Bestellstornierung',
                'summary'  => 'Zusammenfassung der Bestellung',
                'title'    => 'Bestellung storniert!',
            ],

            'billing-address'            => 'Rechnungsadresse',
            'carrier'                    => 'Versanddienst',
            'contact'                    => 'Kontakt',
            'discount'                   => 'Rabatt',
            'excl-tax'                   => 'Ohne Steuern: ',
            'grand-total'                => 'Gesamtsumme',
            'name'                       => 'Name',
            'payment'                    => 'Zahlung',
            'price'                      => 'Preis',
            'qty'                        => 'Menge',
            'shipping-address'           => 'Lieferadresse',
            'shipping-handling-excl-tax' => 'Versandkosten (ohne Steuern)',
            'shipping-handling-incl-tax' => 'Versandkosten (inkl. Steuern)',
            'shipping-handling'          => 'Versandkosten',
            'shipping'                   => 'Versand',
            'sku'                        => 'Artikelnummer',
            'subtotal-excl-tax'          => 'Zwischensumme (ohne Steuern)',
            'subtotal-incl-tax'          => 'Zwischensumme (inkl. Steuern)',
            'subtotal'                   => 'Zwischensumme',
            'tax'                        => 'Steuern',
            'tracking-number'            => 'Sendungsnummer: :tracking_number',
        ],
    ],
];
